/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.group;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.AmetysContextHelper;
import org.ametys.core.group.Group;
import org.ametys.core.group.GroupDirectoryContextHelper;
import org.ametys.core.group.GroupDirectoryDAO;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.group.GroupManager;
import org.ametys.core.group.InvalidModificationException;
import org.ametys.core.group.ModifiableGroup;
import org.ametys.core.group.directory.GroupDirectory;
import org.ametys.core.group.directory.ModifiableGroupDirectory;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.population.PopulationContextHelper;
import org.ametys.plugins.core.group.GroupHelper;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;

public class GroupDAO
extends AbstractLogEnabled
implements Serviceable,
Component,
Contextualizable {
    private static final int _DEFAULT_SEARCH_COUNT_VALUE = 100;
    private static final int _DEFAULT_SEARCH_OFFSET_VALUE = 0;
    protected ServiceManager _smanager;
    protected CurrentUserProvider _currentUserProvider;
    protected GroupManager _groupManager;
    protected GroupDirectoryDAO _groupDirectoryDAO;
    protected UserHelper _userHelper;
    protected GroupDirectoryContextHelper _directoryContextHelper;
    protected GroupHelper _groupHelper;
    protected Context _context;
    protected RightManager _rightManager;
    protected PopulationContextHelper _populationContextHelper;
    protected AmetysContextHelper _ametysContextHelper;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager smanager) throws ServiceException {
        this._smanager = smanager;
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
        this._groupManager = (GroupManager)smanager.lookup(GroupManager.ROLE);
        this._groupDirectoryDAO = (GroupDirectoryDAO)smanager.lookup(GroupDirectoryDAO.ROLE);
        this._userHelper = (UserHelper)smanager.lookup(UserHelper.ROLE);
        this._directoryContextHelper = (GroupDirectoryContextHelper)smanager.lookup(GroupDirectoryContextHelper.ROLE);
        this._groupHelper = (GroupHelper)smanager.lookup(GroupHelper.ROLE);
        this._rightManager = (RightManager)smanager.lookup(RightManager.ROLE);
        this._populationContextHelper = (PopulationContextHelper)smanager.lookup(PopulationContextHelper.ROLE);
        this._ametysContextHelper = (AmetysContextHelper)smanager.lookup(AmetysContextHelper.ROLE);
    }

    @Callable(rights={"Runtime_Rights_Group_Handle"})
    public Map<String, Object> addGroup(String groupDirectoryId, String name) throws InvalidModificationException {
        GroupDirectory groupDirectory = this._groupDirectoryDAO.getGroupDirectory(groupDirectoryId);
        if (!(groupDirectory instanceof ModifiableGroupDirectory)) {
            this.getLogger().error("Groups are not modifiable !");
            throw new InvalidModificationException("Groups are not modifiable !");
        }
        ModifiableGroupDirectory modifiableGroupDirectory = (ModifiableGroupDirectory)groupDirectory;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Starting group creation");
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("The new group name cannot be empty");
        }
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info(String.format("User %s is adding a new group '%s'", this._getCurrentUser(), name));
        }
        ModifiableGroup group = modifiableGroupDirectory.add(name);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Ending group creation");
        }
        return this.group2Json(group);
    }

    @Callable(rights={"Runtime_Rights_Group_Handle"})
    public Map<String, Object> setUsersGroup(String groupDirectoryId, String groupId, List<Map<String, String>> users) throws InvalidModificationException {
        ModifiableGroup group;
        GroupDirectory groupDirectory = this._groupDirectoryDAO.getGroupDirectory(groupDirectoryId);
        if (!(groupDirectory instanceof ModifiableGroupDirectory)) {
            this.getLogger().error("Groups are not modifiable !");
            throw new InvalidModificationException("Groups are not modifiable !");
        }
        ModifiableGroupDirectory modifiableGroupDirectory = (ModifiableGroupDirectory)groupDirectory;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Starting group modification");
        }
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info(String.format("User %s is editing the group '%s'", this._getCurrentUser(), groupId));
        }
        if ((group = modifiableGroupDirectory.getGroup(groupId)) == null) {
            this.getLogger().warn(String.format("User %s tries to edit the group '%s' but the group does not exist.", this._getCurrentUser(), groupId));
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("error", "unknown-group");
            return result;
        }
        group.removeUsers();
        for (Map<String, String> user : users) {
            UserIdentity userIdentity = this._userHelper.json2userIdentity(user);
            if (userIdentity == null) continue;
            group.addUser(userIdentity);
        }
        modifiableGroupDirectory.update(group);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Ending group modification");
        }
        return this.group2Json(group);
    }

    @Callable(rights={"Runtime_Rights_Group_Handle"})
    public Map<String, Object> addUsersGroup(String groupDirectoryId, String groupId, List<Map<String, String>> users) throws InvalidModificationException {
        return this._updateUsersGroup(groupDirectoryId, groupId, users, false);
    }

    @Callable(rights={"Runtime_Rights_Group_Handle"})
    public Map<String, Object> removeUsersGroup(String groupDirectoryId, String groupId, List<Map<String, String>> users) throws InvalidModificationException {
        return this._updateUsersGroup(groupDirectoryId, groupId, users, true);
    }

    private Map<String, Object> _updateUsersGroup(String groupDirectoryId, String groupId, List<Map<String, String>> users, boolean remove) throws InvalidModificationException {
        ModifiableGroup group;
        GroupDirectory groupDirectory = this._groupDirectoryDAO.getGroupDirectory(groupDirectoryId);
        if (!(groupDirectory instanceof ModifiableGroupDirectory)) {
            this.getLogger().error("Groups are not modifiable !");
            throw new InvalidModificationException("Groups are not modifiable !");
        }
        ModifiableGroupDirectory modifiableGroupDirectory = (ModifiableGroupDirectory)groupDirectory;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Starting group modification");
        }
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info(String.format("User %s is editing the group '%s'", this._getCurrentUser(), groupId));
        }
        if ((group = modifiableGroupDirectory.getGroup(groupId)) == null) {
            this.getLogger().warn(String.format("User %s tries to edit the group '%s' but the group does not exist.", this._getCurrentUser(), groupId));
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("error", "unknown-group");
            return result;
        }
        for (Map<String, String> user : users) {
            UserIdentity userIdentity = this._userHelper.json2userIdentity(user);
            if (userIdentity == null) continue;
            if (remove) {
                group.removeUser(userIdentity);
                continue;
            }
            group.addUser(userIdentity);
        }
        modifiableGroupDirectory.update(group);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Ending group modification");
        }
        return this.group2Json(group);
    }

    @Callable(rights={"Runtime_Rights_Group_Handle"})
    public List<Map<String, Object>> getUsersGroup(Map<String, String> user) {
        ArrayList<Map<String, Object>> jsonifiedGroups = new ArrayList<Map<String, Object>>();
        UserIdentity userIdentity = this._userHelper.json2userIdentity(user);
        Set<GroupIdentity> userGroups = this._groupManager.getUserGroups(userIdentity);
        for (GroupIdentity userGroup : userGroups) {
            Group group;
            GroupDirectory groupDirectory = this._groupDirectoryDAO.getGroupDirectory(userGroup.getDirectoryId());
            if (groupDirectory == null || (group = groupDirectory.getGroup(userGroup.getId())) == null) continue;
            Map<String, Object> jsonifiedGroup = this.group2Json(group);
            jsonifiedGroups.add(jsonifiedGroup);
        }
        return jsonifiedGroups;
    }

    @Callable(rights={"Runtime_Rights_Group_Handle"})
    public Map<String, Object> renameGroup(String groupDirectoryId, String groupId, String name) throws InvalidModificationException {
        ModifiableGroup group;
        GroupDirectory groupDirectory = this._groupDirectoryDAO.getGroupDirectory(groupDirectoryId);
        if (!(groupDirectory instanceof ModifiableGroupDirectory)) {
            this.getLogger().error("Groups are not modifiable !");
            throw new InvalidModificationException("Groups are not modifiable !");
        }
        ModifiableGroupDirectory modifiableGroupDirectory = (ModifiableGroupDirectory)groupDirectory;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Starting group renaming");
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("The new group name cannot be empty");
        }
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info(String.format("User %s is renaming the group '%s' to '%s'", this._getCurrentUser(), groupId, name));
        }
        if ((group = modifiableGroupDirectory.getGroup(groupId)) == null) {
            this.getLogger().warn(String.format("User %s tries to rename the group '%s' but the group does not exist.", this._getCurrentUser(), groupId));
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("error", "unknown-group");
            return result;
        }
        group.setLabel(name);
        modifiableGroupDirectory.update(group);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Ending group renaming");
        }
        return this.group2Json(group);
    }

    @Callable(rights={"Runtime_Rights_Group_Handle"})
    public void deleteGroups(String groupDirectoryId, List<String> groupIds) throws InvalidModificationException {
        GroupDirectory groupDirectory = this._groupDirectoryDAO.getGroupDirectory(groupDirectoryId);
        if (!(groupDirectory instanceof ModifiableGroupDirectory)) {
            this.getLogger().error("Groups are not modifiable !");
            throw new InvalidModificationException("Groups are not modifiable !");
        }
        ModifiableGroupDirectory modifiableGroupDirectory = (ModifiableGroupDirectory)groupDirectory;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Starting group removal");
        }
        for (String groupId : groupIds) {
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info(String.format("User %s is is removing group '%s'", this._getCurrentUser(), groupId));
            }
            modifiableGroupDirectory.remove(groupId);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Ending group removal");
        }
    }

    @Callable(rights={""})
    public List<Map<String, Object>> getGroupsByContextAndGroupDirectory(List<String> groupsAndDirectories, List<String> contexts) throws AccessDeniedException {
        ArrayList<Map<String, Object>> groups = new ArrayList<Map<String, Object>>();
        for (String groupAndDirectory : groupsAndDirectories) {
            String groupId = StringUtils.substringBeforeLast((String)groupAndDirectory, (String)"#");
            String groupDir = StringUtils.substringAfterLast((String)groupAndDirectory, (String)"#");
            Request request = ContextHelper.getRequest((Context)this._context);
            List populationContexts = request != null ? (List)request.getAttribute("populationContexts") : null;
            this._checkCurrentUserRightToSearchInGroupDirectory(groupDir, populationContexts);
            this._addNonNullJsonGroup(groups, groupDir, groupId);
        }
        return groups;
    }

    @Callable(rights={""})
    public List<Map<String, Object>> getGroupsByGroupDirectory(List<String> groupIds, String groupDirectoryId) throws AccessDeniedException {
        Request request = ContextHelper.getRequest((Context)this._context);
        List populationContexts = request != null ? (List)request.getAttribute("populationContexts") : null;
        this._checkCurrentUserRightToSearchInGroupDirectory(groupDirectoryId, populationContexts);
        ArrayList<Map<String, Object>> groups = new ArrayList<Map<String, Object>>();
        for (String groupId : groupIds) {
            this._addNonNullJsonGroup(groups, groupDirectoryId, groupId);
        }
        return groups;
    }

    @Callable(rights={""})
    public List<Map<String, Object>> searchGroupsByContexts(List<String> contexts, Integer limit, Integer offset, String searchCriteria) throws AccessDeniedException {
        ArrayList<Map<String, Object>> groups = new ArrayList<Map<String, Object>>();
        Integer limitOrDefault = limit == null ? 100 : (limit == -1 ? Integer.MAX_VALUE : limit);
        Integer offsetOrDefault = offset != null ? offset : 0;
        for (String groupDirectoryId : this._directoryContextHelper.getGroupDirectoriesOnContexts(new HashSet<String>(contexts), true)) {
            GroupDirectory groupDirectory = this._groupDirectoryDAO.getGroupDirectory(groupDirectoryId);
            groups.addAll(this._groupHelper.groups2JSON(groupDirectory.getGroups(limitOrDefault, offsetOrDefault, this._getSearchParameters(searchCriteria)), false));
        }
        return groups;
    }

    @Callable(rights={""})
    public List<Map<String, Object>> searchGroupsByDirectory(String groupDirectoryId, String searchCriteria, Integer limit, Integer offset) {
        Request request = ContextHelper.getRequest((Context)this._context);
        List populationContexts = request != null ? (List)request.getAttribute("populationContexts") : null;
        this._checkCurrentUserRightToSearchInGroupDirectory(groupDirectoryId, populationContexts);
        ArrayList<Map<String, Object>> groups = new ArrayList<Map<String, Object>>();
        Integer limitOrDefault = limit == null ? 100 : (limit == -1 ? Integer.MAX_VALUE : limit);
        Integer offsetOrDefault = offset != null ? offset : 0;
        GroupDirectory groupDirectory = this._groupDirectoryDAO.getGroupDirectory(groupDirectoryId);
        groups.addAll(groupDirectory.getGroups(limitOrDefault, offsetOrDefault, this._getSearchParameters(searchCriteria)).stream().map(group -> this._groupHelper.group2JSON((Group)group, false)).collect(Collectors.toList()));
        return groups;
    }

    protected Map<String, String> _getSearchParameters(String searchCriteria) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pattern", searchCriteria);
        return params;
    }

    private void _checkCurrentUserRightToSearchInGroupDirectory(String groupDirectoryId, List<String> populationContexts) {
        Set<String> groupDirectoryContexts = this._directoryContextHelper.getContextsForGroupDirectory(groupDirectoryId);
        UserIdentity user = this._currentUserProvider.getUser();
        String currentUserPopulationId = user.getPopulationId();
        Set<String> userPopulationContexts = this._populationContextHelper.getContextsForUserPopulation(currentUserPopulationId);
        if (populationContexts != null && populationContexts.contains("/admin") ? this._rightManager.currentUserHasRight("Runtime_Rights_Admin_Access", "/admin") != RightManager.RightResult.RIGHT_ALLOW : !this._ametysContextHelper.areRelated(groupDirectoryContexts, userPopulationContexts)) {
            throw new AccessDeniedException("User " + String.valueOf(user) + " tried to access a group directory without convenient rights");
        }
    }

    private void _addNonNullJsonGroup(List<Map<String, Object>> groups, String groupDirectoryId, String id) {
        GroupDirectory groupDirectory = this._groupDirectoryDAO.getGroupDirectory(groupDirectoryId);
        if (groupDirectory != null) {
            Group group = groupDirectory.getGroup(id);
            if (group != null) {
                Map<String, Object> groupAsJson = this._groupHelper.group2JSON(group, false);
                groups.add(groupAsJson);
            } else {
                this.getLogger().warn(String.format("Group of id '%s' and group directory '%s' does not exist. It may have been removed. Thus, it will not be returned.", id, groupDirectoryId));
            }
        } else {
            this.getLogger().warn(String.format("Group directory of id '%s' does not exist. It may have been removed. Thus, its groups will not be returned.", groupDirectoryId));
        }
    }

    @Callable(rights={"Runtime_Rights_Group_Handle"})
    public Map<String, Object> getGroup(String groupDirectoryId, String id) {
        GroupDirectory groupDirectory = this._groupDirectoryDAO.getGroupDirectory(groupDirectoryId);
        Group group = groupDirectory.getGroup(id);
        if (group != null) {
            return this.group2Json(group);
        }
        return null;
    }

    @Callable(rights={"Runtime_Rights_Group_Handle"})
    public boolean isModifiable(String groupDirectoryId, String id) {
        return this._groupDirectoryDAO.getGroupDirectory(groupDirectoryId) instanceof ModifiableGroupDirectory;
    }

    protected Map<String, Object> group2Json(Group group) {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        infos.put("id", group.getIdentity().getId());
        infos.put("label", group.getLabel());
        infos.put("groupDirectory", group.getIdentity().getDirectoryId());
        infos.put("groupDirectoryLabel", this._groupDirectoryDAO.getGroupDirectory(group.getIdentity().getDirectoryId()).getLabel());
        return infos;
    }

    protected UserIdentity _getCurrentUser() {
        if (this._currentUserProvider == null) {
            try {
                this._currentUserProvider = (CurrentUserProvider)this._smanager.lookup(CurrentUserProvider.ROLE);
            }
            catch (ServiceException e) {
                throw new IllegalStateException(e);
            }
        }
        return this._currentUserProvider.getUser();
    }
}

