/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.group;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ametys.core.group.Group;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.group.GroupManager;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class GroupHelper
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = GroupHelper.class.getName();
    private GroupManager _groupManager;
    private UserHelper _userHelper;

    public void service(ServiceManager manager) throws ServiceException {
        this._groupManager = (GroupManager)manager.lookup(GroupManager.ROLE);
        this._userHelper = (UserHelper)manager.lookup(UserHelper.ROLE);
    }

    public void saxGroupIdentity(GroupIdentity groupIdentity, ContentHandler handler) throws SAXException {
        this.saxGroupIdentity(groupIdentity, handler, "group", false);
    }

    public void saxGroupIdentity(GroupIdentity groupIdentity, ContentHandler handler, String tagName) throws SAXException {
        this.saxGroupIdentity(groupIdentity, handler, tagName, false);
    }

    public void saxGroupIdentity(GroupIdentity groupIdentity, ContentHandler handler, String tagName, boolean withUsers) throws SAXException {
        Group group = this._groupManager.getGroup(groupIdentity);
        if (group != null) {
            this.saxGroup(group, handler, tagName, withUsers);
        } else {
            this.getLogger().warn("Unable to sax unknown group with identity {}", (Object)groupIdentity);
        }
    }

    public void saxGroup(Group group, ContentHandler handler) throws SAXException {
        this.saxGroup(group, handler, "group", false);
    }

    public void saxGroup(Group group, ContentHandler handler, String tagName) throws SAXException {
        this.saxGroup(group, handler, tagName, false);
    }

    public void saxGroup(Group group, ContentHandler handler, String tagName, boolean withUsers) throws SAXException {
        if (group != null) {
            AttributesImpl attr = new AttributesImpl();
            attr.addCDATAAttribute("id", group.getIdentity().getId());
            attr.addCDATAAttribute("groupDirectory", group.getIdentity().getDirectoryId());
            XMLUtils.startElement((ContentHandler)handler, (String)tagName, (Attributes)attr);
            XMLUtils.createElement((ContentHandler)handler, (String)"label", (String)group.getLabel());
            group.getGroupDirectory().getLabel().toSAX(handler, "groupDirectoryLabel");
            if (withUsers) {
                XMLUtils.startElement((ContentHandler)handler, (String)"users");
                for (UserIdentity user : group.getUsers()) {
                    this._userHelper.saxUserIdentity(user, handler);
                }
                XMLUtils.endElement((ContentHandler)handler, (String)"users");
            }
            XMLUtils.endElement((ContentHandler)handler, (String)tagName);
        } else if (this.getLogger().isWarnEnabled()) {
            this.getLogger().warn("Unable to sax null group", (Throwable)new Exception());
        }
    }

    public Map<String, Object> group2JSON(GroupIdentity groupIdentity, boolean users) {
        return this.group2JSON(this._groupManager.getGroup(groupIdentity), users);
    }

    public Map<String, Object> group2JSON(Group group, boolean users) {
        if (group == null) {
            return null;
        }
        HashMap<String, Object> group2json = new HashMap<String, Object>();
        group2json.put("id", group.getIdentity().getId());
        group2json.put("groupDirectory", group.getIdentity().getDirectoryId());
        group2json.put("groupDirectoryLabel", group.getGroupDirectory().getLabel());
        group2json.put("label", group.getLabel());
        if (users) {
            group2json.put("users", group.getUsers());
        }
        return group2json;
    }

    public List<Map<String, Object>> groups2JSON(List<Group> groups, boolean users) {
        return groups.stream().map(group -> this.group2JSON((Group)group, users)).collect(Collectors.toList());
    }
}

