/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.authentication;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.ametys.core.authentication.AbstractCredentialProvider;
import org.ametys.core.authentication.BlockingCredentialProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.directory.UserDirectory;
import org.ametys.core.user.population.UserPopulation;
import org.ametys.runtime.authentication.AuthorizationRequiredException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;

public class BasicCredentialProvider
extends AbstractCredentialProvider
implements BlockingCredentialProvider,
Contextualizable {
    protected static final String __PARAM_REALM = "runtime.authentication.basic.realm";
    private static final String BASIC_AUTHENTICATION_KEY = "BASIC ";
    protected String _realm;
    private Context _context;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    @Override
    public void init(String id, String cpModelId, Map<String, Object> paramValues, String label) throws Exception {
        super.init(id, cpModelId, paramValues, label);
        this._realm = (String)paramValues.get(__PARAM_REALM);
    }

    @Override
    public boolean blockingIsStillConnected(UserIdentity userIdentity, Redirector redirector) throws Exception {
        return true;
    }

    @Override
    public boolean blockingGrantAnonymousRequest() {
        return false;
    }

    @Override
    public UserIdentity blockingGetUserIdentity(Redirector redirector) throws Exception {
        Request request = ContextHelper.getRequest((Context)this._context);
        String auth = request.getHeader("Authorization");
        if (auth == null) {
            throw new AuthorizationRequiredException(this._realm);
        }
        if (!auth.toUpperCase().startsWith(BASIC_AUTHENTICATION_KEY)) {
            return null;
        }
        String userpassEncoded = auth.substring(BASIC_AUTHENTICATION_KEY.length());
        String userpassDecoded = new String(Base64.decodeBase64((byte[])userpassEncoded.getBytes("UTF-8")), "UTF-8");
        StringTokenizer stk = new StringTokenizer(userpassDecoded, ":");
        String login = stk.hasMoreTokens() ? stk.nextToken() : "";
        String password = stk.hasMoreTokens() ? stk.nextToken() : "";
        List<UserPopulation> userPopulations = this._getPopulations(request);
        for (UserPopulation userPopulation : userPopulations) {
            for (UserDirectory userDirectory : userPopulation.getUserDirectories()) {
                if (userDirectory.getStoredUser(login) == null) continue;
                if (userDirectory.checkCredentials(login, password) != UserDirectory.CredentialsResult.NOT_AUTHENTICATED) {
                    return new UserIdentity(login, userPopulation.getId());
                }
                throw new AuthorizationRequiredException(this._realm);
            }
        }
        throw new AuthorizationRequiredException(this._realm);
    }

    private List<UserPopulation> _getPopulations(Request request) {
        List userPopulations = (List)request.getAttribute("Runtime:UserPopulationsList");
        String chosenUserPopulationId = (String)request.getAttribute("Runtime:CurrentUserPopulationId");
        if (StringUtils.isNotBlank((CharSequence)chosenUserPopulationId)) {
            UserPopulation chosenUserPopulation = userPopulations.stream().filter(userPopulation -> Strings.CS.equals(userPopulation.getId(), chosenUserPopulationId)).findFirst().get();
            return Collections.singletonList(chosenUserPopulation);
        }
        return userPopulations;
    }

    @Override
    public void blockingUserNotAllowed(Redirector redirector) {
    }

    @Override
    public void blockingUserAllowed(UserIdentity userIdentity, Redirector redirector) {
    }

    @Override
    public boolean requiresNewWindow() {
        return false;
    }
}

