/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.authentication;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.ametys.core.authentication.AbstractCredentialProvider;
import org.ametys.core.authentication.BlockingCredentialProvider;
import org.ametys.core.authentication.LogoutCapable;
import org.ametys.core.authentication.NonBlockingCredentialProvider;
import org.ametys.core.authentication.token.AuthenticationTokenManager;
import org.ametys.core.captcha.CaptchaHelper;
import org.ametys.core.datasource.ConnectionHelper;
import org.ametys.core.migration.MigrationEngine;
import org.ametys.core.migration.MigrationException;
import org.ametys.core.migration.MigrationExtensionPoint;
import org.ametys.core.migration.version.Version;
import org.ametys.core.migration.version.storage.SqlVersionStorage;
import org.ametys.core.script.SQLScriptHelper;
import org.ametys.core.trace.ForensicLogger;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.user.directory.NotUniqueUserException;
import org.ametys.core.user.directory.StoredUser;
import org.ametys.core.user.directory.UserDirectory;
import org.ametys.core.user.directory.WeakPasswordException;
import org.ametys.core.user.population.UserPopulation;
import org.ametys.plugins.core.authentication.MultifactorAuthenticationManager;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.runtime.plugin.PluginsManager;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Cookie;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.http.HttpCookie;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.excalibur.source.SourceResolver;

public class FormCredentialProvider
extends AbstractCredentialProvider
implements NonBlockingCredentialProvider,
BlockingCredentialProvider,
LogoutCapable,
Contextualizable,
Configurable,
Serviceable {
    public static final String AUTHENTICATION_BY_COOKIE = "authentication_by_cookie";
    public static final Integer NB_CONNECTION_ATTEMPTS = 3;
    public static final int COOKIE_LIFETIME = 1296000;
    public static final String PASSWORD_SESSION_ATTRIBUTE = "runtime.authentication.password";
    public static final String LOGIN_URL_USER_PARAMETER_NAME = "userIdentity";
    public static final String LOGIN_URL_INVALID_PASSCODE_PARAMETER_NAME = "invalidMFACode";
    public static final String LOGIN_URL_MFA_MODE = "MFAMode";
    public static final String PARAM_DISPLAY_RESET_LINK = "runtime.authentication.form.display-reset-link";
    protected static final Integer TIME_ALLOWED = 1;
    private static final String __PARAM_DATASOURCE = "runtime.authentication.form.security.storage";
    private static final String __PARAM_CAPTCHA = "runtime.authentication.form.captcha";
    private static final String __PARAM_COOKIES = "runtime.authentication.form.cookies";
    private static final String __PARAM_LOGIN_BY_EMAIL = "runtime.authentication.form.login-by-email";
    private static final String __PARAM_STORE_PASSWORD_IN_SESSION = "runtime.authentication.form.store-password-in-session";
    private static final String __PARAM_MULTIFACTOR_AUTHENTICATION = "runtime.authentication.form.multifactor";
    private static final String __SESSION_CONNECTING_USERIDENTITY = "Runtime:ConnectingUserIdentity";
    protected String _usernameField;
    protected String _passwordField;
    protected String _rememberMeField;
    protected String _captchaField;
    protected String _captchaKeyField;
    protected String _mfaCodeField;
    protected String _mfaMode;
    protected boolean _cookieEnabled;
    protected String _cookieName;
    protected long _cookieLifetime;
    protected Set<String> _acceptedUrlPrefixes;
    protected boolean _useCaptchaOnFailure;
    protected boolean _allowCookies;
    protected boolean _storePasswordInSession;
    protected boolean _allowLoginByEmail;
    protected boolean _useMultifactorAuthentication;
    protected boolean _displayResetLink;
    protected Context _context;
    protected String _datasourceId;
    protected SourceResolver _sourceResolver;
    protected AuthenticationTokenManager _authenticationTokenManager;
    protected UserManager _userManager;
    protected MultifactorAuthenticationManager _multifactorAuthenticationManager;
    protected boolean _lazyInitialized;
    protected MigrationEngine _migrationEngine;
    protected MigrationExtensionPoint _migrationEP;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
        this._multifactorAuthenticationManager = (MultifactorAuthenticationManager)manager.lookup(MultifactorAuthenticationManager.ROLE);
        this._migrationEngine = (MigrationEngine)manager.lookup(MigrationEngine.ROLE);
        this._migrationEP = (MigrationExtensionPoint)manager.lookup(MigrationExtensionPoint.ROLE);
        try {
            this._authenticationTokenManager = (AuthenticationTokenManager)manager.lookup(AuthenticationTokenManager.ROLE);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        manager.lookup(ConnectionHelper.ROLE);
    }

    @Override
    public void init(String id, String cpModelId, Map<String, Object> paramValues, String label) throws Exception {
        super.init(id, cpModelId, paramValues, label);
        this._useCaptchaOnFailure = (Boolean)paramValues.get(__PARAM_CAPTCHA);
        this._allowCookies = (Boolean)paramValues.get(__PARAM_COOKIES);
        this._allowLoginByEmail = (Boolean)paramValues.get(__PARAM_LOGIN_BY_EMAIL);
        this._datasourceId = (String)paramValues.get(__PARAM_DATASOURCE);
        this._storePasswordInSession = (Boolean)paramValues.get(__PARAM_STORE_PASSWORD_IN_SESSION);
        this._useMultifactorAuthentication = (Boolean)paramValues.get(__PARAM_MULTIFACTOR_AUTHENTICATION);
        this._displayResetLink = (Boolean)paramValues.get(PARAM_DISPLAY_RESET_LINK);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this._usernameField = configuration.getChild("username-field").getValue("Username");
        this._passwordField = configuration.getChild("password-field").getValue("Password");
        this._rememberMeField = configuration.getChild("rememberMe-field").getValue("rememberMe");
        this._captchaField = configuration.getChild("capcha-field").getValue("Captcha");
        this._captchaKeyField = configuration.getChild("captchaKey-field").getValue("CaptchaKey");
        this._mfaCodeField = configuration.getChild("mfaCode-field").getValue("MultifactorAuthenticationCode");
        this._mfaMode = configuration.getChild("mfaMode-field").getValue("MultifactorAuthenticationMode");
        this._cookieEnabled = configuration.getChild("cookie").getChild("cookieEnabled").getValueAsBoolean(true);
        this._cookieLifetime = configuration.getChild("cookie").getChild("cookieLifeTime").getValueAsLong(1296000L);
        this._cookieName = configuration.getChild("cookie").getChild("cookieName").getValue("AmetysAuthentication");
        this._acceptedUrlPrefixes = new HashSet<String>();
        for (Configuration prefixConf : configuration.getChild("unauthenticated").getChildren("urlPrefix")) {
            String prefix = prefixConf.getValue(null);
            if (prefix == null) continue;
            this._acceptedUrlPrefixes.add(prefix);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("FormBasedCredentialsProvider values :  Name field=" + this._usernameField + ", Pwd field=" + this._passwordField + ", CookieEnabled=" + this._cookieEnabled + ", Cookie duration=" + this._cookieLifetime + ", Cookie name=" + this._cookieName + ", accepted prefixes : [" + StringUtils.join(this._acceptedUrlPrefixes, (String)", ") + "]");
        }
    }

    protected Connection getSQLConnection() {
        Connection connection = ConnectionHelper.getConnection(this._datasourceId);
        if (!this._lazyInitialized) {
            MigrationEngine.MigrationComponent component = (MigrationEngine.MigrationComponent)this._migrationEP.getExtension("credential-provider.form");
            SqlVersionStorage.SqlVersionConfiguration sqlVersionConfiguration = new SqlVersionStorage.SqlVersionConfiguration(this._datasourceId);
            try {
                Version version;
                boolean tableExists = SQLScriptHelper.tableExists(connection, "Users_FormConnectionFailed");
                if (tableExists && component.versionStorage().getVersions(component.id(), sqlVersionConfiguration, component).size() == 0) {
                    throw new IllegalStateException("In datasource " + this._datasourceId + " the table Users_FormConnectionFailed is not versionned. Should never happen. Drop the table or restard Ametys.");
                }
                if (!tableExists && this._migrationEngine.initializeVersion(new MigrationEngine.ActionData(version = component.versionStorage().createVersion(component.id(), component, sqlVersionConfiguration, Map.of("TABLENAME", "Users_FormConnectionFailed")), this._migrationEngine.getHighestUpgradeVersionNumber(component), component.initialization(), null))) {
                    throw new IllegalStateException("Requiring a restart after in a table initialization for a " + this.getClass().getName() + " is not authorized");
                }
            }
            catch (SQLException | MigrationException e) {
                this.getLogger().error("The tables requires by the " + this.getClass().getName() + " could not be created. A degraded behavior will occur", (Throwable)e);
            }
            this._lazyInitialized = true;
        }
        return connection;
    }

    @Override
    public void logout(Redirector redirector) {
        String token = this._getCookieValue();
        if (this._authenticationTokenManager != null && StringUtils.isNotEmpty((CharSequence)token)) {
            this._authenticationTokenManager.deleteTokenByValue(token, null);
        }
        this._deleteCookie();
    }

    @Override
    public boolean nonBlockingIsStillConnected(UserIdentity userIdentity, Redirector redirector) {
        return true;
    }

    @Override
    public boolean blockingIsStillConnected(UserIdentity userIdentity, Redirector redirector) {
        return true;
    }

    @Override
    public boolean blockingGrantAnonymousRequest() {
        Request request = ContextHelper.getRequest((Context)this._context);
        boolean accept = false;
        String login = request.getParameter(this._usernameField);
        String password = request.getParameter(this._passwordField);
        String url = (String)request.getAttribute("inWorkspaceURL");
        if (login == null || password == null) {
            if (!accept) {
                for (String prefix : this._acceptedUrlPrefixes) {
                    if (!url.startsWith(prefix)) continue;
                    accept = true;
                    break;
                }
            }
            if (!accept) {
                for (Pattern pattern : CaptchaHelper.getUsedUrlPatterns()) {
                    if (!pattern.matcher(url).matches()) continue;
                    accept = true;
                    break;
                }
            }
        }
        if (accept && this.getLogger().isInfoEnabled()) {
            this.getLogger().info("URL accepted : " + url);
        }
        return accept;
    }

    @Override
    public boolean nonBlockingGrantAnonymousRequest() {
        return this.blockingGrantAnonymousRequest();
    }

    private void _sendMFACodeByEmail(Request request, UserIdentity userIdentity) {
        MultifactorAuthenticationManager.MultifactorAuthenticationCode mfaCode = this._multifactorAuthenticationManager.generateMultifactorAuthenticationCode(userIdentity);
        this._multifactorAuthenticationManager.sendMultifactorAuthenticationCodeByMail(request, userIdentity, mfaCode.code());
    }

    @Override
    public UserIdentity blockingGetUserIdentity(Redirector redirector) throws Exception {
        Request request = ContextHelper.getRequest((Context)this._context);
        try {
            UserIdentity userIdentity = this.getUserIdentityFromRequest(request);
            if (userIdentity != null) {
                session = request.getSession(false);
                if (session != null) {
                    session.removeAttribute(__SESSION_CONNECTING_USERIDENTITY);
                }
            } else {
                session = request.getSession(false);
                if (session != null) {
                    userIdentity = (UserIdentity)session.getAttribute(__SESSION_CONNECTING_USERIDENTITY);
                }
            }
            if (userIdentity != null) {
                String mfaCode = request.getParameter(this._mfaCodeField);
                if (mfaCode != null && this._multifactorAuthenticationManager.isValidMultifactorAuthenticationCode(userIdentity, mfaCode)) {
                    return userIdentity;
                }
                User user = this._userManager.getUser(userIdentity);
                if (this.useMultifactorAuthentication() && StringUtils.isNotEmpty((CharSequence)user.getEmail())) {
                    MFAMode mode;
                    Session session = request.getSession(true);
                    session.setAttribute(__SESSION_CONNECTING_USERIDENTITY, (Object)userIdentity);
                    if (!this._multifactorAuthenticationManager.isAuthenticationApplicationActivated(userIdentity) || MFAMode.EMAIL.toString().equals(request.getParameter(this._mfaMode))) {
                        mode = MFAMode.EMAIL;
                        if (mfaCode == null) {
                            this._sendMFACodeByEmail(request, userIdentity);
                        }
                    } else {
                        mode = MFAMode.APPLICATION;
                    }
                    String url = this._getLoginURLWithMFACodeInformation(request, userIdentity, mode, mfaCode != null);
                    redirector.redirect(false, url);
                    return null;
                }
                return userIdentity;
            }
            redirector.redirect(false, (String)request.getAttribute("Runtime:RequestLoginURL"));
            return null;
        }
        catch (NotUniqueUserException | AccessDeniedException e) {
            this.blockingUserNotAllowed(redirector);
            return null;
        }
    }

    protected String _getLoginURLWithMFACodeInformation(Request request, UserIdentity userIdentity, MFAMode mode, boolean isMFACodeInvalid) {
        String url = (String)request.getAttribute("Runtime:RequestLoginURL");
        StringBuilder parameters = new StringBuilder();
        parameters.append(url.indexOf(63) >= 0 ? "&" : "?");
        parameters.append(LOGIN_URL_USER_PARAMETER_NAME).append("=").append(UserIdentity.userIdentityToString(userIdentity));
        parameters.append("&").append(LOGIN_URL_MFA_MODE).append("=").append(mode.toString());
        parameters.append("&").append(LOGIN_URL_INVALID_PASSCODE_PARAMETER_NAME).append("=").append(isMFACodeInvalid);
        return url + String.valueOf(parameters);
    }

    @Override
    public UserIdentity nonBlockingGetUserIdentity(Redirector redirector) throws Exception {
        Request request = ContextHelper.getRequest((Context)this._context);
        try {
            UserIdentity userIdentity = this.getUserIdentityFromRequest(request);
            if (userIdentity != null) {
                return userIdentity;
            }
            if (this._allowCookies) {
                String token = this._getCookieValue();
                if (this._authenticationTokenManager != null && StringUtils.isNotEmpty((CharSequence)token)) {
                    UserIdentity userFromToken = this._authenticationTokenManager.validateToken(token);
                    if (userFromToken != null) {
                        return userFromToken;
                    }
                    this._deleteCookie();
                }
            }
        }
        catch (NotUniqueUserException | AccessDeniedException e) {
            this.nonBlockingUserNotAllowed(redirector);
            return null;
        }
        return null;
    }

    protected UserIdentity getUserIdentityFromRequest(Request request) throws AccessDeniedException, NotUniqueUserException, WeakPasswordException {
        String login = request.getParameter(this._usernameField);
        String password = request.getParameter(this._passwordField);
        if (StringUtils.isNotBlank((CharSequence)login) && password != null) {
            UserPopulation userPopulation = this._getPopulation(request);
            Integer nbConnect = this.requestNbConnectBDD(login, userPopulation.getId());
            if (this._useCaptchaOnFailure && nbConnect >= NB_CONNECTION_ATTEMPTS) {
                String answer = request.getParameter(this._captchaField);
                String captchaKey = request.getParameter(this._captchaKeyField);
                if (!CaptchaHelper.checkAndInvalidate(captchaKey, answer)) {
                    this._logLoginFailed(login, userPopulation, "invalid-captcha");
                    throw new AccessDeniedException("Captcha is invalid for user '" + login + "'");
                }
            }
            for (UserDirectory userDirectory : userPopulation.getUserDirectories()) {
                StoredUser storedUser = userDirectory.getStoredUser(login);
                if (storedUser == null && this._allowLoginByEmail) {
                    storedUser = userDirectory.getStoredUserByEmail(login);
                }
                if (storedUser == null) continue;
                UserDirectory.CredentialsResult credentialsResult = userDirectory.checkCredentials(storedUser.getIdentifier(), password);
                switch (credentialsResult) {
                    case NOT_AUTHENTICATED: {
                        if (nbConnect >= NB_CONNECTION_ATTEMPTS) {
                            this._logLoginFailed(login, userPopulation, "invalid-credentials");
                        }
                        throw new AccessDeniedException("Password is incorrect for user '" + storedUser.getIdentifier() + "'");
                    }
                    case WEAK_PASSWORD: {
                        throw new WeakPasswordException(userDirectory.getUserIdentity(storedUser));
                    }
                }
                return userDirectory.getUserIdentity(storedUser);
            }
            this._logLoginFailed(login, userPopulation, "unknown-user");
            throw new AccessDeniedException("Unknown user '" + login + "'");
        }
        return null;
    }

    private void _logLoginFailed(String login, UserPopulation userPopulation, String errorCause) {
        Map<String, Object> args = Map.of("login", login, "population", userPopulation.getId(), "error", errorCause);
        ForensicLogger.info("authentication.form.failed", args, null);
    }

    protected UserPopulation _getPopulation(Request request) {
        List userPopulations = (List)request.getAttribute("Runtime:UserPopulationsList");
        if (userPopulations.size() == 1) {
            return (UserPopulation)userPopulations.get(0);
        }
        String chosenUserPopulationId = (String)request.getAttribute("Runtime:CurrentUserPopulationId");
        if (StringUtils.isNotBlank((CharSequence)chosenUserPopulationId)) {
            UserPopulation chosenUserPopulation = userPopulations.stream().filter(userPopulation -> Strings.CS.equals(userPopulation.getId(), chosenUserPopulationId)).findFirst().get();
            return chosenUserPopulation;
        }
        throw new IllegalStateException("The " + this.getClass().getName() + " does not work when population is not known");
    }

    @Override
    public void blockingUserNotAllowed(Redirector redirector) throws Exception {
        Request request = ContextHelper.getRequest((Context)this._context);
        String url = (String)request.getAttribute("Runtime:RequestLoginURL");
        StringBuilder parameters = new StringBuilder();
        parameters.append(url.indexOf(63) >= 0 ? "&" : "?");
        parameters.append("login=");
        parameters.append(request.getParameter(this._usernameField));
        parameters.append("&authFailure=true");
        int nbConnect = this._setNbConnectBDD(request.getParameter(this._usernameField), this._getPopulation(request).getId());
        if (this._useCaptchaOnFailure) {
            String captchaKey = request.getParameter(this._captchaKeyField);
            int nbAttempts = NB_CONNECTION_ATTEMPTS - 1;
            if (nbConnect == nbAttempts || captchaKey == null && nbConnect > nbAttempts) {
                parameters.append("&tooManyAttempts=true");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)this._getCookieValue())) {
            parameters.append("&cookieFailure=true");
            this._deleteCookie();
        }
        redirector.redirect(false, url + String.valueOf(parameters));
    }

    @Override
    public void nonBlockingUserNotAllowed(Redirector redirector) {
    }

    @Override
    public void blockingUserAllowed(UserIdentity userConnected, Redirector redirector) {
        Request request;
        if (this._allowCookies && "true".equals((request = ContextHelper.getRequest((Context)this._context)).getParameter(this._rememberMeField))) {
            this.nonBlockingUserAllowed(userConnected, redirector);
        }
        if (this._storePasswordInSession) {
            request = ContextHelper.getRequest((Context)this._context);
            request.getSession(true).setAttribute(PASSWORD_SESSION_ATTRIBUTE, (Object)request.getParameter(this._passwordField));
        }
        this._deleteLoginFailedBDD(userConnected.getLogin(), userConnected.getPopulationId());
    }

    @Override
    public void nonBlockingUserAllowed(UserIdentity userConnected, Redirector redirector) {
        if (this._cookieEnabled && this._authenticationTokenManager != null) {
            String token = this._authenticationTokenManager.generateToken(userConnected, this._cookieLifetime, 1, "FormsCredentialProvider-Cookie", null);
            this._updateCookie(token);
        }
    }

    @Override
    public boolean requiresNewWindow() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _deleteAllPastLoginFailedBDD() {
        block5: {
            Connection connection = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                connection = this.getSQLConnection();
                String sql = "DELETE FROM Users_FormConnectionFailed WHERE last_connect < ?";
                ZonedDateTime dateToday = ZonedDateTime.now();
                ZonedDateTime thresholdDate = dateToday.minusDays(TIME_ALLOWED.intValue());
                Timestamp threshold = Timestamp.from(thresholdDate.toInstant());
                stmt = connection.prepareStatement(sql);
                stmt.setTimestamp(1, threshold);
                stmt.execute();
                ConnectionHelper.cleanup(rs);
            }
            catch (SQLException e) {
                this.getLogger().error("Error during the connection to the database", (Throwable)e);
                break block5;
            }
            finally {
                ConnectionHelper.cleanup(rs);
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup(connection);
            }
            ConnectionHelper.cleanup(stmt);
            ConnectionHelper.cleanup(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer requestNbConnectBDD(String login, String populationId) {
        Integer n;
        this._deleteAllPastLoginFailedBDD();
        Connection connection = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            connection = this.getSQLConnection();
            String sql = "SELECT nb_connect FROM Users_FormConnectionFailed WHERE LOWER(login) = LOWER(?) and population_id = ?";
            stmt = connection.prepareStatement(sql);
            stmt.setString(1, login);
            stmt.setString(2, populationId);
            rs = stmt.executeQuery();
            Integer nbConnect = 0;
            if (rs.next()) {
                nbConnect = rs.getInt("nb_connect");
            }
            n = nbConnect;
        }
        catch (SQLException e) {
            Integer n2;
            try {
                this.getLogger().error("Error during the connection to the database", (Throwable)e);
                n2 = 0;
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(rs);
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup(connection);
                throw throwable;
            }
            ConnectionHelper.cleanup(rs);
            ConnectionHelper.cleanup(stmt);
            ConnectionHelper.cleanup(connection);
            return n2;
        }
        ConnectionHelper.cleanup(rs);
        ConnectionHelper.cleanup(stmt);
        ConnectionHelper.cleanup(connection);
        return n;
    }

    protected Integer _setNbConnectBDD(String login, String populationId) {
        Integer nbConnect = this.requestNbConnectBDD(login, populationId);
        if (nbConnect == 0) {
            this._insertLoginNbConnectBDD(login, populationId);
        } else {
            this._updateLoginNbConnectBDD(login, populationId, nbConnect);
        }
        return nbConnect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _insertLoginNbConnectBDD(String login, String populationId) {
        Connection connection = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            connection = this.getSQLConnection();
            String sqlUpdate = "INSERT INTO Users_FormConnectionFailed (login, population_id, nb_connect, last_connect) VALUES (?, ?, ?, ?)";
            stmt = connection.prepareStatement(sqlUpdate);
            stmt.setString(1, login);
            stmt.setString(2, populationId);
            stmt.setInt(3, 1);
            Timestamp date = Timestamp.from(Instant.now());
            stmt.setTimestamp(4, date);
            stmt.execute();
        }
        catch (SQLException e) {
            try {
                this.getLogger().error("Error during the connection to the database", (Throwable)e);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(rs);
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup(connection);
                throw throwable;
            }
            ConnectionHelper.cleanup(rs);
            ConnectionHelper.cleanup(stmt);
            ConnectionHelper.cleanup(connection);
        }
        ConnectionHelper.cleanup(rs);
        ConnectionHelper.cleanup(stmt);
        ConnectionHelper.cleanup(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _deleteLoginFailedBDD(String login, String populationId) {
        Connection connection = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            connection = this.getSQLConnection();
            String sql = "DELETE FROM Users_FormConnectionFailed WHERE LOWER(login) = LOWER(?) and population_id = ?";
            stmt = connection.prepareStatement(sql);
            stmt.setString(1, login);
            stmt.setString(2, populationId);
            stmt.execute();
        }
        catch (SQLException e) {
            try {
                this.getLogger().error("Error during the connection to the database", (Throwable)e);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(rs);
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup(connection);
                throw throwable;
            }
            ConnectionHelper.cleanup(rs);
            ConnectionHelper.cleanup(stmt);
            ConnectionHelper.cleanup(connection);
        }
        ConnectionHelper.cleanup(rs);
        ConnectionHelper.cleanup(stmt);
        ConnectionHelper.cleanup(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _updateLoginNbConnectBDD(String login, String populationId, Integer nbConnect) {
        Connection connection = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            connection = this.getSQLConnection();
            String sqlUpdate = "UPDATE Users_FormConnectionFailed SET nb_connect = ? WHERE LOWER(login) = LOWER(?) and population_id = ?";
            stmt = connection.prepareStatement(sqlUpdate);
            stmt.setInt(1, nbConnect + 1);
            stmt.setString(2, login);
            stmt.setString(3, populationId);
            stmt.execute();
        }
        catch (SQLException e) {
            try {
                this.getLogger().error("Error during the connection to the database", (Throwable)e);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(rs);
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup(connection);
                throw throwable;
            }
            ConnectionHelper.cleanup(rs);
            ConnectionHelper.cleanup(stmt);
            ConnectionHelper.cleanup(connection);
        }
        ConnectionHelper.cleanup(rs);
        ConnectionHelper.cleanup(stmt);
        ConnectionHelper.cleanup(connection);
    }

    protected String _getCookieValue() {
        Cookie[] cookies = ContextHelper.getRequest((Context)this._context).getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!this._cookieName.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    protected boolean _isCookieAlreadySet() {
        Cookie[] cookies = ContextHelper.getRequest((Context)this._context).getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!this._cookieName.equals(cookie.getName())) continue;
                return true;
            }
        }
        return false;
    }

    protected void _updateCookie(String value) {
        Request request = ContextHelper.getRequest((Context)this._context);
        Response response = ContextHelper.getResponse((Context)this._context);
        Cookie cookie = response.createCookie(this._cookieName, value);
        cookie.setSecure(request.isSecure());
        cookie.setPath(ContextHelper.getRequest((Context)this._context).getContextPath());
        cookie.setMaxAge((int)this._cookieLifetime);
        ((HttpCookie)cookie).getServletCookie().setHttpOnly(true);
        ContextHelper.getResponse((Context)this._context).addCookie(cookie);
    }

    protected void _deleteCookie() {
        HttpCookie cookie = new HttpCookie(this._cookieName, "");
        cookie.setPath(ContextHelper.getRequest((Context)this._context).getContextPath());
        cookie.setMaxAge(0);
        ContextHelper.getResponse((Context)this._context).addCookie((Cookie)cookie);
    }

    public boolean useMultifactorAuthentication() {
        return this._useMultifactorAuthentication && !PluginsManager.getInstance().isSafeMode();
    }

    public boolean displayResetLink() {
        return this._displayResetLink;
    }

    public static enum MFAMode {
        EMAIL,
        APPLICATION;

    }
}

