/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.authentication;

import dev.samstevens.totp.exceptions.QrGenerationException;
import dev.samstevens.totp.qr.QrData;
import dev.samstevens.totp.qr.QrGenerator;
import dev.samstevens.totp.qr.ZxingPngQrGenerator;
import java.io.IOException;
import java.util.Map;
import org.ametys.plugins.core.authentication.MultifactorAuthenticationManager;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.reading.AbstractReader;
import org.xml.sax.SAXException;

public class MultifactorAuthenticationQrCodeReader
extends AbstractReader
implements Serviceable {
    private MultifactorAuthenticationManager _multifactorAuthenticationManager;
    private QrGenerator _qrGenerator;

    public void service(ServiceManager manager) throws ServiceException {
        this._multifactorAuthenticationManager = (MultifactorAuthenticationManager)manager.lookup(MultifactorAuthenticationManager.ROLE);
    }

    public void setup(SourceResolver sourceResolver, Map sourceObjectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(sourceResolver, sourceObjectModel, src, par);
        this._qrGenerator = new ZxingPngQrGenerator();
    }

    public void recycle() {
        super.recycle();
        this._qrGenerator = null;
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        try {
            QrData data = this._multifactorAuthenticationManager.getCurrentUserQrData();
            byte[] imageData = this._qrGenerator.generate(data);
            this.out.write(imageData);
        }
        catch (QrGenerationException e) {
            throw new ProcessingException((Exception)((Object)e));
        }
    }

    public String getMimeType() {
        return this._qrGenerator.getImageMimeType();
    }

    public boolean shouldSetContentLength() {
        return false;
    }
}

