/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.Weigher;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.ametys.core.cache.CacheException;
import org.ametys.core.cache.CacheStats;
import org.ametys.core.util.SizeUtils;
import org.ametys.plugins.core.impl.cache.AbstractCacheKey;
import org.ametys.plugins.core.impl.cache.GuavaCacheStats;
import org.ametys.runtime.i18n.I18nizableText;

public class GuavaCache<K, V>
implements org.ametys.core.cache.Cache<K, V> {
    protected Cache<K, Optional<V>> _cache;
    protected String _id;
    protected I18nizableText _label;
    protected I18nizableText _description;
    protected long _size;
    protected boolean _computableSize;
    protected Duration _duration;
    protected boolean _isInitialized;
    protected boolean _isDispatchable;

    public GuavaCache(String id, I18nizableText label, I18nizableText description, long size, boolean computableSize, Duration duration, boolean isDispatchable) {
        this._label = label;
        this._description = description;
        this._id = id;
        this._size = size;
        this._computableSize = computableSize;
        this._duration = duration;
        this._isInitialized = false;
        this._isDispatchable = isDispatchable;
        this.resetCache();
    }

    @Override
    public void resetCache() {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        if (this._duration != null) {
            cacheBuilder = cacheBuilder.expireAfterWrite(this._duration);
        }
        this._cache = cacheBuilder.recordStats().maximumWeight(this._size).weigher(new Weigher<K, Optional<V>>(){

            public int weigh(K k, Optional<V> v) {
                if (GuavaCache.this._computableSize) {
                    return (int)(SizeUtils.sizeOf(k) + SizeUtils.sizeOf(v.orElse(null)));
                }
                return 0;
            }
        }).build();
        this._isInitialized = false;
    }

    @Override
    public V get(final K key, final Function<K, V> function) throws CacheException {
        if (key instanceof AbstractCacheKey && ((AbstractCacheKey)key).isPartialKey()) {
            throw new CacheException("Complex key is not valid because it contains null values");
        }
        try {
            return ((Optional)this._cache.get(key, new Callable<Optional<V>>(){

                @Override
                public Optional<V> call() {
                    return Optional.ofNullable(function.apply(key));
                }
            })).orElse(null);
        }
        catch (ExecutionError | UncheckedExecutionException | ExecutionException e) {
            throw new CacheException("An error occurred while computing the new value for key " + String.valueOf(key), e.getCause());
        }
    }

    @Override
    public V get(K key) {
        Optional optional = (Optional)this._cache.getIfPresent(key);
        if (optional != null) {
            return optional.orElse(null);
        }
        return null;
    }

    @Override
    public void put(K key, V value) {
        if (key instanceof AbstractCacheKey && ((AbstractCacheKey)key).isPartialKey()) {
            throw new RuntimeException("complex key is not valid because it contains null values");
        }
        this._cache.put(key, Optional.ofNullable(value));
        this._isInitialized = true;
    }

    @Override
    public void putAll(Map<K, V> map) {
        map.forEach((k, v) -> this._cache.put(k, Optional.ofNullable(v)));
        this._isInitialized = true;
    }

    @Override
    public CacheStats getCacheStats() {
        return new GuavaCacheStats(this._cache.stats());
    }

    @Override
    public long getMemorySize() throws CacheException {
        if (!this._computableSize) {
            return -1L;
        }
        try {
            long sum = 0L;
            Field localCacheField = this._cache.getClass().getDeclaredField("localCache");
            localCacheField.setAccessible(true);
            Object localCache = localCacheField.get(this._cache);
            Field segmentsField = localCache.getClass().getDeclaredField("segments");
            segmentsField.setAccessible(true);
            Object[] segments = (Object[])segmentsField.get(localCache);
            for (int i = 0; i < segments.length; ++i) {
                Field totalWeight = segments[i].getClass().getDeclaredField("totalWeight");
                totalWeight.setAccessible(true);
                long totalWeightValue = (Long)totalWeight.get(segments[i]);
                sum += totalWeightValue;
            }
            return sum;
        }
        catch (Exception e) {
            throw new CacheException("Cannot compute object size", e);
        }
    }

    @Override
    public long getNumberOfElements() {
        return this._cache.size();
    }

    @Override
    public void invalidate(K key) {
        List<Object> keyToRemove = new ArrayList<K>();
        if (key instanceof AbstractCacheKey) {
            AbstractCacheKey invalidationKey = (AbstractCacheKey)key;
            if (invalidationKey.isPartialKey()) {
                List<? super Object> keyList = invalidationKey.getFields();
                keyToRemove = this._cache.asMap().keySet().stream().filter(k -> {
                    AbstractCacheKey abstractK = (AbstractCacheKey)k;
                    boolean isEquals = true;
                    for (int i = 0; i < keyList.size(); ++i) {
                        isEquals = isEquals && (keyList.get(i) == null || keyList.get(i).equals(abstractK.getFields().get(i)));
                    }
                    return isEquals;
                }).collect(Collectors.toList());
            } else {
                keyToRemove.add(key);
            }
        } else {
            keyToRemove.add(key);
        }
        this._cache.invalidateAll(keyToRemove);
    }

    @Override
    public void invalidateAll() {
        this._cache.invalidateAll();
        this._isInitialized = false;
    }

    @Override
    public I18nizableText getDescription() {
        return this._description;
    }

    @Override
    public I18nizableText getLabel() {
        return this._label;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public long getMaxSize() {
        return this._size;
    }

    @Override
    public boolean hasKey(K key) {
        if (key instanceof AbstractCacheKey) {
            AbstractCacheKey invalidationKey = (AbstractCacheKey)key;
            if (invalidationKey.isPartialKey()) {
                List<? super Object> keyList = invalidationKey.getFields();
                return this._cache.asMap().keySet().stream().anyMatch(k -> {
                    boolean hasKey = true;
                    AbstractCacheKey abstractKey = (AbstractCacheKey)k;
                    List<? super Object> fields = abstractKey.getFields();
                    for (int i = 0; hasKey && i < keyList.size(); ++i) {
                        hasKey = keyList.get(i) == null || keyList.get(i).equals(fields.get(i));
                    }
                    return hasKey;
                });
            }
            return this._cache.asMap().containsKey(key);
        }
        return this._cache.asMap().containsKey(key);
    }

    @Override
    public Map<K, V> asMap() {
        HashMap map = new HashMap();
        ConcurrentMap maps = this._cache.asMap();
        maps.forEach((k, v) -> map.put(k, v.orElse(null)));
        return map;
    }

    @Override
    public boolean isComputableSize() {
        return this._computableSize;
    }

    @Override
    public boolean isInitialized() {
        return this._isInitialized;
    }

    @Override
    public boolean isDispatchable() {
        return this._isDispatchable;
    }

    @Override
    public Map<K, V> getAll(AbstractCacheKey filterKey) {
        return this.asMap().entrySet().stream().filter(entry -> this._checkKey(entry.getKey(), filterKey.getFields())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private boolean _checkKey(K key, List<Object> fields) {
        if (key instanceof AbstractCacheKey) {
            if (((AbstractCacheKey)key).getFields().size() != fields.size()) {
                throw new RuntimeException("Complex key lengths does not match");
            }
        } else {
            throw new RuntimeException("Key is not a complex key");
        }
        for (int i = 0; i < fields.size(); ++i) {
            if (fields.get(i) == null || fields.get(i).equals(((AbstractCacheKey)key).getFields().get(i))) continue;
            return false;
        }
        return true;
    }
}

