/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.cache;

import java.time.Duration;
import org.ametys.core.DevMode;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.core.util.SizeUtils;
import org.ametys.plugins.core.impl.cache.GuavaCache;
import org.ametys.runtime.i18n.I18nizableText;

public class GuavaCacheManager
extends AbstractCacheManager {
    protected boolean _canComputeSize;

    @Override
    public void initialize() throws Exception {
        super.initialize();
        boolean jolComputeSize = SizeUtils.enabled();
        if (!jolComputeSize) {
            this.getLogger().warn("JOL is not supported for this JVM. Caches sizes won't be computed.");
        }
        this._canComputeSize = jolComputeSize && DevMode.getDeveloperMode() == DevMode.DEVMODE.PRODUCTION;
    }

    protected Cache _createCache(String id, I18nizableText name, I18nizableText description, boolean computableSize, Duration duration, boolean isDispatchable) {
        return new GuavaCache(id, name, description, Long.MAX_VALUE, this._canComputeSize && computableSize, duration, isDispatchable);
    }
}

