/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.captcha.jcaptcha;

import java.awt.image.BufferedImage;
import java.util.Map;
import org.ametys.core.captcha.BufferedImageReader;
import org.ametys.core.captcha.Captcha;
import org.ametys.core.captcha.CaptchaHelper;
import org.ametys.plugins.core.impl.captcha.jcaptcha.JCaptcha;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.acting.AbstractAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;

public class CreateJCaptchaAction
extends AbstractAction {
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        String cancelledKey = parameters.getParameter("cancelledKey", "");
        Captcha captcha = CaptchaHelper.getCaptcha();
        if (!(captcha instanceof JCaptcha)) {
            throw new RuntimeException("This action can only work if jcaptcha is enabled");
        }
        JCaptcha jCaptcha = (JCaptcha)captcha;
        if (StringUtils.isNotEmpty((CharSequence)cancelledKey)) {
            jCaptcha.removeCaptcha(cancelledKey);
        }
        boolean fisheye = parameters.getParameterAsBoolean("fisheye", false);
        boolean noise = parameters.getParameterAsBoolean("noise", false);
        int color = parameters.getParameterAsInteger("color", 0);
        int width = parameters.getParameterAsInteger("width", 200);
        int height = parameters.getParameterAsInteger("height", 50);
        BufferedImage bi = jCaptcha.generateImageCaptcha(source, color, noise, fisheye, width, height);
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        request.setAttribute(BufferedImageReader.REQUEST_ATTRIBUTE, (Object)bi);
        return EMPTY_MAP;
    }
}

