/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.captcha.jcaptcha;

import java.awt.Color;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import nl.captcha.Captcha;
import nl.captcha.gimpy.DropShadowGimpyRenderer;
import nl.captcha.gimpy.FishEyeGimpyRenderer;
import nl.captcha.gimpy.GimpyRenderer;
import nl.captcha.gimpy.RippleGimpyRenderer;
import nl.captcha.noise.CurvedLineNoiseProducer;
import nl.captcha.noise.NoiseProducer;
import nl.captcha.text.producer.DefaultTextProducer;
import nl.captcha.text.producer.TextProducer;
import nl.captcha.text.renderer.DefaultWordRenderer;
import nl.captcha.text.renderer.WordRenderer;
import org.ametys.core.captcha.AbstractCaptcha;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.commons.lang3.StringUtils;

public class JCaptcha
extends AbstractCaptcha {
    protected static final String STATIC_PREFIX_KEY = "STATIC-";
    protected static final String DYNAMIC_PREFIX_KEY = "DYNAMIC-";
    protected static Map<String, List<ValidableCaptcha>> _mapStaticCaptcha = new HashMap<String, List<ValidableCaptcha>>();
    protected static Map<String, ValidableCaptcha> _mapDynamicCaptcha = new HashMap<String, ValidableCaptcha>();

    @Override
    public boolean checkAndInvalidateCaptcha(String key, String value) {
        if (StringUtils.isEmpty((CharSequence)key) || StringUtils.isEmpty((CharSequence)value)) {
            return false;
        }
        if (key.startsWith(STATIC_PREFIX_KEY)) {
            List<ValidableCaptcha> list = _mapStaticCaptcha.get(key);
            if (list != null) {
                for (ValidableCaptcha c : list) {
                    Captcha captcha;
                    if (!c.isValid() || !(captcha = c.getCaptcha()).isCorrect(value)) continue;
                    c.invalidate();
                    return true;
                }
            }
            return false;
        }
        if (key.startsWith(DYNAMIC_PREFIX_KEY)) {
            ValidableCaptcha vc = _mapDynamicCaptcha.get(key);
            if (vc == null) {
                return false;
            }
            if (!vc.isValid()) {
                _mapDynamicCaptcha.remove(key);
                return false;
            }
            _mapDynamicCaptcha.remove(key);
            Captcha c = vc.getCaptcha();
            return c.isCorrect(value);
        }
        throw new IllegalArgumentException("The key '" + key + "' is not a valid captcha key because it does not starts with 'DYNAMIC-' or 'STATIC-'");
    }

    @Override
    public I18nizableText getLabel() {
        return new I18nizableText("plugin.core-impl", "PLUGINS_CORE_CAPTCHA_CONFIG_TYPE_JCAPTCHA");
    }

    @Override
    public I18nizableText getLoginFailedBecauseCaptchaFailedLabel() {
        return new I18nizableText("plugin.core-impl", "PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_FAILED_WITH_CAPTCHA_jcaptcha");
    }

    @Override
    public I18nizableText getLoginFailedBecauseTooManyAttemptLabel() {
        return new I18nizableText("plugin.core-impl", "PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_FAILED_MANY_TIME_jcaptcha");
    }

    @Override
    public List<Pattern> getUsedUrlPatterns() {
        return Arrays.asList(Pattern.compile("^plugins/core-impl/captcha/core-impl/jcaptcha/[^/]+/image.png"));
    }

    public synchronized BufferedImage generateImageCaptcha(String key, Integer color, boolean addNoise, boolean fisheye, int width, int height) {
        Captcha captcha = this._generateImageCaptcha(color, addNoise, fisheye, width, height);
        ValidableCaptcha vc = new ValidableCaptcha(this, captcha);
        if (key.startsWith(STATIC_PREFIX_KEY)) {
            if (!_mapStaticCaptcha.containsKey(key)) {
                _mapStaticCaptcha.put(key, new ArrayList());
            }
            List<ValidableCaptcha> captchas = _mapStaticCaptcha.get(key);
            captchas.add(new ValidableCaptcha(this, captcha));
        } else if (key.startsWith(DYNAMIC_PREFIX_KEY)) {
            _mapDynamicCaptcha.put(key, vc);
        } else {
            throw new IllegalArgumentException("The key '" + key + "' is not a valid captcha key because it does not starts with 'DYNAMIC-' or 'STATIC-'");
        }
        return vc.getCaptcha().getImage();
    }

    private Captcha _generateImageCaptcha(Integer color, boolean addNoise, boolean fisheye, int width, int height) {
        ArrayList<Color> colors = new ArrayList<Color>();
        colors.add(new Color(color));
        ArrayList<Font> fonts = new ArrayList<Font>();
        fonts.add(new Font("Arial", 1, 40));
        fonts.add(new Font("Courier", 1, 40));
        Captcha.Builder builder = new Captcha.Builder(width, height).addText((TextProducer)new DefaultTextProducer(6, "abcdefghijklmnopqrstuvwxyz".toCharArray()), (WordRenderer)new DefaultWordRenderer(colors, fonts)).gimp((GimpyRenderer)new RippleGimpyRenderer()).addNoise((NoiseProducer)new CurvedLineNoiseProducer(new Color(color), 3.0f));
        if (addNoise) {
            builder.addNoise((NoiseProducer)new CurvedLineNoiseProducer(new Color(color), 3.0f)).gimp((GimpyRenderer)new DropShadowGimpyRenderer());
        }
        if (fisheye) {
            builder.gimp((GimpyRenderer)new FishEyeGimpyRenderer());
        }
        return builder.build();
    }

    public synchronized void removeCaptcha(String key) {
        if (key.startsWith(STATIC_PREFIX_KEY)) {
            _mapStaticCaptcha.remove(key);
        } else if (key.startsWith(DYNAMIC_PREFIX_KEY)) {
            _mapDynamicCaptcha.remove(key);
        }
    }

    public synchronized void cleanOldCaptchas() {
        this._cleanOldStaticCaptchas();
        this._cleanOldDynamicCaptchas();
    }

    private synchronized void _cleanOldDynamicCaptchas() {
        Iterator<String> cIt = _mapDynamicCaptcha.keySet().iterator();
        while (cIt.hasNext()) {
            String id = cIt.next();
            ValidableCaptcha vc = _mapDynamicCaptcha.get(id);
            if (vc.isValid()) continue;
            cIt.remove();
        }
    }

    private synchronized void _cleanOldStaticCaptchas() {
        Iterator<String> cIt = _mapStaticCaptcha.keySet().iterator();
        while (cIt.hasNext()) {
            String id = cIt.next();
            List<ValidableCaptcha> c = _mapStaticCaptcha.get(id);
            Iterator<ValidableCaptcha> it = c.iterator();
            while (it.hasNext()) {
                ValidableCaptcha vc = it.next();
                if (vc.isValid()) continue;
                it.remove();
            }
            if (!c.isEmpty()) continue;
            cIt.remove();
        }
    }

    protected class ValidableCaptcha {
        private Captcha _captcha;
        private Date _date;
        private boolean _valid;

        public ValidableCaptcha(JCaptcha this$0, Captcha c) {
            this._captcha = c;
            this._date = new Date();
            this._valid = true;
        }

        public boolean isValid() {
            if (!this._valid) {
                return false;
            }
            GregorianCalendar validity = new GregorianCalendar();
            ((Calendar)validity).add(12, -20);
            return this._date.after(validity.getTime());
        }

        public Captcha getCaptcha() {
            return this._captcha;
        }

        public void invalidate() {
            this._valid = false;
        }
    }
}

