/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.captcha.recaptcha;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.ametys.core.captcha.AbstractCaptcha;
import org.ametys.core.util.HttpUtils;
import org.ametys.core.util.JSONUtils;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.io.CloseMode;

public class ReCaptchaEnterprise
extends AbstractCaptcha
implements Serviceable,
Initializable,
Disposable {
    private static final String __RECAPTCHA_API_KEY = "runtime.captcha.recaptcha.enterprise.apikey";
    private static final String __RECAPTCHA_SITE_KEY = "runtime.captcha.recaptcha.enterprise.sitekey";
    private static final String __RECAPTCHA_PROJECT_ID = "runtime.captcha.recaptcha.enterprise.projectId";
    private static final String __RECAPTCHA_THRESHOLD = "runtime.captcha.recaptcha.enterprise.threshold";
    private static final String __RECAPTCHA_URL = "https://recaptchaenterprise.googleapis.com/v1/projects/";
    private JSONUtils _jsonUtils;
    private String _projectId;
    private String _apiKey;
    private Object _siteKey;
    private Double _threshold;
    private CloseableHttpClient _httpClient;

    public void service(ServiceManager manager) throws ServiceException {
        this._jsonUtils = (JSONUtils)manager.lookup(JSONUtils.ROLE);
    }

    public void initialize() throws Exception {
        this._initializeConfig();
        this._httpClient = HttpUtils.createHttpClient(0, 2);
    }

    private boolean _initializeConfig() {
        Config config = Config.getInstance();
        if (config != null) {
            this._apiKey = (String)config.getValue(__RECAPTCHA_API_KEY);
            this._projectId = (String)config.getValue(__RECAPTCHA_PROJECT_ID);
            this._siteKey = config.getValue(__RECAPTCHA_SITE_KEY);
            this._threshold = (Double)config.getValue(__RECAPTCHA_THRESHOLD);
            return true;
        }
        return false;
    }

    @Override
    public boolean requireUserInteraction() {
        return false;
    }

    @Override
    public synchronized boolean checkAndInvalidateCaptcha(String key, String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return false;
        }
        if (this._apiKey != null || this._initializeConfig()) {
            try {
                HttpPost post = new HttpPost(__RECAPTCHA_URL + this._projectId + "/assessments?key=" + this._apiKey);
                HashMap<String, Object> eventParams = new HashMap<String, Object>(2);
                eventParams.put("token", value);
                eventParams.put("siteKey", this._siteKey);
                post.setEntity((HttpEntity)new StringEntity(this._jsonUtils.convertObjectToJson(Map.of("event", eventParams)), ContentType.APPLICATION_JSON));
                return (Boolean)this._httpClient.execute((ClassicHttpRequest)post, httpResponse -> {
                    if (httpResponse.getCode() != 200) {
                        return false;
                    }
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    try (InputStream is = httpResponse.getEntity().getContent();){
                        IOUtils.copy((InputStream)is, (OutputStream)bos);
                    }
                    Map<String, Object> jsonObject = this._jsonUtils.convertJsonToMap(bos.toString());
                    Map tokenProperties = (Map)jsonObject.get("tokenProperties");
                    if (tokenProperties != null && tokenProperties.getOrDefault("valid", false).booleanValue()) {
                        Map riskAnalysis = (Map)jsonObject.get("riskAnalysis");
                        Double score = (Double)riskAnalysis.get("score");
                        List reasons = (List)riskAnalysis.computeIfAbsent("reasons", str -> List.of("CLASSIFICATION_REASON_UNSPECIFIED"));
                        if (score >= this._threshold || reasons.contains("LOW_CONFIDENCE_SCORE")) {
                            return true;
                        }
                    }
                    return false;
                });
            }
            catch (IOException e) {
                this.getLogger().error("Unable to contact Google server to validate reCaptcha.", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    @Override
    public I18nizableText getLabel() {
        return new I18nizableText("plugin.core-impl", "PLUGINS_CORE_CAPTCHA_CONFIG_TYPE_RECAPTCHA_ENTERPRISE");
    }

    @Override
    public I18nizableText getLoginFailedBecauseCaptchaFailedLabel() {
        return new I18nizableText("plugin.core-impl", "PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_FAILED_WITH_CAPTCHA_RECAPTCHA_ENTERPRISE");
    }

    @Override
    public I18nizableText getLoginFailedBecauseTooManyAttemptLabel() {
        return new I18nizableText("plugin.core-ui", "PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_AUTH_FAILURE");
    }

    @Override
    public List<Pattern> getUsedUrlPatterns() {
        return List.of();
    }

    public void dispose() {
        this._httpClient.close(CloseMode.GRACEFUL);
    }
}

