/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.captcha.recaptcha;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.ametys.core.captcha.AbstractCaptcha;
import org.ametys.core.util.HttpUtils;
import org.ametys.core.util.JSONUtils;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.io.CloseMode;

public class ReCaptchaV2
extends AbstractCaptcha
implements Serviceable,
Initializable,
Disposable {
    private static String __RECAPTCHA_SECRET_KEY = "runtime.captcha.recaptcha.secretkey";
    private static String __RECAPTCHA_URL = "https://www.google.com/recaptcha/api/siteverify";
    private JSONUtils _jsonUtils;
    private CloseableHttpClient _httpClient;

    public void service(ServiceManager manager) throws ServiceException {
        this._jsonUtils = (JSONUtils)manager.lookup(JSONUtils.ROLE);
    }

    public void initialize() throws Exception {
        this._httpClient = HttpUtils.createHttpClient(0, 2);
    }

    @Override
    public synchronized boolean checkAndInvalidateCaptcha(String key, String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return false;
        }
        if (Config.getInstance() != null) {
            String secretKey = (String)Config.getInstance().getValue(__RECAPTCHA_SECRET_KEY);
            try {
                HttpPost post = new HttpPost(__RECAPTCHA_URL);
                ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
                params.add(new BasicNameValuePair("secret", secretKey));
                params.add(new BasicNameValuePair("response", value));
                post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, StandardCharsets.UTF_8));
                return (Boolean)this._httpClient.execute((ClassicHttpRequest)post, httpResponse -> {
                    if (httpResponse.getCode() != 200) {
                        return false;
                    }
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    try (InputStream is = httpResponse.getEntity().getContent();){
                        IOUtils.copy((InputStream)is, (OutputStream)bos);
                    }
                    Map<String, Object> jsonObject = this._jsonUtils.convertJsonToMap(bos.toString());
                    return (Boolean)jsonObject.getOrDefault("success", false);
                });
            }
            catch (IOException e) {
                this.getLogger().error("Unable to contact Google server to validate reCaptcha.", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    @Override
    public I18nizableText getLabel() {
        return new I18nizableText("plugin.core-impl", "PLUGINS_CORE_CAPTCHA_CONFIG_TYPE_RECAPTCHA");
    }

    @Override
    public I18nizableText getLoginFailedBecauseCaptchaFailedLabel() {
        return new I18nizableText("plugin.core-impl", "PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_FAILED_WITH_CAPTCHA_recaptcha");
    }

    @Override
    public I18nizableText getLoginFailedBecauseTooManyAttemptLabel() {
        return new I18nizableText("plugin.core-impl", "PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_FAILED_MANY_TIME_recaptcha");
    }

    @Override
    public List<Pattern> getUsedUrlPatterns() {
        return List.of();
    }

    public void dispose() {
        this._httpClient.close(CloseMode.GRACEFUL);
    }
}

