/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.checker;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import org.ametys.runtime.model.checker.ItemChecker;
import org.ametys.runtime.model.checker.ItemCheckerTestFailureException;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.excalibur.source.ModifiableTraversableSource;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.TraversableSource;
import org.apache.excalibur.source.impl.FileSource;

public class DirectoryChecker
extends AbstractLogEnabled
implements Configurable,
ItemChecker,
Serviceable {
    private boolean _checkWrite;
    private SourceResolver _sourceResolver;
    private boolean _createsIfRequired;
    private ServiceManager _sManager;

    public void configure(Configuration configuration) throws ConfigurationException {
        this._createsIfRequired = configuration.getChild("configuration").getChild("creates-if-required", false) != null;
        boolean bl = this._checkWrite = configuration.getChild("configuration").getChild("check-write", false) != null;
        if (configuration.getChild("linked-params").getChildren().length != 1) {
            throw new ConfigurationException("The Directory Checker should have exactly 1 linked parameter: the directory");
        }
    }

    public void service(ServiceManager sManager) throws ServiceException {
        this._sManager = sManager;
    }

    @Override
    public void check(List<String> values) throws ItemCheckerTestFailureException {
        if (this._sourceResolver == null) {
            try {
                this._sourceResolver = (SourceResolver)this._sManager.lookup(SourceResolver.ROLE);
            }
            catch (ServiceException e) {
                throw new ItemCheckerTestFailureException("The test cannot be tested now", e);
            }
        }
        this._checkDirectory(values.get(0));
    }

    private void _checkDirectory(String path) throws ItemCheckerTestFailureException {
        Source source = null;
        try {
            source = this._sourceResolver.resolveURI(path, "context://", null);
            boolean removeIt = false;
            if (!source.exists()) {
                if (!this._createsIfRequired) {
                    throw new ItemCheckerTestFailureException("The specified directory at '" + source.getURI() + "' does not exist");
                }
                if (!(source instanceof ModifiableTraversableSource)) {
                    throw new ItemCheckerTestFailureException("The specified directory at '" + source.getURI() + "' does not exist and cannot be created");
                }
                try {
                    ((ModifiableTraversableSource)source).makeCollection();
                    removeIt = true;
                }
                catch (SourceException e) {
                    throw new ItemCheckerTestFailureException("The specified directory at '" + source.getURI() + "' does not exist and cannot be created", e);
                }
            }
            if (!(source instanceof TraversableSource) && ((TraversableSource)source).isCollection()) {
                throw new ItemCheckerTestFailureException("The specified directory at '" + source.getURI() + "' is not a directory");
            }
            if (!(!this._checkWrite || source instanceof ModifiableTraversableSource && source instanceof FileSource && ((FileSource)source).getFile().canWrite())) {
                throw new ItemCheckerTestFailureException("The specified directory at '" + source.getURI() + "' is not writable");
            }
            if (removeIt) {
                try {
                    ((ModifiableTraversableSource)source).delete();
                }
                catch (SourceException e) {
                    this.getLogger().warn("The specified directory '" + source.getURI() + "' was created for tests purposes but could not be removed", (Throwable)e);
                }
            }
        }
        catch (MalformedURLException e) {
            throw new ItemCheckerTestFailureException("An error occurred while trying to resolve the following path '" + path + "'.", e);
        }
        catch (IOException e) {
            throw new ItemCheckerTestFailureException("An error occurred while trying to resolve the following path '" + path + "'.", e);
        }
    }
}

