/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.datasource;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.ametys.core.datasource.DataSourceConsumer;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.config.ConfigManager;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.parameter.Validator;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;

public class ConfigurationDataSourceConsumer
extends AbstractLogEnabled
implements DataSourceConsumer {
    @Override
    public DataSourceConsumer.TypeOfUse isInUse(String id) {
        Map<String, DataSourceConsumer.TypeOfUse> usedDataSourceIds = this.getUsedDataSourceIds();
        return usedDataSourceIds.containsKey(id) ? usedDataSourceIds.get(id) : DataSourceConsumer.TypeOfUse.NOT_USED;
    }

    @Override
    public Map<String, DataSourceConsumer.TypeOfUse> getUsedDataSourceIds() {
        HashMap<String, DataSourceConsumer.TypeOfUse> usedDataSourceIds = new HashMap<String, DataSourceConsumer.TypeOfUse>();
        Config config = Config.getInstance();
        if (config != null) {
            ConfigManager configManager = ConfigManager.getInstance();
            Collection<ElementDefinition> definitions = configManager.getConfigurationParameters();
            for (ElementDefinition definition : definitions) {
                if (!"datasource".equals(definition.getType().getId()) || configManager.evaluateDisableConditions(definition, config)) continue;
                usedDataSourceIds.put((String)config.getValue(definition.getName()), this._isMandatory(definition) ? DataSourceConsumer.TypeOfUse.BLOCKING : DataSourceConsumer.TypeOfUse.NON_BLOCKING);
            }
        }
        return usedDataSourceIds;
    }

    private boolean _isMandatory(ElementDefinition def) {
        Validator validator = def.getValidator();
        if (validator != null) {
            return validator.getConfiguration().containsKey("mandatory") && (Boolean)validator.getConfiguration().get("mandatory") != false;
        }
        return false;
    }
}

