/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.datasource;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.ametys.plugins.core.impl.datasource.StaticSQLDatabaseType;

public class PostgreSQLDatabaseType
extends StaticSQLDatabaseType {
    @Override
    public InputStream getBlob(ResultSet resultSet, String columnName) throws SQLException {
        return resultSet.getBinaryStream(columnName);
    }

    @Override
    public InputStream getBlob(ResultSet resultSet, int pos) throws SQLException {
        return resultSet.getBinaryStream(pos);
    }

    @Override
    public void setBlob(PreparedStatement statement, int pos, String blob) throws SQLException, UnsupportedEncodingException {
        if (blob == null) {
            statement.setNull(pos, -2);
        } else {
            byte[] bytes = blob.getBytes("UTF-8");
            this.setBlob(statement, pos, bytes);
        }
    }

    @Override
    public void setBlob(PreparedStatement statement, int pos, byte[] bytes) throws SQLException {
        if (bytes == null) {
            statement.setNull(pos, -2);
        } else {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
            this.setBlob(statement, pos, byteArrayInputStream, bytes.length);
        }
    }

    @Override
    public void setBlob(PreparedStatement statement, int pos, InputStream is, long length) throws SQLException {
        if (is == null) {
            statement.setNull(pos, -2);
        } else {
            statement.setBinaryStream(pos, is, length);
        }
    }
}

