/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.enumerator;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.Enumerator;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.TraversableSource;

public abstract class AbstractTraversableSourceEnumerator
implements Enumerator<String>,
Serviceable {
    private SourceResolver _srcResolver;

    public void service(ServiceManager manager) throws ServiceException {
        this._srcResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
    }

    @Override
    public Map<String, I18nizableText> getEntries() throws MalformedURLException, IOException {
        TraversableSource extractionDir = (TraversableSource)this._srcResolver.resolveURI(this.getLocation());
        if (extractionDir.exists()) {
            return this._getCollectionFilename(extractionDir, "");
        }
        return Map.of();
    }

    protected abstract String getLocation();

    private Map<String, I18nizableText> _getCollectionFilename(TraversableSource source, String prefix) throws SourceException {
        HashMap<String, I18nizableText> filenames = new HashMap<String, I18nizableText>();
        for (TraversableSource child : source.getChildren()) {
            String childName = child.getName();
            if (child.isCollection()) {
                filenames.putAll(this._getCollectionFilename(child, prefix + childName + File.separator));
                continue;
            }
            if (!this.acceptSource(child)) continue;
            String filePath = prefix + childName;
            filenames.put(filePath, new I18nizableText(filePath));
        }
        return filenames;
    }

    protected boolean acceptSource(TraversableSource source) {
        return true;
    }

    @Override
    public I18nizableText getEntry(String value) throws Exception {
        return new I18nizableText(value);
    }
}

