/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.group.directory;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.core.group.Group;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.group.directory.GroupDirectory;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.SizeUtils;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.commons.lang3.StringUtils;

public class StaticGroupDirectory
extends AbstractLogEnabled
implements GroupDirectory {
    private static final String __PARAMETER_GROUPS_DEFINITION = "runtime.groups.static.group";
    private String _id;
    private I18nizableText _label;
    private String _gdModelId;
    private Map<String, Object> _params;
    private Map<String, Group> _groups;

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public I18nizableText getLabel() {
        return this._label;
    }

    @Override
    public void setId(String id) {
        this._id = id;
    }

    @Override
    public void setLabel(I18nizableText label) {
        this._label = label;
    }

    @Override
    public String getGroupDirectoryModelId() {
        return this._gdModelId;
    }

    @Override
    public Map<String, Object> getParameterValues() {
        return this._params;
    }

    @Override
    public void init(String groupDirectoryModelId, Map<String, Object> paramValues) throws Exception {
        this._gdModelId = groupDirectoryModelId;
        this._groups = new HashMap<String, Group>();
        this._params = paramValues;
        String groupsAsText = (String)paramValues.get(__PARAMETER_GROUPS_DEFINITION);
        for (String groupLine : groupsAsText.split("\\n")) {
            if (!StringUtils.isNotEmpty((CharSequence)groupLine)) continue;
            String[] groupSplited = groupLine.split(":");
            if (groupSplited.length == 0) {
                this.getLogger().error("Error while reading StaticGroupDirectory groups, cannot create a group with the data from line {}", (Object)groupLine);
                continue;
            }
            String groupId = groupSplited[0];
            String label = groupSplited[groupSplited.length > 1 ? 1 : 0];
            HashSet<UserIdentity> users = new HashSet<UserIdentity>();
            for (int i = 2; i < groupSplited.length; ++i) {
                String userLogin = groupSplited[i].indexOf("#") > -1 ? StringUtils.substringBefore((String)groupSplited[i], (String)"#") : groupSplited[i];
                String userPopulation = groupSplited[i].indexOf("#") > -1 ? StringUtils.substringAfter((String)groupSplited[i], (String)"#") : null;
                users.add(new UserIdentity(userLogin, userPopulation));
            }
            this._groups.put(groupId, new StaticGroup(groupId, this._id, label, this, users));
        }
    }

    @Override
    public Group getGroup(String groupID) {
        return this._groups.getOrDefault(groupID, null);
    }

    @Override
    public Set<Group> getGroups() {
        return new HashSet<Group>(this._groups.values());
    }

    @Override
    public Set<String> getUserGroups(UserIdentity userIdentity) {
        return this._groups.values().stream().filter(group -> group.getUsers().contains(userIdentity)).map(Group::getIdentity).map(GroupIdentity::getId).collect(Collectors.toSet());
    }

    @Override
    public List<Group> getGroups(int count, int offset, Map parameters) {
        String pattern = (String)parameters.get("pattern");
        boolean sort = parameters.getOrDefault("sort", false);
        Predicate<Group> matchesPattern = group -> StringUtils.isEmpty((CharSequence)pattern) || group.getLabel().toLowerCase().indexOf(pattern.toLowerCase()) != -1 || group.getIdentity() != null && group.getIdentity().getId().toLowerCase().indexOf(pattern.toLowerCase()) != -1;
        Stream<Group> groupsStream = this._groups.values().stream().filter(matchesPattern);
        if (sort) {
            groupsStream = groupsStream.sorted(Comparator.comparing(Group::getLabel, String.CASE_INSENSITIVE_ORDER));
        }
        return groupsStream.skip(offset).limit(count).collect(Collectors.toList());
    }

    private static final class StaticGroup
    implements Group {
        private GroupIdentity _identity;
        private String _label;
        private Set<UserIdentity> _users;
        @SizeUtils.ExcludeFromSizeCalculation
        private GroupDirectory _groupDirectory;

        StaticGroup(String id, String directoryId, String label, GroupDirectory groupDirectory, Set<UserIdentity> users) {
            this._identity = new GroupIdentity(id, directoryId);
            this._label = label;
            this._groupDirectory = groupDirectory;
            this._users = users;
        }

        @Override
        public GroupIdentity getIdentity() {
            return this._identity;
        }

        @Override
        public String getLabel() {
            return this._label;
        }

        @Override
        public GroupDirectory getGroupDirectory() {
            return this._groupDirectory;
        }

        @Override
        public Set<UserIdentity> getUsers() {
            return this._users;
        }
    }
}

