/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.group.directory;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.group.Group;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.group.directory.GroupDirectory;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.directory.StoredUser;
import org.ametys.core.user.population.PopulationContextHelper;
import org.ametys.core.user.population.UserPopulation;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.SizeUtils;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.i18n.I18nizableTextParameter;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class UserPopulationsGroupDirectory
extends AbstractLogEnabled
implements GroupDirectory,
Serviceable {
    protected UserPopulationDAO _userPopulationDAO;
    protected PopulationContextHelper _populationContextHelper;
    protected I18nUtils _i18nUtils;
    private String _id;
    private I18nizableText _label;
    private String _gdModelId;
    private Map<String, Object> _params;

    public void service(ServiceManager smanager) throws ServiceException {
        this._userPopulationDAO = (UserPopulationDAO)smanager.lookup(UserPopulationDAO.ROLE);
        this._populationContextHelper = (PopulationContextHelper)smanager.lookup(PopulationContextHelper.ROLE);
        this._i18nUtils = (I18nUtils)((Object)smanager.lookup(I18nUtils.ROLE));
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public I18nizableText getLabel() {
        return this._label;
    }

    @Override
    public void setId(String id) {
        this._id = id;
    }

    @Override
    public void setLabel(I18nizableText label) {
        this._label = label;
    }

    @Override
    public String getGroupDirectoryModelId() {
        return this._gdModelId;
    }

    @Override
    public Map<String, Object> getParameterValues() {
        return this._params;
    }

    @Override
    public void init(String groupDirectoryModelId, Map<String, Object> paramValues) throws Exception {
        this._gdModelId = groupDirectoryModelId;
        this._params = paramValues;
    }

    @Override
    public Group getGroup(String groupID) {
        UserPopulation up = this._userPopulationDAO.getUserPopulation(groupID);
        if (up != null && this.getAvailableUserPopulationsForContext().contains(up)) {
            return new UserPopulationGroup(up, this._id, this._getGroupLabel(up), this);
        }
        return null;
    }

    @Override
    public Set<Group> getGroups() {
        List<UserPopulation> userPopulations = this.getAvailableUserPopulationsForContext();
        return userPopulations.stream().map(up -> new UserPopulationGroup((UserPopulation)up, this._id, this._getGroupLabel((UserPopulation)up), this)).collect(Collectors.toSet());
    }

    private String _getGroupLabel(UserPopulation userPopulation) {
        Map<String, I18nizableTextParameter> i18nParams = Map.of("populationLabel", userPopulation.getLabel());
        I18nizableText groupLabel = new I18nizableText("plugin.core-impl", "PLUGINS_CORE_GROUPS_USER_POULATIONS_GROUP_LABEL", i18nParams);
        return this._i18nUtils.translate(groupLabel);
    }

    protected List<UserPopulation> getAvailableUserPopulationsForContext() {
        return this._userPopulationDAO.getEnabledUserPopulations(false);
    }

    @Override
    public Set<String> getUserGroups(UserIdentity userIdentity) {
        Group group = this.getGroup(userIdentity.getPopulationId());
        if (group != null) {
            return Set.of(group.getIdentity().getId());
        }
        return Set.of();
    }

    @Override
    public List<Group> getGroups(int count, int offset, Map parameters) {
        String pattern = (String)parameters.get("pattern");
        return this.getGroups().stream().filter(group -> this._filterMatchingGroup((Group)group, pattern)).skip(offset).limit(count < 0 ? Integer.MAX_VALUE : (long)count).collect(Collectors.toList());
    }

    private boolean _filterMatchingGroup(Group group, String pattern) {
        return StringUtils.isEmpty((CharSequence)pattern) || group.getLabel().toLowerCase().indexOf(pattern.toLowerCase()) != -1 || group.getIdentity() != null && group.getIdentity().getId().toLowerCase().indexOf(pattern.toLowerCase()) != -1;
    }

    private static final class UserPopulationGroup
    implements Group {
        private GroupIdentity _identity;
        private String _label;
        @SizeUtils.ExcludeFromSizeCalculation
        private UserPopulation _userPopulation;
        @SizeUtils.ExcludeFromSizeCalculation
        private GroupDirectory _groupDirectory;

        UserPopulationGroup(UserPopulation userPopulation, String directoryId, String label, GroupDirectory groupDirectory) {
            this._identity = new GroupIdentity(userPopulation.getId(), directoryId);
            this._label = label;
            this._groupDirectory = groupDirectory;
            this._userPopulation = userPopulation;
        }

        @Override
        public GroupIdentity getIdentity() {
            return this._identity;
        }

        @Override
        public String getLabel() {
            return this._label;
        }

        @Override
        public GroupDirectory getGroupDirectory() {
            return this._groupDirectory;
        }

        @Override
        public Set<UserIdentity> getUsers() {
            return this._userPopulation.getUserDirectories().stream().flatMap(ud -> ud.getStoredUsers().stream().map(storedUser -> ud.getUserIdentity((StoredUser)storedUser))).collect(Collectors.toSet());
        }
    }
}

