/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.group.directory.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.core.datasource.ConnectionHelper;
import org.ametys.core.datasource.dbtype.SQLDatabaseTypeExtensionPoint;
import org.ametys.core.group.Group;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.group.InvalidModificationException;
import org.ametys.core.group.ModifiableGroup;
import org.ametys.core.group.directory.GroupDirectory;
import org.ametys.core.group.directory.ModifiableGroupDirectory;
import org.ametys.core.migration.MigrationEngine;
import org.ametys.core.migration.MigrationException;
import org.ametys.core.migration.MigrationExtensionPoint;
import org.ametys.core.migration.version.Version;
import org.ametys.core.migration.version.storage.SqlVersionStorage;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.script.SQLScriptHelper;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.Cacheable;
import org.ametys.core.util.SizeUtils;
import org.ametys.core.util.StringUtils;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.i18n.I18nizableTextParameter;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.excalibur.source.SourceResolver;

public class JdbcGroupDirectory
extends AbstractLogEnabled
implements ModifiableGroupDirectory,
Serviceable,
Cacheable,
Disposable {
    private static final String __DATASOURCE_PARAM_NAME = "runtime.groups.jdbc.datasource";
    private static final String __GROUPS_LIST_TABLE_PARAM_NAME = "runtime.groups.jdbc.list.table";
    private static final String __GROUPS_COMPOSITION_TABLE_PARAM_NAME = "runtime.groups.jdbc.composition.table";
    private static final String __GROUPS_LIST_COLUMN_ID = "Id";
    private static final String __GROUPS_LIST_COLUMN_LABEL = "Label";
    private static final String __GROUPS_COMPOSITION_COLUMN_GROUPID = "Group_Id";
    private static final String __GROUPS_COMPOSITION_COLUMN_LOGIN = "Login";
    private static final String __GROUPS_COMPOSITION_COLUMN_POPULATIONID = "UserPopulation_Id";
    private static final String __JDBC_GROUPDIRECTORY_GROUPS_BY_USER_CACHE_NAME_PREFIX = JdbcGroupDirectory.class.getName() + "$groups.by.user$";
    protected ObservationManager _observationManager;
    protected CurrentUserProvider _currentUserProvider;
    protected SourceResolver _sourceResolver;
    protected AbstractCacheManager _cacheManager;
    protected String _dataSourceId;
    protected String _groupsListTableName;
    protected String _groupsCompositionTableName;
    protected ServiceManager _manager;
    protected String _id;
    protected I18nizableText _label;
    private String _groupDirectoryModelId;
    private Map<String, Object> _paramValues;
    private boolean _lazyInitialized;
    private final String _uniqueCacheSuffix = StringUtils.generateKey();
    private MigrationExtensionPoint _migrationEP;
    private MigrationEngine _migrationEngine;
    private SQLDatabaseTypeExtensionPoint _sqlDatabaseTypeExtensionPoint;

    public void service(ServiceManager manager) throws ServiceException {
        this._manager = manager;
        this._observationManager = (ObservationManager)((Object)manager.lookup(ObservationManager.ROLE));
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._cacheManager = (AbstractCacheManager)manager.lookup(AbstractCacheManager.ROLE);
        this._migrationEP = (MigrationExtensionPoint)manager.lookup(MigrationExtensionPoint.ROLE);
        this._migrationEngine = (MigrationEngine)manager.lookup(MigrationEngine.ROLE);
    }

    private void _initTable(Connection connection) throws SQLException, MigrationException {
        MigrationEngine.MigrationComponent component;
        Version version;
        if (!SQLScriptHelper.tableExists(connection, this._groupsListTableName) && this._migrationEngine.initializeVersion(new MigrationEngine.ActionData(version = (component = (MigrationEngine.MigrationComponent)this._migrationEP.getExtension("group-directory.jdbc")).versionStorage().createVersion("group-directory.jdbc_" + this._groupsListTableName, component, new SqlVersionStorage.SqlVersionConfiguration(this._dataSourceId), Map.of("TABLENAME", this._groupsListTableName, "TABLENAME_COMPOSITION", this._groupsCompositionTableName)), this._migrationEngine.getHighestUpgradeVersionNumber(component), component.initialization(), null))) {
            throw new IllegalStateException("Requiring a restart after in a table initialization for a JdbcGroupDirectory is not authorized");
        }
    }

    private SQLDatabaseTypeExtensionPoint getSQLDatabaseTypeExtensionPoint() {
        if (this._sqlDatabaseTypeExtensionPoint == null) {
            try {
                this._sqlDatabaseTypeExtensionPoint = (SQLDatabaseTypeExtensionPoint)this._manager.lookup(SQLDatabaseTypeExtensionPoint.ROLE);
            }
            catch (ServiceException e) {
                throw new RuntimeException(e);
            }
        }
        return this._sqlDatabaseTypeExtensionPoint;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public I18nizableText getLabel() {
        return this._label;
    }

    @Override
    public void setId(String id) {
        this._id = id;
    }

    @Override
    public void setLabel(I18nizableText label) {
        this._label = label;
    }

    @Override
    public String getGroupDirectoryModelId() {
        return this._groupDirectoryModelId;
    }

    @Override
    public Map<String, Object> getParameterValues() {
        return this._paramValues;
    }

    public void dispose() {
        this.removeCaches();
    }

    @Override
    public Collection<Cacheable.SingleCacheConfiguration> getManagedCaches() {
        return Arrays.asList(Cacheable.SingleCacheConfiguration.of(__JDBC_GROUPDIRECTORY_GROUPS_BY_USER_CACHE_NAME_PREFIX + this._uniqueCacheSuffix, this._buildI18n("PLUGINS_CORE_GROUPS_JDBC_CACHE_GROUPS_BY_USER_LABEL"), this._buildI18n("PLUGINS_CORE_GROUPS_JDBC_CACHE_GROUPS_BY_USER_DESC")));
    }

    private I18nizableText _buildI18n(String i18Key) {
        String catalogue = "plugin.core-impl";
        I18nizableText groupDirectoryId = new I18nizableText(this.getId());
        Map<String, I18nizableTextParameter> params = Map.of("id", groupDirectoryId);
        return new I18nizableText(catalogue, i18Key, params);
    }

    private Cache<UserIdentity, Set<String>> _getCacheGroupsByUser() {
        return this.getCacheManager().get(__JDBC_GROUPDIRECTORY_GROUPS_BY_USER_CACHE_NAME_PREFIX + this._uniqueCacheSuffix);
    }

    @Override
    public AbstractCacheManager getCacheManager() {
        return this._cacheManager;
    }

    @Override
    public void init(String groupDirectoryModelId, Map<String, Object> paramValues) {
        this._groupDirectoryModelId = groupDirectoryModelId;
        this._paramValues = paramValues;
        this._groupsListTableName = (String)paramValues.get(__GROUPS_LIST_TABLE_PARAM_NAME);
        this._groupsCompositionTableName = (String)paramValues.get(__GROUPS_COMPOSITION_TABLE_PARAM_NAME);
        this._dataSourceId = (String)paramValues.get(__DATASOURCE_PARAM_NAME);
        this.createCaches();
    }

    protected Connection getSQLConnection() {
        Connection connection = ConnectionHelper.getConnection(this._dataSourceId);
        if (!this._lazyInitialized) {
            try {
                this._initTable(connection);
            }
            catch (Exception e) {
                this.getLogger().error("The tables requires by the " + this.getClass().getName() + " could not be created. A degraded behavior will occur", (Throwable)e);
            }
            this._lazyInitialized = true;
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public ModifiableGroup getGroup(String groupID) {
        JdbcGroup group = null;
        Connection connection = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            connection = this.getSQLConnection();
            String dbType = ConnectionHelper.getDatabaseType(connection);
            String sql = "SELECT Label FROM " + this.getSQLDatabaseTypeExtensionPoint().languageEscapeTableName(dbType, this._groupsListTableName) + " WHERE Id = ?";
            stmt = connection.prepareStatement(sql);
            stmt.setInt(1, Integer.parseInt(groupID));
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(sql);
            }
            if ((rs = stmt.executeQuery()).next()) {
                String label = rs.getString(__GROUPS_LIST_COLUMN_LABEL);
                group = new JdbcGroup(new GroupIdentity(groupID, this.getId()), label, this);
                this._fillGroup(group, connection);
            }
            ConnectionHelper.cleanup(rs);
        }
        catch (NumberFormatException e) {
            this.getLogger().error("Group ID must be an integer.", (Throwable)e);
            ModifiableGroup modifiableGroup = null;
            return modifiableGroup;
        }
        catch (SQLException e2) {
            this.getLogger().error("Error communication with database", (Throwable)e2);
            ModifiableGroup modifiableGroup = null;
            return modifiableGroup;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ConnectionHelper.cleanup(rs);
            ConnectionHelper.cleanup(stmt);
            ConnectionHelper.cleanup(connection);
        }
        ConnectionHelper.cleanup(stmt);
        ConnectionHelper.cleanup(connection);
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Group> getGroups() {
        LinkedHashSet<Group> groups = new LinkedHashSet<Group>();
        Connection connection = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            connection = this.getSQLConnection();
            String dbType = ConnectionHelper.getDatabaseType(connection);
            stmt = connection.createStatement();
            String sql = this._createGetGroupsClause(dbType);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(sql);
            }
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String groupID = rs.getString(__GROUPS_LIST_COLUMN_ID);
                String label = rs.getString(__GROUPS_LIST_COLUMN_LABEL);
                JdbcGroup group = new JdbcGroup(new GroupIdentity(groupID, this.getId()), label, this);
                this._fillGroup(group, connection);
                groups.add(group);
            }
        }
        catch (SQLException e) {
            Set<Group> set;
            try {
                this.getLogger().error("Error communication with database", (Throwable)e);
                set = Collections.emptySet();
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(rs);
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup(connection);
                throw throwable;
            }
            ConnectionHelper.cleanup(rs);
            ConnectionHelper.cleanup(stmt);
            ConnectionHelper.cleanup(connection);
            return set;
        }
        ConnectionHelper.cleanup(rs);
        ConnectionHelper.cleanup(stmt);
        ConnectionHelper.cleanup(connection);
        return groups;
    }

    protected String _createGetGroupsClause(String dbType) {
        return "SELECT Id, Label FROM " + this.getSQLDatabaseTypeExtensionPoint().languageEscapeTableName(dbType, this._groupsListTableName) + " ORDER BY Label";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _fillGroup(JdbcGroup group, Connection connection) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            String dbType = ConnectionHelper.getDatabaseType(connection);
            String sql = "SELECT Login, UserPopulation_Id FROM " + this.getSQLDatabaseTypeExtensionPoint().languageEscapeTableName(dbType, this._groupsCompositionTableName) + " WHERE Group_Id = ?";
            stmt = connection.prepareStatement(sql);
            stmt.setInt(1, Integer.parseInt(group.getIdentity().getId()));
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(sql);
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                UserIdentity identity = new UserIdentity(rs.getString(__GROUPS_COMPOSITION_COLUMN_LOGIN), rs.getString(__GROUPS_COMPOSITION_COLUMN_POPULATIONID));
                group.addUser(identity);
            }
        }
        catch (Throwable throwable) {
            ConnectionHelper.cleanup(rs);
            ConnectionHelper.cleanup(stmt);
            throw throwable;
        }
        ConnectionHelper.cleanup(rs);
        ConnectionHelper.cleanup(stmt);
    }

    @Override
    public Set<String> getUserGroups(UserIdentity userIdentity) {
        if (this.isCachingEnabled() && this._getCacheGroupsByUser().hasKey(userIdentity)) {
            Set<String> userGroups = this._getCacheGroupsByUser().get(userIdentity);
            return userGroups;
        }
        Set<String> userGroups = this._executeSqlForUserGroups(userIdentity);
        if (this.isCachingEnabled()) {
            this._getCacheGroupsByUser().put(userIdentity, userGroups);
        }
        return userGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> _executeSqlForUserGroups(UserIdentity userIdentity) {
        String login = userIdentity.getLogin();
        String populationId = userIdentity.getPopulationId();
        HashSet<String> groups = new HashSet<String>();
        if (login == null) {
            return groups;
        }
        Connection connection = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            connection = this.getSQLConnection();
            String dbType = ConnectionHelper.getDatabaseType(connection);
            String sql = "SELECT Group_Id FROM " + this.getSQLDatabaseTypeExtensionPoint().languageEscapeTableName(dbType, this._groupsCompositionTableName) + " WHERE Login = ? AND UserPopulation_Id = ?";
            stmt = connection.prepareStatement(sql);
            stmt.setString(1, login);
            stmt.setString(2, populationId);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(sql);
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                String groupID = rs.getString(__GROUPS_COMPOSITION_COLUMN_GROUPID);
                groups.add(groupID);
            }
            ConnectionHelper.cleanup(rs);
        }
        catch (SQLException e) {
            this.getLogger().error("Error communication with database", (Throwable)e);
            Set<String> set = Collections.emptySet();
            return set;
        }
        finally {
            ConnectionHelper.cleanup(rs);
            ConnectionHelper.cleanup(stmt);
            ConnectionHelper.cleanup(connection);
        }
        ConnectionHelper.cleanup(stmt);
        ConnectionHelper.cleanup(connection);
        return groups;
    }

    @Override
    public List<Group> getGroups(int count, int offset, Map parameters) {
        ArrayList<Group> groups = new ArrayList<Group>();
        String pattern = (String)parameters.get("pattern");
        Iterator<Group> iterator = this.getGroups().iterator();
        int currentOffset = offset;
        while (currentOffset > 0 && iterator.hasNext()) {
            Group group = iterator.next();
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)pattern) && group.getLabel().toLowerCase().indexOf(pattern.toLowerCase()) == -1 && (group.getIdentity() == null || group.getIdentity().getId().toLowerCase().indexOf(pattern.toLowerCase()) == -1)) continue;
            --currentOffset;
        }
        int currentCount = count;
        while ((count == -1 || currentCount > 0) && iterator.hasNext()) {
            Group group = iterator.next();
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)pattern) && group.getLabel().toLowerCase().indexOf(pattern.toLowerCase()) == -1 && (group.getIdentity() == null || group.getIdentity().getId().toLowerCase().indexOf(pattern.toLowerCase()) == -1)) continue;
            groups.add(group);
            --currentCount;
        }
        return groups;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ModifiableGroup add(String name) throws InvalidModificationException {
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        String id = null;
        try {
            block19: {
                connection = this.getSQLConnection();
                String dbType = ConnectionHelper.getDatabaseType(connection);
                if ("oracle".equals(dbType)) {
                    statement = connection.prepareStatement("SELECT seq_" + this._groupsListTableName + ".nextval FROM dual");
                    rs = statement.executeQuery();
                    if (rs.next()) {
                        id = rs.getString(1);
                    }
                    ConnectionHelper.cleanup(rs);
                    ConnectionHelper.cleanup(statement);
                    statement = connection.prepareStatement("INSERT INTO " + this.getSQLDatabaseTypeExtensionPoint().languageEscapeTableName(dbType, this._groupsListTableName) + " (Id, Label) VALUES(?, ?)");
                    statement.setString(1, id);
                    statement.setString(2, name);
                } else {
                    statement = connection.prepareStatement("INSERT INTO " + this.getSQLDatabaseTypeExtensionPoint().languageEscapeTableName(dbType, this._groupsListTableName) + " (Label) VALUES (?)");
                    statement.setString(1, name);
                }
                statement.executeUpdate();
                ConnectionHelper.cleanup(statement);
                if ("mysql".equals(dbType)) {
                    statement = connection.prepareStatement("SELECT Id FROM " + this.getSQLDatabaseTypeExtensionPoint().languageEscapeTableName(dbType, this._groupsListTableName) + " WHERE Id = last_insert_id()");
                    rs = statement.executeQuery();
                    if (rs.next()) {
                        id = rs.getString(__GROUPS_LIST_COLUMN_ID);
                        break block19;
                    } else {
                        if (connection.getAutoCommit()) {
                            throw new InvalidModificationException("Cannot retrieve inserted group. Group was created but listeners not called : base may be inconsistant");
                        }
                        connection.rollback();
                        throw new InvalidModificationException("Cannot retrieve inserted group. Rolling back");
                    }
                }
                if ("derby".equals(dbType)) {
                    statement = connection.prepareStatement("VALUES IDENTITY_VAL_LOCAL ()");
                    rs = statement.executeQuery();
                    if (rs.next()) {
                        id = rs.getString(1);
                    }
                } else if ("hsqldb".equals(dbType)) {
                    statement = connection.prepareStatement("CALL IDENTITY ()");
                    rs = statement.executeQuery();
                    if (rs.next()) {
                        id = rs.getString(1);
                    }
                } else if ("postgresql".equals(dbType) && (rs = (statement = connection.prepareStatement("SELECT lastval()")).executeQuery()).next()) {
                    id = rs.getString(1);
                }
            }
            if (id != null) {
                HashMap<String, Object> eventParams = new HashMap<String, Object>();
                eventParams.put("group", new GroupIdentity(id, this.getId()));
                this._observationManager.notify(new Event("group.added", this._currentUserProvider.getUser(), eventParams));
            }
        }
        catch (SQLException ex) {
            try {
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(rs);
                ConnectionHelper.cleanup(statement);
                ConnectionHelper.cleanup(connection);
                throw throwable;
            }
        }
        ConnectionHelper.cleanup(rs);
        ConnectionHelper.cleanup(statement);
        ConnectionHelper.cleanup(connection);
        return new JdbcGroup(new GroupIdentity(id, this.getId()), name, this);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void update(ModifiableGroup userGroup) throws InvalidModificationException {
        Connection connection = null;
        PreparedStatement statement = null;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Updating group " + GroupIdentity.groupIdentityToString(userGroup.getIdentity()) + " with " + userGroup.getUsers().size() + " user(s)");
        }
        try {
            connection = this.getSQLConnection();
            String dbType = ConnectionHelper.getDatabaseType(connection);
            connection.setAutoCommit(false);
            statement = connection.prepareStatement("UPDATE " + this.getSQLDatabaseTypeExtensionPoint().languageEscapeTableName(dbType, this._groupsListTableName) + " SET Label=? WHERE Id = ?");
            statement.setString(1, userGroup.getLabel());
            statement.setInt(2, Integer.parseInt(userGroup.getIdentity().getId()));
            if (statement.executeUpdate() == 0) {
                throw new InvalidModificationException("No group with id '" + userGroup.getIdentity().getId() + "' may be removed");
            }
            ConnectionHelper.cleanup(statement);
            statement = connection.prepareStatement("DELETE FROM " + this.getSQLDatabaseTypeExtensionPoint().languageEscapeTableName(dbType, this._groupsCompositionTableName) + " WHERE Group_Id = ?");
            statement.setInt(1, Integer.parseInt(userGroup.getIdentity().getId()));
            statement.executeUpdate();
            ConnectionHelper.cleanup(statement);
            if (!userGroup.getUsers().isEmpty()) {
                boolean supportsBatch = connection.getMetaData().supportsBatchUpdates();
                statement = connection.prepareStatement("INSERT INTO " + this.getSQLDatabaseTypeExtensionPoint().languageEscapeTableName(dbType, this._groupsCompositionTableName) + " (Group_Id, Login, UserPopulation_Id) VALUES (?, ?, ?)");
                for (UserIdentity identity : userGroup.getUsers()) {
                    String login = identity.getLogin();
                    String populationId = identity.getPopulationId();
                    statement.setInt(1, Integer.parseInt(userGroup.getIdentity().getId()));
                    statement.setString(2, login);
                    statement.setString(3, populationId);
                    if (supportsBatch) {
                        statement.addBatch();
                        continue;
                    }
                    statement.executeUpdate();
                }
                if (supportsBatch) {
                    statement.executeBatch();
                }
            }
            ConnectionHelper.cleanup(statement);
            connection.commit();
            this._getCacheGroupsByUser().invalidateAll();
            HashMap<String, Object> eventParams = new HashMap<String, Object>();
            eventParams.put("group", userGroup.getIdentity());
            this._observationManager.notify(new Event("group.updated", this._currentUserProvider.getUser(), eventParams));
        }
        catch (NumberFormatException ex) {
            try {
                throw new InvalidModificationException("No group with id '" + userGroup.getIdentity().getId() + "' may be removed", ex);
                catch (SQLException ex2) {
                    throw new RuntimeException(ex2);
                }
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(statement);
                ConnectionHelper.cleanup(connection);
                throw throwable;
            }
        }
        ConnectionHelper.cleanup(statement);
        ConnectionHelper.cleanup(connection);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Updated group " + GroupIdentity.groupIdentityToString(userGroup.getIdentity()) + " with " + userGroup.getUsers().size() + " user(s)");
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void remove(String groupID) throws InvalidModificationException {
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = this.getSQLConnection();
            String dbType = ConnectionHelper.getDatabaseType(connection);
            statement = connection.prepareStatement("DELETE FROM " + this.getSQLDatabaseTypeExtensionPoint().languageEscapeTableName(dbType, this._groupsListTableName) + " WHERE Id = ?");
            statement.setInt(1, Integer.parseInt(groupID));
            if (statement.executeUpdate() == 0) {
                throw new InvalidModificationException("No group with id '" + groupID + "' may be removed");
            }
            ConnectionHelper.cleanup(statement);
            statement = connection.prepareStatement("DELETE FROM " + this.getSQLDatabaseTypeExtensionPoint().languageEscapeTableName(dbType, this._groupsCompositionTableName) + " WHERE Group_Id = ?");
            statement.setInt(1, Integer.parseInt(groupID));
            statement.executeUpdate();
            this._getCacheGroupsByUser().invalidateAll();
            HashMap<String, Object> eventParams = new HashMap<String, Object>();
            eventParams.put("group", new GroupIdentity(groupID, this.getId()));
            this._observationManager.notify(new Event("group.deleted", this._currentUserProvider.getUser(), eventParams));
        }
        catch (NumberFormatException ex) {
            try {
                throw new InvalidModificationException("No group with id '" + groupID + "' may be removed, the ID must be a number.", ex);
                catch (SQLException ex2) {
                    throw new RuntimeException(ex2);
                }
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(statement);
                ConnectionHelper.cleanup(connection);
                throw throwable;
            }
        }
        ConnectionHelper.cleanup(statement);
        ConnectionHelper.cleanup(connection);
    }

    private static final class JdbcGroup
    implements ModifiableGroup {
        private Set<UserIdentity> _users;
        private GroupIdentity _identity;
        private String _groupLabel;
        @SizeUtils.ExcludeFromSizeCalculation
        private GroupDirectory _groupDirectory;

        JdbcGroup(GroupIdentity identity, String label, GroupDirectory groupDirectory) {
            this._identity = identity;
            this._groupLabel = label;
            this._groupDirectory = groupDirectory;
            this._users = new HashSet<UserIdentity>();
        }

        @Override
        public GroupIdentity getIdentity() {
            return this._identity;
        }

        @Override
        public String getLabel() {
            return this._groupLabel;
        }

        @Override
        public GroupDirectory getGroupDirectory() {
            return this._groupDirectory;
        }

        @Override
        public void setLabel(String label) {
            this._groupLabel = label;
        }

        @Override
        public void addUser(UserIdentity user) {
            this._users.add(user);
        }

        @Override
        public void removeUser(UserIdentity user) {
            this._users.remove(user);
        }

        @Override
        public void removeUsers() {
            this._users.clear();
        }

        @Override
        public Set<UserIdentity> getUsers() {
            return this._users;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("UserGroup[");
            sb.append(this._identity);
            sb.append(" (");
            sb.append(this._groupLabel);
            sb.append(") => ");
            sb.append(this._users.toString());
            sb.append("]");
            return sb.toString();
        }

        public boolean equals(Object another) {
            if (another == null || !(another instanceof JdbcGroup)) {
                return false;
            }
            JdbcGroup otherGroup = (JdbcGroup)another;
            return this._identity != null && this._identity.equals(otherGroup.getIdentity());
        }

        public int hashCode() {
            return this._identity.hashCode();
        }
    }
}

