/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.group.directory.ldap;

import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.SizeLimitExceededException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.core.group.Group;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.group.directory.GroupDirectory;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.user.directory.UserDirectory;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.core.util.SizeUtils;
import org.ametys.core.util.StringUtils;
import org.ametys.core.util.ldap.AbstractLDAPConnector;
import org.ametys.core.util.ldap.IncompleteLDAPResultException;
import org.ametys.core.util.ldap.ScopeEnumerator;
import org.ametys.plugins.core.impl.user.LdapUserIdentity;
import org.ametys.plugins.core.impl.user.directory.LdapUserDirectory;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.i18n.I18nizableTextParameter;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.slf4j.Logger;

public class LdapGroupDirectory
extends AbstractLDAPConnector
implements GroupDirectory,
Disposable {
    protected static final String __PARAM_DATASOURCE_ID = "runtime.groups.ldap.datasource";
    protected static final String __PARAM_ASSOCIATED_USERDIRECTORY_ID = "runtime.groups.ldap.userdirectory";
    protected static final String __PARAM_GROUPS_RELATIVE_DN = "runtime.groups.ldap.groupDN";
    protected static final String __PARAM_GROUPS_OBJECT_FILTER = "runtime.groups.ldap.filter";
    protected static final String __PARAM_GROUPS_SEARCH_SCOPE = "runtime.groups.ldap.scope";
    protected static final String __PARAM_GROUPS_ID_ATTRIBUTE = "runtime.groups.ldap.id";
    protected static final String __PARAM_GROUPS_DESCRIPTION_ATTRIBUTE = "runtime.groups.ldap.description";
    protected static final String __PARAM_USERS_UID_ATTRIBUTE = "runtime.users.ldap.uidAttr";
    protected static final String __PARAM_GROUPS_MEMBER_ATTRIBUTE = "runtime.groups.ldap.member";
    protected static final String __PARAM_GROUPS_MEMBEROF_ATTRIBUTE = "runtime.groups.ldap.memberof";
    private static final String __LDAP_GROUPDIRECTORY_GROUP_BY_ID_CACHE_NAME_PREFIX = LdapGroupDirectory.class.getName() + "$group.by.id$";
    private static final String __LDAP_GROUPDIRECTORY_GROUPS_BY_USER_CACHE_NAME_PREFIX = LdapGroupDirectory.class.getName() + "$groups.by.user$";
    private static final String __LDAP_GROUPDIRECTORY_USERS_BY_GROUP_CACHE_NAME_PREFIX = LdapGroupDirectory.class.getName() + "$users.by.group$";
    private static final String __LDAP_GROUPDIRECTORY_ALL_GROUPS_CACHE_NAME_PREFIX = LdapGroupDirectory.class.getName() + "$all.groups$";
    protected UserManager _userManager;
    protected UserPopulationDAO _userPopulationDAO;
    protected String _groupsRelativeDN;
    protected String _groupsObjectFilter;
    protected int _groupsSearchScope;
    protected String _groupsIdAttribute;
    protected String _groupsDescriptionAttribute;
    protected String _groupsMemberAttribute;
    protected String _associatedUserDirectoryId;
    protected String _associatedPopulationId;
    protected String _userUidAttribute;
    protected String _usersMemberOfAttribute;
    protected String _id;
    protected I18nizableText _label;
    private String _groupDirectoryModelId;
    private Map<String, Object> _paramValues;
    private Pattern _groupExtractionPattern;
    private final String _uniqueCacheSuffix = StringUtils.generateKey();
    private AbstractCacheManager _cacheManager;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._userManager = (UserManager)serviceManager.lookup(UserManager.ROLE);
        this._userPopulationDAO = (UserPopulationDAO)serviceManager.lookup(UserPopulationDAO.ROLE);
        this._cacheManager = (AbstractCacheManager)serviceManager.lookup(AbstractCacheManager.ROLE);
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public I18nizableText getLabel() {
        return this._label;
    }

    @Override
    public void setId(String id) {
        this._id = id;
    }

    @Override
    public void setLabel(I18nizableText label) {
        this._label = label;
    }

    @Override
    public String getGroupDirectoryModelId() {
        return this._groupDirectoryModelId;
    }

    @Override
    public Map<String, Object> getParameterValues() {
        return this._paramValues;
    }

    private void _createCaches() {
        this._cacheManager.createMemoryCache(__LDAP_GROUPDIRECTORY_GROUP_BY_ID_CACHE_NAME_PREFIX + this.getUniqueCacheIdSuffix(), this._buildI18n("PLUGINS_CORE_GROUPS_LDAPGROUP_CACHE_GROUP_BY_ID_LABEL"), this._buildI18n("PLUGINS_CORE_GROUPS_LDAPGROUP_CACHE_GROUP_BY_ID_DESC"), true, null);
        this._cacheManager.createMemoryCache(__LDAP_GROUPDIRECTORY_GROUPS_BY_USER_CACHE_NAME_PREFIX + this.getUniqueCacheIdSuffix(), this._buildI18n("PLUGINS_CORE_GROUPS_LDAPGROUP_CACHE_GROUPS_BY_USER_LABEL"), this._buildI18n("PLUGINS_CORE_GROUPS_LDAPGROUP_CACHE_GROUPS_BY_USER_DESC"), true, null);
        this._cacheManager.createMemoryCache(__LDAP_GROUPDIRECTORY_USERS_BY_GROUP_CACHE_NAME_PREFIX + this.getUniqueCacheIdSuffix(), this._buildI18n("PLUGINS_CORE_GROUPS_LDAPGROUP_CACHE_USERS_BY_GROUP_LABEL"), this._buildI18n("PLUGINS_CORE_GROUPS_LDAPGROUP_CACHE_USERS_BY_GROUP_DESC"), true, null);
        this._cacheManager.createMemoryCache(__LDAP_GROUPDIRECTORY_ALL_GROUPS_CACHE_NAME_PREFIX + this.getUniqueCacheIdSuffix(), this._buildI18n("PLUGINS_CORE_GROUPS_LDAPGROUP_CACHE_ALL_GROUPS_LABEL"), this._buildI18n("PLUGINS_CORE_GROUPS_LDAPGROUP_CACHE_ALL_GROUPS_DESC"), true, null);
    }

    private I18nizableText _buildI18n(String i18nKey) {
        String catalogue = "plugin.core-impl";
        I18nizableText groupDirectoryId = new I18nizableText(this.getId());
        Map<String, I18nizableTextParameter> labelParams = Map.of("id", groupDirectoryId);
        return new I18nizableText(catalogue, i18nKey, labelParams);
    }

    private Cache<String, Group> _getCacheGroupById() {
        return this._cacheManager.get(__LDAP_GROUPDIRECTORY_GROUP_BY_ID_CACHE_NAME_PREFIX + this.getUniqueCacheIdSuffix());
    }

    private Cache<UserIdentity, Set<String>> _getCacheGroupsByUser() {
        return this._cacheManager.get(__LDAP_GROUPDIRECTORY_GROUPS_BY_USER_CACHE_NAME_PREFIX + this.getUniqueCacheIdSuffix());
    }

    private Cache<GroupIdentity, Set<UserIdentity>> _getCacheUsersByGroup() {
        return this._cacheManager.get(__LDAP_GROUPDIRECTORY_USERS_BY_GROUP_CACHE_NAME_PREFIX + this.getUniqueCacheIdSuffix());
    }

    private Cache<String, Set<String>> _getCacheAllGroups() {
        return this._cacheManager.get(__LDAP_GROUPDIRECTORY_ALL_GROUPS_CACHE_NAME_PREFIX + this.getUniqueCacheIdSuffix());
    }

    private String getUniqueCacheIdSuffix() {
        return this._uniqueCacheSuffix;
    }

    @Override
    public void init(String groupDirectoryModelId, Map<String, Object> paramValues) throws Exception {
        this._groupDirectoryModelId = groupDirectoryModelId;
        this._paramValues = paramValues;
        String populationAndUserDirectory = (String)paramValues.get(__PARAM_ASSOCIATED_USERDIRECTORY_ID);
        String[] split = populationAndUserDirectory.split("#");
        this._associatedPopulationId = split[0];
        this._associatedUserDirectoryId = split[1];
        this._groupsRelativeDN = (String)paramValues.get(__PARAM_GROUPS_RELATIVE_DN);
        this._groupsObjectFilter = (String)paramValues.get(__PARAM_GROUPS_OBJECT_FILTER);
        this._groupsSearchScope = ScopeEnumerator.parseScope((String)paramValues.get(__PARAM_GROUPS_SEARCH_SCOPE));
        this._groupsIdAttribute = (String)paramValues.get(__PARAM_GROUPS_ID_ATTRIBUTE);
        this._groupsDescriptionAttribute = (String)paramValues.get(__PARAM_GROUPS_DESCRIPTION_ATTRIBUTE);
        this._userUidAttribute = (String)paramValues.get(__PARAM_USERS_UID_ATTRIBUTE);
        this._groupsMemberAttribute = (String)paramValues.get(__PARAM_GROUPS_MEMBER_ATTRIBUTE);
        this._usersMemberOfAttribute = (String)paramValues.get(__PARAM_GROUPS_MEMBEROF_ATTRIBUTE);
        String dataSourceId = (String)paramValues.get(__PARAM_DATASOURCE_ID);
        try {
            this._delayedInitialize(dataSourceId);
        }
        catch (Exception e) {
            this.getLogger().error("An error occured during the initialization of LDAPUserDirectory", (Throwable)e);
        }
        this._groupExtractionPattern = Pattern.compile("^" + this._groupsIdAttribute + "=([^,]+),.*", 2);
        this._createCaches();
    }

    @Override
    public Group getGroup(String groupID) {
        return this._getCacheGroupById().get(groupID, id -> {
            InitialDirContext context = null;
            NamingEnumeration<SearchResult> results = null;
            SearchResult result = null;
            try {
                context = new InitialDirContext(this._getContextEnv());
                StringBuffer filter = new StringBuffer("(&");
                filter.append(this._groupsObjectFilter);
                filter.append("(");
                filter.append(this._groupsIdAttribute);
                filter.append("={0}))");
                results = context.search(this._groupsRelativeDN, filter.toString(), new Object[]{groupID}, this._getSearchConstraint());
                if (results.hasMore()) {
                    result = results.next();
                }
            }
            catch (IllegalArgumentException e) {
                this.getLogger().error("Error missing at least one attribute or attribute value", (Throwable)e);
            }
            catch (NamingException e) {
                this.getLogger().error("Error communication with ldap server", (Throwable)e);
            }
            finally {
                this._cleanup(context, results);
            }
            return result != null ? this._getUserGroup(result, false) : null;
        });
    }

    @Override
    public Set<Group> getGroups() {
        String cacheKey = "ALL_GROUPS";
        Set groupIds = this._getCacheAllGroups().get(cacheKey, key -> {
            List<Group> groups = this.getGroups(-1, 0, Collections.emptyMap());
            return groups.stream().map(Group::getIdentity).map(GroupIdentity::getId).collect(Collectors.toSet());
        });
        return groupIds.stream().map(this::getGroup).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Override
    public List<Group> getGroups(int count, int offset, Map parameters) {
        String pattern = (String)parameters.get("pattern");
        try {
            List<SearchResult> searchResults;
            try {
                searchResults = this._search(this._groupsRelativeDN, this._groupsObjectFilter, this._getSearchConstraint(), count > -1 && this._serverSideSorting);
            }
            catch (IncompleteLDAPResultException e) {
                searchResults = (List<SearchResult>)e.getPartialResults();
                this.getLogger().warn("LDAP refused to return more than " + searchResults.size() + " results");
            }
            return searchResults.stream().map(result -> this._getUserGroup((SearchResult)result, true)).filter(Objects::nonNull).filter(group -> this._filterMatchingGroup((Group)group, pattern)).skip(offset).limit(count < 0 ? Integer.MAX_VALUE : (long)count).toList();
        }
        catch (NamingException e) {
            this.getLogger().error("Error of communication with ldap server", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private boolean _filterMatchingGroup(Group group, String pattern) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)pattern)) {
            return true;
        }
        Function<String, String> normalize = str -> Normalizer.normalize(str.toLowerCase(), Normalizer.Form.NFD).replaceAll("[\\p{InCombiningDiacriticalMarks}]", "").trim();
        String toMatch = normalize.apply(pattern);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)toMatch)) {
            return true;
        }
        String groupLabel = normalize.apply(group.getLabel());
        if (groupLabel.indexOf(toMatch) != -1) {
            return true;
        }
        String groupIdentity = group.getIdentity() != null ? normalize.apply(group.getIdentity().getId()) : null;
        return groupIdentity != null && groupIdentity.indexOf(toMatch) != -1;
    }

    @Override
    public Set<String> getUserGroups(UserIdentity userIdentity) {
        return this._getCacheGroupsByUser().get(userIdentity, userId -> {
            String populationId = userIdentity.getPopulationId();
            UserDirectory userDirectory = this._userManager.getUserDirectory(populationId, userIdentity.getLogin());
            if (userDirectory == null || !populationId.equals(this._associatedPopulationId) || !this._associatedUserDirectoryId.equals(userDirectory.getId())) {
                return Set.of();
            }
            if (!(userDirectory instanceof LdapUserDirectory)) {
                this.getLogger().warn("The Ldap group directory '{}' must be associated with a Ldap user directory.", (Object)this.getId());
                return Set.of();
            }
            LdapUserDirectory ldapUserDirectory = (LdapUserDirectory)userDirectory;
            String usersRelativeDN = (String)ldapUserDirectory.getParameterValues().get("runtime.users.ldap.peopleDN");
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this._usersMemberOfAttribute)) {
                return this._getUserGroupsFromMemberOfAttr(userIdentity, usersRelativeDN, ldapUserDirectory);
            }
            return this._getUserGroupsFromMemberAttr(userIdentity, ldapUserDirectory);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> _getUserGroupsFromMemberOfAttr(UserIdentity userIdentity, String usersRelativeDN, LdapUserDirectory ldapUserDirectory) {
        HashSet<String> groups = new HashSet<String>();
        String login = userIdentity.getLogin();
        InitialDirContext context = null;
        NamingEnumeration<SearchResult> userResults = null;
        try {
            context = new InitialDirContext(this._getContextEnv());
            Attributes userAttrs = null;
            if (userIdentity instanceof LdapUserIdentity) {
                String dn = ((LdapUserIdentity)userIdentity).getDn();
                String relativeDn = this._getRelativeDn(dn);
                userAttrs = context.getAttributes(relativeDn, new String[]{this._usersMemberOfAttribute});
            } else {
                String userLoginAttribute = (String)ldapUserDirectory.getParameterValues().get("runtime.users.ldap.loginAttr");
                String usersObjectFilter = (String)ldapUserDirectory.getParameterValues().get("runtime.users.ldap.baseFilter");
                StringBuffer userFilter = new StringBuffer("(&");
                userFilter.append(usersObjectFilter);
                userFilter.append("(");
                userFilter.append(userLoginAttribute);
                userFilter.append("={0}))");
                this.getLogger().debug("Searching groups of user '{}' on user itself: '{}'.", (Object)login, (Object)userFilter);
                userResults = context.search(usersRelativeDN, userFilter.toString(), new Object[]{login}, this._getUserSearchConstraint(new String[]{userLoginAttribute, this._usersMemberOfAttribute}));
                if (userResults.hasMore()) {
                    SearchResult userResult = userResults.next();
                    userAttrs = userResult.getAttributes();
                }
                userResults.close();
            }
            if (userAttrs != null) {
                groups.addAll(this._getGroupIdsOfUser(userAttrs));
            }
        }
        catch (NamingException e) {
            this.getLogger().error("Error communication with ldap server", (Throwable)e);
        }
        finally {
            this._cleanup(context, userResults);
        }
        this.getLogger().debug("{} groups found for user '{}' from '{}' attribute on users", new Object[]{groups.size(), login, this._usersMemberOfAttribute});
        return groups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> _getUserGroupsFromMemberAttr(UserIdentity userIdentity, LdapUserDirectory ldapUserDirectory) {
        HashSet<String> groups = new HashSet<String>();
        String login = userIdentity.getLogin();
        InitialDirContext context = null;
        NamingEnumeration<SearchResult> userResults = null;
        StringBuffer groupFilter = new StringBuffer("(&");
        groupFilter.append(this._groupsObjectFilter);
        groupFilter.append("(|");
        String dn = ldapUserDirectory.getUserDN(login);
        groupFilter.append("(");
        groupFilter.append(this._groupsMemberAttribute);
        groupFilter.append("={0}");
        groupFilter.append(")");
        groupFilter.append("(");
        groupFilter.append(this._groupsMemberAttribute);
        groupFilter.append("={1})");
        groupFilter.append("))");
        this.getLogger().debug("Searching groups of user '{}' with base DN '{}': '{}'.", new Object[]{login, this._groupsRelativeDN, groupFilter});
        int groupCount = 0;
        int results = 0;
        try {
            context = new InitialDirContext(this._getContextEnv());
            userResults = context.search(this._groupsRelativeDN, groupFilter.toString(), new Object[]{dn, login}, this._getSearchConstraint());
            while (userResults.hasMore()) {
                ++results;
                String groupId = this._getGroupId(userResults.next());
                if (groupId == null) continue;
                groups.add(groupId);
                ++groupCount;
            }
        }
        catch (SizeLimitExceededException e) {
            this.getLogger().warn("LDAP refused to return more than " + results + " results");
        }
        catch (NamingException e) {
            this.getLogger().error("Error communication with ldap server", (Throwable)e);
        }
        finally {
            this._cleanup(context, userResults);
        }
        this.getLogger().debug("{} groups found for user '{}' from '{}' attribute on groups", new Object[]{groupCount, login, this._groupsMemberAttribute});
        return groups;
    }

    protected String _getGroupId(SearchResult groupEntry) {
        Attributes attrs = groupEntry.getAttributes();
        try {
            Attribute groupIDAttr = attrs.get(this._groupsIdAttribute);
            if (groupIDAttr == null) {
                this.getLogger().warn("Missing group id attribute : \"{}\". Group will be ignored.", (Object)this._groupsIdAttribute);
                return null;
            }
            return (String)groupIDAttr.get();
        }
        catch (NamingException e) {
            this.getLogger().warn("Missing at least one value for an attribute in an ldap entry.  Group will be ignored.", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> _getGroupIdsOfUser(Attributes userAttrs) throws NamingException {
        HashSet<String> groups = new HashSet<String>();
        Attribute userGroups = userAttrs.get(this._usersMemberOfAttribute);
        if (userGroups != null) {
            NamingEnumeration<?> groupIds = null;
            try {
                groupIds = userGroups.getAll();
                while (groupIds.hasMore()) {
                    String groupId = (String)groupIds.next();
                    Matcher matcher = this._groupExtractionPattern.matcher(groupId);
                    if (matcher.matches()) {
                        Group group;
                        SearchResult groupResult;
                        String relativeGroupDn = this._getRelativeDn(groupId);
                        if (!this._isGroupDnInScope(relativeGroupDn) || (groupResult = this._getGroupMatchingFilter(relativeGroupDn)) == null || (group = this._getUserGroup(groupResult, true)) == null) continue;
                        groups.add(group.getIdentity().getId());
                        continue;
                    }
                    Group group = this.getGroup(groupId);
                    if (group == null) continue;
                    groups.add(group.getIdentity().getId());
                }
            }
            finally {
                this._cleanup(null, groupIds);
            }
        }
        return groups;
    }

    private boolean _isGroupDnInScope(String relativeGroupDn) {
        String groupsBaseDn = this._groupsRelativeDN.toLowerCase();
        String groupDnLower = relativeGroupDn.toLowerCase();
        switch (this._groupsSearchScope) {
            case 0: {
                return groupDnLower.equals(groupsBaseDn);
            }
            case 1: {
                if (groupDnLower.equals(groupsBaseDn)) {
                    return true;
                }
                if (groupDnLower.endsWith("," + groupsBaseDn)) {
                    String prefix = groupDnLower.substring(0, groupDnLower.length() - groupsBaseDn.length() - 1);
                    return !prefix.contains(",");
                }
                return false;
            }
        }
        return groupDnLower.endsWith("," + groupsBaseDn) || groupDnLower.equals(groupsBaseDn);
    }

    protected Group _getUserGroup(SearchResult entry, boolean storeInCache) {
        LdapGroup group = null;
        Attributes attrs = entry.getAttributes();
        try {
            Attribute groupIDAttr = attrs.get(this._groupsIdAttribute);
            if (groupIDAttr == null) {
                this.getLogger().warn("Missing group id attribute : \"" + this._groupsIdAttribute + "\". Group will be ignored.");
                return null;
            }
            String groupID = (String)groupIDAttr.get();
            Attribute groupDESCAttr = attrs.get(this._groupsDescriptionAttribute);
            if (groupDESCAttr == null) {
                this.getLogger().warn("Missing group description attribute : \"" + this._groupsDescriptionAttribute + "\". Group will be ignored.");
                return null;
            }
            String groupDesc = (String)groupDESCAttr.get();
            Attribute membersAttr = null;
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this._groupsMemberAttribute)) {
                membersAttr = attrs.get(this._groupsMemberAttribute);
            }
            group = new LdapGroup(new GroupIdentity(groupID, this.getId()), groupDesc, this, membersAttr, this.getLogger());
            if (storeInCache) {
                this._getCacheGroupById().put(groupID, group);
            }
        }
        catch (NamingException e) {
            this.getLogger().warn("Missing at least one value for an attribute in an ldap entry. Group will be ignored.", (Throwable)e);
            return null;
        }
        catch (IllegalArgumentException e) {
            this.getLogger().error("Error missing at least one attribute or attribute value", (Throwable)e);
        }
        return group;
    }

    protected String _getRelativeDn(String dn) {
        String relativeDn = dn;
        String suffix = "," + this._ldapBaseDN;
        if (dn.endsWith(suffix)) {
            relativeDn = org.apache.commons.lang3.StringUtils.substring((String)dn, (int)0, (int)(-suffix.length()));
        }
        return relativeDn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UserIdentity _getUserInLdapFromDn(String ldapDn) {
        Attribute userLogin;
        InitialLdapContext ldapContext;
        block7: {
            block6: {
                UserDirectory associatedUserDirectory = this._userPopulationDAO.getUserPopulation(this._associatedPopulationId).getUserDirectory(this._associatedUserDirectoryId);
                String userLoginAttribute = (String)associatedUserDirectory.getParameterValues().get("runtime.users.ldap.loginAttr");
                String relativeDn = this._getRelativeDn(ldapDn);
                ldapContext = null;
                ldapContext = new InitialLdapContext(this._getContextEnv(), null);
                Attributes userAttrs = ldapContext.getAttributes(relativeDn, new String[]{userLoginAttribute});
                userLogin = userAttrs.get(userLoginAttribute);
                if (userLogin != null) break block6;
                this.getLogger().warn("User '{}' was found in LDAP but is missing the attribute {}", (Object)relativeDn, (Object)userLoginAttribute);
                UserIdentity userIdentity = null;
                this._cleanup(ldapContext, null);
                return userIdentity;
            }
            UserIdentity identity = new UserIdentity((String)userLogin.get(), this._associatedPopulationId);
            if (this._userManager.getUser(identity) == null) break block7;
            UserIdentity userIdentity = identity;
            this._cleanup(ldapContext, null);
            return userIdentity;
        }
        try {
            this.getLogger().warn("User with login '{}' was found in LDAP but is not a user of the population {}", userLogin.get(), (Object)this._associatedPopulationId);
        }
        catch (NamingException e) {
            try {
                this.getLogger().warn(String.format("Unable to get the user from the LDAP DN entry: %s", ldapDn), (Throwable)e);
            }
            catch (Throwable throwable) {
                this._cleanup(ldapContext, null);
                throw throwable;
            }
            this._cleanup(ldapContext, null);
        }
        this._cleanup(ldapContext, null);
        return null;
    }

    protected UserIdentity _getUserInLdapFromUid(String ldapUid) {
        UserDirectory associatedUserDirectory = this._userPopulationDAO.getUserPopulation(this._associatedPopulationId).getUserDirectory(this._associatedUserDirectoryId);
        String userLoginAttribute = (String)associatedUserDirectory.getParameterValues().get("runtime.users.ldap.loginAttr");
        String usersRelativeDN = (String)associatedUserDirectory.getParameterValues().get("runtime.users.ldap.peopleDN");
        try {
            String filter = this._userUidAttribute + "=" + ldapUid;
            SearchControls constraints = this._getUserSearchConstraint(new String[]{userLoginAttribute});
            List<SearchResult> results = this._search(usersRelativeDN, filter, constraints, false);
            if (results.size() > 0) {
                SearchResult searchResult = results.get(0);
                Attribute userLogin = searchResult.getAttributes().get(userLoginAttribute);
                if (userLogin == null) {
                    this.getLogger().warn("User '{}' was found in LDAP but is missing the attribute {}", (Object)searchResult, (Object)userLoginAttribute);
                    return null;
                }
                UserIdentity identity = new UserIdentity((String)userLogin.get(), this._associatedPopulationId);
                if (this._userManager.getUser(identity) != null) {
                    return identity;
                }
                this.getLogger().warn("User with login '{}' was found in LDAP but is not a user of the population {}", userLogin.get(), (Object)this._associatedPopulationId);
            }
            this.getLogger().warn("Unable to get the user from the LDAP UID: {}", (Object)ldapUid);
            return null;
        }
        catch (NoSuchElementException | NamingException | IncompleteLDAPResultException e) {
            this.getLogger().warn(String.format("Unable to get the user from the LDAP UID: %s", ldapUid), (Throwable)e);
            return null;
        }
    }

    protected Set<UserIdentity> _getUsersFromMembersOfAttr(String groupId) {
        LinkedHashSet<UserIdentity> identities = new LinkedHashSet<UserIdentity>();
        if (this._usersMemberOfAttribute == null) {
            return identities;
        }
        UserDirectory associatedUserDirectory = this._userPopulationDAO.getUserPopulation(this._associatedPopulationId).getUserDirectory(this._associatedUserDirectoryId);
        String userLoginAttribute = (String)associatedUserDirectory.getParameterValues().get("runtime.users.ldap.loginAttr");
        String usersRelativeDN = (String)associatedUserDirectory.getParameterValues().get("runtime.users.ldap.peopleDN");
        String usersObjectFilter = (String)associatedUserDirectory.getParameterValues().get("runtime.users.ldap.baseFilter");
        try {
            List<SearchResult> searchResults;
            String memberOfValue = this._groupsIdAttribute + "=" + groupId + "," + this._groupsRelativeDN + "," + this._ldapBaseDN;
            String filter = "(&" + usersObjectFilter + "(|(" + this._usersMemberOfAttribute + "=" + groupId + ")(" + this._usersMemberOfAttribute + "=" + memberOfValue + ")))";
            try {
                searchResults = this._search(usersRelativeDN, filter, this._getUserSearchConstraint(new String[]{userLoginAttribute}), false);
            }
            catch (IncompleteLDAPResultException e) {
                searchResults = (List<SearchResult>)e.getPartialResults();
                this.getLogger().warn("LDAP refused to return more than " + searchResults.size() + " results");
            }
            for (SearchResult searchResult : searchResults) {
                Attributes attrs = searchResult.getAttributes();
                Attribute userLogin = attrs.get(userLoginAttribute);
                if (userLogin == null) {
                    this.getLogger().warn("User '{}' was found in LDAP but is missing the attribute {}", (Object)searchResult, (Object)userLoginAttribute);
                    break;
                }
                UserIdentity identity = new UserIdentity((String)userLogin.get(), this._associatedPopulationId);
                if (this._userManager.getUser(identity) != null) {
                    identities.add(identity);
                    continue;
                }
                this.getLogger().warn("User with login '{}' was found in LDAP but is not a user of the population {}", userLogin.get(), (Object)this._associatedPopulationId);
            }
        }
        catch (NamingException e) {
            this.getLogger().error("Error of communication with ldap server", (Throwable)e);
        }
        return identities;
    }

    private SearchControls _getUserSearchConstraint(String[] returningAttributes) {
        SearchControls constraints = new SearchControls();
        constraints.setReturningAttributes(returningAttributes);
        UserDirectory associatedUserDirectory = this._userPopulationDAO.getUserPopulation(this._associatedPopulationId).getUserDirectory(this._associatedUserDirectoryId);
        int usersSearchScope = ScopeEnumerator.parseScope((String)associatedUserDirectory.getParameterValues().get("runtime.users.ldap.scope"));
        constraints.setSearchScope(usersSearchScope);
        return constraints;
    }

    protected SearchControls _getSearchConstraint() {
        SearchControls constraints = new SearchControls();
        constraints.setReturningAttributes(new String[]{this._groupsIdAttribute, this._groupsDescriptionAttribute, this._groupsMemberAttribute});
        constraints.setSearchScope(this._groupsSearchScope);
        return constraints;
    }

    protected Map<String, Object> _group2JSON(Group group, boolean users) {
        HashMap<String, Object> group2json = new HashMap<String, Object>();
        group2json.put("id", group.getIdentity().getId());
        group2json.put("groupDirectory", group.getIdentity().getDirectoryId());
        group2json.put("groupDirectoryLabel", group.getGroupDirectory().getLabel());
        group2json.put("label", group.getLabel());
        if (users) {
            group2json.put("users", group.getUsers());
        }
        return group2json;
    }

    @Override
    protected String[] getSortByFields() {
        return new String[]{this._groupsDescriptionAttribute};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SearchResult _getGroupMatchingFilter(String relativeGroupDn) {
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(0);
        constraints.setReturningAttributes(new String[]{this._groupsIdAttribute, this._groupsDescriptionAttribute, this._groupsMemberAttribute});
        InitialDirContext context = null;
        NamingEnumeration<SearchResult> results = null;
        try {
            context = new InitialDirContext(this._getContextEnv());
            results = context.search(relativeGroupDn, this._groupsObjectFilter, constraints);
            if (results.hasMore()) {
                SearchResult searchResult = results.next();
                return searchResult;
            }
            SearchResult searchResult = null;
            return searchResult;
        }
        catch (NamingException e) {
            this.getLogger().debug("Group '{}' does not match filter '{}': {}", new Object[]{relativeGroupDn, this._groupsObjectFilter, e.getMessage()});
            SearchResult searchResult = null;
            return searchResult;
        }
        finally {
            this._cleanup(context, results);
        }
    }

    public void dispose() {
        this._cacheManager.removeCache(__LDAP_GROUPDIRECTORY_GROUP_BY_ID_CACHE_NAME_PREFIX + this.getUniqueCacheIdSuffix(), AbstractCacheManager.CacheType.MEMORY);
        this._cacheManager.removeCache(__LDAP_GROUPDIRECTORY_GROUPS_BY_USER_CACHE_NAME_PREFIX + this.getUniqueCacheIdSuffix(), AbstractCacheManager.CacheType.MEMORY);
        this._cacheManager.removeCache(__LDAP_GROUPDIRECTORY_USERS_BY_GROUP_CACHE_NAME_PREFIX + this.getUniqueCacheIdSuffix(), AbstractCacheManager.CacheType.MEMORY);
        this._cacheManager.removeCache(__LDAP_GROUPDIRECTORY_ALL_GROUPS_CACHE_NAME_PREFIX + this.getUniqueCacheIdSuffix(), AbstractCacheManager.CacheType.MEMORY);
    }

    private static final class LdapGroup
    implements Group {
        private boolean _userInitialized;
        private Set<UserIdentity> _users;
        private GroupIdentity _identity;
        private String _groupLabel;
        private Attribute _membersAttr;
        @SizeUtils.ExcludeFromSizeCalculation
        private Logger _logger;
        @SizeUtils.ExcludeFromSizeCalculation
        private LdapGroupDirectory _groupDirectory;

        LdapGroup(GroupIdentity identity, String label, LdapGroupDirectory groupDirectory, Attribute membersAttr, Logger logger) {
            this._identity = identity;
            this._groupLabel = label;
            this._groupDirectory = groupDirectory;
            this._membersAttr = membersAttr;
            this._logger = logger;
            this._userInitialized = false;
            this._users = new HashSet<UserIdentity>();
        }

        @Override
        public GroupIdentity getIdentity() {
            return this._identity;
        }

        @Override
        public String getLabel() {
            return this._groupLabel;
        }

        @Override
        public GroupDirectory getGroupDirectory() {
            return this._groupDirectory;
        }

        @Override
        public Set<UserIdentity> getUsers() {
            if (!this._userInitialized) {
                if (this._hasUsersFromCache(this._identity)) {
                    this._users.addAll(this._getUsersFromCache(this._identity));
                } else {
                    this._users.addAll(this._membersAttr != null ? this._getUsersFromMembersAttr() : this._groupDirectory._getUsersFromMembersOfAttr(this._identity.getId()));
                    this._loadUsersInCache(this._identity, this._users);
                }
                this._userInitialized = true;
            }
            return this._users;
        }

        private boolean _hasUsersFromCache(GroupIdentity groupIdentity) {
            return this._groupDirectory._getCacheUsersByGroup().hasKey(groupIdentity);
        }

        private Set<UserIdentity> _getUsersFromCache(GroupIdentity groupIdentity) {
            this._logger.debug("Users found in cache for group '{}", (Object)groupIdentity);
            return this._groupDirectory._getCacheUsersByGroup().get(groupIdentity);
        }

        private void _loadUsersInCache(GroupIdentity groupIdentity, Set<UserIdentity> users) {
            this._groupDirectory._getCacheUsersByGroup().put(groupIdentity, users);
            this._logger.debug("Users loaded in cache for group '{}", (Object)groupIdentity);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<UserIdentity> _getUsersFromMembersAttr() {
            HashSet<UserIdentity> users = new HashSet<UserIdentity>();
            NamingEnumeration<?> members = null;
            ArrayList<String> userDNs = new ArrayList<String>();
            try {
                members = this._membersAttr.getAll();
                while (members.hasMore()) {
                    String userDN = (String)members.next();
                    userDNs.add(userDN);
                }
            }
            catch (NamingException e) {
                this._logger.warn("Missing at least one value for an attribute in an ldap entry.  Group will be ignored.", (Throwable)e);
            }
            finally {
                this._cleanup(null, members);
            }
            for (String userDN : userDNs) {
                UserIdentity identity = this._isDn(userDN) ? this._groupDirectory._getUserInLdapFromDn(userDN) : this._groupDirectory._getUserInLdapFromUid(userDN);
                if (identity == null) continue;
                users.add(identity);
            }
            return users;
        }

        private boolean _isDn(String userDN) {
            return userDN.contains("=");
        }

        private void _cleanup(Context context, NamingEnumeration members) {
            this._groupDirectory._cleanup(context, members);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("UserGroup[");
            sb.append(this._identity);
            sb.append(" (");
            sb.append(this._groupLabel);
            sb.append(") => ");
            if (this._userInitialized) {
                sb.append(this._users.toString());
            } else {
                sb.append("\"Users are not loaded yet\"");
            }
            sb.append("]");
            return sb.toString();
        }

        public boolean equals(Object another) {
            if (another == null || !(another instanceof LdapGroup)) {
                return false;
            }
            LdapGroup otherGroup = (LdapGroup)another;
            return this._identity != null && this._identity.equals(otherGroup.getIdentity());
        }

        public int hashCode() {
            return this._identity.hashCode();
        }
    }
}

