/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.hash;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Base64;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.util.AmetysHomeHelper;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.crypto.generators.Argon2BytesGenerator;
import org.bouncycastle.crypto.params.Argon2Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Argon2PasswordEncoder {
    public static final String ROLE = Argon2PasswordEncoder.class.getName();
    private static Logger __logger = LoggerFactory.getLogger(Config.class);
    private static final String __PEPPER_FILE_PREFIX = "auth/pepper_";
    private static final int __SALT_LENGTH = 16;
    private static final int __PEPPER_LENGTH = 16;
    private static final int __HASH_LENGTH = 32;
    private static final int __PARALLELISM = 1;
    private static final int __MEMORY = 8192;
    private static final int __ITERATIONS = 5;
    private static final Base64.Encoder __B64ENCODER = Base64.getEncoder().withoutPadding();
    private static final Base64.Decoder __B64DECODER = Base64.getDecoder();
    private byte[] _pepper;

    public Argon2PasswordEncoder(byte[] pepper) {
        this._pepper = pepper;
    }

    public static byte[] getOrCreatePepper(String id) throws IOException {
        File pepperFile = new File(AmetysHomeHelper.getAmetysHomeData(), __PEPPER_FILE_PREFIX + id);
        if (!pepperFile.exists()) {
            if (!pepperFile.getParentFile().exists()) {
                pepperFile.getParentFile().mkdirs();
            }
            pepperFile.createNewFile();
            byte[] pepperByes = Argon2PasswordEncoder.generateBytes(16);
            try (FileOutputStream fileOutputStream = new FileOutputStream(pepperFile);){
                IOUtils.write((byte[])pepperByes, (OutputStream)fileOutputStream);
            }
        }
        try (FileInputStream inputStream = new FileInputStream(pepperFile);){
            byte[] byArray = IOUtils.toByteArray((InputStream)inputStream);
            return byArray;
        }
    }

    public String encode(CharSequence rawPassword) {
        byte[] hash = new byte[32];
        Argon2Parameters params = new Argon2Parameters.Builder(2).withSalt(Argon2PasswordEncoder.generateBytes(16)).withParallelism(1).withMemoryAsKB(8192).withIterations(5).withSecret(this._pepper).build();
        Argon2BytesGenerator generator = new Argon2BytesGenerator();
        generator.init(params);
        generator.generateBytes(rawPassword.toString().toCharArray(), hash);
        return this.encode(hash, params);
    }

    public boolean matches(CharSequence rawPassword, String encodedPassword) {
        Argon2Hash decoded;
        if (encodedPassword == null) {
            __logger.warn("password hash is null");
            return false;
        }
        try {
            decoded = this.decode(encodedPassword);
        }
        catch (IllegalArgumentException ex) {
            __logger.warn("Malformed password hash", (Throwable)ex);
            return false;
        }
        byte[] hashBytes = new byte[decoded.getHash().length];
        Argon2BytesGenerator generator = new Argon2BytesGenerator();
        Argon2Parameters decodedParams = decoded.getParameters();
        Argon2Parameters params = new Argon2Parameters.Builder(2).withSalt(decodedParams.getSalt()).withParallelism(decodedParams.getLanes()).withMemoryAsKB(decodedParams.getMemory()).withIterations(decodedParams.getIterations()).withSecret(this._pepper).build();
        generator.init(params);
        generator.generateBytes(rawPassword.toString().toCharArray(), hashBytes);
        return this.constantTimeArrayEquals(decoded.getHash(), hashBytes);
    }

    private boolean constantTimeArrayEquals(byte[] expected, byte[] actual) {
        if (expected.length != actual.length) {
            return false;
        }
        int result = 0;
        for (int i = 0; i < expected.length; ++i) {
            result |= expected[i] ^ actual[i];
        }
        return result == 0;
    }

    private static byte[] generateBytes(int keyLength) {
        byte[] bytes = new byte[keyLength];
        SecureRandom random = new SecureRandom();
        random.nextBytes(bytes);
        return bytes;
    }

    private String encode(byte[] hash, Argon2Parameters parameters) throws IllegalArgumentException {
        StringBuilder stringBuilder = new StringBuilder();
        switch (parameters.getType()) {
            case 0: {
                stringBuilder.append("$argon2d");
                break;
            }
            case 1: {
                stringBuilder.append("$argon2i");
                break;
            }
            case 2: {
                stringBuilder.append("$argon2id");
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid algorithm type: " + parameters.getType());
            }
        }
        stringBuilder.append("$v=").append(parameters.getVersion()).append("$m=").append(parameters.getMemory()).append(",t=").append(parameters.getIterations()).append(",p=").append(parameters.getLanes());
        if (parameters.getSalt() != null) {
            stringBuilder.append("$").append(__B64ENCODER.encodeToString(parameters.getSalt()));
        }
        stringBuilder.append("$").append(__B64ENCODER.encodeToString(hash));
        return stringBuilder.toString();
    }

    private Argon2Hash decode(String encodedHash) throws IllegalArgumentException {
        String[] parts = encodedHash.split("\\$");
        if (parts.length < 4) {
            throw new IllegalArgumentException("Invalid encoded Argon2-hash");
        }
        int currentPart = 1;
        Argon2Parameters.Builder paramsBuilder = switch (parts[currentPart++]) {
            case "argon2d" -> new Argon2Parameters.Builder(0);
            case "argon2i" -> new Argon2Parameters.Builder(1);
            case "argon2id" -> new Argon2Parameters.Builder(2);
            default -> throw new IllegalArgumentException("Invalid algorithm type: " + parts[0]);
        };
        if (parts[currentPart].startsWith("v=")) {
            paramsBuilder.withVersion(Integer.parseInt(parts[currentPart].substring(2)));
        }
        int n = ++currentPart;
        ++currentPart;
        String[] performanceParams = parts[n].split(",");
        if (performanceParams.length != 3) {
            throw new IllegalArgumentException("Amount of performance parameters invalid");
        }
        if (!performanceParams[0].startsWith("m=")) {
            throw new IllegalArgumentException("Invalid memory parameter");
        }
        paramsBuilder.withMemoryAsKB(Integer.parseInt(performanceParams[0].substring(2)));
        if (!performanceParams[1].startsWith("t=")) {
            throw new IllegalArgumentException("Invalid iterations parameter");
        }
        paramsBuilder.withIterations(Integer.parseInt(performanceParams[1].substring(2)));
        if (!performanceParams[2].startsWith("p=")) {
            throw new IllegalArgumentException("Invalid parallelity parameter");
        }
        paramsBuilder.withParallelism(Integer.parseInt(performanceParams[2].substring(2)));
        paramsBuilder.withSalt(__B64DECODER.decode(parts[currentPart++]));
        return new Argon2Hash(__B64DECODER.decode(parts[currentPart]), paramsBuilder.build());
    }

    private static class Argon2Hash {
        private byte[] _hash;
        private Argon2Parameters _parameters;

        Argon2Hash(byte[] hash, Argon2Parameters parameters) {
            this._hash = (byte[])hash.clone();
            this._parameters = parameters;
        }

        public byte[] getHash() {
            return (byte[])this._hash.clone();
        }

        public Argon2Parameters getParameters() {
            return this._parameters;
        }
    }
}

