/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.right;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.right.AccessController;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.core.impl.right.AbstractProfileStorageBasedAccessController;
import org.ametys.runtime.i18n.I18nizableText;

public abstract class AbstractHierarchicalWithPermissionContextAccessController<T, C>
extends AbstractProfileStorageBasedAccessController {
    protected abstract Set<T> _getParents(T var1, C var2);

    protected C _getPermissionContext(T initialObject) {
        return (C)initialObject;
    }

    protected boolean isInheritanceAllowed(T object) {
        return !this._profileAssignmentStorageEP.isInheritanceDisallowed(object);
    }

    @Override
    public Map<String, AccessController.AccessResult> getPermissionByRight(UserIdentity user, Set<GroupIdentity> userGroups, Object object) {
        return this.getPermissionByRight(user, userGroups, object, this._getPermissionContext(object));
    }

    protected Map<String, AccessController.AccessResult> getPermissionByRight(UserIdentity user, Set<GroupIdentity> userGroups, T object, C permissionCtx) {
        Set<T> parents;
        Map<String, AccessController.AccessResult> permissions = super.getPermissionByRight(user, userGroups, object);
        if (this.isInheritanceAllowed(object) && (parents = this._getParents(object, permissionCtx)) != null) {
            HashMap<String, AccessController.AccessResult> parentsPermissions = new HashMap<String, AccessController.AccessResult>();
            for (T parent : parents) {
                Map<String, AccessController.AccessResult> parentPermissions = this.getPermissionByRight(user, userGroups, parent, permissionCtx);
                for (String rightId : parentPermissions.keySet()) {
                    parentsPermissions.put(rightId, AccessController.AccessResult.merge(parentPermissions.get(rightId), (AccessController.AccessResult)((Object)parentsPermissions.get(rightId))));
                }
            }
            for (String rightId : parentsPermissions.keySet()) {
                if (permissions.containsKey(rightId) && permissions.get(rightId) != AccessController.AccessResult.UNKNOWN) continue;
                permissions.put(rightId, (AccessController.AccessResult)((Object)parentsPermissions.get(rightId)));
            }
        }
        return permissions;
    }

    @Override
    protected AccessController.AccessResult _getPermission(UserIdentity user, Set<GroupIdentity> userGroups, Set<String> profilesIds, Object object, Object convertedObject) {
        return this._getPermission(user, userGroups, profilesIds, object, convertedObject, this._getPermissionContext(object));
    }

    protected AccessController.AccessResult _getPermission(UserIdentity user, Set<GroupIdentity> userGroups, Set<String> profilesIds, T object, Object convertedObject, C permissionCtx) {
        Set<T> parents;
        Map cacheResult = (Map)this._hasRightResultInSecondCache(convertedObject, profilesIds, AbstractProfileStorageBasedAccessController.CacheKind.USER);
        if (cacheResult != null && cacheResult.containsKey(user)) {
            return (AccessController.AccessResult)((Object)cacheResult.get(user));
        }
        AccessController.AccessResult permission = super._getPermission(user, userGroups, profilesIds, object, convertedObject);
        if (permission == AccessController.AccessResult.UNKNOWN && this.isInheritanceAllowed(object) && (parents = this._getParents(object, permissionCtx)) != null) {
            for (T parent : parents) {
                Object convertedParentObject = this._convertContext(parent);
                AccessController.AccessResult parentResult = this._getPermission(user, userGroups, profilesIds, parent, convertedParentObject, permissionCtx);
                permission = AccessController.AccessResult.merge(permission, parentResult);
            }
            if (permission != AccessController.AccessResult.UNKNOWN) {
                if (cacheResult == null) {
                    cacheResult = (Map)this._hasRightResultInSecondCache(convertedObject, profilesIds, AbstractProfileStorageBasedAccessController.CacheKind.USER);
                    cacheResult = cacheResult == null ? new HashMap() : cacheResult;
                }
                cacheResult.put(user, permission);
                this._putInSecondCache(profilesIds, convertedObject, cacheResult, AbstractProfileStorageBasedAccessController.CacheKind.USER);
            }
        }
        return permission;
    }

    @Override
    protected AccessController.AccessResult _getPermissionForAnonymous(Set<String> profilesIds, Object object, Object convertedObject) {
        return this._getPermissionForAnonymous(profilesIds, object, convertedObject, this._getPermissionContext(object));
    }

    protected AccessController.AccessResult _getPermissionForAnonymous(Set<String> profilesIds, T object, Object convertedObject, C permissionCtx) {
        Set<T> parents;
        AccessController.AccessResult cacheResult = (AccessController.AccessResult)((Object)this._hasRightResultInSecondCache(convertedObject, profilesIds, AbstractProfileStorageBasedAccessController.CacheKind.ANONYMOUS));
        if (cacheResult != null) {
            return cacheResult;
        }
        AccessController.AccessResult permission = super._getPermissionForAnonymous(profilesIds, object, convertedObject);
        if (permission == AccessController.AccessResult.UNKNOWN && this.isInheritanceAllowed(object) && (parents = this._getParents(object, permissionCtx)) != null) {
            for (T parent : parents) {
                Object convertedParentObject = this._convertContext(parent);
                AccessController.AccessResult parentResult = this._getPermissionForAnonymous(profilesIds, parent, convertedParentObject, permissionCtx);
                permission = AccessController.AccessResult.merge(permission, parentResult);
            }
            if (permission != AccessController.AccessResult.UNKNOWN) {
                this._putInSecondCache(profilesIds, convertedObject, (Object)permission, AbstractProfileStorageBasedAccessController.CacheKind.ANONYMOUS);
            }
        }
        return permission;
    }

    @Override
    protected AccessController.AccessResult _getPermissionForAnyConnectedUser(Set<String> profilesIds, Object object, Object convertedObject) {
        return this._getPermissionForAnyConnectedUser(profilesIds, object, convertedObject, this._getPermissionContext(object));
    }

    protected AccessController.AccessResult _getPermissionForAnyConnectedUser(Set<String> profilesIds, T object, Object convertedObject, C permissionCtx) {
        Set<T> parents;
        AccessController.AccessResult cacheResult = (AccessController.AccessResult)((Object)this._hasRightResultInSecondCache(convertedObject, profilesIds, AbstractProfileStorageBasedAccessController.CacheKind.ANY_CONNECTED_USER));
        if (cacheResult != null) {
            return cacheResult;
        }
        AccessController.AccessResult permission = super._getPermissionForAnyConnectedUser(profilesIds, object, convertedObject);
        if (permission == AccessController.AccessResult.UNKNOWN && this.isInheritanceAllowed(object) && (parents = this._getParents(object, permissionCtx)) != null) {
            for (T parent : parents) {
                Object convertedParentObject = this._convertContext(parent);
                AccessController.AccessResult parentResult = this._getPermissionForAnyConnectedUser(profilesIds, parent, convertedParentObject, permissionCtx);
                permission = AccessController.AccessResult.merge(permission, parentResult);
            }
            if (permission != AccessController.AccessResult.UNKNOWN) {
                this._putInSecondCache(profilesIds, convertedObject, (Object)permission, AbstractProfileStorageBasedAccessController.CacheKind.ANY_CONNECTED_USER);
            }
        }
        return permission;
    }

    @Override
    protected Map<UserIdentity, AccessController.AccessResult> _getPermissionByUser(Set<String> profilesIds, Object object, Object convertedObject) {
        return this._getPermissionByUser(profilesIds, object, convertedObject, this._getPermissionContext(object));
    }

    protected Map<UserIdentity, AccessController.AccessResult> _getPermissionByUser(Set<String> profilesIds, T object, Object convertedObject, C permissionCtx) {
        Set<T> parents;
        Map cacheResult = (Map)this._hasRightResultInSecondCache(convertedObject, profilesIds, AbstractProfileStorageBasedAccessController.CacheKind.USERS);
        if (cacheResult != null) {
            return cacheResult;
        }
        Map<UserIdentity, AccessController.AccessResult> permissions = super._getPermissionByUser(profilesIds, object, convertedObject);
        if (this.isInheritanceAllowed(object) && (parents = this._getParents(object, permissionCtx)) != null) {
            HashMap<UserIdentity, AccessController.AccessResult> parentsPermissions = new HashMap<UserIdentity, AccessController.AccessResult>();
            for (T parent : parents) {
                Object convertedParentObject = this._convertContext(parent);
                Map<UserIdentity, AccessController.AccessResult> parentPermissions = this._getPermissionByUser(profilesIds, parent, convertedParentObject, permissionCtx);
                for (UserIdentity user : parentPermissions.keySet()) {
                    parentsPermissions.put(user, AccessController.AccessResult.merge(parentPermissions.get(user), (AccessController.AccessResult)((Object)parentsPermissions.get(user))));
                }
            }
            for (UserIdentity user : parentsPermissions.keySet()) {
                if (permissions.containsKey(user) && permissions.get(user) != AccessController.AccessResult.UNKNOWN) continue;
                permissions.put(user, (AccessController.AccessResult)((Object)parentsPermissions.get(user)));
            }
        }
        this._putInSecondCache(profilesIds, convertedObject, permissions, AbstractProfileStorageBasedAccessController.CacheKind.USERS);
        return permissions;
    }

    @Override
    protected Map<GroupIdentity, AccessController.AccessResult> _getPermissionByGroup(Set<String> profilesIds, Object object, Object convertedObject) {
        return this._getPermissionByGroup(profilesIds, object, convertedObject, this._getPermissionContext(object));
    }

    protected Map<GroupIdentity, AccessController.AccessResult> _getPermissionByGroup(Set<String> profilesIds, T object, Object convertedObject, C permissionCtx) {
        Set<T> parents;
        Map cacheResult = (Map)this._hasRightResultInSecondCache(convertedObject, profilesIds, AbstractProfileStorageBasedAccessController.CacheKind.GROUPS);
        if (cacheResult != null) {
            return cacheResult;
        }
        Map<GroupIdentity, AccessController.AccessResult> permissions = super._getPermissionByGroup(profilesIds, object, convertedObject);
        if (this.isInheritanceAllowed(object) && (parents = this._getParents(object, permissionCtx)) != null) {
            HashMap<GroupIdentity, AccessController.AccessResult> parentsPermissions = new HashMap<GroupIdentity, AccessController.AccessResult>();
            for (T parent : parents) {
                Object convertedParentObject = this._convertContext(parent);
                Map<GroupIdentity, AccessController.AccessResult> parentPermissions = this._getPermissionByGroup(profilesIds, parent, convertedParentObject, permissionCtx);
                for (GroupIdentity group : parentPermissions.keySet()) {
                    parentsPermissions.put(group, AccessController.AccessResult.merge(parentPermissions.get(group), (AccessController.AccessResult)((Object)parentsPermissions.get(group))));
                }
            }
            for (GroupIdentity group : parentsPermissions.keySet()) {
                if (permissions.containsKey(group) && permissions.get(group) != AccessController.AccessResult.UNKNOWN) continue;
                permissions.put(group, (AccessController.AccessResult)((Object)parentsPermissions.get(group)));
            }
        }
        this._putInSecondCache(profilesIds, convertedObject, permissions, AbstractProfileStorageBasedAccessController.CacheKind.GROUPS);
        return permissions;
    }

    @Override
    protected AbstractProfileStorageBasedAccessController.PermissionDetails _getPermissionDetails(UserIdentity user, Set<GroupIdentity> groups, Set<String> profilesIds, Object object, Object convertedObject) {
        return this._getPermissionDetails(user, groups, profilesIds, object, convertedObject, this._getPermissionContext(object));
    }

    protected AbstractProfileStorageBasedAccessController.PermissionDetails _getPermissionDetails(UserIdentity user, Set<GroupIdentity> userGroups, Set<String> profilesIds, T object, Object convertedObject, C permissionCtx) {
        Set<T> parents;
        AbstractProfileStorageBasedAccessController.PermissionDetails details = super._getPermissionDetails(user, userGroups, profilesIds, object, convertedObject);
        if (details.getResult() == AccessController.AccessResult.UNKNOWN && this.isInheritanceAllowed(object) && (parents = this._getParents(object, permissionCtx)) != null) {
            for (T parent : parents) {
                Object convertedParentObject;
                AbstractProfileStorageBasedAccessController.PermissionDetails parentDetails = this._getPermissionDetails(user, userGroups, profilesIds, parent, convertedParentObject = this._convertContext(parent), permissionCtx);
                AccessController.AccessResult result = parentDetails.getResult();
                if (result == AccessController.AccessResult.UNKNOWN || AccessController.AccessResult.merge(result, details.getResult()) != result) continue;
                details = HierarchicalPermissionDetails.of(parentDetails);
            }
        }
        return details;
    }

    @Override
    protected AbstractProfileStorageBasedAccessController.PermissionDetails _getPermissionDetailsForAnyConnectedUser(Set<String> profilesIds, Object object, Object convertedObject) {
        return this._getPermissionDetailsForAnyConnectedUser(profilesIds, object, convertedObject, this._getPermissionContext(object));
    }

    protected AbstractProfileStorageBasedAccessController.PermissionDetails _getPermissionDetailsForAnyConnectedUser(Set<String> profilesIds, T object, Object convertedObject, C permissionCtx) {
        Set<T> parents;
        AbstractProfileStorageBasedAccessController.PermissionDetails details = super._getPermissionDetailsForAnyConnectedUser(profilesIds, object, convertedObject);
        boolean inheritanceAllowed = this.isInheritanceAllowed(object);
        if (details.getResult() == AccessController.AccessResult.UNKNOWN && inheritanceAllowed && (parents = this._getParents(object, permissionCtx)) != null) {
            for (T parent : parents) {
                Object convertedParentObject;
                AbstractProfileStorageBasedAccessController.PermissionDetails parentDetails = this._getPermissionDetailsForAnyConnectedUser(profilesIds, parent, convertedParentObject = this._convertContext(parent), permissionCtx);
                AccessController.AccessResult result = parentDetails.getResult();
                if (result == AccessController.AccessResult.UNKNOWN || AccessController.AccessResult.merge(result, details.getResult()) != result) continue;
                details = HierarchicalPermissionDetails.of(parentDetails);
            }
        }
        return details;
    }

    @Override
    protected AbstractProfileStorageBasedAccessController.PermissionDetails _getPermissionDetailsForAnonymous(Set<String> profilesIds, Object object, Object convertedObject) {
        return this._getPermissionDetailsForAnonymous(profilesIds, object, convertedObject, this._getPermissionContext(object));
    }

    protected AbstractProfileStorageBasedAccessController.PermissionDetails _getPermissionDetailsForAnonymous(Set<String> profilesIds, T object, Object convertedObject, C permissionCtx) {
        Set<T> parents;
        AbstractProfileStorageBasedAccessController.PermissionDetails details = super._getPermissionDetailsForAnonymous(profilesIds, object, convertedObject);
        boolean inheritanceAllowed = this.isInheritanceAllowed(object);
        if (details.getResult() == AccessController.AccessResult.UNKNOWN && inheritanceAllowed && (parents = this._getParents(object, permissionCtx)) != null) {
            for (T parent : parents) {
                Object convertedParentObject;
                AbstractProfileStorageBasedAccessController.PermissionDetails parentDetails = this._getPermissionDetailsForAnonymous(profilesIds, parent, convertedParentObject = this._convertContext(parent), permissionCtx);
                AccessController.AccessResult result = parentDetails.getResult();
                if (result == AccessController.AccessResult.UNKNOWN || AccessController.AccessResult.merge(result, details.getResult()) != result) continue;
                details = HierarchicalPermissionDetails.of(parentDetails);
            }
        }
        return details;
    }

    @Override
    protected I18nizableText _getExplanationI18nText(AbstractProfileStorageBasedAccessController.PermissionDetails details) {
        if (details instanceof HierarchicalPermissionDetails) {
            return new I18nizableText("plugin.core-impl", this._getAccessExplanationI18nKey("PLUGINS_CORE_HIERARCHICAL_ACCESS_CONTROLLER_", details), this._getExplanationI18nParams(details));
        }
        return super._getExplanationI18nText(details);
    }

    @Override
    protected Map<AccessController.Permission, AbstractProfileStorageBasedAccessController.PermissionDetails> _getAllPermissionsDetailsForAnonymous(Object object, Object convertedContext) {
        return this._getAllPermissionsDetailsForAnonymous(object, convertedContext, this._getPermissionContext(object));
    }

    protected Map<AccessController.Permission, AbstractProfileStorageBasedAccessController.PermissionDetails> _getAllPermissionsDetailsForAnonymous(T object, Object convertedContext, C permissionCtx) {
        Set<T> parents;
        Map<AccessController.Permission, AbstractProfileStorageBasedAccessController.PermissionDetails> results = super._getAllPermissionsDetailsForAnonymous(object, convertedContext);
        boolean inheritanceAllowed = this.isInheritanceAllowed(object);
        if (inheritanceAllowed && (parents = this._getParents(object, permissionCtx)) != null) {
            HashMap<AccessController.Permission, HierarchicalPermissionDetails> parentResults = new HashMap<AccessController.Permission, HierarchicalPermissionDetails>();
            for (T parent : parents) {
                Map<AccessController.Permission, AbstractProfileStorageBasedAccessController.PermissionDetails> parentPermissions = this._getAllPermissionsDetailsForAnonymous(parent, this._convertContext(parent), permissionCtx);
                this._filterAndMergeHierarchicalPermissions(parentResults, parentPermissions, results);
            }
            results.putAll(parentResults);
        }
        return results;
    }

    @Override
    protected Map<AccessController.Permission, AbstractProfileStorageBasedAccessController.PermissionDetails> _getAllPermissionsDetailsForAnyConnected(Object object, Object convertedContext) {
        return this._getAllPermissionsDetailsForAnyConnected(object, convertedContext, this._getPermissionContext(object));
    }

    protected Map<AccessController.Permission, AbstractProfileStorageBasedAccessController.PermissionDetails> _getAllPermissionsDetailsForAnyConnected(T object, Object convertedContext, C permissionCtx) {
        Set<T> parents;
        Map<AccessController.Permission, AbstractProfileStorageBasedAccessController.PermissionDetails> results = super._getAllPermissionsDetailsForAnyConnected(object, convertedContext);
        boolean inheritanceAllowed = this.isInheritanceAllowed(object);
        if (inheritanceAllowed && (parents = this._getParents(object, permissionCtx)) != null) {
            HashMap<AccessController.Permission, HierarchicalPermissionDetails> parentResults = new HashMap<AccessController.Permission, HierarchicalPermissionDetails>();
            for (T parent : parents) {
                Map<AccessController.Permission, AbstractProfileStorageBasedAccessController.PermissionDetails> parentPermissions = this._getAllPermissionsDetailsForAnyConnected(parent, this._convertContext(parent), permissionCtx);
                this._filterAndMergeHierarchicalPermissions(parentResults, parentPermissions, results);
            }
            results.putAll(parentResults);
        }
        return results;
    }

    private void _filterAndMergeHierarchicalPermissions(Map<AccessController.Permission, HierarchicalPermissionDetails> mergedPermissions, Map<AccessController.Permission, ? extends AbstractProfileStorageBasedAccessController.PermissionDetails> parentCtxPermissions, Map<AccessController.Permission, AbstractProfileStorageBasedAccessController.PermissionDetails> initialCtxPermissions) {
        parentCtxPermissions.entrySet().stream().filter(e -> e.getValue() != null && ((AbstractProfileStorageBasedAccessController.PermissionDetails)e.getValue()).getResult() != AccessController.AccessResult.UNKNOWN).filter(e -> initialCtxPermissions == null || initialCtxPermissions.get(e.getKey()) == null || ((AbstractProfileStorageBasedAccessController.PermissionDetails)initialCtxPermissions.get(e.getKey())).getResult() == AccessController.AccessResult.UNKNOWN).forEach(e -> {
            HierarchicalPermissionDetails details = HierarchicalPermissionDetails.of((AbstractProfileStorageBasedAccessController.PermissionDetails)e.getValue());
            mergedPermissions.merge((AccessController.Permission)e.getKey(), details, (d1, d2) -> AccessController.AccessResult.merge(d1.getResult(), d2.getResult()) == d2.getResult() ? d2 : d1);
        });
    }

    @Override
    protected Map<UserIdentity, Map<AccessController.Permission, AbstractProfileStorageBasedAccessController.PermissionDetails>> _getAllPermissionsDetailsByUser(Object object, Object convertedContext) {
        return this._getAllPermissionsDetailsByUser(object, convertedContext, this._getPermissionContext(object));
    }

    protected Map<UserIdentity, Map<AccessController.Permission, AbstractProfileStorageBasedAccessController.PermissionDetails>> _getAllPermissionsDetailsByUser(T object, Object convertedContext, C permissionCtx) {
        Set<T> parents;
        Map<UserIdentity, Map<AccessController.Permission, AbstractProfileStorageBasedAccessController.PermissionDetails>> results = super._getAllPermissionsDetailsByUser(object, convertedContext);
        boolean inheritanceAllowed = this.isInheritanceAllowed(object);
        if (inheritanceAllowed && (parents = this._getParents(object, permissionCtx)) != null) {
            HashMap<UserIdentity, Map> parentsResults = new HashMap<UserIdentity, Map>();
            for (T t : parents) {
                Map<UserIdentity, Map<AccessController.Permission, AbstractProfileStorageBasedAccessController.PermissionDetails>> parentPermissionsByUser = this._getAllPermissionsDetailsByUser(t, this._convertContext(t), permissionCtx);
                for (UserIdentity identity : parentPermissionsByUser.keySet()) {
                    Map<AccessController.Permission, AbstractProfileStorageBasedAccessController.PermissionDetails> initialPermissionsForUser = results.get(identity);
                    Map parentsPermissionsForUser = parentsResults.computeIfAbsent(identity, e -> new HashMap());
                    this._filterAndMergeHierarchicalPermissions(parentsPermissionsForUser, parentPermissionsByUser.get(identity), initialPermissionsForUser);
                }
            }
            for (Map.Entry entry : parentsResults.entrySet()) {
                results.computeIfAbsent((UserIdentity)entry.getKey(), e -> new HashMap()).putAll((Map)entry.getValue());
            }
        }
        return results;
    }

    @Override
    protected Map<GroupIdentity, Map<AccessController.Permission, AbstractProfileStorageBasedAccessController.PermissionDetails>> _getAllPermissionsDetailsByGroup(Object object, Object convertedContext) {
        return this._getAllPermissionsDetailsByGroup(object, convertedContext, this._getPermissionContext(object));
    }

    protected Map<GroupIdentity, Map<AccessController.Permission, AbstractProfileStorageBasedAccessController.PermissionDetails>> _getAllPermissionsDetailsByGroup(T object, Object convertedContext, C permissionCtx) {
        Set<T> parents;
        Map<GroupIdentity, Map<AccessController.Permission, AbstractProfileStorageBasedAccessController.PermissionDetails>> results = super._getAllPermissionsDetailsByGroup(object, convertedContext);
        boolean inheritanceAllowed = this.isInheritanceAllowed(object);
        if (inheritanceAllowed && (parents = this._getParents(object, permissionCtx)) != null) {
            HashMap<GroupIdentity, Map> parentsResults = new HashMap<GroupIdentity, Map>();
            for (T t : parents) {
                Map<GroupIdentity, Map<AccessController.Permission, AbstractProfileStorageBasedAccessController.PermissionDetails>> parentPermissionsByGroup = this._getAllPermissionsDetailsByGroup(t, this._convertContext(t), permissionCtx);
                for (GroupIdentity identity : parentPermissionsByGroup.keySet()) {
                    Map<AccessController.Permission, AbstractProfileStorageBasedAccessController.PermissionDetails> initialPermissionsForGroup = results.get(identity);
                    Map parentsPermissionsForGroup = parentsResults.computeIfAbsent(identity, e -> new HashMap());
                    this._filterAndMergeHierarchicalPermissions(parentsPermissionsForGroup, parentPermissionsByGroup.get(identity), initialPermissionsForGroup);
                }
            }
            for (Map.Entry entry : parentsResults.entrySet()) {
                results.computeIfAbsent((GroupIdentity)entry.getKey(), e -> new HashMap()).putAll((Map)entry.getValue());
            }
        }
        return results;
    }

    protected static class HierarchicalPermissionDetails
    extends AbstractProfileStorageBasedAccessController.PermissionDetails {
        public HierarchicalPermissionDetails(AbstractProfileStorageBasedAccessController.PermissionDetails parentDetails) {
            super(parentDetails.getResult(), parentDetails.getProfiles(), parentDetails.getGroups(), parentDetails.getObject());
        }

        public static HierarchicalPermissionDetails of(AbstractProfileStorageBasedAccessController.PermissionDetails permissionDetails) {
            HierarchicalPermissionDetails hDetails;
            return permissionDetails instanceof HierarchicalPermissionDetails ? (hDetails = (HierarchicalPermissionDetails)permissionDetails) : new HierarchicalPermissionDetails(permissionDetails);
        }
    }
}

