/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.right;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.core.group.Group;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.group.GroupManager;
import org.ametys.core.right.AccessController;
import org.ametys.core.right.AccessExplanation;
import org.ametys.core.right.Profile;
import org.ametys.core.right.ProfileAssignmentStorage;
import org.ametys.core.right.ProfileAssignmentStorageExtensionPoint;
import org.ametys.core.right.ProfileBasedAccessController;
import org.ametys.core.right.RightManager;
import org.ametys.core.right.RightProfilesDAO;
import org.ametys.core.right.RightsException;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.core.impl.cache.AbstractCacheKey;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.i18n.I18nizableTextParameter;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.plugin.component.PluginAware;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.collections.CollectionUtils;

public abstract class AbstractProfileStorageBasedAccessController
extends AbstractLogEnabled
implements ProfileBasedAccessController,
Serviceable,
Initializable,
PluginAware {
    protected static final UserIdentity __ANONYMOUS_USER_IDENTITY = null;
    protected static final UserIdentity __ANY_CONTECTED_USER_IDENTITY = new UserIdentity(null, null);
    protected ProfileAssignmentStorageExtensionPoint _profileAssignmentStorageEP;
    protected RightProfilesDAO _rightProfileDAO;
    protected AbstractCacheManager _cacheManager;
    protected GroupManager _groupManager;
    private String _cache1;
    private String _cache2;
    private String _id;

    @Override
    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._id = id;
        this._cache1 = RightManager.ROLE + "$" + this._id + "$Cache-1";
        this._cache2 = RightManager.ROLE + "$" + this._id + "$Cache-2";
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._rightProfileDAO = (RightProfilesDAO)manager.lookup(RightProfilesDAO.ROLE);
        this._profileAssignmentStorageEP = (ProfileAssignmentStorageExtensionPoint)manager.lookup(ProfileAssignmentStorageExtensionPoint.ROLE);
        this._cacheManager = (AbstractCacheManager)manager.lookup(AbstractCacheManager.ROLE);
        this._groupManager = (GroupManager)manager.lookup(GroupManager.ROLE);
    }

    public void initialize() throws Exception {
        this._cacheManager.createRequestCache(this._cache1, this._buildI18n("PLUGINS_CORE_RIGHT_CACHE_1_LABEL"), this._buildI18n("PLUGINS_CORE_RIGHT_CACHE_1_DESCRIPTION"), true);
        this._cacheManager.createRequestCache(this._cache2, this._buildI18n("PLUGINS_CORE_RIGHT_CACHE_2_LABEL"), this._buildI18n("PLUGINS_CORE_RIGHT_CACHE_2_DESCRIPTION"), true);
    }

    private I18nizableText _buildI18n(String i18Key) {
        String catalogue = "plugin.core";
        I18nizableText className = new I18nizableText(this._id);
        Map<String, I18nizableTextParameter> params = Map.of("id", className);
        return new I18nizableText(catalogue, i18Key, params);
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public Map<String, AccessController.AccessResult> getPermissionByRight(UserIdentity user, Set<GroupIdentity> userGroups, Object object) {
        HashMap<String, AccessController.AccessResult> rights = new HashMap<String, AccessController.AccessResult>();
        Map<String, AccessController.AccessResult> permissionsByProfile = this._profileAssignmentStorageEP.getPermissionsByProfile(user, userGroups, this._convertContext(object));
        for (String profileId : permissionsByProfile.keySet()) {
            List<String> rights2 = this._rightProfileDAO.getRights(profileId);
            for (String rightId : rights2) {
                rights.put(rightId, AccessController.AccessResult.merge(permissionsByProfile.get(profileId), (AccessController.AccessResult)((Object)rights.get(rightId))));
            }
        }
        return rights;
    }

    @Override
    public AccessController.AccessResult getPermission(UserIdentity user, Set<GroupIdentity> userGroups, String rightId, Object object) {
        Set<String> profilesIds = this._rightProfileDAO.getProfilesWithRight(rightId);
        if (profilesIds == null || profilesIds.isEmpty()) {
            return AccessController.AccessResult.UNKNOWN;
        }
        Object convertedObject = this._convertContext(object);
        return this._getPermission(user, userGroups, profilesIds, object, convertedObject);
    }

    @Override
    public AccessController.AccessResult getReadAccessPermission(UserIdentity user, Set<GroupIdentity> userGroups, Object object) {
        Set<String> profilesIds = Collections.singleton("READER");
        Object convertedObject = this._convertContext(object);
        return this._getPermission(user, userGroups, profilesIds, object, convertedObject);
    }

    protected AccessController.AccessResult _getPermission(UserIdentity user, Set<GroupIdentity> userGroups, Set<String> profilesIds, Object object, Object convertedObject) {
        Map cacheResult = (Map)this._hasRightResultInSecondCache(convertedObject, profilesIds, CacheKind.USER);
        if (cacheResult != null && cacheResult.containsKey(user)) {
            return (AccessController.AccessResult)((Object)cacheResult.get(user));
        }
        Map<String, AccessController.AccessResult> permissions = this._profileAssignmentStorageEP.getPermissions(user, userGroups, profilesIds, convertedObject);
        AccessController.AccessResult result = AccessController.AccessResult.merge(permissions.values());
        cacheResult = cacheResult == null ? new HashMap() : cacheResult;
        cacheResult.put(user, result);
        this._putInSecondCache(profilesIds, convertedObject, cacheResult, CacheKind.USER);
        return result;
    }

    @Override
    public AccessController.AccessResult getPermissionForAnonymous(String rightId, Object object) {
        Set<String> profilesIds = this._rightProfileDAO.getProfilesWithRight(rightId);
        if (profilesIds == null || profilesIds.isEmpty()) {
            return AccessController.AccessResult.UNKNOWN;
        }
        Object convertedObject = this._convertContext(object);
        return this._getPermissionForAnonymous(profilesIds, object, convertedObject);
    }

    @Override
    public AccessController.AccessResult getReadAccessPermissionForAnonymous(Object object) {
        Set<String> profilesIds = Collections.singleton("READER");
        Object convertedObject = this._convertContext(object);
        return this._getPermissionForAnonymous(profilesIds, object, convertedObject);
    }

    protected AccessController.AccessResult _getPermissionForAnonymous(Set<String> profilesIds, Object object, Object convertedObject) {
        AccessController.AccessResult cacheResult = (AccessController.AccessResult)((Object)this._hasRightResultInSecondCache(convertedObject, profilesIds, CacheKind.ANONYMOUS));
        if (cacheResult != null) {
            return cacheResult;
        }
        AccessController.AccessResult result = this._profileAssignmentStorageEP.getPermissionForAnonymous(profilesIds, convertedObject);
        this._putInSecondCache(profilesIds, convertedObject, (Object)result, CacheKind.ANONYMOUS);
        return result;
    }

    @Override
    public AccessController.AccessResult getPermissionForAnyConnectedUser(String rightId, Object object) {
        Set<String> profilesIds = this._rightProfileDAO.getProfilesWithRight(rightId);
        if (profilesIds == null || profilesIds.isEmpty()) {
            return AccessController.AccessResult.UNKNOWN;
        }
        Object convertedObject = this._convertContext(object);
        return this._getPermissionForAnyConnectedUser(profilesIds, object, convertedObject);
    }

    @Override
    public AccessController.AccessResult getReadAccessPermissionForAnyConnectedUser(Object object) {
        Set<String> profilesIds = Collections.singleton("READER");
        Object convertedObject = this._convertContext(object);
        return this._getPermissionForAnyConnectedUser(profilesIds, object, convertedObject);
    }

    protected AccessController.AccessResult _getPermissionForAnyConnectedUser(Set<String> profilesIds, Object object, Object convertedObject) {
        AccessController.AccessResult cacheResult = (AccessController.AccessResult)((Object)this._hasRightResultInSecondCache(convertedObject, profilesIds, CacheKind.ANY_CONNECTED_USER));
        if (cacheResult != null) {
            return cacheResult;
        }
        AccessController.AccessResult result = this._profileAssignmentStorageEP.getPermissionForAnyConnectedUser(profilesIds, convertedObject);
        this._putInSecondCache(profilesIds, convertedObject, (Object)result, CacheKind.ANY_CONNECTED_USER);
        return result;
    }

    @Override
    public Map<UserIdentity, AccessController.AccessResult> getPermissionByUser(String rightId, Object object) {
        Set<String> profilesIds = this._rightProfileDAO.getProfilesWithRight(rightId);
        if (profilesIds == null || profilesIds.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        Object convertedObject = this._convertContext(object);
        return this._getPermissionByUser(profilesIds, object, convertedObject);
    }

    @Override
    public Map<UserIdentity, AccessController.AccessResult> getReadAccessPermissionByUser(Object object) {
        Set<String> profilesIds = Collections.singleton("READER");
        Object convertedObject = this._convertContext(object);
        return this._getPermissionByUser(profilesIds, object, convertedObject);
    }

    protected Map<UserIdentity, AccessController.AccessResult> _getPermissionByUser(Set<String> profilesIds, Object object, Object convertedObject) {
        Map cacheResult = (Map)this._hasRightResultInSecondCache(convertedObject, profilesIds, CacheKind.USERS);
        if (cacheResult != null) {
            return cacheResult;
        }
        Map<UserIdentity, AccessController.AccessResult> result = this._profileAssignmentStorageEP.getPermissionsByUser(profilesIds, convertedObject);
        this._putInSecondCache(profilesIds, convertedObject, result, CacheKind.USERS);
        return result;
    }

    @Override
    public Map<GroupIdentity, AccessController.AccessResult> getPermissionByGroup(String rightId, Object object) {
        Set<String> profilesIds = this._rightProfileDAO.getProfilesWithRight(rightId);
        if (profilesIds == null || profilesIds.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        Object convertedObject = this._convertContext(object);
        return this._getPermissionByGroup(profilesIds, object, convertedObject);
    }

    @Override
    public Map<GroupIdentity, AccessController.AccessResult> getReadAccessPermissionByGroup(Object object) {
        Set<String> profilesIds = Collections.singleton("READER");
        Object convertedObject = this._convertContext(object);
        return this._getPermissionByGroup(profilesIds, object, convertedObject);
    }

    protected Map<GroupIdentity, AccessController.AccessResult> _getPermissionByGroup(Set<String> profilesIds, Object object, Object convertedObject) {
        Map cacheResult = (Map)this._hasRightResultInSecondCache(convertedObject, profilesIds, CacheKind.GROUPS);
        if (cacheResult != null) {
            return cacheResult;
        }
        Map<GroupIdentity, AccessController.AccessResult> result = this._profileAssignmentStorageEP.getPermissionsByGroup(profilesIds, convertedObject);
        this._putInSecondCache(profilesIds, convertedObject, result, CacheKind.GROUPS);
        return result;
    }

    protected Object _convertContext(Object initialContext) {
        return initialContext;
    }

    protected Object _unconvertContext(Object storedObject) {
        return storedObject;
    }

    protected boolean ignoreOnHasAnyPermission() {
        return false;
    }

    @Override
    public boolean hasAnonymousAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts) {
        Set<String> profilesIds = Collections.singleton("READER");
        return this._hasAnonymousAnyPermissionOnWorkspace(workspacesContexts, profilesIds);
    }

    @Override
    public boolean hasAnonymousAnyPermissionOnWorkspace(Set<Object> workspacesContexts, String rightId) {
        Set<String> profilesIds = this._rightProfileDAO.getProfilesWithRight(rightId);
        return this._hasAnonymousAnyPermissionOnWorkspace(workspacesContexts, profilesIds);
    }

    private boolean _hasAnonymousAnyPermissionOnWorkspace(Set<Object> workspacesContexts, Set<String> profilesIds) {
        Set<String> hasAnonymousAnyPermission;
        if (this.ignoreOnHasAnyPermission()) {
            return false;
        }
        Boolean cacheResult = this._hasRightResultInFirstCache(__ANONYMOUS_USER_IDENTITY, profilesIds, workspacesContexts);
        if (cacheResult != null) {
            return cacheResult;
        }
        Set<? extends Object> rootContexts = this._convertWorkspaceToRootRightContexts(workspacesContexts);
        Set<String> determinedProfiles = profilesIds;
        boolean rightResult = false;
        if (CollectionUtils.isNotEmpty(rootContexts) && !(hasAnonymousAnyPermission = this._profileAssignmentStorageEP.hasAnonymousAnyPermission(rootContexts, profilesIds)).isEmpty()) {
            rightResult = true;
            determinedProfiles = hasAnonymousAnyPermission;
        }
        this._putInFirstCache(__ANONYMOUS_USER_IDENTITY, determinedProfiles, workspacesContexts, rightResult);
        return rightResult;
    }

    @Override
    public boolean hasAnyConnectedUserAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts) {
        Set<String> profilesIds = Collections.singleton("READER");
        return this._hasAnyConnectedUserAnyPermissionOnWorkspace(workspacesContexts, profilesIds);
    }

    @Override
    public boolean hasAnyConnectedUserAnyPermissionOnWorkspace(Set<Object> workspacesContexts, String rightId) {
        Set<String> profilesIds = this._rightProfileDAO.getProfilesWithRight(rightId);
        return this._hasAnyConnectedUserAnyPermissionOnWorkspace(workspacesContexts, profilesIds);
    }

    private boolean _hasAnyConnectedUserAnyPermissionOnWorkspace(Set<Object> workspacesContexts, Set<String> profilesIds) {
        Set<String> hasAnyConnectedUserAnyPermission;
        if (this.ignoreOnHasAnyPermission()) {
            return false;
        }
        Boolean cacheResult = this._hasRightResultInFirstCache(__ANY_CONTECTED_USER_IDENTITY, profilesIds, workspacesContexts);
        if (cacheResult != null) {
            return cacheResult;
        }
        Set<? extends Object> rootContexts = this._convertWorkspaceToRootRightContexts(workspacesContexts);
        Set<String> determinedProfiles = profilesIds;
        boolean rightResult = false;
        if (CollectionUtils.isNotEmpty(rootContexts) && !(hasAnyConnectedUserAnyPermission = this._profileAssignmentStorageEP.hasAnyConnectedUserAnyPermission(rootContexts, profilesIds)).isEmpty()) {
            rightResult = true;
            determinedProfiles = hasAnyConnectedUserAnyPermission;
        }
        this._putInFirstCache(__ANY_CONTECTED_USER_IDENTITY, determinedProfiles, workspacesContexts, rightResult);
        return rightResult;
    }

    @Override
    public boolean hasUserAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts, UserIdentity user, Set<GroupIdentity> userGroups) {
        Set<String> profilesIds = Collections.singleton("READER");
        return this._hasUserAnyPermissionOnWorkspace(workspacesContexts, user, userGroups, profilesIds);
    }

    @Override
    public boolean hasUserAnyPermissionOnWorkspace(Set<Object> workspacesContexts, UserIdentity user, Set<GroupIdentity> userGroups, String rightId) {
        Set<String> profilesIds = this._rightProfileDAO.getProfilesWithRight(rightId);
        return this._hasUserAnyPermissionOnWorkspace(workspacesContexts, user, userGroups, profilesIds);
    }

    private boolean _hasUserAnyPermissionOnWorkspace(Set<Object> workspacesContexts, UserIdentity user, Set<GroupIdentity> userGroups, Set<String> profilesIds) {
        Set<String> hasUserAnyPermission;
        if (this.ignoreOnHasAnyPermission()) {
            return false;
        }
        Boolean cacheResult = this._hasRightResultInFirstCache(user, profilesIds, workspacesContexts);
        if (cacheResult != null) {
            return cacheResult;
        }
        Set<? extends Object> rootContexts = this._convertWorkspaceToRootRightContexts(workspacesContexts);
        Set<String> determinedProfiles = profilesIds;
        boolean rightResult = false;
        if (CollectionUtils.isNotEmpty(rootContexts) && !(hasUserAnyPermission = this._profileAssignmentStorageEP.hasUserAnyPermission(rootContexts, user, userGroups, profilesIds)).isEmpty()) {
            rightResult = true;
            determinedProfiles = hasUserAnyPermission;
        }
        this._putInFirstCache(user, determinedProfiles, workspacesContexts, rightResult);
        return rightResult;
    }

    protected abstract Set<? extends Object> _convertWorkspaceToRootRightContexts(Set<Object> var1);

    protected Boolean _hasRightResultInFirstCache(UserIdentity userIdentity, Set<String> profilesIds, Object object) {
        if (profilesIds == null || profilesIds.isEmpty()) {
            return false;
        }
        Cache mapCache = this._cacheManager.get(this._cache1);
        if (mapCache != null) {
            int negativeProfiles = 0;
            for (String profileId : profilesIds) {
                Cache1Key key = Cache1Key.of(userIdentity, profileId, object);
                if (!mapCache.hasKey(key)) continue;
                if (((Boolean)mapCache.get(key)).booleanValue()) {
                    this.getLogger().debug("Find entry in cache for [{}, {}, {}] => true", new Object[]{userIdentity, profilesIds, object});
                    return true;
                }
                ++negativeProfiles;
            }
            if (negativeProfiles == profilesIds.size()) {
                return false;
            }
        }
        this.getLogger().debug("Did not find entry in cache for [{}, {}, {}]", new Object[]{userIdentity, profilesIds, object});
        return null;
    }

    protected void _putInFirstCache(UserIdentity userIdentity, Set<String> profilesIds, Object object, boolean rightResult) {
        Cache<Cache1Key, Boolean> mapCache = this._cacheManager.get(this._cache1);
        if (mapCache != null) {
            for (String profileId : profilesIds) {
                mapCache.put(Cache1Key.of(userIdentity, profileId, object), rightResult);
            }
        }
    }

    protected Object _hasRightResultInSecondCache(Object object, Set<String> profilesIds, CacheKind key) {
        Cache mapCache = this._cacheManager.get(this._cache2);
        Object cacheResult = mapCache.get(Cache2Key.of(profilesIds, object, key));
        if (cacheResult != null) {
            this.getLogger().debug("Find entry in cache for [{}, {}, {}] => {}", new Object[]{profilesIds, object, key, cacheResult});
            return cacheResult;
        }
        this.getLogger().debug("Did not find entry in cache for [{}, {}, {}]", new Object[]{profilesIds, object, key});
        return null;
    }

    protected void _putInSecondCache(Set<String> profilesIds, Object object, Object result, CacheKind key) {
        Cache<Cache2Key, Object> mapCache = this._cacheManager.get(this._cache2);
        if (mapCache != null) {
            mapCache.put(Cache2Key.of(profilesIds, object, key), result);
        }
    }

    @Override
    public AccessExplanation explainReadAccessPermission(UserIdentity user, Set<GroupIdentity> groups, Object object) {
        Set<String> profilesIds = Collections.singleton("READER");
        return this._explainPermission(user, groups, profilesIds, object, this._convertContext(object));
    }

    @Override
    public AccessExplanation explainPermission(UserIdentity user, Set<GroupIdentity> groups, String rightId, Object object) {
        Set<String> profilesIds = this._rightProfileDAO.getProfilesWithRight(rightId);
        if (profilesIds == null || profilesIds.isEmpty()) {
            return this._buildExplanation(new PermissionDetails(AccessController.AccessResult.UNKNOWN, Set.of(), Set.of(), object));
        }
        return this._explainPermission(user, groups, profilesIds, object, this._convertContext(object));
    }

    protected AccessExplanation _explainPermission(UserIdentity user, Set<GroupIdentity> userGroups, Set<String> profilesIds, Object object, Object convertedObject) {
        PermissionDetails permissionDetails = this._getPermissionDetails(user, userGroups, profilesIds, object, convertedObject);
        return this._buildExplanation(permissionDetails);
    }

    protected PermissionDetails _getPermissionDetails(UserIdentity user, Set<GroupIdentity> groups, Set<String> profilesIds, Object object, Object convertedObject) {
        Map<String, AccessController.AccessResult> permissions = this._profileAssignmentStorageEP.getPermissions(user, groups, profilesIds, convertedObject);
        AccessController.AccessResult finalResult = AccessController.AccessResult.merge(permissions.values());
        if (finalResult == AccessController.AccessResult.UNKNOWN) {
            return new PermissionDetails(finalResult, Set.of(), Set.of(), object);
        }
        Set<Profile> profiles = permissions.entrySet().stream().filter(e -> e.getValue() == finalResult).map(e -> this._rightProfileDAO.getProfile((String)e.getKey())).collect(Collectors.toSet());
        Set<Group> grantingOrDenyingGroups = new HashSet<Group>();
        if (finalResult == AccessController.AccessResult.GROUP_ALLOWED || finalResult == AccessController.AccessResult.GROUP_DENIED) {
            Map<GroupIdentity, AccessController.AccessResult> permissionsForGroups = this._profileAssignmentStorageEP.getPermissionsByGroup(profilesIds, convertedObject);
            grantingOrDenyingGroups = permissionsForGroups.entrySet().stream().filter(e -> e.getValue() == finalResult).map(e -> this._groupManager.getGroup((GroupIdentity)e.getKey())).collect(Collectors.toSet());
        }
        return new PermissionDetails(finalResult, profiles, grantingOrDenyingGroups, object);
    }

    protected AccessExplanation _buildExplanation(PermissionDetails details) {
        try {
            return new AccessExplanation(this.getId(), details.getResult(), this._getExplanationI18nText(details));
        }
        catch (RightsException e) {
            this.getLogger().warn("An error occured while building explanation for context {}", details.getObject(), (Object)e);
            return AccessController.getDefaultAccessExplanation(this.getId(), details.getResult());
        }
    }

    protected I18nizableText _getExplanationI18nText(PermissionDetails details) {
        return new I18nizableText("plugin.core-impl", this._getAccessExplanationI18nKey("PLUGINS_CORE_PROFILE_STORAGE_ACCESS_CONTROLLER_", details), this._getExplanationI18nParams(details));
    }

    protected String _getAccessExplanationI18nKey(String i18nKeyPrefix, PermissionDetails details) {
        StringBuilder builder = new StringBuilder(i18nKeyPrefix).append(details.getResult().name()).append("_EXPLANATION");
        if (details.getProfiles().size() > 1) {
            builder.append("_MULTIPLE_PROFILES");
        }
        if (details.getGroups().size() > 1) {
            builder.append("_MULTIPLE_GROUPS");
        }
        return builder.toString();
    }

    protected Map<String, I18nizableTextParameter> _getExplanationI18nParams(PermissionDetails details) {
        Set<Profile> profiles;
        HashMap<String, I18nizableTextParameter> explanationI18nParams = new HashMap<String, I18nizableTextParameter>();
        explanationI18nParams.put("objectLabel", this.getObjectLabelForExplanation(details.getObject()));
        Set<Group> groups = details.getGroups();
        if (!groups.isEmpty()) {
            explanationI18nParams.put("groups", AccessExplanation.groupsToI18nizableText(groups));
        }
        if (!(profiles = details.getProfiles()).isEmpty()) {
            explanationI18nParams.put("profiles", AccessExplanation.profilesToI18nizableText(profiles));
        }
        return explanationI18nParams;
    }

    protected I18nizableText getObjectLabelForExplanation(Object object) throws RightsException {
        return this.getObjectLabel(object);
    }

    @Override
    public AccessExplanation explainReadAccessPermissionForAnyConnectedUser(Object object) {
        Set<String> profilesIds = Collections.singleton("READER");
        return this._explainPermissionForAnyConnectedUser(profilesIds, object, this._convertContext(object));
    }

    @Override
    public AccessExplanation explainPermissionForAnyConnectedUser(String rightId, Object object) {
        Set<String> profilesIds = this._rightProfileDAO.getProfilesWithRight(rightId);
        if (profilesIds == null || profilesIds.isEmpty()) {
            return this._buildExplanation(new PermissionDetails(AccessController.AccessResult.UNKNOWN, Set.of(), Set.of(), object));
        }
        return this._explainPermissionForAnyConnectedUser(profilesIds, object, this._convertContext(object));
    }

    protected AccessExplanation _explainPermissionForAnyConnectedUser(Set<String> profilesIds, Object object, Object convertedObject) {
        PermissionDetails permissionDetails = this._getPermissionDetailsForAnyConnectedUser(profilesIds, object, convertedObject);
        return this._buildExplanation(permissionDetails);
    }

    protected PermissionDetails _getPermissionDetailsForAnyConnectedUser(Set<String> profilesIds, Object object, Object convertedObject) {
        AccessController.AccessResult result = this._profileAssignmentStorageEP.getPermissionForAnyConnectedUser(profilesIds, convertedObject);
        if (result == AccessController.AccessResult.UNKNOWN) {
            return new PermissionDetails(result, Set.of(), Set.of(), object);
        }
        Map<ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys, Set<String>> assignments = this._profileAssignmentStorageEP.getProfilesForAnonymousAndAnyConnectedUser(convertedObject);
        Set<Profile> matchingProfiles = assignments.get((Object)(result == AccessController.AccessResult.ANY_CONNECTED_ALLOWED ? ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANYCONNECTEDUSER_ALLOWED : ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANYCONNECTEDUSER_DENIED)).stream().filter(p -> profilesIds.contains(p)).map(this._rightProfileDAO::getProfile).collect(Collectors.toSet());
        return new PermissionDetails(result, matchingProfiles, Set.of(), object);
    }

    @Override
    public AccessExplanation explainReadAccessPermissionForAnonymous(Object object) {
        Set<String> profilesIds = Collections.singleton("READER");
        return this._explainPermissionForAnonymous(profilesIds, object, this._convertContext(object));
    }

    @Override
    public AccessExplanation explainPermissionForAnonymous(String rightId, Object object) {
        Set<String> profilesIds = this._rightProfileDAO.getProfilesWithRight(rightId);
        if (profilesIds == null || profilesIds.isEmpty()) {
            return this._buildExplanation(new PermissionDetails(AccessController.AccessResult.UNKNOWN, Set.of(), Set.of(), object));
        }
        return this._explainPermissionForAnonymous(profilesIds, object, this._convertContext(object));
    }

    protected AccessExplanation _explainPermissionForAnonymous(Set<String> profilesIds, Object object, Object convertedObject) {
        PermissionDetails permissionDetails = this._getPermissionDetailsForAnonymous(profilesIds, object, convertedObject);
        return this._buildExplanation(permissionDetails);
    }

    protected PermissionDetails _getPermissionDetailsForAnonymous(Set<String> profilesIds, Object object, Object convertedObject) {
        AccessController.AccessResult result = this._profileAssignmentStorageEP.getPermissionForAnonymous(profilesIds, convertedObject);
        if (result == AccessController.AccessResult.UNKNOWN) {
            return new PermissionDetails(result, Set.of(), Set.of(), object);
        }
        Map<ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys, Set<String>> assignments = this._profileAssignmentStorageEP.getProfilesForAnonymousAndAnyConnectedUser(convertedObject);
        Set matchedProfileIds = Optional.ofNullable(assignments.get((Object)(result == AccessController.AccessResult.ANONYMOUS_DENIED ? ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANONYMOUS_DENIED : ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANONYMOUS_ALLOWED))).orElse(Set.of());
        Set<Profile> matchingProfiles = matchedProfileIds.stream().filter(p -> profilesIds.contains(p)).map(this._rightProfileDAO::getProfile).collect(Collectors.toSet());
        return new PermissionDetails(result, matchingProfiles, Set.of(), object);
    }

    @Override
    public Map<AccessController.ExplanationObject, Map<AccessController.Permission, AccessExplanation>> explainAllPermissions(UserIdentity identity, Set<GroupIdentity> groups, Set<Object> workspacesContexts) {
        HashMap<AccessController.ExplanationObject, Map<AccessController.Permission, AccessExplanation>> result = new HashMap<AccessController.ExplanationObject, Map<AccessController.Permission, AccessExplanation>>();
        Set<? extends Object> rootContexts = this._convertWorkspaceToRootRightContexts(workspacesContexts);
        if (CollectionUtils.isNotEmpty(rootContexts)) {
            Map<Object, Map<ProfileAssignmentStorageExtensionPoint.AccessResultInfo, Set<String>>> allPermissions = this._profileAssignmentStorageEP.getAllPermissions(rootContexts, identity, groups);
            for (Object storedObject : allPermissions.keySet()) {
                try {
                    Object object = this._unconvertContext(storedObject);
                    HashMap<String, List> resultsByProfile = new HashMap<String, List>();
                    for (Map.Entry<ProfileAssignmentStorageExtensionPoint.AccessResultInfo, Set<String>> entry : allPermissions.get(storedObject).entrySet()) {
                        for (String profileId : entry.getValue()) {
                            List results = resultsByProfile.computeIfAbsent(profileId, str -> new ArrayList());
                            results.add(entry.getKey());
                        }
                    }
                    HashMap<AccessController.Permission, AccessExplanation> detailsByProfile = new HashMap<AccessController.Permission, AccessExplanation>();
                    for (Map.Entry profileResults : resultsByProfile.entrySet()) {
                        String profileId;
                        Profile profile;
                        AccessController.AccessResult accessResult = AccessController.AccessResult.merge(((List)profileResults.getValue()).stream().map(ProfileAssignmentStorageExtensionPoint.AccessResultInfo::accessResult).toList());
                        if (accessResult == AccessController.AccessResult.UNKNOWN || (profile = this._rightProfileDAO.getProfile(profileId = (String)profileResults.getKey())) == null) continue;
                        Set<Group> grantingGroups = Set.of();
                        if (accessResult == AccessController.AccessResult.GROUP_ALLOWED || accessResult == AccessController.AccessResult.GROUP_DENIED) {
                            grantingGroups = ((List)profileResults.getValue()).stream().filter(info -> info.accessResult() == accessResult).map(info -> this._groupManager.getGroup((GroupIdentity)info.target())).collect(Collectors.toSet());
                        }
                        AccessController.Permission permission = "READER".equals(profileId) ? new AccessController.Permission(AccessController.Permission.PermissionType.READ, null) : new AccessController.Permission(AccessController.Permission.PermissionType.PROFILE, profileId);
                        detailsByProfile.put(permission, this._buildExplanation(new PermissionDetails(accessResult, Set.of(profile), grantingGroups, object)));
                    }
                    result.put(this.getExplanationObject(object), detailsByProfile);
                }
                catch (RightsException e) {
                    this.getLogger().warn("An error occured while retrieving the explanation object for stored object '{}' of controller '{}'. The context will be ignored for this controller", new Object[]{storedObject.toString(), this.getId(), e});
                }
            }
        }
        return result;
    }

    @Override
    public Map<AccessController.Permission, AccessExplanation> explainAllPermissionsForAnonymous(Object object) {
        Object convertedContext = this._convertContext(object);
        Map<AccessController.Permission, PermissionDetails> results = this._getAllPermissionsDetailsForAnonymous(object, convertedContext);
        return results.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this._buildExplanation((PermissionDetails)e.getValue())));
    }

    protected Map<AccessController.Permission, PermissionDetails> _getAllPermissionsDetailsForAnonymous(Object object, Object convertedContext) {
        Set<String> allowedProfiles;
        HashMap<AccessController.Permission, PermissionDetails> results = new HashMap<AccessController.Permission, PermissionDetails>();
        Map<ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys, Set<String>> profilesForAnonymous = this._profileAssignmentStorageEP.getProfilesForAnonymousAndAnyConnectedUser(convertedContext);
        Set<String> deniedProfiles = profilesForAnonymous.get((Object)ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANONYMOUS_DENIED);
        if (deniedProfiles != null) {
            for (String profileId : deniedProfiles) {
                Profile profile = this._rightProfileDAO.getProfile(profileId);
                if (profile == null) continue;
                PermissionDetails details = new PermissionDetails(AccessController.AccessResult.ANONYMOUS_DENIED, Set.of(profile), Set.of(), object);
                AccessController.Permission permission = profileId.equals("READER") ? new AccessController.Permission(AccessController.Permission.PermissionType.READ, null) : new AccessController.Permission(AccessController.Permission.PermissionType.PROFILE, profileId);
                results.put(permission, details);
            }
        }
        if ((allowedProfiles = profilesForAnonymous.get((Object)ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANONYMOUS_ALLOWED)) != null) {
            for (String profileId : allowedProfiles) {
                Profile profile = this._rightProfileDAO.getProfile(profileId);
                if (profile == null) continue;
                PermissionDetails details = new PermissionDetails(AccessController.AccessResult.ANONYMOUS_ALLOWED, Set.of(profile), Set.of(), object);
                AccessController.Permission permission = profileId.equals("READER") ? new AccessController.Permission(AccessController.Permission.PermissionType.READ, null) : new AccessController.Permission(AccessController.Permission.PermissionType.PROFILE, profileId);
                results.put(permission, details);
            }
        }
        return results;
    }

    @Override
    public Map<AccessController.Permission, AccessExplanation> explainAllPermissionsForAnyConnected(Object object) {
        Object convertedContext = this._convertContext(object);
        Map<AccessController.Permission, PermissionDetails> results = this._getAllPermissionsDetailsForAnyConnected(object, convertedContext);
        return results.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this._buildExplanation((PermissionDetails)e.getValue())));
    }

    protected Map<AccessController.Permission, PermissionDetails> _getAllPermissionsDetailsForAnyConnected(Object object, Object convertedContext) {
        Set<String> deniedProfiles;
        HashMap<AccessController.Permission, PermissionDetails> results = new HashMap<AccessController.Permission, PermissionDetails>();
        Map<ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys, Set<String>> profilesForAnonymous = this._profileAssignmentStorageEP.getProfilesForAnonymousAndAnyConnectedUser(convertedContext);
        Set<String> allowedProfiles = profilesForAnonymous.get((Object)ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANYCONNECTEDUSER_ALLOWED);
        if (allowedProfiles != null) {
            for (String profileId : allowedProfiles) {
                Profile profile = this._rightProfileDAO.getProfile(profileId);
                if (profile == null) continue;
                PermissionDetails details = new PermissionDetails(AccessController.AccessResult.ANY_CONNECTED_ALLOWED, Set.of(profile), Set.of(), object);
                AccessController.Permission permission = profileId.equals("READER") ? new AccessController.Permission(AccessController.Permission.PermissionType.READ, null) : new AccessController.Permission(AccessController.Permission.PermissionType.PROFILE, profileId);
                results.put(permission, details);
            }
        }
        if ((deniedProfiles = profilesForAnonymous.get((Object)ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANYCONNECTEDUSER_DENIED)) != null) {
            for (String profileId : deniedProfiles) {
                Profile profile = this._rightProfileDAO.getProfile(profileId);
                if (profile == null) continue;
                PermissionDetails details = new PermissionDetails(AccessController.AccessResult.ANY_CONNECTED_DENIED, Set.of(profile), Set.of(), object);
                AccessController.Permission permission = profileId.equals("READER") ? new AccessController.Permission(AccessController.Permission.PermissionType.READ, null) : new AccessController.Permission(AccessController.Permission.PermissionType.PROFILE, profileId);
                results.put(permission, details);
            }
        }
        return results;
    }

    @Override
    public Map<UserIdentity, Map<AccessController.Permission, AccessExplanation>> explainAllPermissionsByUser(Object object) {
        Object convertedContext = this._convertContext(object);
        Map<UserIdentity, Map<AccessController.Permission, PermissionDetails>> detailsByUser = this._getAllPermissionsDetailsByUser(object, convertedContext);
        HashMap<UserIdentity, Map<AccessController.Permission, AccessExplanation>> results = new HashMap<UserIdentity, Map<AccessController.Permission, AccessExplanation>>(detailsByUser.size());
        for (UserIdentity identity : detailsByUser.keySet()) {
            results.put(identity, detailsByUser.get(identity).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this._buildExplanation((PermissionDetails)e.getValue()))));
        }
        return results;
    }

    protected Map<UserIdentity, Map<AccessController.Permission, PermissionDetails>> _getAllPermissionsDetailsByUser(Object object, Object convertedContext) {
        HashMap<UserIdentity, Map<AccessController.Permission, PermissionDetails>> results = new HashMap<UserIdentity, Map<AccessController.Permission, PermissionDetails>>();
        Map<UserIdentity, Map<ProfileAssignmentStorage.UserOrGroup, Set<String>>> profilesByUser = this._profileAssignmentStorageEP.getProfilesForUsers(convertedContext, null);
        for (UserIdentity user : profilesByUser.keySet()) {
            Set<String> deniedProfiles;
            Map<ProfileAssignmentStorage.UserOrGroup, Set<String>> userProfiles = profilesByUser.get(user);
            HashMap<AccessController.Permission, PermissionDetails> userResults = new HashMap<AccessController.Permission, PermissionDetails>();
            Set<String> allowedProfiles = userProfiles.get((Object)ProfileAssignmentStorage.UserOrGroup.ALLOWED);
            if (allowedProfiles != null) {
                for (String profileId : allowedProfiles) {
                    Profile profile = this._rightProfileDAO.getProfile(profileId);
                    if (profile == null) continue;
                    PermissionDetails details = new PermissionDetails(AccessController.AccessResult.USER_ALLOWED, Set.of(profile), Set.of(), object);
                    AccessController.Permission permission = profileId.equals("READER") ? new AccessController.Permission(AccessController.Permission.PermissionType.READ, null) : new AccessController.Permission(AccessController.Permission.PermissionType.PROFILE, profileId);
                    userResults.put(permission, details);
                }
            }
            if ((deniedProfiles = userProfiles.get((Object)ProfileAssignmentStorage.UserOrGroup.DENIED)) != null) {
                for (String profileId : deniedProfiles) {
                    Profile profile = this._rightProfileDAO.getProfile(profileId);
                    if (profile == null) continue;
                    PermissionDetails details = new PermissionDetails(AccessController.AccessResult.USER_DENIED, Set.of(profile), Set.of(), object);
                    AccessController.Permission permission = profileId.equals("READER") ? new AccessController.Permission(AccessController.Permission.PermissionType.READ, null) : new AccessController.Permission(AccessController.Permission.PermissionType.PROFILE, profileId);
                    userResults.put(permission, details);
                }
            }
            results.put(user, userResults);
        }
        return results;
    }

    @Override
    public Map<GroupIdentity, Map<AccessController.Permission, AccessExplanation>> explainAllPermissionsByGroup(Object object) {
        Object convertedContext = this._convertContext(object);
        Map<GroupIdentity, Map<AccessController.Permission, PermissionDetails>> detailsByGroup = this._getAllPermissionsDetailsByGroup(object, convertedContext);
        HashMap<GroupIdentity, Map<AccessController.Permission, AccessExplanation>> results = new HashMap<GroupIdentity, Map<AccessController.Permission, AccessExplanation>>(detailsByGroup.size());
        for (GroupIdentity identity : detailsByGroup.keySet()) {
            results.put(identity, detailsByGroup.get(identity).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this._buildExplanation((PermissionDetails)e.getValue()))));
        }
        return results;
    }

    protected Map<GroupIdentity, Map<AccessController.Permission, PermissionDetails>> _getAllPermissionsDetailsByGroup(Object object, Object convertedContext) {
        HashMap<GroupIdentity, Map<AccessController.Permission, PermissionDetails>> results = new HashMap<GroupIdentity, Map<AccessController.Permission, PermissionDetails>>();
        Map<GroupIdentity, Map<ProfileAssignmentStorage.UserOrGroup, Set<String>>> profilesByGroups = this._profileAssignmentStorageEP.getProfilesForGroups(convertedContext, null);
        for (GroupIdentity group : profilesByGroups.keySet()) {
            Set<String> deniedProfiles;
            Map<ProfileAssignmentStorage.UserOrGroup, Set<String>> groupProfiles = profilesByGroups.get(group);
            HashMap<AccessController.Permission, PermissionDetails> groupResults = new HashMap<AccessController.Permission, PermissionDetails>();
            Set<String> allowedProfiles = groupProfiles.get((Object)ProfileAssignmentStorage.UserOrGroup.ALLOWED);
            if (allowedProfiles != null) {
                for (String profileId : allowedProfiles) {
                    Profile profile = this._rightProfileDAO.getProfile(profileId);
                    if (profile == null) continue;
                    PermissionDetails details = new PermissionDetails(AccessController.AccessResult.GROUP_ALLOWED, Set.of(profile), Set.of(), object);
                    AccessController.Permission permission = profileId.equals("READER") ? new AccessController.Permission(AccessController.Permission.PermissionType.READ, null) : new AccessController.Permission(AccessController.Permission.PermissionType.PROFILE, profileId);
                    groupResults.put(permission, details);
                }
            }
            if ((deniedProfiles = groupProfiles.get((Object)ProfileAssignmentStorage.UserOrGroup.DENIED)) != null) {
                for (String profileId : deniedProfiles) {
                    Profile profile = this._rightProfileDAO.getProfile(profileId);
                    if (profile == null) continue;
                    PermissionDetails details = new PermissionDetails(AccessController.AccessResult.GROUP_DENIED, Set.of(profile), Set.of(), object);
                    AccessController.Permission permission = profileId.equals("READER") ? new AccessController.Permission(AccessController.Permission.PermissionType.READ, null) : new AccessController.Permission(AccessController.Permission.PermissionType.PROFILE, profileId);
                    groupResults.put(permission, details);
                }
            }
            results.put(group, groupResults);
        }
        return results;
    }

    @Override
    public Map<AccessController.ExplanationObject, AccessExplanation> explainAllProfileUsesForAnonymousOnWorkspaces(String profileId, Set<Object> workspacesContexts) {
        Set<? extends Object> rootContexts;
        HashMap<AccessController.ExplanationObject, AccessExplanation> result = new HashMap<AccessController.ExplanationObject, AccessExplanation>();
        Profile profile = this._rightProfileDAO.getProfile(profileId);
        if (profile != null && CollectionUtils.isNotEmpty(rootContexts = this._convertWorkspaceToRootRightContexts(workspacesContexts))) {
            Map<Object, List<ProfileAssignmentStorageExtensionPoint.AccessResultInfo>> storedAssignments = this._profileAssignmentStorageEP.getAllProfileAssignments(profileId, rootContexts);
            block0: for (Map.Entry<Object, List<ProfileAssignmentStorageExtensionPoint.AccessResultInfo>> entry : storedAssignments.entrySet()) {
                Object object = this._unconvertContext(entry.getKey());
                AccessController.ExplanationObject explanationObject = this.getExplanationObject(object);
                List<ProfileAssignmentStorageExtensionPoint.AccessResultInfo> infos = entry.getValue();
                for (ProfileAssignmentStorageExtensionPoint.AccessResultInfo info : infos) {
                    AccessExplanation explanation;
                    if (info.accessResult().equals((Object)AccessController.AccessResult.ANONYMOUS_DENIED)) {
                        explanation = this._buildExplanation(new PermissionDetails(AccessController.AccessResult.ANONYMOUS_DENIED, Set.of(profile), Set.of(), object));
                        result.put(explanationObject, explanation);
                        continue block0;
                    }
                    if (!info.accessResult().equals((Object)AccessController.AccessResult.ANONYMOUS_ALLOWED)) continue;
                    explanation = this._buildExplanation(new PermissionDetails(AccessController.AccessResult.ANONYMOUS_ALLOWED, Set.of(profile), Set.of(), object));
                    result.put(explanationObject, explanation);
                }
            }
        }
        return result;
    }

    @Override
    public Map<AccessController.ExplanationObject, AccessExplanation> explainAllProfileUsesForAnyConnectedOnWorkspaces(String profileId, Set<Object> workspacesContexts) {
        Set<? extends Object> rootContexts;
        HashMap<AccessController.ExplanationObject, AccessExplanation> result = new HashMap<AccessController.ExplanationObject, AccessExplanation>();
        Profile profile = this._rightProfileDAO.getProfile(profileId);
        if (profile != null && CollectionUtils.isNotEmpty(rootContexts = this._convertWorkspaceToRootRightContexts(workspacesContexts))) {
            Map<Object, List<ProfileAssignmentStorageExtensionPoint.AccessResultInfo>> storedAssignments = this._profileAssignmentStorageEP.getAllProfileAssignments(profileId, rootContexts);
            block0: for (Map.Entry<Object, List<ProfileAssignmentStorageExtensionPoint.AccessResultInfo>> entry : storedAssignments.entrySet()) {
                Object object = this._unconvertContext(entry.getKey());
                AccessController.ExplanationObject explanationObject = this.getExplanationObject(object);
                List<ProfileAssignmentStorageExtensionPoint.AccessResultInfo> infos = entry.getValue();
                for (ProfileAssignmentStorageExtensionPoint.AccessResultInfo info : infos) {
                    AccessExplanation explanation;
                    if (info.accessResult().equals((Object)AccessController.AccessResult.ANY_CONNECTED_DENIED)) {
                        explanation = this._buildExplanation(new PermissionDetails(AccessController.AccessResult.ANY_CONNECTED_DENIED, Set.of(profile), Set.of(), object));
                        result.put(explanationObject, explanation);
                        continue block0;
                    }
                    if (!info.accessResult().equals((Object)AccessController.AccessResult.ANY_CONNECTED_ALLOWED)) continue;
                    explanation = this._buildExplanation(new PermissionDetails(AccessController.AccessResult.ANY_CONNECTED_ALLOWED, Set.of(profile), Set.of(), object));
                    result.put(explanationObject, explanation);
                }
            }
        }
        return result;
    }

    @Override
    public Map<AccessController.ExplanationObject, Map<GroupIdentity, AccessExplanation>> explainAllProfileUsesOnWorkspacesByGroups(String profileId, Set<Object> workspacesContexts) {
        Set<? extends Object> rootContexts;
        HashMap<AccessController.ExplanationObject, Map<GroupIdentity, AccessExplanation>> result = new HashMap<AccessController.ExplanationObject, Map<GroupIdentity, AccessExplanation>>();
        Profile profile = this._rightProfileDAO.getProfile(profileId);
        if (profile != null && CollectionUtils.isNotEmpty(rootContexts = this._convertWorkspaceToRootRightContexts(workspacesContexts))) {
            Map<Object, List<ProfileAssignmentStorageExtensionPoint.AccessResultInfo>> storedAssignments = this._profileAssignmentStorageEP.getAllProfileAssignments(profileId, rootContexts);
            for (Map.Entry<Object, List<ProfileAssignmentStorageExtensionPoint.AccessResultInfo>> entry : storedAssignments.entrySet()) {
                Object object = this._unconvertContext(entry.getKey());
                HashMap<GroupIdentity, AccessExplanation> contextResult = new HashMap<GroupIdentity, AccessExplanation>();
                List<ProfileAssignmentStorageExtensionPoint.AccessResultInfo> infos = entry.getValue();
                for (ProfileAssignmentStorageExtensionPoint.AccessResultInfo info : infos) {
                    AccessExplanation explanation;
                    Group group;
                    if (info.accessResult().equals((Object)AccessController.AccessResult.GROUP_DENIED)) {
                        group = this._groupManager.getGroup((GroupIdentity)info.target());
                        if (group == null) continue;
                        explanation = this._buildExplanation(new PermissionDetails(AccessController.AccessResult.GROUP_DENIED, Set.of(profile), Set.of(group), object));
                        contextResult.put((GroupIdentity)info.target(), explanation);
                        continue;
                    }
                    if (!info.accessResult().equals((Object)AccessController.AccessResult.GROUP_ALLOWED) || (group = this._groupManager.getGroup((GroupIdentity)info.target())) == null) continue;
                    explanation = this._buildExplanation(new PermissionDetails(AccessController.AccessResult.GROUP_ALLOWED, Set.of(profile), Set.of(group), object));
                    contextResult.putIfAbsent((GroupIdentity)info.target(), explanation);
                }
                if (contextResult.isEmpty()) continue;
                AccessController.ExplanationObject explanationObject = this.getExplanationObject(object);
                result.put(explanationObject, contextResult);
            }
        }
        return result;
    }

    @Override
    public Map<AccessController.ExplanationObject, Map<UserIdentity, AccessExplanation>> explainAllProfileUsesOnWorkspacesByUser(String profileId, Set<Object> workspacesContexts) {
        Set<? extends Object> rootContexts;
        HashMap<AccessController.ExplanationObject, Map<UserIdentity, AccessExplanation>> result = new HashMap<AccessController.ExplanationObject, Map<UserIdentity, AccessExplanation>>();
        Profile profile = this._rightProfileDAO.getProfile(profileId);
        if (profile != null && CollectionUtils.isNotEmpty(rootContexts = this._convertWorkspaceToRootRightContexts(workspacesContexts))) {
            Map<Object, List<ProfileAssignmentStorageExtensionPoint.AccessResultInfo>> storedAssignments = this._profileAssignmentStorageEP.getAllProfileAssignments(profileId, rootContexts);
            for (Map.Entry<Object, List<ProfileAssignmentStorageExtensionPoint.AccessResultInfo>> entry : storedAssignments.entrySet()) {
                Object object = this._unconvertContext(entry.getKey());
                HashMap<UserIdentity, AccessExplanation> contextResult = new HashMap<UserIdentity, AccessExplanation>();
                List<ProfileAssignmentStorageExtensionPoint.AccessResultInfo> infos = entry.getValue();
                for (ProfileAssignmentStorageExtensionPoint.AccessResultInfo info : infos) {
                    AccessExplanation explanation;
                    if (info.accessResult().equals((Object)AccessController.AccessResult.USER_DENIED)) {
                        explanation = this._buildExplanation(new PermissionDetails(AccessController.AccessResult.USER_DENIED, Set.of(profile), Set.of(), object));
                        contextResult.put((UserIdentity)info.target(), explanation);
                        continue;
                    }
                    if (!info.accessResult().equals((Object)AccessController.AccessResult.USER_ALLOWED)) continue;
                    explanation = this._buildExplanation(new PermissionDetails(AccessController.AccessResult.USER_ALLOWED, Set.of(profile), Set.of(), object));
                    contextResult.putIfAbsent((UserIdentity)info.target(), explanation);
                }
                if (contextResult.isEmpty()) continue;
                AccessController.ExplanationObject explanationObject = this.getExplanationObject(object);
                result.put(explanationObject, contextResult);
            }
        }
        return result;
    }

    protected static enum CacheKind {
        ANONYMOUS,
        ANY_CONNECTED_USER,
        USERS,
        USER,
        GROUPS;

    }

    static class Cache1Key
    extends AbstractCacheKey {
        Cache1Key(UserIdentity userIdentity, String profileId, Object object) {
            super(userIdentity, profileId, object);
        }

        static Cache1Key of(UserIdentity userIdentity, String profileId, Object object) {
            return new Cache1Key(userIdentity, profileId, object);
        }
    }

    static class Cache2Key
    extends AbstractCacheKey {
        Cache2Key(Set<String> profileIds, Object object, CacheKind cacheKind) {
            super(new Object[]{profileIds, object, cacheKind});
        }

        static Cache2Key of(Set<String> profileIds, Object object, CacheKind cacheKind) {
            return new Cache2Key(profileIds, object, cacheKind);
        }
    }

    protected static class PermissionDetails {
        private AccessController.AccessResult _result;
        private Set<Profile> _profiles;
        private Object _object;
        private Set<Group> _groups;

        PermissionDetails(AccessController.AccessResult result, Set<Profile> profiles, Set<Group> groups, Object object) {
            this._result = result;
            this._profiles = profiles;
            this._groups = groups;
            this._object = object;
        }

        public AccessController.AccessResult getResult() {
            return this._result;
        }

        public Set<Profile> getProfiles() {
            return this._profiles;
        }

        public Object getObject() {
            return this._object;
        }

        public Set<Group> getGroups() {
            return this._groups;
        }
    }
}

