/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.right;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.right.AccessController;
import org.ametys.core.right.AccessExplanation;
import org.ametys.core.user.UserIdentity;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.plugin.component.PluginAware;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;

public abstract class AbstractRightBasedAccessController
extends AbstractLogEnabled
implements AccessController,
Component,
PluginAware,
Contextualizable {
    protected String _pluginName;
    protected String _id;
    protected Context _context;

    @Override
    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
        this._id = id;
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public AccessExplanation explainReadAccessPermissionForAnonymous(Object object) {
        return this._getAccessExplanation(this.getReadAccessPermissionForAnonymous(object), object, null, null, null);
    }

    @Override
    public AccessExplanation explainPermissionForAnonymous(String rightId, Object object) {
        return this._getAccessExplanation(this.getPermissionForAnonymous(rightId, object), object, null, null, null);
    }

    @Override
    public AccessExplanation explainReadAccessPermissionForAnyConnectedUser(Object object) {
        return this._getAccessExplanation(this.getReadAccessPermissionForAnyConnectedUser(object), object, null, null, null);
    }

    @Override
    public AccessExplanation explainPermissionForAnyConnectedUser(String rightId, Object object) {
        return this._getAccessExplanation(this.getPermissionForAnyConnectedUser(rightId, object), object, null, null, null);
    }

    @Override
    public AccessExplanation explainReadAccessPermission(UserIdentity user, Set<GroupIdentity> groups, Object object) {
        return this._getAccessExplanation(this.getReadAccessPermission(user, groups, object), object, user, groups, null);
    }

    @Override
    public AccessExplanation explainPermission(UserIdentity user, Set<GroupIdentity> groups, String rightId, Object object) {
        return this._getAccessExplanation(this.getPermission(user, groups, rightId, object), object, user, groups, rightId);
    }

    protected abstract AccessExplanation _getAccessExplanation(AccessController.AccessResult var1, Object var2, UserIdentity var3, Set<GroupIdentity> var4, String var5);

    @Override
    public Map<AccessController.ExplanationObject, Map<AccessController.Permission, AccessExplanation>> explainAllPermissions(UserIdentity identity, Set<GroupIdentity> groups, Set<Object> workspacesContexts) {
        HashMap<AccessController.ExplanationObject, Map<AccessController.Permission, AccessExplanation>> result = new HashMap<AccessController.ExplanationObject, Map<AccessController.Permission, AccessExplanation>>();
        for (Object object : this.getHandledObjects(identity, groups, workspacesContexts)) {
            if (!this.supports(object)) continue;
            HashMap<AccessController.Permission, AccessExplanation> contextPermissionExplanation = new HashMap<AccessController.Permission, AccessExplanation>();
            for (String rightId : this.getHandledRights()) {
                AccessExplanation explanation = this.explainPermission(identity, groups, rightId, object);
                if (explanation.accessResult() == AccessController.AccessResult.UNKNOWN) continue;
                contextPermissionExplanation.put(new AccessController.Permission(AccessController.Permission.PermissionType.RIGHT, rightId), explanation);
            }
            AccessExplanation explanation = this.explainReadAccessPermission(identity, groups, object);
            if (explanation.accessResult() != AccessController.AccessResult.UNKNOWN) {
                contextPermissionExplanation.put(new AccessController.Permission(AccessController.Permission.PermissionType.READ, null), explanation);
            }
            if (contextPermissionExplanation.isEmpty()) continue;
            result.put(this.getExplanationObject(object), contextPermissionExplanation);
        }
        return result;
    }

    @Override
    public Map<AccessController.Permission, AccessExplanation> explainAllPermissionsForAnonymous(Object object) {
        HashMap<AccessController.Permission, AccessExplanation> results = new HashMap<AccessController.Permission, AccessExplanation>();
        AccessExplanation readAccess = this.explainReadAccessPermissionForAnonymous(object);
        if (readAccess.accessResult() != AccessController.AccessResult.UNKNOWN) {
            results.put(new AccessController.Permission(AccessController.Permission.PermissionType.READ, null), readAccess);
        }
        for (String right : this.getHandledRights()) {
            AccessExplanation access = this.explainPermissionForAnonymous(right, object);
            if (access.accessResult() == AccessController.AccessResult.UNKNOWN) continue;
            results.put(new AccessController.Permission(AccessController.Permission.PermissionType.RIGHT, right), access);
        }
        return results;
    }

    @Override
    public Map<AccessController.Permission, AccessExplanation> explainAllPermissionsForAnyConnected(Object object) {
        HashMap<AccessController.Permission, AccessExplanation> results = new HashMap<AccessController.Permission, AccessExplanation>();
        AccessExplanation readAccess = this.explainReadAccessPermissionForAnyConnectedUser(object);
        if (readAccess.accessResult() != AccessController.AccessResult.UNKNOWN) {
            results.put(new AccessController.Permission(AccessController.Permission.PermissionType.READ, null), readAccess);
        }
        for (String right : this.getHandledRights()) {
            AccessExplanation access = this.explainPermissionForAnyConnectedUser(right, object);
            if (access.accessResult() == AccessController.AccessResult.UNKNOWN) continue;
            results.put(new AccessController.Permission(AccessController.Permission.PermissionType.RIGHT, right), access);
        }
        return results;
    }

    @Override
    public Map<UserIdentity, Map<AccessController.Permission, AccessExplanation>> explainAllPermissionsByUser(Object object) {
        HashMap<UserIdentity, Map<AccessController.Permission, AccessExplanation>> results = new HashMap<UserIdentity, Map<AccessController.Permission, AccessExplanation>>();
        Map<UserIdentity, AccessController.AccessResult> readAccessPermissionByUser = this.getReadAccessPermissionByUser(object);
        for (UserIdentity identity : readAccessPermissionByUser.keySet()) {
            AccessController.AccessResult accessResult = readAccessPermissionByUser.get(identity);
            if (accessResult == AccessController.AccessResult.UNKNOWN) continue;
            AccessExplanation explanation = this._getAccessExplanation(accessResult, object, identity, null, null);
            Map userResults = results.computeIfAbsent(identity, i -> new HashMap());
            userResults.put(new AccessController.Permission(AccessController.Permission.PermissionType.READ, null), explanation);
        }
        for (String right : this.getHandledRights()) {
            Map<UserIdentity, AccessController.AccessResult> permissionByUser = this.getPermissionByUser(right, object);
            for (UserIdentity identity : permissionByUser.keySet()) {
                AccessController.AccessResult accessResult = permissionByUser.get(identity);
                if (accessResult == AccessController.AccessResult.UNKNOWN) continue;
                AccessExplanation explanation = this._getAccessExplanation(accessResult, object, identity, null, right);
                Map userResults = results.computeIfAbsent(identity, i -> new HashMap());
                userResults.put(new AccessController.Permission(AccessController.Permission.PermissionType.RIGHT, right), explanation);
            }
        }
        return results;
    }

    @Override
    public Map<GroupIdentity, Map<AccessController.Permission, AccessExplanation>> explainAllPermissionsByGroup(Object object) {
        HashMap<GroupIdentity, Map<AccessController.Permission, AccessExplanation>> results = new HashMap<GroupIdentity, Map<AccessController.Permission, AccessExplanation>>();
        Map<GroupIdentity, AccessController.AccessResult> readAccessPermissionByGroup = this.getReadAccessPermissionByGroup(object);
        for (GroupIdentity identity : readAccessPermissionByGroup.keySet()) {
            AccessController.AccessResult accessResult = readAccessPermissionByGroup.get(identity);
            if (accessResult == AccessController.AccessResult.UNKNOWN) continue;
            AccessExplanation explanation = this._getAccessExplanation(accessResult, object, null, Set.of(identity), null);
            Map groupResults = results.computeIfAbsent(identity, i -> new HashMap());
            groupResults.put(new AccessController.Permission(AccessController.Permission.PermissionType.READ, null), explanation);
        }
        for (String right : this.getHandledRights()) {
            Map<GroupIdentity, AccessController.AccessResult> permissionByGroup = this.getPermissionByGroup(right, object);
            for (GroupIdentity identity : permissionByGroup.keySet()) {
                AccessController.AccessResult accessResult = permissionByGroup.get(identity);
                if (accessResult == AccessController.AccessResult.UNKNOWN) continue;
                AccessExplanation explanation = this._getAccessExplanation(accessResult, object, null, Set.of(identity), null);
                Map groupResults = results.computeIfAbsent(identity, i -> new HashMap());
                groupResults.put(new AccessController.Permission(AccessController.Permission.PermissionType.RIGHT, right), explanation);
            }
        }
        return results;
    }

    protected abstract Collection<String> getHandledRights();

    protected abstract Iterable<? extends Object> getHandledObjects(UserIdentity var1, Set<GroupIdentity> var2, Set<Object> var3);
}

