/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.right;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.core.datasource.AbstractMyBatisDAO;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.right.ModifiableProfileAssignmentStorage;
import org.ametys.core.right.ProfileAssignmentStorage;
import org.ametys.core.user.UserIdentity;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.SqlSession;

public class JdbcProfileAssignmentStorage
extends AbstractMyBatisDAO
implements ModifiableProfileAssignmentStorage,
Initializable {
    private static final String __JDBC_PROFILE_ASSIGNMENT_STORAGE_CACHE = JdbcProfileAssignmentStorage.class.getName() + "$storage";
    private static final String __JDBC_PROFILE_ASSIGNMENT_INHERITANCE_CACHE = JdbcProfileAssignmentStorage.class.getName() + "$inheritance";
    protected String _supportedContext;
    private AbstractCacheManager _cacheManager;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._cacheManager = (AbstractCacheManager)this._manager.lookup(AbstractCacheManager.ROLE);
    }

    public synchronized void initialize() throws Exception {
        if (!this._cacheManager.hasCache(__JDBC_PROFILE_ASSIGNMENT_STORAGE_CACHE)) {
            this._cacheManager.createMemoryCache(__JDBC_PROFILE_ASSIGNMENT_STORAGE_CACHE, new I18nizableText("plugin.admin", "PLUGINS_ADMIN_RIGHTS_JDBC_PROFILE_ASSIGNMENT_STORAGE_CACHE_LABEL"), new I18nizableText("plugin.admin", "PLUGINS_ADMIN_RIGHTS_JDBC_PROFILE_ASSIGNMENT_STORAGE_CACHE_DESCRIPTION"), true, null);
        }
        if (!this._cacheManager.hasCache(__JDBC_PROFILE_ASSIGNMENT_INHERITANCE_CACHE)) {
            this._cacheManager.createMemoryCache(__JDBC_PROFILE_ASSIGNMENT_INHERITANCE_CACHE, new I18nizableText("plugin.admin", "PLUGINS_ADMIN_RIGHTS_JDBC_PROFILE_ASSIGNMENT_INHERITANCE_CACHE_LABEL"), new I18nizableText("plugin.admin", "PLUGINS_ADMIN_RIGHTS_JDBC_PROFILE_ASSIGNMENT_INHERITANCE_CACHE_DESCRIPTION"), true, null);
        }
    }

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this._supportedContext = configuration.getChild("context").getValue();
    }

    protected synchronized Database _getFullData(Object context) {
        String rootContext = "/" + StringUtils.split((String)((String)context), (char)'/')[0];
        return this._getStorageCache().get(rootContext, key -> {
            try (SqlSession session = this.getSession();){
                Database db;
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("context", rootContext);
                List profiles = session.selectList("ProfilesAssignment.getAllProfiles", parameters);
                Database database = db = new Database(profiles);
                return database;
            }
        });
    }

    protected synchronized void _clearCache() {
        this._getStorageCache().invalidateAll();
    }

    protected synchronized void _clearCache(Object context) {
        String rootContext = "/" + StringUtils.split((String)((String)context), (char)'/')[0];
        if (this._getStorageCache().hasKey(rootContext)) {
            this._getStorageCache().invalidate(rootContext);
        }
    }

    protected synchronized Cache<String, Boolean> _getInheritances() {
        Cache<String, Boolean> inheritanceCache = this._getInheritanceCache();
        if (!inheritanceCache.isInitialized()) {
            try (SqlSession session = this.getSession();){
                List inheritances = session.selectList("ProfilesAssignment.getInheritances", new HashMap());
                inheritances.stream().forEach(result -> inheritanceCache.put((String)result.get("context"), (Boolean)result.get("disallow")));
            }
        }
        return inheritanceCache;
    }

    protected synchronized void _clearInheritanceCache() {
        this._getInheritanceCache().invalidateAll();
    }

    protected Object getObjectWithPrefix(Object context) {
        return context;
    }

    protected String getPrefix() {
        return null;
    }

    private Set<String> _getRootContextPrefixes(Set<? extends Object> rootContexts) {
        String prefix = this.getPrefix();
        return rootContexts.stream().filter(String.class::isInstance).map(context -> (prefix != null ? prefix : "") + (String)context).collect(Collectors.toSet());
    }

    @Override
    public Set<String> hasUserAnyAllowedProfile(Set<? extends Object> rootContexts, UserIdentity user, Set<String> profileIds) {
        Set<String> stringPrefixContexts = this._getRootContextPrefixes(rootContexts);
        HashSet<String> anyAllowedProfiles = new HashSet<String>();
        for (String stringPrefixContext : stringPrefixContexts) {
            Set profiles = this._getFullData(stringPrefixContext).getAllowedUserData().entrySet().stream().filter(entry -> JdbcProfileAssignmentStorage._equalsOrStartsWith((String)entry.getKey(), stringPrefixContext)).map(Map.Entry::getValue).map(m -> (Set)m.get(user)).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet());
            anyAllowedProfiles.addAll(profiles);
        }
        for (String profileId : profileIds) {
            if (!anyAllowedProfiles.contains(profileId)) continue;
            return anyAllowedProfiles;
        }
        return Set.of();
    }

    @Override
    public Set<String> hasGroupAnyAllowedProfile(Set<? extends Object> rootContexts, Set<GroupIdentity> groups, Set<String> profileIds) {
        Set<String> stringPrefixContexts = this._getRootContextPrefixes(rootContexts);
        HashSet<String> anyAllowedProfiles = new HashSet<String>();
        for (String stringPrefixContext : stringPrefixContexts) {
            this._getFullData(stringPrefixContext).getAllowedGroupData().entrySet().stream().filter(entry -> JdbcProfileAssignmentStorage._equalsOrStartsWith((String)entry.getKey(), stringPrefixContext)).map(Map.Entry::getValue).forEach(profilesByGroup -> {
                for (GroupIdentity group : groups) {
                    Set profiles = (Set)profilesByGroup.get(group);
                    if (profiles == null) continue;
                    anyAllowedProfiles.addAll(profiles);
                }
            });
        }
        for (String profileId : profileIds) {
            if (!anyAllowedProfiles.contains(profileId)) continue;
            return anyAllowedProfiles;
        }
        return Set.of();
    }

    @Override
    public Set<String> hasAnyConnectedAnyAllowedProfile(Set<? extends Object> rootContexts, Set<String> profileIds) {
        Set<String> stringPrefixContexts = this._getRootContextPrefixes(rootContexts);
        HashSet<String> anyAllowedProfiles = new HashSet<String>();
        for (String stringPrefixContext : stringPrefixContexts) {
            Set profiles = this._getFullData(stringPrefixContext).getAllowedAnyConnected().entrySet().stream().filter(entry -> JdbcProfileAssignmentStorage._equalsOrStartsWith((String)entry.getKey(), stringPrefixContext)).map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toSet());
            anyAllowedProfiles.addAll(profiles);
        }
        for (String profileId : profileIds) {
            if (!anyAllowedProfiles.contains(profileId)) continue;
            return anyAllowedProfiles;
        }
        return Set.of();
    }

    @Override
    public Set<String> hasAnonymousAnyAllowedProfile(Set<? extends Object> rootContexts, Set<String> profileIds) {
        Set<String> stringPrefixContexts = this._getRootContextPrefixes(rootContexts);
        HashSet<String> anyAllowedProfiles = new HashSet<String>();
        for (String stringPrefixContext : stringPrefixContexts) {
            Set profiles = this._getFullData(stringPrefixContext).getAllowedAnonymous().entrySet().stream().filter(entry -> JdbcProfileAssignmentStorage._equalsOrStartsWith((String)entry.getKey(), stringPrefixContext)).map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toSet());
            anyAllowedProfiles.addAll(profiles);
        }
        for (String profileId : profileIds) {
            if (!anyAllowedProfiles.contains(profileId)) continue;
            return anyAllowedProfiles;
        }
        return Set.of();
    }

    private static boolean _equalsOrStartsWith(String value, String prefix) {
        return value.equals(prefix) || value.startsWith(prefix + "/");
    }

    @Override
    public Map<Object, Map<ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys, Set<String>>> getAllProfilesForAnonymousAndAnyConnectedUser(Set<? extends Object> rootContexts) {
        Set<String> stringPrefixContexts = this._getRootContextPrefixes(rootContexts);
        HashMap<Object, Map<ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys, Set<String>>> result = new HashMap<Object, Map<ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys, Set<String>>>();
        for (String stringPrefixContext : stringPrefixContexts) {
            Database databaseValue = this._getFullData(stringPrefixContext);
            databaseValue.getAllowedAnonymous().entrySet().stream().filter(entry -> JdbcProfileAssignmentStorage._equalsOrStartsWith((String)entry.getKey(), stringPrefixContext)).forEach(entry -> {
                Set allowedProfiles = (Set)entry.getValue();
                if (!allowedProfiles.isEmpty()) {
                    Map contextMap = result.computeIfAbsent(entry.getKey(), k -> new HashMap());
                    contextMap.put(ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANONYMOUS_ALLOWED, allowedProfiles);
                }
            });
            databaseValue.getDeniedAnonymous().entrySet().stream().filter(entry -> JdbcProfileAssignmentStorage._equalsOrStartsWith((String)entry.getKey(), stringPrefixContext)).forEach(entry -> {
                Set deniedProfiles = (Set)entry.getValue();
                if (!deniedProfiles.isEmpty()) {
                    Map contextMap = result.computeIfAbsent(entry.getKey(), k -> new HashMap());
                    contextMap.put(ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANONYMOUS_DENIED, deniedProfiles);
                }
            });
            databaseValue.getAllowedAnyConnected().entrySet().stream().filter(entry -> JdbcProfileAssignmentStorage._equalsOrStartsWith((String)entry.getKey(), stringPrefixContext)).forEach(entry -> {
                Set allowedProfiles = (Set)entry.getValue();
                if (!allowedProfiles.isEmpty()) {
                    Map contextMap = result.computeIfAbsent(entry.getKey(), k -> new HashMap());
                    contextMap.put(ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANYCONNECTEDUSER_ALLOWED, allowedProfiles);
                }
            });
            databaseValue.getDeniedAnyConnected().entrySet().stream().filter(entry -> JdbcProfileAssignmentStorage._equalsOrStartsWith((String)entry.getKey(), stringPrefixContext)).forEach(entry -> {
                Set deniedProfiles = (Set)entry.getValue();
                if (!deniedProfiles.isEmpty()) {
                    Map contextMap = result.computeIfAbsent(entry.getKey(), k -> new HashMap());
                    contextMap.put(ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANYCONNECTEDUSER_DENIED, deniedProfiles);
                }
            });
        }
        return result;
    }

    @Override
    public Map<Object, Map<GroupIdentity, Map<ProfileAssignmentStorage.UserOrGroup, Set<String>>>> getAllProfilesForGroups(Set<? extends Object> rootContexts, Set<GroupIdentity> groups) {
        Set<String> stringPrefixContexts = this._getRootContextPrefixes(rootContexts);
        HashMap<Object, Map<GroupIdentity, Map<ProfileAssignmentStorage.UserOrGroup, Set<String>>>> result = new HashMap<Object, Map<GroupIdentity, Map<ProfileAssignmentStorage.UserOrGroup, Set<String>>>>();
        for (String stringPrefixContext : stringPrefixContexts) {
            Database databaseValue = this._getFullData(stringPrefixContext);
            databaseValue.getAllowedGroupData().entrySet().stream().filter(entry -> JdbcProfileAssignmentStorage._equalsOrStartsWith((String)entry.getKey(), stringPrefixContext)).filter(entry -> CollectionUtils.containsAny(((Map)entry.getValue()).keySet(), (Collection)groups)).forEach(entry -> {
                Map assignments = (Map)entry.getValue();
                for (GroupIdentity group : assignments.keySet()) {
                    Set allowed;
                    if (!groups.contains(group) || (allowed = (Set)assignments.get(group)) == null || allowed.isEmpty()) continue;
                    Map contextMap = result.computeIfAbsent(entry.getKey(), k -> new HashMap());
                    Map groupAssignements = contextMap.computeIfAbsent(group, k -> new HashMap());
                    groupAssignements.put(ProfileAssignmentStorage.UserOrGroup.ALLOWED, allowed);
                }
            });
            databaseValue.getDeniedGroupData().entrySet().stream().filter(entry -> JdbcProfileAssignmentStorage._equalsOrStartsWith((String)entry.getKey(), stringPrefixContext)).filter(entry -> CollectionUtils.containsAny(((Map)entry.getValue()).keySet(), (Collection)groups)).forEach(entry -> {
                Map assignments = (Map)entry.getValue();
                for (GroupIdentity group : assignments.keySet()) {
                    Set denied;
                    if (!groups.contains(group) || (denied = (Set)assignments.get(group)) == null || denied.isEmpty()) continue;
                    Map contextMap = result.computeIfAbsent(entry.getKey(), k -> new HashMap());
                    Map groupAssignements = contextMap.computeIfAbsent(group, k -> new HashMap());
                    groupAssignements.put(ProfileAssignmentStorage.UserOrGroup.DENIED, denied);
                }
            });
        }
        return result;
    }

    @Override
    public Map<Object, Map<ProfileAssignmentStorage.UserOrGroup, Set<String>>> getAllProfilesForUser(Set<? extends Object> rootContexts, UserIdentity user) {
        Set<String> stringPrefixContexts = this._getRootContextPrefixes(rootContexts);
        HashMap<Object, Map<ProfileAssignmentStorage.UserOrGroup, Set<String>>> result = new HashMap<Object, Map<ProfileAssignmentStorage.UserOrGroup, Set<String>>>();
        for (String stringPrefixContext : stringPrefixContexts) {
            Database databaseValue = this._getFullData(stringPrefixContext);
            databaseValue.getAllowedUserData().entrySet().stream().filter(entry -> JdbcProfileAssignmentStorage._equalsOrStartsWith((String)entry.getKey(), stringPrefixContext)).filter(entry -> ((Map)entry.getValue()).keySet().contains(user)).forEach(entry -> {
                Set allowed = (Set)((Map)entry.getValue()).get(user);
                if (allowed != null && !allowed.isEmpty()) {
                    Map contextMap = result.computeIfAbsent(entry.getKey(), k -> new HashMap());
                    contextMap.put(ProfileAssignmentStorage.UserOrGroup.ALLOWED, allowed);
                }
            });
            databaseValue.getDeniedUserData().entrySet().stream().filter(entry -> JdbcProfileAssignmentStorage._equalsOrStartsWith((String)entry.getKey(), stringPrefixContext)).filter(entry -> ((Map)entry.getValue()).keySet().contains(user)).forEach(entry -> {
                Set denied = (Set)((Map)entry.getValue()).get(user);
                if (denied != null && !denied.isEmpty()) {
                    Map contextMap = result.computeIfAbsent(entry.getKey(), k -> new HashMap());
                    contextMap.put(ProfileAssignmentStorage.UserOrGroup.DENIED, denied);
                }
            });
        }
        return result;
    }

    @Override
    public Map<Object, Set<ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys>> getAllAssignmentsForAnonymousAndAnyConnectedUser(Set<? extends Object> rootContexts, String profileId) {
        Set<String> stringPrefixContexts = this._getRootContextPrefixes(rootContexts);
        HashMap<Object, Set<ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys>> result = new HashMap<Object, Set<ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys>>();
        for (String stringPrefixContext : stringPrefixContexts) {
            Database fullData = this._getFullData(stringPrefixContext);
            fullData.getDeniedAnyConnected().entrySet().stream().filter(entry -> JdbcProfileAssignmentStorage._equalsOrStartsWith((String)entry.getKey(), stringPrefixContext)).filter(entry -> ((Set)entry.getValue()).contains(profileId)).map(Map.Entry::getKey).forEach(context -> result.computeIfAbsent(context, s -> new HashSet(4)).add(ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANYCONNECTEDUSER_DENIED));
            fullData.getAllowedAnyConnected().entrySet().stream().filter(entry -> JdbcProfileAssignmentStorage._equalsOrStartsWith((String)entry.getKey(), stringPrefixContext)).filter(entry -> ((Set)entry.getValue()).contains(profileId)).map(Map.Entry::getKey).forEach(context -> result.computeIfAbsent(context, s -> new HashSet(4)).add(ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANYCONNECTEDUSER_ALLOWED));
            fullData.getDeniedAnonymous().entrySet().stream().filter(entry -> JdbcProfileAssignmentStorage._equalsOrStartsWith((String)entry.getKey(), stringPrefixContext)).filter(entry -> ((Set)entry.getValue()).contains(profileId)).map(Map.Entry::getKey).forEach(context -> result.computeIfAbsent(context, s -> new HashSet(4)).add(ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANONYMOUS_DENIED));
            fullData.getAllowedAnonymous().entrySet().stream().filter(entry -> JdbcProfileAssignmentStorage._equalsOrStartsWith((String)entry.getKey(), stringPrefixContext)).filter(entry -> ((Set)entry.getValue()).contains(profileId)).map(Map.Entry::getKey).forEach(context -> result.computeIfAbsent(context, s -> new HashSet(4)).add(ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANONYMOUS_ALLOWED));
        }
        return result;
    }

    @Override
    public Map<Object, Map<GroupIdentity, Set<ProfileAssignmentStorage.UserOrGroup>>> getAllAssignmentsForGroups(Set<? extends Object> rootContexts, String profileId) {
        Set<String> stringPrefixContexts = this._getRootContextPrefixes(rootContexts);
        HashMap<Object, Map<GroupIdentity, Set<ProfileAssignmentStorage.UserOrGroup>>> result = new HashMap<Object, Map<GroupIdentity, Set<ProfileAssignmentStorage.UserOrGroup>>>();
        for (String stringPrefixContext : stringPrefixContexts) {
            Database fullData = this._getFullData(stringPrefixContext);
            fullData.getDeniedGroupData().entrySet().stream().filter(entry -> JdbcProfileAssignmentStorage._equalsOrStartsWith((String)entry.getKey(), stringPrefixContext)).forEach(e -> {
                String context = (String)e.getKey();
                Map groupResult = result.computeIfAbsent(context, s -> new HashMap());
                ((Map)e.getValue()).entrySet().stream().filter(gEntry -> ((Set)gEntry.getValue()).contains(profileId)).forEach(gEntry -> groupResult.computeIfAbsent((GroupIdentity)gEntry.getKey(), g -> new HashSet(4)).add(ProfileAssignmentStorage.UserOrGroup.DENIED));
            });
            fullData.getAllowedGroupData().entrySet().stream().filter(entry -> JdbcProfileAssignmentStorage._equalsOrStartsWith((String)entry.getKey(), stringPrefixContext)).forEach(e -> {
                String context = (String)e.getKey();
                Map groupResult = result.computeIfAbsent(context, s -> new HashMap());
                ((Map)e.getValue()).entrySet().stream().filter(gEntry -> ((Set)gEntry.getValue()).contains(profileId)).forEach(gEntry -> groupResult.computeIfAbsent((GroupIdentity)gEntry.getKey(), g -> new HashSet(4)).add(ProfileAssignmentStorage.UserOrGroup.ALLOWED));
            });
        }
        return result;
    }

    @Override
    public Map<Object, Map<UserIdentity, Set<ProfileAssignmentStorage.UserOrGroup>>> getAllAssignmentsForUsers(Set<? extends Object> rootContexts, String profileId) {
        Set<String> stringPrefixContexts = this._getRootContextPrefixes(rootContexts);
        HashMap<Object, Map<UserIdentity, Set<ProfileAssignmentStorage.UserOrGroup>>> result = new HashMap<Object, Map<UserIdentity, Set<ProfileAssignmentStorage.UserOrGroup>>>();
        for (String stringPrefixContext : stringPrefixContexts) {
            Database fullData = this._getFullData(stringPrefixContext);
            fullData.getDeniedUserData().entrySet().stream().filter(entry -> JdbcProfileAssignmentStorage._equalsOrStartsWith((String)entry.getKey(), stringPrefixContext)).forEach(e -> {
                String context = (String)e.getKey();
                Map userResult = result.computeIfAbsent(context, s -> new HashMap());
                ((Map)e.getValue()).entrySet().stream().filter(uEntry -> ((Set)uEntry.getValue()).contains(profileId)).forEach(uEntry -> userResult.computeIfAbsent((UserIdentity)uEntry.getKey(), g -> new HashSet(4)).add(ProfileAssignmentStorage.UserOrGroup.DENIED));
            });
            fullData.getAllowedUserData().entrySet().stream().filter(entry -> JdbcProfileAssignmentStorage._equalsOrStartsWith((String)entry.getKey(), stringPrefixContext)).forEach(e -> {
                String context = (String)e.getKey();
                Map userResult = result.computeIfAbsent(context, s -> new HashMap());
                ((Map)e.getValue()).entrySet().stream().filter(uEntry -> ((Set)uEntry.getValue()).contains(profileId)).forEach(uEntry -> userResult.computeIfAbsent((UserIdentity)uEntry.getKey(), g -> new HashSet(4)).add(ProfileAssignmentStorage.UserOrGroup.ALLOWED));
            });
        }
        return result;
    }

    @Override
    public Map<UserIdentity, Map<ProfileAssignmentStorage.UserOrGroup, Set<String>>> getProfilesForUsers(Object object, UserIdentity user) {
        Set<UserIdentity> userKeys;
        HashMap<UserIdentity, Map<ProfileAssignmentStorage.UserOrGroup, Set<String>>> result = new HashMap<UserIdentity, Map<ProfileAssignmentStorage.UserOrGroup, Set<String>>>();
        Map allowedProfilesByUser = Optional.ofNullable(this._getFullData(object).getAllowedUserData().get(object)).orElse(Map.of());
        Map deniedProfilesByUser = Optional.ofNullable(this._getFullData(object).getDeniedUserData().get(object)).orElse(Map.of());
        if (user != null) {
            userKeys = Set.of(user);
        } else {
            userKeys = new HashSet<UserIdentity>();
            userKeys.addAll(allowedProfilesByUser.keySet());
            userKeys.addAll(deniedProfilesByUser.keySet());
        }
        for (UserIdentity userKey : userKeys) {
            result.put(userKey, Map.of(ProfileAssignmentStorage.UserOrGroup.ALLOWED, allowedProfilesByUser.containsKey(userKey) ? (Set)allowedProfilesByUser.get(userKey) : Set.of(), ProfileAssignmentStorage.UserOrGroup.DENIED, deniedProfilesByUser.containsKey(userKey) ? (Set)deniedProfilesByUser.get(userKey) : Set.of()));
        }
        return result;
    }

    @Override
    public void addAllowedProfilesForAnyConnectedUser(Object object, Set<String> profileIds) {
        this._clearCache(object);
        try (SqlSession session = this.getSession();){
            Object prefixedObject = this.getObjectWithPrefix(object);
            for (String profileId : profileIds) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("context", prefixedObject);
                parameters.put("profileIds", Arrays.asList(profileId));
                List allowedProfiles = session.selectList("ProfilesAssignment.getAnyConnectedAllowedProfiles", parameters);
                if (allowedProfiles.isEmpty()) {
                    parameters.put("profileId", profileId);
                    session.insert("ProfilesAssignment.addAllowedAnyConnected", parameters);
                    continue;
                }
                this.getLogger().debug("Profile {} is already allowed for anyconnected on context {}", (Object)profileId, prefixedObject);
            }
            session.commit();
        }
    }

    @Override
    public void removeAllowedProfilesForAnyConnectedUser(Object object, Set<String> profileIds) {
        this._clearCache(object);
        try (SqlSession session = this.getSession(true);){
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("context", this.getObjectWithPrefix(object));
            parameters.put("profileIds", profileIds);
            session.delete("ProfilesAssignment.deleteAllowedAnyConnected", parameters);
        }
    }

    @Override
    public Map<ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys, Set<String>> getProfilesForAnonymousAndAnyConnectedUser(Object object) {
        return Map.of(ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANONYMOUS_ALLOWED, Optional.ofNullable(this._getFullData(object).getAllowedAnonymous().get(object)).orElse(Set.of()), ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANONYMOUS_DENIED, Optional.ofNullable(this._getFullData(object).getDeniedAnonymous().get(object)).orElse(Set.of()), ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANYCONNECTEDUSER_ALLOWED, Optional.ofNullable(this._getFullData(object).getAllowedAnyConnected().get(object)).orElse(Set.of()), ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANYCONNECTEDUSER_DENIED, Optional.ofNullable(this._getFullData(object).getDeniedAnyConnected().get(object)).orElse(Set.of()));
    }

    @Override
    public void addDeniedProfilesForAnyConnectedUser(Object object, Set<String> profileIds) {
        this._clearCache(object);
        try (SqlSession session = this.getSession();){
            Object prefixedObject = this.getObjectWithPrefix(object);
            for (String profileId : profileIds) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("context", prefixedObject);
                parameters.put("profileIds", Arrays.asList(profileId));
                List deniedProfiles = session.selectList("ProfilesAssignment.getAnyConnectedDeniedProfiles", parameters);
                if (deniedProfiles.isEmpty()) {
                    parameters.put("profileId", profileId);
                    session.insert("ProfilesAssignment.addDeniedAnyConnected", parameters);
                    continue;
                }
                this.getLogger().debug("Profile {} is already denied for anyconnected on context {}", (Object)profileId, prefixedObject);
            }
            session.commit();
        }
    }

    @Override
    public void removeDeniedProfilesForAnyConnectedUser(Object object, Set<String> profileIds) {
        this._clearCache(object);
        try (SqlSession session = this.getSession(true);){
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("context", this.getObjectWithPrefix(object));
            parameters.put("profileIds", profileIds);
            session.delete("ProfilesAssignment.deleteDeniedAnyConnected", parameters);
        }
    }

    @Override
    public void addAllowedProfilesForAnonymous(Object object, Set<String> profileIds) {
        this._clearCache(object);
        try (SqlSession session = this.getSession();){
            Object prefixedObject = this.getObjectWithPrefix(object);
            for (String profileId : profileIds) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("context", prefixedObject);
                parameters.put("profileIds", Arrays.asList(profileId));
                List allowedProfiles = session.selectList("ProfilesAssignment.getAnonymousAllowedProfiles", parameters);
                if (allowedProfiles.isEmpty()) {
                    parameters.put("profileId", profileId);
                    session.insert("ProfilesAssignment.addAllowedAnonymous", parameters);
                    continue;
                }
                this.getLogger().debug("Profile {} is already allowed for anonymous on context {}", (Object)profileId, prefixedObject);
            }
            session.commit();
        }
    }

    @Override
    public void removeAllowedProfilesForAnonymous(Object object, Set<String> profileIds) {
        this._clearCache(object);
        try (SqlSession session = this.getSession(true);){
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("context", this.getObjectWithPrefix(object));
            parameters.put("profileIds", profileIds);
            session.delete("ProfilesAssignment.deleteAllowedAnonymous", parameters);
        }
    }

    @Override
    public void addDeniedProfilesForAnonymous(Object object, Set<String> profileIds) {
        this._clearCache(object);
        try (SqlSession session = this.getSession();){
            Object prefixedObject = this.getObjectWithPrefix(object);
            for (String profileId : profileIds) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("context", prefixedObject);
                parameters.put("profileIds", Arrays.asList(profileId));
                List deniedProfiles = session.selectList("ProfilesAssignment.getAnonymousDeniedProfiles", parameters);
                if (deniedProfiles.isEmpty()) {
                    parameters.put("profileId", profileId);
                    session.insert("ProfilesAssignment.addDeniedAnonymous", parameters);
                    continue;
                }
                this.getLogger().debug("Profile {} is already denied for anonymous on context {}", (Object)profileId, prefixedObject);
            }
            session.commit();
        }
    }

    @Override
    public void removeDeniedProfilesForAnonymous(Object object, Set<String> profileIds) {
        this._clearCache(object);
        try (SqlSession session = this.getSession(true);){
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("context", this.getObjectWithPrefix(object));
            parameters.put("profileIds", profileIds);
            session.delete("ProfilesAssignment.deleteDeniedAnonymous", parameters);
        }
    }

    @Override
    public void addAllowedUsers(Set<UserIdentity> users, Object object, String profileId) {
        this._clearCache(object);
        try (SqlSession session = this.getSession();){
            Object prefixedObject = this.getObjectWithPrefix(object);
            for (UserIdentity userIdentity : users) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("login", userIdentity.getLogin());
                parameters.put("population", userIdentity.getPopulationId());
                parameters.put("context", prefixedObject);
                parameters.put("profileIds", Arrays.asList(profileId));
                List allowedProfiles = session.selectList("ProfilesAssignment.getUserAllowedProfiles", parameters);
                if (allowedProfiles.isEmpty()) {
                    parameters.put("profileId", profileId);
                    session.insert("ProfilesAssignment.addAllowedUser", parameters);
                    continue;
                }
                this.getLogger().debug("Login {} has already profile {} on context {}", new Object[]{userIdentity, profileId, prefixedObject});
            }
            session.commit();
        }
    }

    @Override
    public void removeAllowedUsers(Set<UserIdentity> users, Object object, String profileId) {
        this._clearCache(object);
        try (SqlSession session = this.getSession();){
            for (UserIdentity userIdentity : users) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("login", userIdentity.getLogin());
                parameters.put("population", userIdentity.getPopulationId());
                parameters.put("profileIds", Arrays.asList(profileId));
                if (object != null) {
                    parameters.put("context", this.getObjectWithPrefix(object));
                }
                session.delete("ProfilesAssignment.deleteAllowedUser", parameters);
            }
            session.commit();
        }
    }

    @Override
    public void removeAllowedUsers(Set<UserIdentity> users, Object object) {
        this._clearCache(object);
        try (SqlSession session = this.getSession();){
            for (UserIdentity userIdentity : users) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("login", userIdentity.getLogin());
                parameters.put("population", userIdentity.getPopulationId());
                if (object != null) {
                    parameters.put("context", this.getObjectWithPrefix(object));
                }
                session.delete("ProfilesAssignment.deleteAllowedUser", parameters);
            }
            session.commit();
        }
    }

    @Override
    public Map<GroupIdentity, Map<ProfileAssignmentStorage.UserOrGroup, Set<String>>> getProfilesForGroups(Object object, Set<GroupIdentity> groups) {
        Set<GroupIdentity> groupKeys;
        HashMap<GroupIdentity, Map<ProfileAssignmentStorage.UserOrGroup, Set<String>>> result = new HashMap<GroupIdentity, Map<ProfileAssignmentStorage.UserOrGroup, Set<String>>>();
        Map allowedProfilesByGroup = Optional.ofNullable(this._getFullData(object).getAllowedGroupData().get(object)).orElse(Map.of());
        Map deniedProfilesByGroup = Optional.ofNullable(this._getFullData(object).getDeniedGroupData().get(object)).orElse(Map.of());
        if (groups != null) {
            groupKeys = groups;
        } else {
            groupKeys = new HashSet<GroupIdentity>();
            groupKeys.addAll(allowedProfilesByGroup.keySet());
            groupKeys.addAll(deniedProfilesByGroup.keySet());
        }
        for (GroupIdentity group : groupKeys) {
            result.put(group, Map.of(ProfileAssignmentStorage.UserOrGroup.ALLOWED, allowedProfilesByGroup.containsKey(group) ? (Set)allowedProfilesByGroup.get(group) : Set.of(), ProfileAssignmentStorage.UserOrGroup.DENIED, deniedProfilesByGroup.containsKey(group) ? (Set)deniedProfilesByGroup.get(group) : Set.of()));
        }
        return result;
    }

    @Override
    public void addAllowedGroups(Set<GroupIdentity> groups, Object object, String profileId) {
        this._clearCache(object);
        try (SqlSession session = this.getSession();){
            Object prefixedObject = this.getObjectWithPrefix(object);
            for (GroupIdentity group : groups) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("groupId", group.getId());
                parameters.put("groupDirectory", group.getDirectoryId());
                parameters.put("context", prefixedObject);
                parameters.put("profileIds", Arrays.asList(profileId));
                List allowedProfiles = session.selectList("ProfilesAssignment.getGroupAllowedProfiles", parameters);
                if (allowedProfiles.isEmpty()) {
                    parameters.put("profileId", profileId);
                    session.insert("ProfilesAssignment.addAllowedGroup", parameters);
                    continue;
                }
                this.getLogger().debug("Group {} is already allowed for profile {} on context {}", new Object[]{group, profileId, prefixedObject});
            }
            session.commit();
        }
    }

    @Override
    public void removeAllowedGroups(Set<GroupIdentity> groups, Object object, String profileId) {
        this._clearCache(object);
        try (SqlSession session = this.getSession();){
            for (GroupIdentity group : groups) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("groupId", group.getId());
                parameters.put("groupDirectory", group.getDirectoryId());
                parameters.put("profileIds", Arrays.asList(profileId));
                if (object != null) {
                    parameters.put("context", this.getObjectWithPrefix(object));
                }
                session.delete("ProfilesAssignment.deleteAllowedGroup", parameters);
            }
            session.commit();
        }
    }

    @Override
    public void removeAllowedGroups(Set<GroupIdentity> groups, Object object) {
        this._clearCache(object);
        try (SqlSession session = this.getSession();){
            for (GroupIdentity group : groups) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("groupId", group.getId());
                parameters.put("groupDirectory", group.getDirectoryId());
                if (object != null) {
                    parameters.put("context", this.getObjectWithPrefix(object));
                }
                session.delete("ProfilesAssignment.deleteAllowedGroup", parameters);
            }
            session.commit();
        }
    }

    @Override
    public void addDeniedUsers(Set<UserIdentity> users, Object object, String profileId) {
        this._clearCache(object);
        try (SqlSession session = this.getSession();){
            Object prefixedObject = this.getObjectWithPrefix(object);
            for (UserIdentity userIdentity : users) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("login", userIdentity.getLogin());
                parameters.put("population", userIdentity.getPopulationId());
                parameters.put("context", prefixedObject);
                parameters.put("profileIds", Arrays.asList(profileId));
                List deniedProfiles = session.selectList("ProfilesAssignment.getUserDeniedProfiles", parameters);
                if (deniedProfiles.isEmpty()) {
                    parameters.put("profileId", profileId);
                    session.insert("ProfilesAssignment.addDeniedUser", parameters);
                    continue;
                }
                this.getLogger().debug("Login {} is already denied for profile {} on context {}", new Object[]{userIdentity, profileId, prefixedObject});
            }
            session.commit();
        }
    }

    @Override
    public void removeDeniedUsers(Set<UserIdentity> users, Object object, String profileId) {
        this._clearCache(object);
        try (SqlSession session = this.getSession();){
            for (UserIdentity userIdentity : users) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("login", userIdentity.getLogin());
                parameters.put("population", userIdentity.getPopulationId());
                parameters.put("profileIds", Arrays.asList(profileId));
                if (object != null) {
                    parameters.put("context", this.getObjectWithPrefix(object));
                }
                session.delete("ProfilesAssignment.deleteDeniedUser", parameters);
            }
            session.commit();
        }
    }

    @Override
    public void removeDeniedUsers(Set<UserIdentity> users, Object object) {
        this._clearCache(object);
        try (SqlSession session = this.getSession();){
            for (UserIdentity userIdentity : users) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("login", userIdentity.getLogin());
                parameters.put("population", userIdentity.getPopulationId());
                if (object != null) {
                    parameters.put("context", this.getObjectWithPrefix(object));
                }
                session.delete("ProfilesAssignment.deleteDeniedUser", parameters);
            }
            session.commit();
        }
    }

    @Override
    public void addDeniedGroups(Set<GroupIdentity> groups, Object object, String profileId) {
        this._clearCache(object);
        try (SqlSession session = this.getSession();){
            Object prefixedObject = this.getObjectWithPrefix(object);
            for (GroupIdentity group : groups) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("groupId", group.getId());
                parameters.put("groupDirectory", group.getDirectoryId());
                parameters.put("context", prefixedObject);
                parameters.put("profileIds", Arrays.asList(profileId));
                List deniedProfiles = session.selectList("ProfilesAssignment.getGroupDeniedProfiles", parameters);
                if (deniedProfiles.isEmpty()) {
                    parameters.put("profileId", profileId);
                    session.insert("ProfilesAssignment.addDeniedGroup", parameters);
                    continue;
                }
                this.getLogger().debug("Group {} is already denied for profile {} on context {}", new Object[]{group, profileId, prefixedObject});
            }
            session.commit();
        }
    }

    @Override
    public void removeDeniedGroups(Set<GroupIdentity> groups, Object object, String profileId) {
        this._clearCache(object);
        try (SqlSession session = this.getSession();){
            for (GroupIdentity group : groups) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("groupId", group.getId());
                parameters.put("groupDirectory", group.getDirectoryId());
                parameters.put("profileIds", Arrays.asList(profileId));
                if (object != null) {
                    parameters.put("context", this.getObjectWithPrefix(object));
                }
                session.delete("ProfilesAssignment.deleteDeniedGroup", parameters);
            }
            session.commit();
        }
    }

    @Override
    public void removeDeniedGroups(Set<GroupIdentity> groups, Object object) {
        this._clearCache(object);
        try (SqlSession session = this.getSession();){
            for (GroupIdentity group : groups) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("groupId", group.getId());
                parameters.put("groupDirectory", group.getDirectoryId());
                if (object != null) {
                    parameters.put("context", this.getObjectWithPrefix(object));
                }
                session.delete("ProfilesAssignment.deleteDeniedGroup", parameters);
            }
            session.commit();
        }
    }

    @Override
    public void disallowInheritance(Object object, boolean disallow) {
        try (SqlSession session = this.getSession();){
            Object ctxWithPrefix = this.getObjectWithPrefix(object);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("context", ctxWithPrefix);
            parameters.put("disallow", disallow);
            if (this._getInheritances().hasKey((String)ctxWithPrefix)) {
                session.insert("ProfilesAssignment.updateInheritance", parameters);
            } else {
                session.insert("ProfilesAssignment.insertInheritance", parameters);
            }
            session.commit();
            this._clearInheritanceCache();
        }
    }

    @Override
    public boolean isInheritanceDisallowed(Object object) {
        Object ctxWithPrefix = this.getObjectWithPrefix(object);
        Boolean isDisallowed = this._getInheritances().get((String)ctxWithPrefix);
        return isDisallowed != null && Boolean.TRUE.equals(isDisallowed);
    }

    @Override
    public void removeProfile(String profileId) {
        this._clearCache();
        try (SqlSession session = this.getSession();){
            HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
            parameters.put("profileIds", Arrays.asList(profileId));
            session.delete("ProfilesAssignment.deleteAllowedUser", parameters);
            session.delete("ProfilesAssignment.deleteDeniedUser", parameters);
            session.delete("ProfilesAssignment.deleteAllowedGroup", parameters);
            session.delete("ProfilesAssignment.deleteDeniedGroup", parameters);
            session.delete("ProfilesAssignment.deleteAllowedAnonymous", parameters);
            session.delete("ProfilesAssignment.deleteDeniedAnonymous", parameters);
            session.delete("ProfilesAssignment.deleteAllowedAnyConnected", parameters);
            session.delete("ProfilesAssignment.deleteDeniedAnyConnected", parameters);
            session.commit();
        }
    }

    @Override
    public void removeUser(UserIdentity user) {
        this._clearCache();
        try (SqlSession session = this.getSession();){
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("login", user.getLogin());
            parameters.put("population", user.getPopulationId());
            session.delete("ProfilesAssignment.deleteAllowedUser", parameters);
            session.delete("ProfilesAssignment.deleteDeniedUser", parameters);
            session.commit();
        }
    }

    @Override
    public void removeGroup(GroupIdentity group) {
        this._clearCache();
        try (SqlSession session = this.getSession();){
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("groupId", group.getId());
            parameters.put("groupDirectory", group.getDirectoryId());
            session.delete("ProfilesAssignment.deleteAllowedGroup", parameters);
            session.delete("ProfilesAssignment.deleteDeniedGroup", parameters);
            session.commit();
        }
    }

    @Override
    public boolean supports(Object object) {
        if (object instanceof String) {
            String context = (String)object;
            return context.equals(this._supportedContext) || context.startsWith(this._supportedContext + "/");
        }
        return false;
    }

    @Override
    public boolean isRootContextSupported(Object rootContext) {
        return this.supports(rootContext);
    }

    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    private Cache<String, Database> _getStorageCache() {
        return this._cacheManager.get(__JDBC_PROFILE_ASSIGNMENT_STORAGE_CACHE);
    }

    private Cache<String, Boolean> _getInheritanceCache() {
        return this._cacheManager.get(__JDBC_PROFILE_ASSIGNMENT_INHERITANCE_CACHE);
    }

    private static class Database {
        private Map<String, Set<String>> _allowedAnonymousData = new HashMap<String, Set<String>>();
        private Map<String, Set<String>> _deniedAnonymousData = new HashMap<String, Set<String>>();
        private Map<String, Set<String>> _allowedAnyConnectedData = new HashMap<String, Set<String>>();
        private Map<String, Set<String>> _deniedAnyConnectedData = new HashMap<String, Set<String>>();
        private Map<String, Map<UserIdentity, Set<String>>> _allowedUserData = new HashMap<String, Map<UserIdentity, Set<String>>>();
        private Map<String, Map<UserIdentity, Set<String>>> _deniedUserData = new HashMap<String, Map<UserIdentity, Set<String>>>();
        private Map<String, Map<GroupIdentity, Set<String>>> _allowedGroupData = new HashMap<String, Map<GroupIdentity, Set<String>>>();
        private Map<String, Map<GroupIdentity, Set<String>>> _deniedGroupData = new HashMap<String, Map<GroupIdentity, Set<String>>>();

        Database(List<Map<String, String>> data) {
            for (Map<String, String> map : data) {
                String targetGroup;
                String targetId;
                String type = map.get("type").trim();
                String profileId = map.get("profileId");
                String context = map.get("context");
                if ("ALLOWED_ANONYMOUS".equals(type) || "DENIED_ANONYMOUS".equals(type) || "ALLOWED_ANYCONNECTED".equals(type) || "DENIED_ANYCONNECTED".equals(type)) {
                    this._buildAnonymousOrAnyConnectedData(type, profileId, context);
                    continue;
                }
                if ("ALLOWED_USER".equals(type) || "DENIED_USER".equals(type)) {
                    targetId = map.get("targetId");
                    targetGroup = map.get("targetGroup");
                    UserIdentity user = new UserIdentity(targetId, targetGroup);
                    this._buildUserData(type, profileId, context, user);
                    continue;
                }
                targetId = map.get("targetId");
                targetGroup = map.get("targetGroup");
                GroupIdentity group = new GroupIdentity(targetId, targetGroup);
                this._buildGroupData(type, profileId, context, group);
            }
        }

        private void _buildGroupData(String type, String profileId, String context, GroupIdentity group) {
            Map<GroupIdentity, Set<String>> contextMap;
            Map<String, Map<GroupIdentity, Set<String>>> wData = "ALLOWED_GROUP".equals(type) ? this._allowedGroupData : this._deniedGroupData;
            if (!wData.containsKey(context)) {
                wData.put(context, new HashMap());
            }
            if (!(contextMap = wData.get(context)).containsKey(group)) {
                contextMap.put(group, new HashSet());
            }
            Set<String> profileSet = contextMap.get(group);
            profileSet.add(profileId);
        }

        private void _buildUserData(String type, String profileId, String context, UserIdentity user) {
            Map<UserIdentity, Set<String>> contextMap;
            Map<String, Map<UserIdentity, Set<String>>> wData = "ALLOWED_USER".equals(type) ? this._allowedUserData : this._deniedUserData;
            if (!wData.containsKey(context)) {
                wData.put(context, new HashMap());
            }
            if (!(contextMap = wData.get(context)).containsKey(user)) {
                contextMap.put(user, new HashSet());
            }
            Set<String> profileSet = contextMap.get(user);
            profileSet.add(profileId);
        }

        private void _buildAnonymousOrAnyConnectedData(String type, String profileId, String context) {
            Map<String, Set<String>> wData = "ALLOWED_ANONYMOUS".equals(type) ? this._allowedAnonymousData : ("DENIED_ANONYMOUS".equals(type) ? this._deniedAnonymousData : ("ALLOWED_ANYCONNECTED".equals(type) ? this._allowedAnyConnectedData : this._deniedAnyConnectedData));
            if (!wData.containsKey(context)) {
                wData.put(context, new HashSet());
            }
            Set<String> profileSet = wData.get(context);
            profileSet.add(profileId);
        }

        public Map<String, Set<String>> getAllowedAnonymous() {
            return this._allowedAnonymousData;
        }

        public Map<String, Set<String>> getDeniedAnonymous() {
            return this._deniedAnonymousData;
        }

        public Map<String, Set<String>> getAllowedAnyConnected() {
            return this._allowedAnyConnectedData;
        }

        public Map<String, Set<String>> getDeniedAnyConnected() {
            return this._deniedAnyConnectedData;
        }

        public Map<String, Map<UserIdentity, Set<String>>> getAllowedUserData() {
            return this._allowedUserData;
        }

        public Map<String, Map<UserIdentity, Set<String>>> getDeniedUserData() {
            return this._deniedUserData;
        }

        public Map<String, Map<GroupIdentity, Set<String>>> getAllowedGroupData() {
            return this._allowedGroupData;
        }

        public Map<String, Map<GroupIdentity, Set<String>>> getDeniedGroupData() {
            return this._deniedGroupData;
        }
    }
}

