/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.right;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.ametys.core.right.RightsException;
import org.ametys.plugins.core.impl.right.AbstractHierarchicalAccessController;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;

public class StringHierarchicalAccessController
extends AbstractHierarchicalAccessController<String>
implements Configurable {
    protected static final char SEPARATOR = '/';
    protected Set<String> _prefixes;
    protected Pattern _workspaceMatcher;
    protected boolean _reverseWorkspaceMather;

    public void configure(Configuration configuration) throws ConfigurationException {
        this._prefixes = new HashSet<String>();
        for (Configuration prefixConfiguration : configuration.getChildren("prefix")) {
            String prefix = prefixConfiguration.getValue();
            this._prefixes.add(prefix);
        }
        String workspace = configuration.getChild("workspace").getValue("");
        if (StringUtils.isNotBlank((CharSequence)workspace)) {
            if (workspace.startsWith("!")) {
                this._reverseWorkspaceMather = true;
                workspace = workspace.substring(1);
            }
            this._workspaceMatcher = Pattern.compile(workspace);
        }
    }

    protected Set<String> getSupportedPrefixes() {
        return this._prefixes;
    }

    protected Set<String> getRootPrefixes() {
        return this._prefixes;
    }

    @Override
    protected Set<? extends Object> _convertWorkspaceToRootRightContexts(Set<Object> workspacesContexts) {
        if (this._workspaceMatcher != null) {
            for (Object workspaceContext : workspacesContexts) {
                boolean match;
                if (!(workspaceContext instanceof String) || ((match = this._workspaceMatcher.matcher((String)workspaceContext).matches()) || !this._reverseWorkspaceMather) && (!match || this._reverseWorkspaceMather)) continue;
                return this.getRootPrefixes();
            }
            return null;
        }
        return this.getRootPrefixes();
    }

    @Override
    public boolean supports(Object object) {
        if (!(object instanceof String)) {
            return false;
        }
        String context = (String)object;
        Set<String> prefixes = this.getSupportedPrefixes();
        if (prefixes != null) {
            for (String prefix : prefixes) {
                if ((!StringUtils.isNotBlank((CharSequence)prefix) || !Strings.CS.equals(context, prefix)) && !context.startsWith(prefix + "/")) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected Set<String> _getParents(String object) {
        if (object == null) {
            return null;
        }
        int index = object.lastIndexOf(47);
        if (index <= 1) {
            return null;
        }
        return Collections.singleton(object.substring(0, index));
    }

    @Override
    protected I18nizableText getObjectLabelForExplanation(Object object) throws RightsException {
        return new I18nizableText("plugin.core-impl", "PLUGINS_CORE_STRING_HIERARCHICAL_ACCESS_CONTROLLER_CONTEXT_LABEL", Map.of("object", this.getObjectLabel(object)));
    }

    @Override
    public I18nizableText getObjectLabel(Object object) {
        return new I18nizableText((String)object);
    }

    @Override
    public I18nizableText getObjectCategory(Object object) {
        return null;
    }
}

