/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.right;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.right.RightContextConvertor;
import org.ametys.runtime.plugin.ExtensionPoint;
import org.ametys.runtime.plugin.component.ExtensionPointAware;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;

public class WorkspaceRightContextConvertor
implements RightContextConvertor,
Contextualizable,
ExtensionPointAware {
    protected Context _context;
    protected ExtensionPoint<RightContextConvertor> _rightContextConvertorEP;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    @Override
    public void setExtensionPoint(ExtensionPoint point) {
        this._rightContextConvertorEP = point;
    }

    @Override
    public Set<Object> convert(Object object) {
        String context;
        HashSet<Object> objects = new HashSet<Object>();
        if (object instanceof String && (context = (String)object).indexOf("${WorkspaceName}") != -1) {
            Request request = ContextHelper.getRequest((Context)this._context);
            String currentWorkspace = (String)request.getAttribute("workspaceName");
            if (StringUtils.isBlank((CharSequence)currentWorkspace)) {
                currentWorkspace = "admin";
            }
            String resolvedContext = Strings.CS.replace(context, "${WorkspaceName}", currentWorkspace);
            objects.addAll(this._rightContextConvertorEP.getExtensionsIds().stream().map(this._rightContextConvertorEP::getExtension).flatMap(convertor -> convertor.convert(resolvedContext).stream()).collect(Collectors.toSet()));
            objects.add(resolvedContext);
        }
        return objects;
    }
}

