/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.schedule;

import java.time.LocalTime;
import org.ametys.core.schedule.Runnable;
import org.ametys.plugins.core.impl.schedule.ConfigBasedRunnable;
import org.ametys.runtime.config.Config;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractConfigBasedHourRunnable
extends ConfigBasedRunnable {
    @Override
    protected boolean isEnabled(Configuration configuration) {
        Configuration hourCfg = configuration.getChild("param-hour", false);
        return super.isEnabled(configuration) && hourCfg != null && StringUtils.isNotBlank((CharSequence)((CharSequence)Config.getInstance().getValue(hourCfg.getValue("").trim())));
    }

    @Override
    protected void configureFireProcess(Configuration configuration, DefaultConfiguration modifiedConfiguration) throws ConfigurationException {
        Configuration hourCfg = configuration.getChild("param-hour", false);
        if (hourCfg != null) {
            String hourCfgValue = (String)Config.getInstance().getValue(hourCfg.getValue("").trim());
            if (StringUtils.isNotBlank((CharSequence)hourCfgValue)) {
                LocalTime lt = LocalTime.parse(hourCfgValue);
                DefaultConfiguration fireProcessConfig = new DefaultConfiguration("fire-process");
                fireProcessConfig.setValue(Runnable.FireProcess.CRON.name());
                modifiedConfiguration.addChild((Configuration)fireProcessConfig);
                String cronExpression = this.getCronExpression(configuration, lt);
                DefaultConfiguration cronConfig = new DefaultConfiguration("cron");
                cronConfig.setValue(cronExpression);
                modifiedConfiguration.addChild((Configuration)cronConfig);
            }
        } else {
            throw new ConfigurationException("Mandatory configuration 'param-hour' is missing for config based hour runnable " + this.getClass().getName());
        }
    }

    protected abstract String getCronExpression(Configuration var1, LocalTime var2) throws ConfigurationException;
}

