/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.schedule;

import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ametys.core.model.type.ModelItemTypeExtensionPoint;
import org.ametys.core.schedule.Schedulable;
import org.ametys.core.schedule.progression.ProgressionTracker;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.language.UserLanguagesManager;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.AbstractElementDefinitionParser;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Enumerator;
import org.ametys.runtime.model.disableconditions.DisableConditions;
import org.ametys.runtime.model.disableconditions.VoidStaticRelativeDisableConditions;
import org.ametys.runtime.parameter.Validator;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.plugin.component.PluginAware;
import org.ametys.runtime.plugin.component.ThreadSafeComponentManager;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.quartz.JobExecutionContext;

public abstract class AbstractStaticSchedulable
extends AbstractLogEnabled
implements Schedulable,
Component,
Configurable,
PluginAware,
Serviceable,
Contextualizable {
    public static final String PROGRESSION_TRACKER = "progression-tracker";
    protected String _pluginName;
    protected String _id;
    protected ServiceManager _smanager;
    protected Context _context;
    protected Instant _startTime;
    protected I18nizableText _label;
    protected I18nizableText _description;
    protected String _iconGlyph;
    protected String _iconSmall;
    protected String _iconMedium;
    protected String _iconLarge;
    protected boolean _private;
    protected boolean _acceptConcurrentExecution;
    protected Map<String, ElementDefinition> _parameters;
    protected ModelItemTypeExtensionPoint _schedulableParameterTypeExtensionPoint;
    protected UserManager _userManager;
    protected UserLanguagesManager _userLanguagesManager;

    @Override
    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
        this._id = id;
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._smanager = manager;
        this._schedulableParameterTypeExtensionPoint = (ModelItemTypeExtensionPoint)this._smanager.lookup(ModelItemTypeExtensionPoint.ROLE_SCHEDULABLE);
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
        this._userLanguagesManager = (UserLanguagesManager)manager.lookup(UserLanguagesManager.ROLE);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this._label = I18nizableText.parseI18nizableText(configuration.getChild("label"), "plugin." + this._pluginName);
        this._description = I18nizableText.parseI18nizableText(configuration.getChild("description"), "plugin." + this._pluginName);
        this._iconGlyph = configuration.getChild("icon-glyph").getValue("");
        this._iconSmall = configuration.getChild("icon-small").getValue("");
        this._iconMedium = configuration.getChild("icon-medium").getValue("");
        this._iconLarge = configuration.getChild("icon-large").getValue("");
        this._private = configuration.getChild("private").getValueAsBoolean(false);
        this._acceptConcurrentExecution = configuration.getChild("acceptConcurrentExecution").getValueAsBoolean(true);
        this._configureParameters(configuration.getChild("parameters"));
    }

    private void _configureParameters(Configuration paramConfigs) throws ConfigurationException {
        this._parameters = new LinkedHashMap<String, ElementDefinition>();
        ThreadSafeComponentManager<DisableConditions> disableConditionsManager = new ThreadSafeComponentManager<DisableConditions>();
        disableConditionsManager.setLogger(this.getLogger());
        disableConditionsManager.contextualize(this._context);
        disableConditionsManager.service(this._smanager);
        ThreadSafeComponentManager<Validator> validatorManager = new ThreadSafeComponentManager<Validator>();
        validatorManager.setLogger(this.getLogger());
        validatorManager.contextualize(this._context);
        validatorManager.service(this._smanager);
        ThreadSafeComponentManager<Enumerator> enumeratorManager = new ThreadSafeComponentManager<Enumerator>();
        enumeratorManager.setLogger(this.getLogger());
        enumeratorManager.contextualize(this._context);
        enumeratorManager.service(this._smanager);
        SchedulableParameterParser paramParser = new SchedulableParameterParser(this, this._schedulableParameterTypeExtensionPoint, disableConditionsManager, enumeratorManager, validatorManager);
        for (Configuration paramConf : paramConfigs.getChildren("param")) {
            ElementDefinition definition = (ElementDefinition)paramParser.parse(this._smanager, this._pluginName, paramConf, null, null);
            String id = definition.getName();
            if (this._parameters.containsKey(id)) {
                throw new ConfigurationException("The parameter '" + id + "' is already declared. IDs must be unique.", paramConf);
            }
            this._parameters.put(id, definition);
        }
        try {
            paramParser.lookupComponents();
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to lookup parameter local components", paramConfigs, (Throwable)e);
        }
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public ProgressionTracker getProgressionTracker(JobExecutionContext context) {
        return (ProgressionTracker)context.get((Object)PROGRESSION_TRACKER);
    }

    @Override
    public I18nizableText getLabel() {
        return this._label;
    }

    @Override
    public I18nizableText getDescription() {
        return this._description;
    }

    @Override
    public String getIconGlyph() {
        return this._iconGlyph;
    }

    @Override
    public String getIconSmall() {
        return this._iconSmall;
    }

    @Override
    public String getIconMedium() {
        return this._iconMedium;
    }

    @Override
    public String getIconLarge() {
        return this._iconLarge;
    }

    @Override
    public boolean isPrivate() {
        return this._private;
    }

    @Override
    public boolean acceptConcurrentExecution() {
        return this._acceptConcurrentExecution;
    }

    @Override
    public Map<String, ElementDefinition> getParameters() {
        return this._parameters;
    }

    public class SchedulableParameterParser
    extends AbstractElementDefinitionParser<VoidStaticRelativeDisableConditions> {
        public SchedulableParameterParser(AbstractStaticSchedulable this$0, ModelItemTypeExtensionPoint schedulableParameterTypeExtensionPoint, ThreadSafeComponentManager<DisableConditions> disableConditionsManager, ThreadSafeComponentManager<Enumerator> enumeratorManager, ThreadSafeComponentManager<Validator> validatorManager) {
            super(schedulableParameterTypeExtensionPoint, disableConditionsManager, enumeratorManager, validatorManager);
        }

        @Override
        protected String _getNameConfigurationAttribute() {
            return "id";
        }
    }
}

