/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.schedule;

import org.ametys.core.schedule.Runnable;
import org.ametys.plugins.core.impl.schedule.ConfigBasedRunnable;
import org.ametys.runtime.config.Config;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;

public class ConfigBasedEveryNMinutesRunnable
extends ConfigBasedRunnable {
    @Override
    protected void configureFireProcess(Configuration configuration, DefaultConfiguration modifiedConfiguration) throws ConfigurationException {
        Long periodCfgValue;
        Configuration periodCfg = configuration.getChild("param-period", false);
        if (periodCfg != null) {
            String periodParamName = periodCfg.getValue("").trim();
            periodCfgValue = (Long)Config.getInstance().getValue(periodParamName);
            if (periodCfgValue == 60L) {
                periodCfgValue = 0L;
            }
        } else {
            throw new ConfigurationException("Mandatory configuration 'param-period' is missing for config based every N minutes runnable " + this.getClass().getName());
        }
        DefaultConfiguration fireProcessConfig = new DefaultConfiguration("fire-process");
        fireProcessConfig.setValue(Runnable.FireProcess.CRON.name());
        modifiedConfiguration.addChild((Configuration)fireProcessConfig);
        String cronExpression = "0 0/" + periodCfgValue + " * * * ?";
        DefaultConfiguration cronConfig = new DefaultConfiguration("cron");
        cronConfig.setValue(cronExpression);
        modifiedConfiguration.addChild((Configuration)cronConfig);
    }
}

