/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.schedule;

import java.time.LocalTime;
import org.ametys.plugins.core.impl.schedule.AbstractConfigBasedHourRunnable;
import org.ametys.runtime.config.Config;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public class ConfigBasedMonthlyRunnable
extends AbstractConfigBasedHourRunnable {
    @Override
    protected String getCronExpression(Configuration configuration, LocalTime time) throws ConfigurationException {
        Configuration dayOfWeekCfg = configuration.getChild("param-dayofweek", false);
        Configuration dayOfMonthCfg = configuration.getChild("param-dayofmonth", false);
        if (dayOfWeekCfg != null) {
            if (dayOfMonthCfg != null) {
                throw new ConfigurationException("Configuration 'param-dayofweek' and 'param-dayofmonth' are mutually exclusive but both are set for config based monthly runnable " + this.getId());
            }
            String day = (String)Config.getInstance().getValue(dayOfWeekCfg.getValue("").trim());
            char[] charArray = day.toCharArray();
            charArray[0] = (char)(charArray[0] + '\u0001');
            day = new String(charArray);
            return "0 " + time.getMinute() + " " + time.getHour() + " " + "? " + "* " + day + " *";
        }
        if (dayOfMonthCfg != null) {
            long day = (Long)Config.getInstance().getValue(dayOfMonthCfg.getValue("").trim());
            return "0 " + time.getMinute() + " " + time.getHour() + " " + day + " " + "* " + "* " + "*";
        }
        throw new ConfigurationException("Missing configuration 'param-dayofweek' or 'param-dayofmonth' for config based monthly runnable '" + this.getId() + "'. One of the two must be set.");
    }
}

