/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.schedule;

import jakarta.mail.MessagingException;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.Locale;
import java.util.Map;
import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.core.impl.schedule.AbstractStaticSchedulable;
import org.ametys.plugins.core.ui.script.AsyncScriptHandler;
import org.ametys.plugins.core.ui.script.ScriptHandler;
import org.ametys.runtime.servlet.RuntimeServlet;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;

public class ScriptSchedulable
extends AbstractStaticSchedulable {
    public static final String SCRIPT_KEY = "script";
    public static final String RECIPIENT_KEY = "recipient";
    public static final String WORKSPACE_KEY = "workspace";
    public static final String MAINTENANCE_KEY = "maintenance";
    private static final String __JOBDATAMAP_SCRIPT_KEY = "parameterValues#script";
    private static final String __JOBDATAMAP_RECIPIENT_KEY = "parameterValues#recipient";
    private static final String __JOBDATAMAP_WORKSPACE_KEY = "parameterValues#workspace";
    private static final String __JOBDATAMAP_MAINTENANCE_KEY = "parameterValues#maintenance";
    protected ScriptHandler _scriptHandler;
    protected AsyncScriptHandler _asyncScriptHandler;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._scriptHandler = (ScriptHandler)manager.lookup(ScriptHandler.ROLE);
        if (manager.hasService(AsyncScriptHandler.COMPONENT_ROLE)) {
            this._asyncScriptHandler = (AsyncScriptHandler)manager.lookup(AsyncScriptHandler.COMPONENT_ROLE);
            this._scriptHandler = this._asyncScriptHandler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(JobExecutionContext context, ContainerProgressionTracker progressionTracker) throws Exception {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        String script = (String)jobDataMap.get((Object)__JOBDATAMAP_SCRIPT_KEY);
        String recipient = (String)jobDataMap.get((Object)__JOBDATAMAP_RECIPIENT_KEY);
        String workspace = (String)jobDataMap.get((Object)__JOBDATAMAP_WORKSPACE_KEY);
        Boolean maintenance = (Boolean)jobDataMap.get((Object)__JOBDATAMAP_MAINTENANCE_KEY);
        UserIdentity userIdentity = UserIdentity.stringToUserIdentity(jobDataMap.getString("userIdentity"));
        RuntimeServlet.RunMode oldMode = null;
        if (Boolean.TRUE.equals(maintenance) && (oldMode = RuntimeServlet.getRunMode()) != RuntimeServlet.RunMode.MAINTENANCE) {
            RuntimeServlet.setMaintenanceStatus(RuntimeServlet.MaintenanceStatus.FORCED, new RuntimeServlet.ForcedMainteanceInformations("", userIdentity, ZonedDateTime.now()));
            RuntimeServlet.setRunMode(RuntimeServlet.RunMode.MAINTENANCE);
        }
        try {
            Map<String, Object> scriptResults = this._executeScript(script, workspace, progressionTracker);
            this._sendMail(scriptResults, recipient, userIdentity);
            if (scriptResults.containsKey("stacktrace")) {
                throw new JobExecutionException("Script failure. See preceding exception to know more.");
            }
        }
        finally {
            if (Boolean.TRUE.equals(maintenance) && oldMode != RuntimeServlet.RunMode.MAINTENANCE) {
                RuntimeServlet.setRunMode(oldMode);
                RuntimeServlet.setMaintenanceStatus(RuntimeServlet.MaintenanceStatus.NONE, null);
            }
        }
    }

    private Map<String, Object> _executeScript(String script, String workspace, ContainerProgressionTracker progressionTracker) {
        return this._scriptHandler.executeScript("function main() { \n " + script + " \n }", null, workspace, progressionTracker);
    }

    private Locale _getLocale(UserIdentity userIdentity) {
        String languageFound;
        Locale locale = null;
        User user = this._userManager.getUser(userIdentity);
        if (user != null && (languageFound = user.getLanguage()) != null) {
            locale = Locale.of(languageFound);
        }
        if (locale == null) {
            locale = Locale.of(this._userLanguagesManager.getDefaultLanguage());
        }
        return locale;
    }

    private void _sendMail(Map<String, Object> scriptResults, String recipient, UserIdentity userIdentity) throws MessagingException, IOException {
        Locale locale = this._getLocale(userIdentity);
        Logger logger = this.getLogger();
        if (this._asyncScriptHandler != null) {
            this._asyncScriptHandler.sendReportMail(scriptResults, userIdentity, recipient, locale, logger);
        }
    }
}

