/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.schedule;

import java.util.HashMap;
import java.util.Map;
import org.ametys.core.schedule.Runnable;
import org.ametys.core.schedule.RunnableExtensionPoint;
import org.ametys.core.schedule.Schedulable;
import org.ametys.core.schedule.SchedulableExtensionPoint;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.ModelHelper;
import org.ametys.runtime.parameter.ValidationResult;
import org.ametys.runtime.plugin.component.PluginAware;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class StaticRunnable
implements Runnable,
Component,
Configurable,
PluginAware,
Serviceable {
    protected SchedulableExtensionPoint _schedulableEP;
    protected String _pluginName;
    protected String _featureName;
    protected String _id;
    protected I18nizableText _label;
    protected I18nizableText _description;
    protected Runnable.FireProcess _fireProcess;
    protected String _cronExpression;
    protected String _schedulableId;
    protected boolean _removable;
    protected boolean _modifiable;
    protected boolean _deactivatable;
    protected Runnable.MisfirePolicy _misfirePolicy;
    protected Map<String, Object> _parameterValues;

    public void service(ServiceManager manager) throws ServiceException {
        this._schedulableEP = (SchedulableExtensionPoint)manager.lookup(SchedulableExtensionPoint.ROLE);
    }

    @Override
    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
        this._featureName = featureName;
        this._id = id;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this._label = I18nizableText.parseI18nizableText(configuration.getChild("label"), "plugin." + this._pluginName);
        this._description = I18nizableText.parseI18nizableText(configuration.getChild("description"), "plugin." + this._pluginName);
        this._fireProcess = Runnable.FireProcess.valueOf(configuration.getChild("fire-process").getValue("cron").toUpperCase());
        this._cronExpression = configuration.getChild("cron").getValue("0 0 2 * * ? *");
        this._schedulableId = configuration.getChild("schedulableId").getValue();
        if (!this._schedulableEP.hasExtension(this._schedulableId)) {
            String message = String.format("The extension '%s' of point '%s' declared in the feature '%s' in the plugin '%s' references the Schedulable extension '%s' but it seems to not exist.", this._id, RunnableExtensionPoint.class.getName(), this._featureName, this._pluginName, this._schedulableId);
            throw new ConfigurationException(message, configuration);
        }
        this._removable = configuration.getChild("removable").getValueAsBoolean(false);
        this._modifiable = configuration.getChild("modifiable").getValueAsBoolean(false);
        this._deactivatable = configuration.getChild("deactivatable").getValueAsBoolean(false);
        this._misfirePolicy = Runnable.MisfirePolicy.valueOf(configuration.getChild("misfire-policy").getValue("do_nothing").toUpperCase());
        this._configureParameterValues(configuration.getChild("parameters"));
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public I18nizableText getLabel() {
        return this._label;
    }

    @Override
    public I18nizableText getDescription() {
        return this._description;
    }

    @Override
    public Runnable.FireProcess getFireProcess() {
        return this._fireProcess;
    }

    @Override
    public String getCronExpression() {
        return this._cronExpression;
    }

    @Override
    public String getSchedulableId() {
        return this._schedulableId;
    }

    @Override
    public boolean isRemovable() {
        return this._removable;
    }

    @Override
    public boolean isModifiable() {
        return this._modifiable;
    }

    @Override
    public boolean isDeactivatable() {
        return this._deactivatable;
    }

    @Override
    public Runnable.MisfirePolicy getMisfirePolicy() {
        return this._misfirePolicy;
    }

    @Override
    public boolean isVolatile() {
        return true;
    }

    @Override
    public Map<String, Object> getParameterValues() {
        return this._parameterValues;
    }

    protected void _configureParameterValues(Configuration paramConfigs) throws ConfigurationException {
        this._parameterValues = new HashMap<String, Object>();
        Schedulable schedulable = (Schedulable)this._schedulableEP.getExtension(this._schedulableId);
        Map<String, ElementDefinition> declaredParameters = schedulable.getParameters();
        for (String paramId : declaredParameters.keySet()) {
            ValidationResult validationResult;
            ElementDefinition definition = declaredParameters.get(paramId);
            Object typedValue = null;
            Configuration paramConf = paramConfigs.getChild(paramId, false);
            if (paramConf != null) {
                String valueAsString = paramConf.getValue("");
                typedValue = definition.getType().castValue(valueAsString);
            }
            if (!(validationResult = ModelHelper.validateValue(definition, typedValue)).hasErrors()) {
                this._parameterValues.put(paramId, typedValue);
                continue;
            }
            StringBuilder message = new StringBuilder("The parameter '").append(paramId).append("' is not valid for the Runnable of id '").append(this._id).append("':");
            for (I18nizableText error : validationResult.getErrors()) {
                message.append("\n* " + error.toString());
            }
            throw new ConfigurationException(message.toString(), paramConfigs);
        }
    }

    @Override
    public UserIdentity getUserIdentity() {
        return UserPopulationDAO.SYSTEM_USER_IDENTITY;
    }
}

