/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.upload;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.core.upload.UploadManager;
import org.ametys.plugins.core.impl.schedule.AbstractStaticSchedulable;
import org.ametys.plugins.core.impl.upload.FSUploadManager;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.AbstractFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.quartz.JobExecutionContext;

public class CleanFSUploadSchedulable
extends AbstractStaticSchedulable
implements ThreadSafe {
    protected UploadManager _uploadManager;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._uploadManager = (UploadManager)manager.lookup(UploadManager.ROLE);
    }

    @Override
    public void execute(JobExecutionContext context, ContainerProgressionTracker progressionTracker) throws Exception {
        this.getLogger().info("Time to clean old uploads");
        try {
            GregorianCalendar calendar = new GregorianCalendar();
            ((Calendar)calendar).add(6, -1);
            FSUploadFileFilter filter = new FSUploadFileFilter(calendar.getTimeInMillis());
            File[] fileArray = this._uploadManager;
            if (fileArray instanceof FSUploadManager) {
                FSUploadManager fSUploadManager = (FSUploadManager)fileArray;
                for (File effectiveLoginDir : fSUploadManager.getUploadsDirectories()) {
                    String[] dirsToRemove = effectiveLoginDir.list((FilenameFilter)((Object)filter));
                    if (dirsToRemove == null) continue;
                    for (String dirToRemove : dirsToRemove) {
                        File uploadDir = new File(effectiveLoginDir, dirToRemove);
                        this.getLogger().debug("Removing directory: " + String.valueOf(uploadDir));
                        FileUtils.deleteDirectory((File)uploadDir);
                    }
                }
            } else {
                this.getLogger().warn("Current implementation of UploadManager does not support the clean of uploads directory");
            }
        }
        catch (Exception e) {
            this.getLogger().error("Unable to clean old uploads", (Throwable)e);
        }
    }

    private static class FSUploadFileFilter
    extends AbstractFileFilter {
        private long _yesterday;

        FSUploadFileFilter(long yesterday) {
            this._yesterday = yesterday;
        }

        public boolean accept(File file) {
            if (!file.isDirectory()) {
                return false;
            }
            Collection uploadFiles = FileUtils.listFiles((File)file, (IOFileFilter)TrueFileFilter.INSTANCE, null);
            if (uploadFiles.isEmpty()) {
                return true;
            }
            File firstFile = (File)uploadFiles.iterator().next();
            return firstFile.lastModified() < this._yesterday;
        }
    }
}

