/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.upload;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.UUID;
import org.ametys.core.upload.Upload;
import org.ametys.core.upload.UploadManager;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.DateUtils;
import org.ametys.core.util.FilenameUtils;
import org.ametys.core.util.URIUtils;
import org.ametys.runtime.util.AmetysHomeHelper;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.environment.Context;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public class FSUploadManager
implements UploadManager,
ThreadSafe,
Initializable,
LogEnabled,
Contextualizable {
    public static final String UPLOADS_DIRECTORY = "uploads-user";
    protected Context _cocoonContext;
    protected File _globalUploadsDir;
    private Logger _logger;

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this._cocoonContext = (Context)context.get((Object)"environment-context");
    }

    public void enableLogging(Logger logger) {
        this._logger = logger;
    }

    public void initialize() throws Exception {
        this._globalUploadsDir = new File(AmetysHomeHelper.getAmetysHomeData(), UPLOADS_DIRECTORY);
    }

    @Override
    public Upload storeUpload(UserIdentity user, String filename, InputStream is) throws IOException {
        if (!this._globalUploadsDir.exists() && !this._globalUploadsDir.mkdirs()) {
            throw new IOException("Unable to create directory: " + String.valueOf(this._globalUploadsDir));
        }
        String id = UUID.randomUUID().toString();
        File uploadFile = null;
        uploadFile = new File(this._getUploadDir(user != null ? UserIdentity.userIdentityToString(user) : null, id), FilenameUtils.encodeName(filename));
        if (this._logger.isInfoEnabled()) {
            this._logger.info("Using file: " + String.valueOf(uploadFile));
        }
        if (!uploadFile.getParentFile().mkdirs()) {
            throw new IOException("Unable to create directory: " + uploadFile.getParent());
        }
        try (FileOutputStream os = new FileOutputStream(uploadFile);){
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        return new FSUpload(this._cocoonContext, uploadFile);
    }

    @Override
    public Upload getUpload(UserIdentity user, String id) throws NoSuchElementException {
        File uploadDir = this._getUploadDir(user != null ? UserIdentity.userIdentityToString(user) : null, id);
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Using directory: " + String.valueOf(uploadDir));
        }
        if (!uploadDir.exists() || !uploadDir.isDirectory()) {
            throw new NoSuchElementException("No directory: " + String.valueOf(uploadDir));
        }
        Collection files = FileUtils.listFiles((File)uploadDir, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)FalseFileFilter.INSTANCE);
        if (this._logger.isInfoEnabled()) {
            this._logger.info("Found files: " + String.valueOf(files));
        }
        if (files.isEmpty()) {
            throw new NoSuchElementException("No files in directory: " + String.valueOf(uploadDir));
        }
        return new FSUpload(this._cocoonContext, (File)files.iterator().next());
    }

    protected File _getUploadDir(String login, String id) {
        String fileName = login != null ? FilenameUtils.encodeName(login) : "_Anonymous";
        return new File(new File(this._globalUploadsDir, fileName), id);
    }

    public File[] getUploadsDirectories() {
        return Optional.of(this._globalUploadsDir).map(dir -> dir.listFiles((FilenameFilter)DirectoryFileFilter.INSTANCE)).orElseGet(() -> new File[0]);
    }

    protected static class FSUpload
    implements Upload {
        private Context _context;
        private File _file;

        public FSUpload(Context context, File file) {
            this._context = context;
            this._file = file;
        }

        @Override
        public String getId() {
            return this._file.getParentFile().getName();
        }

        @Override
        public ZonedDateTime getUploadedDate() {
            return DateUtils.asZonedDateTime(this._file.lastModified());
        }

        @Override
        public String getFilename() {
            return URIUtils.decode(this._file.getName());
        }

        @Override
        public String getMimeType() {
            String mimeType = this._context.getMimeType(this.getFilename().toLowerCase());
            if (mimeType == null) {
                mimeType = "application/unknown";
            }
            return mimeType;
        }

        @Override
        public long getLength() {
            return this._file.length();
        }

        @Override
        public InputStream getInputStream() {
            try {
                return new FileInputStream(this._file);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Missing file: " + String.valueOf(this._file), e);
            }
        }
    }
}

