/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.user;

import java.util.Map;
import org.ametys.core.authentication.AuthenticateAction;
import org.ametys.core.authentication.CredentialProvider;
import org.ametys.core.authentication.LogoutCapable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;

public class AvalonCurrentUserProvider
extends AbstractLogEnabled
implements CurrentUserProvider,
Contextualizable,
ThreadSafe {
    protected Context _context;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    @Override
    public UserIdentity getUser() {
        UserIdentity user = null;
        try {
            Request request = this._getRequest();
            user = AuthenticateAction.getUserIdentityFromSession(request);
        }
        catch (Exception e) {
            this.getLogger().info("Unable to retrieve current authenticated user", (Throwable)e);
        }
        if (user == null) {
            this.getLogger().debug("There is no current user");
        } else {
            this.getLogger().debug("Providing current user as: {}", (Object)user);
        }
        return user;
    }

    private Request _getRequest() {
        Map objectModel = ContextHelper.getObjectModel((Context)this._context);
        return ObjectModelHelper.getRequest((Map)objectModel);
    }

    @Override
    public void logout(Redirector redirector) throws ProcessingException {
        Map objectModel = ContextHelper.getObjectModel((Context)this._context);
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        Session session = request.getSession(false);
        if (session != null) {
            CredentialProvider cp = AuthenticateAction.getCredentialProviderFromSession(request);
            if (cp instanceof LogoutCapable) {
                ((LogoutCapable)((Object)cp)).logout(redirector);
            }
            session.invalidate();
        }
    }
}

