/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.user.dataprovider;

import org.ametys.core.user.User;
import org.ametys.core.user.dataprovider.UserDataProvider;
import org.ametys.core.user.directory.StoredUser;

public class StoredUserDataProvider
implements UserDataProvider {
    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean supports(String element) {
        try {
            this.getValue(new StoredUser(null, null), element);
            return true;
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
    }

    @Override
    public Object getValue(User user, String dataId) {
        StoredUser storedUser = user.getStoredUser();
        return this.getValue(storedUser, dataId);
    }

    private Object getValue(StoredUser storedUser, String dataId) {
        switch (dataId) {
            case "lastname": {
                return storedUser.getLastName();
            }
            case "firstname": {
                return storedUser.getFirstName();
            }
            case "email": {
                return storedUser.getEmail();
            }
            case "creation-date": {
                return storedUser.getCreationDate();
            }
            case "creation-origin": {
                return storedUser.getCreationOrigin();
            }
        }
        throw new UnsupportedOperationException("The data '" + dataId + "' requested is not supported by this extension");
    }
}

