/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.user.directory;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.core.user.directory.StoredUser;
import org.ametys.core.user.directory.UserDirectory;
import org.ametys.core.util.Cacheable;
import org.ametys.core.util.StringUtils;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.i18n.I18nizableTextParameter;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public abstract class AbstractCachingUserDirectory
extends AbstractLogEnabled
implements UserDirectory,
Serviceable,
Cacheable,
Disposable {
    private String _id;
    private String _label;
    private String _udModelId;
    private Map<String, Object> _paramValues;
    private String _populationId;
    private final String _uniqueCacheSuffix = StringUtils.generateKey();
    private AbstractCacheManager _cacheManager;

    public void service(ServiceManager manager) throws ServiceException {
        this._cacheManager = (AbstractCacheManager)manager.lookup(AbstractCacheManager.ROLE);
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public String getLabel() {
        return this._label;
    }

    @Override
    public void setPopulationId(String populationId) {
        this._populationId = populationId;
    }

    @Override
    public String getPopulationId() {
        return this._populationId;
    }

    @Override
    public Map<String, Object> getParameterValues() {
        return this._paramValues;
    }

    @Override
    public String getUserDirectoryModelId() {
        return this._udModelId;
    }

    @Override
    public void init(String id, String udModelId, Map<String, Object> paramValues, String label) throws Exception {
        this._id = id;
        this._udModelId = udModelId;
        this._label = label;
        this._paramValues = paramValues;
    }

    @Override
    public Collection<Cacheable.SingleCacheConfiguration> getManagedCaches() {
        return Arrays.asList(Cacheable.SingleCacheConfiguration.of(this.getClass().getName() + "$by.login$" + this._uniqueCacheSuffix, this._buildI18n("PLUGINS_CORE_USERS_CACHE_BY_LOGIN_LABEL"), this._buildI18n("PLUGINS_CORE_USERS_CACHE_BY_LOGIN_DESC")), Cacheable.SingleCacheConfiguration.of(this.getClass().getName() + "$by.mail$" + this._uniqueCacheSuffix, this._buildI18n("PLUGINS_CORE_USERS_CACHE_BY_MAIL_LABEL"), this._buildI18n("PLUGINS_CORE_USERS_CACHE_BY_MAIL_DESC")));
    }

    private I18nizableText _buildI18n(String i18Key) {
        String catalogue = "plugin.core-impl";
        I18nizableText userDirectoryId = new I18nizableText(this.getPopulationId() + "#" + this.getId());
        I18nizableText type = new I18nizableText(this.getCacheTypeLabel());
        Map<String, I18nizableTextParameter> params = Map.of("type", type, "id", userDirectoryId);
        return new I18nizableText(catalogue, i18Key, params);
    }

    protected Cache<String, StoredUser> getCacheByLogin() {
        return this.getCache(this.getClass().getName() + "$by.login$" + this._uniqueCacheSuffix);
    }

    protected Cache<String, StoredUser> getCacheByMail() {
        return this.getCache(this.getClass().getName() + "$by.mail$" + this._uniqueCacheSuffix);
    }

    protected abstract String getCacheTypeLabel();

    @Override
    public AbstractCacheManager getCacheManager() {
        return this._cacheManager;
    }

    public void dispose() {
        this.removeCaches();
    }
}

