/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.user.directory;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.ametys.core.cache.Cache;
import org.ametys.core.datasource.ConnectionHelper;
import org.ametys.core.migration.MigrationEngine;
import org.ametys.core.migration.MigrationException;
import org.ametys.core.migration.MigrationExtensionPoint;
import org.ametys.core.migration.version.Version;
import org.ametys.core.migration.version.storage.SqlVersionStorage;
import org.ametys.core.model.type.ModelItemTypeExtensionPoint;
import org.ametys.core.observation.AsyncObserver;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.script.SQLScriptHelper;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.InvalidModificationException;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.directory.ModifiableUserDirectory;
import org.ametys.core.user.directory.NotUniqueUserException;
import org.ametys.core.user.directory.StoredUser;
import org.ametys.core.user.directory.UserDirectory;
import org.ametys.core.util.DateUtils;
import org.ametys.core.util.StringUtils;
import org.ametys.plugins.core.impl.hash.Argon2PasswordEncoder;
import org.ametys.plugins.core.impl.user.directory.AbstractCachingUserDirectory;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.DefaultElementDefinition;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.ModelHelper;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.type.ModelItemType;
import org.ametys.runtime.parameter.DefaultValidator;
import org.ametys.runtime.parameter.ValidationResult;
import org.ametys.runtime.parameter.Validator;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.excalibur.source.SourceResolver;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class JdbcUserDirectory
extends AbstractCachingUserDirectory
implements ModifiableUserDirectory,
Component,
Contextualizable,
Initializable,
AsyncObserver {
    public static final String DATASOURCE_PARAM_NAME = "runtime.users.jdbc.datasource";
    public static final String USERS_TABLE_PARAM_NAME = "runtime.users.jdbc.table";
    public static final String USE_STRONG_PASSWORD_PARAM_NAME = "runtime.users.jdbc.strong.password";
    public static final String USE_STRONG_PASSWORD_MIN_LENGTH_PARAM_NAME = "runtime.users.jdbc.strong.password.min-length";
    public static final String USE_STRONG_PASSWORD_MIN_UPPERCASE_PARAM_NAME = "runtime.users.jdbc.strong.password.min-uppercase";
    public static final String USE_STRONG_PASSWORD_MIN_LOWERCASE_PARAM_NAME = "runtime.users.jdbc.strong.password.min-lowercase";
    public static final String USE_STRONG_PASSWORD_MIN_NUMBERS_PARAM_NAME = "runtime.users.jdbc.strong.password.min-numbers";
    public static final String USE_STRONG_PASSWORD_MIN_SPECIALS_PARAM_NAME = "runtime.users.jdbc.strong.password.min-specials";
    public static final String USE_STRONG_PASSWORD_SPECIAL_CHARACTERS_PARAM_NAME = "runtime.users.jdbc.strong.password.special-characters";
    protected static final String BASE_PLUGIN_NAME = "core";
    protected static final String __COLUMN_LOGIN = "login";
    protected static final String __COLUMN_PASSWORD = "password";
    protected static final String __COLUMN_FIRSTNAME = "firstname";
    protected static final String __COLUMN_LASTNAME = "lastname";
    protected static final String __COLUMN_EMAIL = "email";
    protected static final String __COLUMN_CREATION_DATE = "creationDate";
    protected static final String __COLUMN_CREATION_ORIGIN = "creationOrigin";
    protected static final String __COLUMN_SALT = "salt";
    static final String[] __COLUMNS = new String[]{"login", "password", "firstname", "lastname", "email"};
    static final String[] __ORDERBY_COLUMNS = new String[]{"lastname", "firstname"};
    protected String _dataSourceId;
    protected String _userTableName;
    protected boolean _useStrongPassword;
    protected StrongPasswordRequirements _strongPasswordRequirements;
    protected Map<String, ElementDefinition> _model;
    protected ServiceManager _manager;
    protected Context _context;
    protected SourceResolver _sourceResolver;
    protected Argon2PasswordEncoder _argon2PasswordEncoder;
    protected ModelItemTypeExtensionPoint _jdbcParameterTypeExtensionPoint;
    protected View _view;
    private ObservationManager _observationManager;
    private CurrentUserProvider _currentUserProvider;
    private boolean _lazyInitialized;
    private MigrationExtensionPoint _migrationEP;
    private MigrationEngine _migrationEngine;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._manager = manager;
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._jdbcParameterTypeExtensionPoint = (ModelItemTypeExtensionPoint)manager.lookup(ModelItemTypeExtensionPoint.ROLE_JDBC);
        this._migrationEP = (MigrationExtensionPoint)manager.lookup(MigrationExtensionPoint.ROLE);
        this._migrationEngine = (MigrationEngine)manager.lookup(MigrationEngine.ROLE);
        if (manager.hasService(ObservationManager.ROLE)) {
            this._observationManager = (ObservationManager)((Object)this._manager.lookup(ObservationManager.ROLE));
        }
    }

    public void initialize() throws Exception {
        if (this._observationManager != null) {
            this._observationManager.registerObserver(this);
        }
    }

    @Override
    public void dispose() {
        if (this._observationManager != null) {
            this._observationManager.unregisterObserver(this);
        }
    }

    @Override
    public String getFamilyId() {
        return JdbcUserDirectory.class.getName();
    }

    @Override
    protected String getCacheTypeLabel() {
        return "SQL";
    }

    @Override
    public void init(String id, String udModelId, Map<String, Object> paramValues, String label) throws Exception {
        super.init(id, udModelId, paramValues, label);
        this._userTableName = (String)paramValues.get(USERS_TABLE_PARAM_NAME);
        this._dataSourceId = (String)paramValues.get(DATASOURCE_PARAM_NAME);
        this._useStrongPassword = (Boolean)paramValues.get(USE_STRONG_PASSWORD_PARAM_NAME);
        long minLength = this._getLongValue(paramValues, USE_STRONG_PASSWORD_MIN_LENGTH_PARAM_NAME);
        long minLowerCase = this._getLongValue(paramValues, USE_STRONG_PASSWORD_MIN_LOWERCASE_PARAM_NAME);
        long minUppercase = this._getLongValue(paramValues, USE_STRONG_PASSWORD_MIN_UPPERCASE_PARAM_NAME);
        long minNumbers = this._getLongValue(paramValues, USE_STRONG_PASSWORD_MIN_NUMBERS_PARAM_NAME);
        long minSpecials = this._getLongValue(paramValues, USE_STRONG_PASSWORD_MIN_SPECIALS_PARAM_NAME);
        String specialCharacters = (String)paramValues.get(USE_STRONG_PASSWORD_SPECIAL_CHARACTERS_PARAM_NAME);
        this._strongPasswordRequirements = new StrongPasswordRequirements(minLength, minLowerCase, minUppercase, minNumbers, minSpecials, specialCharacters);
        this._initModelParameters();
        this.createCaches();
        this._argon2PasswordEncoder = new Argon2PasswordEncoder(Argon2PasswordEncoder.getOrCreatePepper(id));
    }

    private long _getLongValue(Map<String, Object> paramValues, String paramName) {
        Long longValue = (Long)paramValues.get(paramName);
        return longValue != null ? longValue : 0L;
    }

    protected void _initModelParameters() {
        this._model = new LinkedHashMap<String, ElementDefinition>();
        I18nizableText invalidLoginText = new I18nizableText("plugin.core", "PLUGINS_CORE_USERS_JDBC_FIELD_LOGIN_INVALID");
        DefaultValidator loginValidator = new DefaultValidator("^[a-zA-Z0-9_\\-\\.@]{3,64}$", invalidLoginText, true);
        this._initModelParameter(__COLUMN_LOGIN, "string", "PLUGINS_CORE_USERS_JDBC_FIELD_LOGIN_LABEL", "PLUGINS_CORE_USERS_JDBC_FIELD_LOGIN_DESCRIPTION", loginValidator);
        this._initModelParameter(__COLUMN_PASSWORD, __COLUMN_PASSWORD, "PLUGINS_CORE_USERS_JDBC_FIELD_PASSWORD_LABEL", "PLUGINS_CORE_USERS_JDBC_FIELD_PASSWORD_DESCRIPTION", null);
        this._initModelParameter(__COLUMN_FIRSTNAME, "string", "PLUGINS_CORE_USERS_JDBC_FIELD_FIRSTNAME_LABEL", "PLUGINS_CORE_USERS_JDBC_FIELD_FIRSTNAME_DESCRIPTION", null);
        this._initModelParameter(__COLUMN_LASTNAME, "string", "PLUGINS_CORE_USERS_JDBC_FIELD_LASTNAME_LABEL", "PLUGINS_CORE_USERS_JDBC_FIELD_LASTNAME_DESCRIPTION", null);
        I18nizableText invalidEmailText = new I18nizableText("plugin.core", "PLUGINS_CORE_USERS_JDBC_FIELD_EMAIL_INVALID");
        DefaultValidator emailValidator = new DefaultValidator("^.+@.+$", invalidEmailText, false);
        this._initModelParameter(__COLUMN_EMAIL, "string", "PLUGINS_CORE_USERS_JDBC_FIELD_EMAIL_LABEL", "PLUGINS_CORE_USERS_JDBC_FIELD_EMAIL_DESCRIPTION", emailValidator);
    }

    private void _initModelParameter(String name, String parameterType, String labelKey, String descriptionKey, Validator validator) {
        ModelItemType modelItemType = (ModelItemType)this._jdbcParameterTypeExtensionPoint.getExtension(parameterType);
        DefaultElementDefinition parameter = new DefaultElementDefinition();
        parameter.setPluginName(BASE_PLUGIN_NAME);
        parameter.setType(modelItemType);
        parameter.setName(name);
        parameter.setLabel(new I18nizableText("plugin.core", labelKey));
        parameter.setDescription(new I18nizableText("plugin.core", descriptionKey));
        parameter.setValidator(validator != null ? validator : new DefaultValidator(null, true));
        parameter.setModel(this);
        this._model.put(name, parameter);
    }

    private void _initTable(Connection connection) throws SQLException, MigrationException {
        MigrationEngine.MigrationComponent component;
        Version version;
        if (!SQLScriptHelper.tableExists(connection, this._userTableName) && this._migrationEngine.initializeVersion(new MigrationEngine.ActionData(version = (component = (MigrationEngine.MigrationComponent)this._migrationEP.getExtension("user-directory.jdbc")).versionStorage().createVersion("user-directory.jdbc_" + this._userTableName, component, new SqlVersionStorage.SqlVersionConfiguration(this._dataSourceId), Map.of("TABLENAME", this._userTableName)), this._migrationEngine.getHighestUpgradeVersionNumber(component), component.initialization(), null))) {
            throw new IllegalStateException("Requiring a restart after in a table initialization for a JdbcUserDirectory is not authorized");
        }
    }

    protected CurrentUserProvider getCurrentUserProvider() {
        if (this._currentUserProvider == null) {
            try {
                this._currentUserProvider = (CurrentUserProvider)this._manager.lookup(CurrentUserProvider.ROLE);
            }
            catch (ServiceException e) {
                throw new RuntimeException("Unable to lookup CurrentUserProvider component", e);
            }
        }
        return this._currentUserProvider;
    }

    protected Connection getSQLConnection() {
        Connection connection = ConnectionHelper.getConnection(this._dataSourceId);
        if (!this._lazyInitialized) {
            try {
                this._initTable(connection);
            }
            catch (Exception e) {
                this.getLogger().error("The tables requires by the " + this.getClass().getName() + " could not be created. A degraded behavior will occur", (Throwable)e);
            }
            this._lazyInitialized = true;
        }
        return connection;
    }

    @Override
    public Collection<StoredUser> getStoredUsers() {
        return this.getStoredUsers(Integer.MAX_VALUE, 0, Collections.EMPTY_MAP);
    }

    @Override
    public List<StoredUser> getStoredUsers(int count, int offset, Map<String, Object> parameters) {
        String pattern = (String)org.apache.commons.lang3.StringUtils.defaultIfEmpty((CharSequence)((String)parameters.get("pattern")), null);
        int boundedCount = count >= 0 ? count : Integer.MAX_VALUE;
        int boundedOffset = offset >= 0 ? offset : 0;
        SelectUsersJdbcQueryExecutor<List<StoredUser>> queryExecutor = new SelectUsersJdbcQueryExecutor<List<StoredUser>>(pattern, boundedCount, boundedOffset){

            @Override
            protected List<StoredUser> processResultSet(ResultSet rs) throws SQLException {
                return JdbcUserDirectory.this._getUsersProcessResultSet(rs, true);
            }
        };
        return (List)queryExecutor.run();
    }

    @Override
    public StoredUser getStoredUser(final String login) {
        if (this.isCachingEnabled() && this.getCacheByLogin().hasKey(login)) {
            StoredUser storedUser = this.getCacheByLogin().get(login);
            return storedUser;
        }
        SelectUserJdbcQueryExecutor<StoredUser> queryExecutor = new SelectUserJdbcQueryExecutor<StoredUser>(login){

            @Override
            protected StoredUser processResultSet(ResultSet rs) throws SQLException {
                Cache<String, StoredUser> cache = JdbcUserDirectory.this.isCachingEnabled() ? JdbcUserDirectory.this.getCacheByLogin() : null;
                return JdbcUserDirectory.this._getUserProcessResultSet(rs, login, cache);
            }
        };
        return (StoredUser)queryExecutor.run();
    }

    @Override
    public StoredUser getStoredUserByEmail(String email) throws NotUniqueUserException {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)email)) {
            return null;
        }
        String lcEmail = email.toLowerCase();
        if (this.isCachingEnabled() && this.getCacheByMail().hasKey(lcEmail)) {
            StoredUser storedUser = this.getCacheByMail().get(lcEmail);
            return storedUser;
        }
        SelectUserJdbcQueryExecutor<List<StoredUser>> queryExecutor = new SelectUserJdbcQueryExecutor<List<StoredUser>>(email, __COLUMN_EMAIL){

            @Override
            protected List<StoredUser> processResultSet(ResultSet rs) throws SQLException {
                return JdbcUserDirectory.this._getUsersProcessResultSet(rs, false);
            }
        };
        List storedUsers = (List)queryExecutor.run();
        if (storedUsers.size() == 1) {
            return (StoredUser)storedUsers.get(0);
        }
        if (storedUsers.isEmpty()) {
            return null;
        }
        throw new NotUniqueUserException("Find " + storedUsers.size() + " users matching the email " + email);
    }

    public boolean checkPasswordStrength(String password) {
        return !this.useStrongPassword() || !this.getStrongPasswordRequirements().validate(password).hasErrors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public UserDirectory.CredentialsResult checkCredentials(String login, String password) {
        UserDirectory.CredentialsResult credentialsResult;
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        boolean updateNeeded;
        block26: {
            UserDirectory.CredentialsResult credentialsResult2;
            block25: {
                UserDirectory.CredentialsResult credentialsResult3;
                block24: {
                    UserDirectory.CredentialsResult credentialsResult4;
                    block23: {
                        UserDirectory.CredentialsResult encryptedPassword2;
                        block22: {
                            UserDirectory.CredentialsResult credentialsResult5;
                            block21: {
                                UserDirectory.CredentialsResult credentialsResult6;
                                block20: {
                                    updateNeeded = false;
                                    con = null;
                                    stmt = null;
                                    rs = null;
                                    try {
                                        block29: {
                                            block27: {
                                                String salt;
                                                String storedPassword;
                                                block28: {
                                                    con = this.getSQLConnection();
                                                    String sql = "SELECT login, password, salt FROM " + this._userTableName + " WHERE login = ?";
                                                    if (this.getLogger().isDebugEnabled()) {
                                                        this.getLogger().debug(sql);
                                                    }
                                                    stmt = con.prepareStatement(sql);
                                                    stmt.setString(1, login);
                                                    rs = stmt.executeQuery();
                                                    if (!rs.next()) break block27;
                                                    storedPassword = rs.getString(__COLUMN_PASSWORD);
                                                    salt = rs.getString(__COLUMN_SALT);
                                                    if (salt != null) break block28;
                                                    if (this._isMD5Encrypted(storedPassword)) {
                                                        String encryptedPassword2 = StringUtils.md5Base64(password);
                                                        if (encryptedPassword2 == null) {
                                                            this.getLogger().error("Unable to encrypt password");
                                                            credentialsResult6 = UserDirectory.CredentialsResult.NOT_AUTHENTICATED;
                                                            ConnectionHelper.cleanup(rs);
                                                            break block20;
                                                        }
                                                        if (!storedPassword.equals(encryptedPassword2)) {
                                                            credentialsResult5 = UserDirectory.CredentialsResult.NOT_AUTHENTICATED;
                                                            ConnectionHelper.cleanup(rs);
                                                            break block21;
                                                        }
                                                        updateNeeded = true;
                                                        break block29;
                                                    } else if (!this._argon2PasswordEncoder.matches(password, storedPassword)) {
                                                        encryptedPassword2 = UserDirectory.CredentialsResult.NOT_AUTHENTICATED;
                                                        ConnectionHelper.cleanup(rs);
                                                        break block22;
                                                    }
                                                    break block29;
                                                }
                                                String encryptedPassword3 = DigestUtils.sha512Hex((String)(salt + password));
                                                if (encryptedPassword3 == null) {
                                                    this.getLogger().error("Unable to encrypt password");
                                                    credentialsResult4 = UserDirectory.CredentialsResult.NOT_AUTHENTICATED;
                                                    ConnectionHelper.cleanup(rs);
                                                    break block23;
                                                }
                                                if (!storedPassword.equalsIgnoreCase(encryptedPassword3)) {
                                                    credentialsResult3 = UserDirectory.CredentialsResult.NOT_AUTHENTICATED;
                                                    ConnectionHelper.cleanup(rs);
                                                    break block24;
                                                }
                                                updateNeeded = true;
                                                break block29;
                                            }
                                            credentialsResult2 = UserDirectory.CredentialsResult.NOT_AUTHENTICATED;
                                            ConnectionHelper.cleanup(rs);
                                            break block25;
                                        }
                                        credentialsResult = this.checkPasswordStrength(password) ? UserDirectory.CredentialsResult.AUTHENTICATED : UserDirectory.CredentialsResult.WEAK_PASSWORD;
                                        ConnectionHelper.cleanup(rs);
                                        break block26;
                                    }
                                    catch (SQLException e) {
                                        this.getLogger().error("Error during the connection to the database", (Throwable)e);
                                        credentialsResult = UserDirectory.CredentialsResult.NOT_AUTHENTICATED;
                                        return credentialsResult;
                                    }
                                }
                                ConnectionHelper.cleanup(stmt);
                                ConnectionHelper.cleanup(con);
                                if (!updateNeeded) return credentialsResult6;
                                this._updateToArgon2Password(login, password);
                                return credentialsResult6;
                            }
                            ConnectionHelper.cleanup(stmt);
                            ConnectionHelper.cleanup(con);
                            if (!updateNeeded) return credentialsResult5;
                            this._updateToArgon2Password(login, password);
                            return credentialsResult5;
                        }
                        ConnectionHelper.cleanup(stmt);
                        ConnectionHelper.cleanup(con);
                        if (!updateNeeded) return encryptedPassword2;
                        this._updateToArgon2Password(login, password);
                        return encryptedPassword2;
                    }
                    ConnectionHelper.cleanup(stmt);
                    ConnectionHelper.cleanup(con);
                    if (!updateNeeded) return credentialsResult4;
                    this._updateToArgon2Password(login, password);
                    return credentialsResult4;
                }
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup(con);
                if (!updateNeeded) return credentialsResult3;
                this._updateToArgon2Password(login, password);
                return credentialsResult3;
            }
            ConnectionHelper.cleanup(stmt);
            ConnectionHelper.cleanup(con);
            if (!updateNeeded) return credentialsResult2;
            this._updateToArgon2Password(login, password);
            return credentialsResult2;
        }
        ConnectionHelper.cleanup(stmt);
        ConnectionHelper.cleanup(con);
        if (!updateNeeded) return credentialsResult;
        this._updateToArgon2Password(login, password);
        return credentialsResult;
        finally {
            ConnectionHelper.cleanup(rs);
            ConnectionHelper.cleanup(stmt);
            ConnectionHelper.cleanup(con);
            if (updateNeeded) {
                this._updateToArgon2Password(login, password);
            }
        }
    }

    @Override
    public void add(Map<String, String> userInformation, User.UserCreationOrigin userOrigin) throws InvalidModificationException {
        Map<String, List<I18nizableText>> errorFields;
        Connection con = null;
        PreparedStatement stmt = null;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Starting adding a new user");
        }
        if ((errorFields = this.validate(userInformation)).size() > 0) {
            throw new InvalidModificationException("The creation of user failed because of invalid parameter values", errorFields);
        }
        String login = userInformation.get(__COLUMN_LOGIN);
        try {
            con = this.getSQLConnection();
            stmt = this.createAddStatement(con, userInformation, userOrigin != null ? userOrigin : User.UserCreationOrigin.NOT_AVAILABLE);
            if (stmt.executeUpdate() != 1) {
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn("The user to remove '" + login + "' was not removed.");
                }
                throw new InvalidModificationException("Error no user inserted");
            }
            if (this._observationManager != null) {
                HashMap<String, Object> eventParams = new HashMap<String, Object>();
                eventParams.put("user", new UserIdentity(login, this.getPopulationId()));
                this._observationManager.notify(new Event("user.added", this.getCurrentUserProvider().getUser(), eventParams));
            }
        }
        catch (SQLException e) {
            try {
                this.getLogger().error("Error communication with database", (Throwable)e);
                throw new InvalidModificationException("Error during the communication with the database", e);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup(con);
                throw throwable;
            }
        }
        ConnectionHelper.cleanup(stmt);
        ConnectionHelper.cleanup(con);
    }

    @Override
    public Map<String, List<I18nizableText>> validate(Map<String, String> userInformation) {
        HashMap<String, List<I18nizableText>> errorFields = new HashMap<String, List<I18nizableText>>();
        boolean clearText = this._passwordIsInClearText(userInformation);
        boolean validatePasswordRequirements = clearText && this.useStrongPassword();
        for (ElementDefinition parameter : this._model.values()) {
            Object typedValue = parameter.getType().castValue(userInformation.get(parameter.getName()));
            ValidationResult result = ModelHelper.validateValue(parameter, typedValue);
            if (validatePasswordRequirements && __COLUMN_PASSWORD.equals(parameter.getName())) {
                result.addResult(this._strongPasswordRequirements.validate((String)typedValue));
            }
            if (!result.hasErrors()) continue;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("The field '" + parameter.getName() + "' is not valid");
            }
            errorFields.put(parameter.getName(), result.getErrors());
        }
        return errorFields;
    }

    private boolean _passwordIsInClearText(Map<String, String> userInformation) {
        boolean clearText = !userInformation.containsKey("clearText") || !"false".equals(userInformation.get("clearText"));
        return clearText;
    }

    @Override
    public void update(Map<String, String> userInformation) throws InvalidModificationException {
        Connection con = null;
        PreparedStatement stmt = null;
        boolean clearText = this._passwordIsInClearText(userInformation);
        boolean validatePasswordRequirements = clearText && this.useStrongPassword();
        HashMap<String, List<I18nizableText>> errorFields = new HashMap<String, List<I18nizableText>>();
        for (String id : userInformation.keySet()) {
            ElementDefinition parameter = this._model.get(id);
            if (parameter == null) continue;
            Object typedValue = parameter.getType().castValue(userInformation.get(parameter.getName()));
            ValidationResult result = ModelHelper.validateValue(parameter, typedValue);
            if (validatePasswordRequirements && __COLUMN_PASSWORD.equals(parameter.getName())) {
                result.addResult(this._strongPasswordRequirements.validate((String)typedValue));
            }
            if (!result.hasErrors()) continue;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("The field '" + parameter.getName() + "' is not valid");
            }
            errorFields.put(parameter.getName(), result.getErrors());
        }
        if (!errorFields.isEmpty()) {
            throw new InvalidModificationException("The modification of user failed because of invalid parameter values", errorFields);
        }
        String login = userInformation.get(__COLUMN_LOGIN);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)login)) {
            throw new InvalidModificationException("Cannot update without login information");
        }
        try {
            con = this.getSQLConnection();
            stmt = this.createModifyStatement(con, userInformation);
            if (stmt.executeUpdate() != 1) {
                throw new InvalidModificationException("Error. User '" + login + "' not updated");
            }
            if (this._observationManager != null) {
                HashMap<String, Object> eventParams = new HashMap<String, Object>();
                eventParams.put("user", new UserIdentity(login, this.getPopulationId()));
                this._observationManager.notify(new Event("user.updated", this.getCurrentUserProvider().getUser(), eventParams));
            }
        }
        catch (SQLException e) {
            try {
                this.getLogger().error("Error communication with database", (Throwable)e);
                throw new InvalidModificationException("Error communication with database", e);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup(con);
                throw throwable;
            }
        }
        ConnectionHelper.cleanup(stmt);
        ConnectionHelper.cleanup(con);
    }

    public boolean useStrongPassword() {
        return this._useStrongPassword;
    }

    public void forceStrongPassword(boolean flag) {
        this._useStrongPassword = flag;
    }

    public StrongPasswordRequirements getStrongPasswordRequirements() {
        return this._strongPasswordRequirements;
    }

    @Override
    public void remove(String login) throws InvalidModificationException {
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = this.getSQLConnection();
            String sqlRequest = "DELETE FROM " + this._userTableName + " WHERE login = ?";
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(sqlRequest);
            }
            stmt = con.prepareStatement(sqlRequest);
            stmt.setString(1, login);
            if (stmt.executeUpdate() != 1) {
                throw new InvalidModificationException("Error user was not deleted");
            }
            if (this._observationManager != null) {
                HashMap<String, Object> eventParams = new HashMap<String, Object>();
                eventParams.put("user", new UserIdentity(login, this.getPopulationId()));
                this._observationManager.notify(new Event("user.deleted", this.getCurrentUserProvider().getUser(), eventParams));
            }
        }
        catch (SQLException e) {
            try {
                throw new InvalidModificationException("Error during the communication with the database", e);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup(con);
                throw throwable;
            }
        }
        ConnectionHelper.cleanup(stmt);
        ConnectionHelper.cleanup(con);
    }

    @Override
    public Collection<? extends ModelItem> getModelItems() {
        return Collections.unmodifiableCollection(this._model.values());
    }

    protected JdbcPredicate _getMandatoryPredicate(String pattern) {
        return null;
    }

    protected String _getPatternToMatch(String pattern) {
        if (pattern != null) {
            return "%" + pattern + "%";
        }
        return null;
    }

    protected boolean _isMD5Encrypted(String password) {
        return password.length() == 24;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _updateToArgon2Password(String login, String password) {
        block6: {
            Connection con = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                con = this.getSQLConnection();
                String newEncryptedPassword = this._argon2PasswordEncoder.encode(password);
                String sqlUpdate = "UPDATE " + this._userTableName + " SET password = ?, salt = NULL WHERE login = ?";
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug(sqlUpdate);
                }
                stmt = con.prepareStatement(sqlUpdate);
                stmt.setString(1, newEncryptedPassword);
                stmt.setString(2, login);
                stmt.execute();
                ConnectionHelper.cleanup(rs);
            }
            catch (SQLException e) {
                this.getLogger().error("Error during the connection to the database", (Throwable)e);
                break block6;
            }
            finally {
                ConnectionHelper.cleanup(rs);
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup(con);
            }
            ConnectionHelper.cleanup(stmt);
            ConnectionHelper.cleanup(con);
        }
    }

    protected PreparedStatement createAddStatement(Connection con, Map<String, String> userInformation, User.UserCreationOrigin userOrigin) throws SQLException {
        String beginClause = "INSERT INTO " + this._userTableName + " (";
        String middleClause = ") VALUES (";
        String endClause = ")";
        StringBuffer intoClause = new StringBuffer();
        StringBuffer valueClause = new StringBuffer();
        for (String column : this._getColumns()) {
            if (intoClause.length() > 0) {
                intoClause.append(", ");
            }
            intoClause.append(column);
            if (valueClause.length() > 0) {
                valueClause.append(", ");
            }
            valueClause.append("?");
        }
        if (intoClause.length() > 0) {
            intoClause.append(", ");
        }
        intoClause.append(__COLUMN_CREATION_DATE);
        if (valueClause.length() > 0) {
            valueClause.append(", ");
        }
        valueClause.append("?");
        intoClause.append(", ");
        intoClause.append(__COLUMN_CREATION_ORIGIN);
        valueClause.append(", ");
        valueClause.append("?");
        String sqlRequest = beginClause + intoClause.toString() + middleClause + String.valueOf(valueClause) + endClause;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(sqlRequest);
        }
        PreparedStatement stmt = con.prepareStatement(sqlRequest);
        int i = 1;
        boolean clearText = !userInformation.containsKey("clearText") || !"false".equals(userInformation.get("clearText"));
        for (String column : this._getColumns()) {
            if (__COLUMN_PASSWORD.equals(column)) {
                String encryptedPassword;
                if (clearText) {
                    encryptedPassword = this._argon2PasswordEncoder.encode(userInformation.get(column));
                    if (encryptedPassword == null) {
                        String message = "Cannot encode password";
                        this.getLogger().error(message);
                        throw new SQLException(message);
                    }
                } else {
                    encryptedPassword = userInformation.get(column);
                }
                stmt.setString(i++, encryptedPassword);
                continue;
            }
            stmt.setString(i++, userInformation.get(column));
        }
        Timestamp now = new Timestamp(System.currentTimeMillis());
        stmt.setTimestamp(i++, now);
        stmt.setString(i++, userOrigin.name());
        return stmt;
    }

    protected PreparedStatement createModifyStatement(Connection con, Map<String, String> userInformation) throws SQLException {
        String beginClause = "UPDATE " + this._userTableName + " SET ";
        String endClause = " WHERE login = ?";
        StringBuffer columnNames = new StringBuffer("");
        boolean passwordUpdate = false;
        for (String id : userInformation.keySet()) {
            if (!ArrayUtils.contains((Object[])this._getColumns(), (Object)id) || __COLUMN_LOGIN.equals(id) || "origin".equals(id) || __COLUMN_PASSWORD.equals(id) && userInformation.get(id) == null) continue;
            if (__COLUMN_PASSWORD.equals(id)) {
                passwordUpdate = true;
            }
            if (columnNames.length() > 0) {
                columnNames.append(", ");
            }
            columnNames.append(id + " = ?");
        }
        if (passwordUpdate) {
            columnNames.append(", salt = NULL");
        }
        String sqlRequest = beginClause + columnNames.toString() + endClause;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(sqlRequest);
        }
        PreparedStatement stmt = con.prepareStatement(sqlRequest);
        this._fillModifyStatement(stmt, userInformation);
        return stmt;
    }

    protected void _fillModifyStatement(PreparedStatement stmt, Map<String, String> userInformation) throws SQLException {
        int index = 1;
        boolean clearText = this._passwordIsInClearText(userInformation);
        for (String id : userInformation.keySet()) {
            if (!ArrayUtils.contains((Object[])this._getColumns(), (Object)id) || __COLUMN_LOGIN.equals(id) || "origin".equals(id)) continue;
            if (__COLUMN_PASSWORD.equals(id)) {
                String encryptedPassword;
                if (userInformation.get(id) == null) continue;
                if (clearText) {
                    encryptedPassword = this._argon2PasswordEncoder.encode(userInformation.get(id));
                    if (encryptedPassword == null) {
                        String message = "Cannot encrypt password";
                        this.getLogger().error(message);
                        throw new SQLException(message);
                    }
                } else {
                    encryptedPassword = userInformation.get(id);
                }
                stmt.setString(index++, encryptedPassword);
                continue;
            }
            stmt.setString(index++, userInformation.get(id));
        }
        stmt.setString(index++, userInformation.get(__COLUMN_LOGIN));
    }

    protected List<StoredUser> _getUsersProcessResultSet(ResultSet rs, boolean isLogin) throws SQLException {
        ArrayList<StoredUser> storedUsers = new ArrayList<StoredUser>();
        while (rs.next()) {
            StoredUser storedUser = null;
            Cache<String, StoredUser> cache = null;
            if (this.isCachingEnabled()) {
                if (isLogin) {
                    String login;
                    cache = this.getCacheByLogin();
                    storedUser = cache.hasKey(login = rs.getString(__COLUMN_LOGIN)) ? cache.get(login) : null;
                } else {
                    String email;
                    cache = this.getCacheByMail();
                    StoredUser storedUser2 = storedUser = cache.hasKey(email = rs.getString(__COLUMN_EMAIL).toLowerCase()) ? cache.get(email) : null;
                }
            }
            if (storedUser == null) {
                storedUser = this._createUserFromResultSet(rs);
                if (cache != null) {
                    if (isLogin) {
                        cache.put(storedUser.getIdentifier(), storedUser);
                    } else {
                        cache.put(storedUser.getEmail().toLowerCase(), storedUser);
                    }
                }
            }
            storedUsers.add(storedUser);
        }
        return storedUsers;
    }

    protected StoredUser _createUserFromResultSet(ResultSet rs) throws SQLException {
        String originAsStr;
        String login = rs.getString(__COLUMN_LOGIN);
        String lastName = rs.getString(__COLUMN_LASTNAME);
        String firstName = rs.getString(__COLUMN_FIRSTNAME);
        String email = rs.getString(__COLUMN_EMAIL);
        Timestamp timestamp = rs.getTimestamp(__COLUMN_CREATION_DATE);
        ZonedDateTime creationDate = null;
        if (timestamp != null) {
            creationDate = DateUtils.asZonedDateTime(timestamp.getTime());
        }
        User.UserCreationOrigin creationOrigin = org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)(originAsStr = rs.getString(__COLUMN_CREATION_ORIGIN))) ? User.UserCreationOrigin.valueOf(originAsStr) : User.UserCreationOrigin.NOT_AVAILABLE;
        return new StoredUser(login, lastName, firstName, email, creationDate, creationOrigin);
    }

    protected StoredUser _getUserProcessResultSet(ResultSet rs, String login, Cache<String, StoredUser> cache) throws SQLException {
        if (rs.next()) {
            StoredUser storedUser = this._createUserFromResultSet(rs);
            if (this.isCachingEnabled()) {
                cache.put(login, storedUser);
            }
            return storedUser;
        }
        return null;
    }

    @Override
    public View getView() {
        if (this._view == null) {
            this._view = View.of(this, this._getColumns());
        }
        return this._view;
    }

    private boolean _dontMatch(Pattern pattern, String value) {
        return pattern != null && !pattern.matcher(value).matches();
    }

    protected String[] _getColumns() {
        return __COLUMNS;
    }

    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean supports(Event event) {
        String eventId = event.getId();
        return "user.updated".equals(eventId) || "user.deleted".equals(eventId);
    }

    @Override
    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        if (this.isCachingEnabled()) {
            Object object = event.getArguments().get("user");
            if (object instanceof UserIdentity) {
                UserIdentity identity = (UserIdentity)object;
                if (identity.getPopulationId().equals(this.getPopulationId())) {
                    switch (event.getId()) {
                        case "user.updated": 
                        case "user.deleted": {
                            this.getCacheByLogin().invalidate(identity.getLogin());
                            this.getCacheByMail().invalidateAll();
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Event with id '" + event.getId() + "' are not supported by this observer");
                        }
                    }
                }
            } else {
                throw new IllegalStateException("'" + event.getArguments().get("user").toString() + "' is not a UserIdentity");
            }
        }
    }

    public class StrongPasswordRequirements {
        public static final String DEFAULT_SPECIAL_CHARACTERS = "!%&@#$^*?_~";
        private long _minLength;
        private long _minNumbers;
        private long _minSpecials;
        private long _minLowercase;
        private long _minUppercase;
        private String _specialCharacters;
        private Pattern _numberPattern;
        private Pattern _lowerCasePattern;
        private Pattern _upperCasePattern;
        private Pattern _specialPattern;

        public StrongPasswordRequirements(long minLength, long minLowercase, long minUppercase, long minNumbers, long minSpecials) {
            this(minLength, minLowercase, minUppercase, minNumbers, minSpecials, DEFAULT_SPECIAL_CHARACTERS);
        }

        public StrongPasswordRequirements(long minLength, long minLowercase, long minUppercase, long minNumbers, long minSpecials, String specialCharacters) {
            this._minLength = Math.max(minLength, 8L);
            this._minNumbers = minNumbers;
            this._minLowercase = minLowercase;
            this._minUppercase = minUppercase;
            this._minSpecials = minSpecials;
            this._specialCharacters = specialCharacters;
            this._numberPattern = this._minNumbers > 0L ? Pattern.compile("^(.*[0-9].*){" + this._minNumbers + ",}$") : null;
            this._lowerCasePattern = this._minLowercase > 0L ? Pattern.compile("^(.*[a-z].*){" + this._minLowercase + ",}$") : null;
            Pattern pattern = this._upperCasePattern = this._minUppercase > 0L ? Pattern.compile("^(.*[A-Z].*){" + this._minUppercase + ",}$") : null;
            if (this._minSpecials > 0L && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this._specialCharacters)) {
                String quotedSpecialCharacters = Pattern.quote(this._specialCharacters);
                this._specialPattern = Pattern.compile("^(.*[" + quotedSpecialCharacters + "].*){" + this._minSpecials + ",}$");
            }
        }

        public long minNumbers() {
            return this._minNumbers;
        }

        public long minLowerCase() {
            return this._minLowercase;
        }

        public long minUppercase() {
            return this._minUppercase;
        }

        public long minSpecials() {
            return this._minSpecials;
        }

        public void toSAX(ContentHandler contentHandler, String tagName) throws SAXException {
            AttributesImpl atts = new AttributesImpl();
            atts.addCDATAAttribute("minLength", String.valueOf(this._minLength));
            atts.addCDATAAttribute("minNumbers", String.valueOf(this._minNumbers));
            atts.addCDATAAttribute("minLowercase", String.valueOf(this._minLowercase));
            atts.addCDATAAttribute("minUppercase", String.valueOf(this._minUppercase));
            atts.addCDATAAttribute("minSpecials", String.valueOf(this._minSpecials));
            atts.addCDATAAttribute("specialCharacters", this._specialCharacters);
            XMLUtils.createElement((ContentHandler)contentHandler, (String)tagName, (Attributes)atts);
        }

        public Map<String, I18nizableText> getWidgetParameters() {
            HashMap<String, I18nizableText> widgetParameters = new HashMap<String, I18nizableText>();
            widgetParameters.put("useStrongPassword", new I18nizableText("true"));
            widgetParameters.put("useMinLength", new I18nizableText(String.valueOf(this._minLength)));
            widgetParameters.put("minNumbers", new I18nizableText(String.valueOf(this._minNumbers)));
            widgetParameters.put("minLowercase", new I18nizableText(String.valueOf(this._minLowercase)));
            widgetParameters.put("minUppercase", new I18nizableText(String.valueOf(this._minUppercase)));
            widgetParameters.put("minSpecials", new I18nizableText(String.valueOf(this._minSpecials)));
            widgetParameters.put("specialCharacters", new I18nizableText(this._specialCharacters));
            return widgetParameters;
        }

        public ValidationResult validate(String value) {
            ValidationResult result = new ValidationResult();
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)value)) {
                result.addError(new I18nizableText("plugin.core-ui", "PLUGINS_CORE_UI_CHANGEPASSWORD_EMPTY"));
                return result;
            }
            if (this._minLength > 0L && (long)value.length() < this._minLength) {
                List<String> i18nParams = List.of(String.valueOf(this._minLength));
                result.addError(new I18nizableText("plugin.core-ui", "PLUGINS_CORE_UI_CHANGEPASSWORD_USE_MIN_LENGTH", i18nParams));
            }
            if (JdbcUserDirectory.this._dontMatch(this._numberPattern, value)) {
                result.addError(this._minNumbers == 1L ? new I18nizableText("plugin.core-ui", "PLUGINS_CORE_UI_CHANGEPASSWORD_USE_NUMBER") : new I18nizableText("plugin.core-ui", "PLUGINS_CORE_UI_CHANGEPASSWORD_USE_NUMBERS", List.of(String.valueOf(this._minNumbers))));
            }
            if (JdbcUserDirectory.this._dontMatch(this._lowerCasePattern, value)) {
                result.addError(this._minLowercase == 1L ? new I18nizableText("plugin.core-ui", "PLUGINS_CORE_UI_CHANGEPASSWORD_USE_LOWERCASE") : new I18nizableText("plugin.core-ui", "PLUGINS_CORE_UI_CHANGEPASSWORD_USE_LOWERCASES", List.of(String.valueOf(this._minLowercase))));
            }
            if (JdbcUserDirectory.this._dontMatch(this._upperCasePattern, value)) {
                result.addError(this._minUppercase == 1L ? new I18nizableText("plugin.core-ui", "PLUGINS_CORE_UI_CHANGEPASSWORD_USE_UPPERCASE") : new I18nizableText("plugin.core-ui", "PLUGINS_CORE_UI_CHANGEPASSWORD_USE_UPPERCASES", List.of(String.valueOf(this._minUppercase))));
            }
            if (JdbcUserDirectory.this._dontMatch(this._specialPattern, value)) {
                result.addError(this._minSpecials == 1L ? new I18nizableText("plugin.core-ui", "PLUGINS_CORE_UI_CHANGEPASSWORD_USE_SPECIAL", List.of(this._specialCharacters)) : new I18nizableText("plugin.core-ui", "PLUGINS_CORE_UI_CHANGEPASSWORD_USE_SPECIALS", List.of(String.valueOf(this._minSpecials), this._specialCharacters)));
            }
            return result;
        }
    }

    protected class SelectUsersJdbcQueryExecutor<T>
    extends AbstractJdbcQueryExecutor<T> {
        protected String _pattern;
        protected int _length;
        protected int _offset;
        protected JdbcPredicate _mandatoryPredicate;
        protected String _patternToMatch;

        protected SelectUsersJdbcQueryExecutor(String pattern, int length, int offset) {
            this._pattern = pattern;
            this._length = length;
            this._offset = offset;
        }

        @Override
        protected String getSqlQuery(Connection connection) {
            StringBuilder selectClause = new StringBuilder();
            for (String column : JdbcUserDirectory.this._getColumns()) {
                if (selectClause.length() > 0) {
                    selectClause.append(", ");
                }
                selectClause.append(column);
            }
            if (selectClause.length() > 0) {
                selectClause.append(", ");
            }
            selectClause.append(JdbcUserDirectory.__COLUMN_CREATION_DATE);
            selectClause.append(", ");
            selectClause.append(JdbcUserDirectory.__COLUMN_CREATION_ORIGIN);
            StringBuilder sql = new StringBuilder("SELECT ");
            sql.append((CharSequence)selectClause).append(" FROM ").append(JdbcUserDirectory.this._userTableName);
            this._mandatoryPredicate = JdbcUserDirectory.this._getMandatoryPredicate(this._pattern);
            if (this._mandatoryPredicate != null) {
                sql.append(" WHERE ").append(this._mandatoryPredicate.getPredicate());
            }
            this._patternToMatch = JdbcUserDirectory.this._getPatternToMatch(this._pattern);
            if (this._patternToMatch != null) {
                if ("derby".equals(ConnectionHelper.getDatabaseType(connection))) {
                    sql.append(this._mandatoryPredicate != null ? " AND (" : " WHERE ").append("UPPER(").append(JdbcUserDirectory.__COLUMN_LOGIN).append(") LIKE UPPER(?) OR ").append("UPPER(").append(JdbcUserDirectory.__COLUMN_LASTNAME).append(") LIKE UPPER(?) OR ").append("UPPER(").append(JdbcUserDirectory.__COLUMN_FIRSTNAME).append(") LIKE UPPER(?)");
                } else {
                    sql.append(this._mandatoryPredicate != null ? " AND (" : " WHERE ").append(JdbcUserDirectory.__COLUMN_LOGIN).append(" LIKE ? OR ").append(JdbcUserDirectory.__COLUMN_LASTNAME).append(" LIKE ? OR ").append(JdbcUserDirectory.__COLUMN_FIRSTNAME).append(" LIKE ?");
                }
                if (this._mandatoryPredicate != null) {
                    sql.append(')');
                }
            }
            StringBuilder orderByClause = new StringBuilder();
            for (String column : __ORDERBY_COLUMNS) {
                orderByClause.append(orderByClause.length() == 0 ? " ORDER BY " : ", ");
                orderByClause.append(column);
            }
            sql.append((CharSequence)orderByClause);
            sql = this._addQuerySize(this._length, this._offset, connection, selectClause, sql);
            return sql.toString();
        }

        private StringBuilder _addQuerySize(int length, int offset, Connection con, StringBuilder selectClause, StringBuilder sql) {
            if (length == Integer.MAX_VALUE && offset == 0) {
                return sql;
            }
            String dbType = ConnectionHelper.getDatabaseType(con);
            if ("mysql".equals(dbType) || "postgresql".equals(dbType) || "hsqldb".equals(dbType)) {
                sql.append(" LIMIT " + length + " OFFSET " + offset);
                return sql;
            }
            if ("oracle".equals(dbType)) {
                return new StringBuilder("select " + selectClause.toString() + " from (select rownum r, " + selectClause.toString() + " from (" + sql.toString() + ")) where r BETWEEN " + (offset + 1) + " AND " + (offset + length));
            }
            if ("derby".equals(dbType)) {
                return new StringBuilder("select ").append((CharSequence)selectClause).append(" from (select ROW_NUMBER() OVER () AS ROWNUM, ").append(selectClause.toString()).append(" from (").append(sql.toString()).append(") AS TR ) AS TRR where ROWNUM BETWEEN ").append(offset + 1).append(" AND ").append(offset + length);
            }
            if (JdbcUserDirectory.this.getLogger().isWarnEnabled()) {
                JdbcUserDirectory.this.getLogger().warn("The request will not have the limit and offset set, since its type is unknown");
            }
            return sql;
        }

        @Override
        protected PreparedStatement prepareStatement(Connection connection, String sql) throws SQLException {
            PreparedStatement stmt = super.prepareStatement(connection, sql);
            int i = 1;
            if (this._mandatoryPredicate != null) {
                for (String value : this._mandatoryPredicate.getValues()) {
                    stmt.setString(i++, value);
                }
            }
            if (this._patternToMatch != null) {
                stmt.setString(i++, this._patternToMatch);
                stmt.setString(i++, this._patternToMatch);
                stmt.setString(i++, this._patternToMatch);
            }
            return stmt;
        }
    }

    protected class SelectUserJdbcQueryExecutor<T>
    extends AbstractJdbcQueryExecutor<T> {
        protected String _value;
        protected String _searchColumn;

        protected SelectUserJdbcQueryExecutor(String value) {
            this._value = value;
            this._searchColumn = JdbcUserDirectory.__COLUMN_LOGIN;
        }

        protected SelectUserJdbcQueryExecutor(String value, String searchColumn) {
            this._value = value;
            this._searchColumn = searchColumn;
        }

        @Override
        protected String getSqlQuery(Connection connection) {
            StringBuilder selectClause = new StringBuilder();
            for (String id : JdbcUserDirectory.this._getColumns()) {
                if (selectClause.length() > 0) {
                    selectClause.append(", ");
                }
                selectClause.append(id);
            }
            if (selectClause.length() > 0) {
                selectClause.append(", ");
            }
            selectClause.append(JdbcUserDirectory.__COLUMN_CREATION_DATE);
            selectClause.append(", ");
            selectClause.append(JdbcUserDirectory.__COLUMN_CREATION_ORIGIN);
            StringBuilder sql = new StringBuilder("SELECT ");
            sql.append((CharSequence)selectClause).append(" FROM ").append(JdbcUserDirectory.this._userTableName);
            sql.append(" WHERE ").append(this._searchColumn).append(" = ?");
            return sql.toString();
        }

        @Override
        protected PreparedStatement prepareStatement(Connection connection, String sql) throws SQLException {
            PreparedStatement stmt = super.prepareStatement(connection, sql);
            stmt.setString(1, this._value);
            return stmt;
        }
    }

    public class JdbcPredicate {
        protected String _predicate;
        protected List<String> _predicateParamValues;

        public JdbcPredicate(JdbcUserDirectory this$0, String predicate, String ... values) {
            this(this$0, predicate, Arrays.asList(values));
        }

        public JdbcPredicate(JdbcUserDirectory this$0, String predicate, List<String> values) {
            this._predicate = predicate;
            this._predicateParamValues = values;
        }

        public String getPredicate() {
            return this._predicate;
        }

        public void setPredicate(String predicate) {
            this._predicate = predicate;
        }

        public List<String> getValues() {
            return this._predicateParamValues;
        }

        public void setValues(List<String> values) {
            this._predicateParamValues = values;
        }
    }

    protected abstract class AbstractJdbcQueryExecutor<T> {
        protected AbstractJdbcQueryExecutor() {
        }

        public T run() {
            try {
                return this.runWithException();
            }
            catch (Exception e) {
                JdbcUserDirectory.this.getLogger().error("Exception during a query execution", (Throwable)e);
                throw new RuntimeException("Exception during a query execution", e);
            }
        }

        public T runWithException() throws Exception {
            T t;
            Connection connection = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                connection = JdbcUserDirectory.this.getSQLConnection();
                String sql = this.getSqlQuery(connection);
                if (JdbcUserDirectory.this.getLogger().isDebugEnabled()) {
                    JdbcUserDirectory.this.getLogger().debug("Executing SQL query: " + sql);
                }
                stmt = this.prepareStatement(connection, sql);
                rs = this.executeQuery(stmt);
                t = this.processResultSet(rs);
            }
            catch (SQLException e) {
                try {
                    JdbcUserDirectory.this.getLogger().error("Error during the communication with the database", (Throwable)e);
                    throw new RuntimeException("Error during the communication with the database", e);
                }
                catch (Throwable throwable) {
                    ConnectionHelper.cleanup(rs);
                    ConnectionHelper.cleanup(stmt);
                    ConnectionHelper.cleanup(connection);
                    throw throwable;
                }
            }
            ConnectionHelper.cleanup(rs);
            ConnectionHelper.cleanup(stmt);
            ConnectionHelper.cleanup(connection);
            return t;
        }

        protected abstract String getSqlQuery(Connection var1);

        protected PreparedStatement prepareStatement(Connection connection, String sql) throws SQLException {
            return connection.prepareStatement(sql);
        }

        protected ResultSet executeQuery(PreparedStatement stmt) throws SQLException {
            return stmt.executeQuery();
        }

        protected T processResultSet(ResultSet rs) throws SQLException, Exception {
            return null;
        }
    }
}

