/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.user.directory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.naming.AuthenticationException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.SizeLimitExceededException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.SortControl;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.directory.NotUniqueUserException;
import org.ametys.core.user.directory.StoredUser;
import org.ametys.core.user.directory.UserDirectory;
import org.ametys.core.util.Cacheable;
import org.ametys.core.util.StringUtils;
import org.ametys.core.util.ldap.AbstractLDAPConnector;
import org.ametys.core.util.ldap.IncompleteLDAPResultException;
import org.ametys.core.util.ldap.ScopeEnumerator;
import org.ametys.plugins.core.impl.user.LdapUserIdentity;
import org.ametys.plugins.core.impl.user.directory.StoredLdapUser;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.i18n.I18nizableTextParameter;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.Strings;

public class LdapUserDirectory
extends AbstractLDAPConnector
implements UserDirectory,
Component,
Cacheable,
Disposable {
    public static final String PARAM_DATASOURCE_ID = "runtime.users.ldap.datasource";
    public static final String PARAM_USERS_RELATIVE_DN = "runtime.users.ldap.peopleDN";
    public static final String PARAM_USERS_OBJECT_FILTER = "runtime.users.ldap.baseFilter";
    public static final String PARAM_USERS_SEARCH_SCOPE = "runtime.users.ldap.scope";
    public static final String PARAM_USERS_LOGIN_ATTRIBUTE = "runtime.users.ldap.loginAttr";
    public static final String PARAM_USERS_FIRSTNAME_ATTRIBUTE = "runtime.users.ldap.firstnameAttr";
    public static final String PARAM_USERS_LASTNAME_ATTRIBUTE = "runtime.users.ldap.lastnameAttr";
    public static final String PARAM_USERS_EMAIL_ATTRIBUTE = "runtime.users.ldap.emailAttr";
    public static final String PARAM_USERS_EMAIL_IS_MANDATORY = "runtime.users.ldap.emailMandatory";
    public static final String PARAM_SERVER_SIDE_SORTING = "runtime.users.ldap.serverSideSorting";
    private static final String __LDAP_USERDIRECTORY_USER_BY_LOGIN_CACHE_NAME_PREFIX = LdapUserDirectory.class.getName() + "$by.login$";
    private static final String __LDAP_USERDIRECTORY_USER_BY_MAIL_CACHE_NAME_PREFIX = LdapUserDirectory.class.getName() + "$by.mail$";
    protected String _usersRelativeDN;
    protected String _usersObjectFilter;
    protected int _usersSearchScope;
    protected String _usersLoginAttribute;
    protected String _usersFirstnameAttribute;
    protected String _usersLastnameAttribute;
    protected String _usersEmailAttribute;
    protected boolean _userEmailIsMandatory;
    private String _udModelId;
    private Map<String, Object> _paramValues;
    private String _populationId;
    private String _label;
    private String _id;
    private final String _uniqueCacheSuffix = StringUtils.generateKey();
    private AbstractCacheManager _cacheManager;

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public String getLabel() {
        return this._label;
    }

    @Override
    public boolean isCaseSensitive() {
        return false;
    }

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._cacheManager = (AbstractCacheManager)serviceManager.lookup(AbstractCacheManager.ROLE);
    }

    public void dispose() {
        this.removeCaches();
    }

    @Override
    public AbstractCacheManager getCacheManager() {
        return this._cacheManager;
    }

    private String getUniqueCacheIdSuffix() {
        return this._uniqueCacheSuffix;
    }

    @Override
    public Collection<Cacheable.SingleCacheConfiguration> getManagedCaches() {
        return Arrays.asList(Cacheable.SingleCacheConfiguration.of(__LDAP_USERDIRECTORY_USER_BY_LOGIN_CACHE_NAME_PREFIX + this.getUniqueCacheIdSuffix(), this._buildI18n("PLUGINS_CORE_USERS_CACHE_BY_LOGIN_LABEL"), this._buildI18n("PLUGINS_CORE_USERS_CACHE_BY_LOGIN_DESC")), Cacheable.SingleCacheConfiguration.of(__LDAP_USERDIRECTORY_USER_BY_MAIL_CACHE_NAME_PREFIX + this.getUniqueCacheIdSuffix(), this._buildI18n("PLUGINS_CORE_USERS_CACHE_BY_MAIL_LABEL"), this._buildI18n("PLUGINS_CORE_USERS_CACHE_BY_MAIL_DESC")));
    }

    private I18nizableText _buildI18n(String i18nKey) {
        String catalogue = "plugin.core-impl";
        I18nizableText userDirectoryId = new I18nizableText(this.getPopulationId() + "#" + this.getId());
        Map<String, I18nizableTextParameter> labelParams = Map.of("type", new I18nizableText("LDAP"), "id", userDirectoryId);
        return new I18nizableText(catalogue, i18nKey, labelParams);
    }

    private Cache<String, StoredUser> getCacheByLogin() {
        return this.getCache(__LDAP_USERDIRECTORY_USER_BY_LOGIN_CACHE_NAME_PREFIX + this.getUniqueCacheIdSuffix());
    }

    private Cache<String, StoredUser> getCacheByMail() {
        return this.getCache(__LDAP_USERDIRECTORY_USER_BY_MAIL_CACHE_NAME_PREFIX + this.getUniqueCacheIdSuffix());
    }

    @Override
    public void init(String id, String udModelId, Map<String, Object> paramValues, String label) throws Exception {
        this._id = id;
        this._udModelId = udModelId;
        this._paramValues = paramValues;
        this._label = label;
        this._usersRelativeDN = (String)paramValues.get(PARAM_USERS_RELATIVE_DN);
        this._usersObjectFilter = (String)paramValues.get(PARAM_USERS_OBJECT_FILTER);
        this._usersSearchScope = ScopeEnumerator.parseScope((String)paramValues.get(PARAM_USERS_SEARCH_SCOPE));
        this._usersLoginAttribute = (String)paramValues.get(PARAM_USERS_LOGIN_ATTRIBUTE);
        this._usersFirstnameAttribute = (String)paramValues.get(PARAM_USERS_FIRSTNAME_ATTRIBUTE);
        if (this._usersFirstnameAttribute != null && this._usersFirstnameAttribute.length() == 0) {
            this._usersFirstnameAttribute = null;
        }
        this._usersLastnameAttribute = (String)paramValues.get(PARAM_USERS_LASTNAME_ATTRIBUTE);
        this._usersEmailAttribute = (String)paramValues.get(PARAM_USERS_EMAIL_ATTRIBUTE);
        this._userEmailIsMandatory = (Boolean)paramValues.get(PARAM_USERS_EMAIL_IS_MANDATORY);
        String dataSourceId = (String)paramValues.get(PARAM_DATASOURCE_ID);
        this._delayedInitialize(dataSourceId);
        this.createCaches();
    }

    @Override
    public void setPopulationId(String populationId) {
        this._populationId = populationId;
    }

    @Override
    public String getPopulationId() {
        return this._populationId;
    }

    @Override
    public Map<String, Object> getParameterValues() {
        return this._paramValues;
    }

    @Override
    public String getUserDirectoryModelId() {
        return this._udModelId;
    }

    @Override
    public Collection<StoredUser> getStoredUsers() {
        ArrayList<StoredUser> storedUsers = new ArrayList<StoredUser>();
        try {
            List<SearchResult> searchResult;
            try {
                searchResult = this._search(this._usersRelativeDN, this._usersObjectFilter, this._getSearchConstraint(0), false);
            }
            catch (IncompleteLDAPResultException e) {
                searchResult = (List<SearchResult>)e.getPartialResults();
                this.getLogger().warn("LDAP refused to return more than " + searchResult.size() + " results");
            }
            for (SearchResult result : searchResult) {
                try {
                    Map<String, Object> attributes = this._getAttributes(result);
                    if (attributes == null) continue;
                    StoredUser storedUser = this._createUser(attributes);
                    if (this.isCachingEnabled() && storedUser != null) {
                        String login = storedUser.getIdentifier();
                        if (!this.isCaseSensitive()) {
                            login = login.toLowerCase();
                        }
                        this.getCacheByLogin().put(login, storedUser);
                    }
                    storedUsers.add(storedUser);
                }
                catch (NamingException e) {
                    this.getLogger().error("Error of communication with ldap server on one user. Continuing", (Throwable)e);
                }
            }
        }
        catch (NamingException e) {
            this.getLogger().error("Error of communication with ldap server", (Throwable)e);
        }
        return storedUsers;
    }

    @Override
    public List<StoredUser> getStoredUsers(int count, int offset, Map<String, Object> parameters) {
        String pattern = (String)parameters.get("pattern");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)pattern)) {
            pattern = null;
        }
        if (count != 0) {
            LinkedHashMap<String, Map<String, Object>> entries = new LinkedHashMap<String, Map<String, Object>>();
            return this._internalGetUsers(entries, count, offset >= 0 ? offset : 0, pattern, 0);
        }
        return new ArrayList<StoredUser>();
    }

    @Override
    public StoredUser getStoredUserByEmail(String email) throws NotUniqueUserException {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)email)) {
            return null;
        }
        String lcEmail = email.toLowerCase();
        if (this.isCachingEnabled() && this.getCacheByMail().hasKey(lcEmail)) {
            StoredUser storedUser = this.getCacheByMail().get(lcEmail);
            return storedUser;
        }
        StoredUser storedUser = null;
        InitialDirContext context = null;
        NamingEnumeration<SearchResult> results = null;
        try {
            context = new InitialDirContext(this._getContextEnv());
            String filter = "(&" + this._usersObjectFilter + "(" + this._usersEmailAttribute + "={0}))";
            Object[] params = new Object[]{email};
            results = context.search(this._usersRelativeDN, filter, params, this._getSearchConstraint(0));
            if (results.hasMore()) {
                SearchResult result = results.next();
                Map<String, Object> attributes = this._getAttributes(result);
                if (attributes != null) {
                    storedUser = this._createUser(attributes);
                }
                if (results.hasMore()) {
                    throw new NotUniqueUserException("Multiple matches for attribute '" + this._usersEmailAttribute + "' and value = '" + email + "'");
                }
            }
            if (this.isCachingEnabled()) {
                this.getCacheByMail().put(lcEmail, storedUser);
            }
        }
        catch (PartialResultException e) {
            if (this._ldapFollowReferrals) {
                this.getLogger().warn("Error communicating with ldap server retrieving user with email '{}'", (Object)email, (Object)e);
            } else {
                this.getLogger().debug("Error communicating with ldap server retrieving user with email '{}'", (Object)email, (Object)e);
            }
        }
        catch (NamingException e) {
            throw new IllegalStateException("Error communicating with ldap server retrieving user with email '" + email + "'", e);
        }
        finally {
            this._cleanup(context, results);
        }
        return storedUser;
    }

    @Override
    public StoredUser getStoredUser(String login) {
        String csLogin = login;
        if (!this.isCaseSensitive()) {
            csLogin = csLogin.toLowerCase();
        }
        if (this.isCachingEnabled() && this.getCacheByLogin().hasKey(csLogin)) {
            StoredUser storedUser = this.getCacheByLogin().get(csLogin);
            return storedUser;
        }
        StoredUser storedUser = null;
        InitialDirContext context = null;
        NamingEnumeration<SearchResult> results = null;
        try {
            context = new InitialDirContext(this._getContextEnv());
            String filter = "(&" + this._usersObjectFilter + "(" + this._usersLoginAttribute + "={0}))";
            Object[] params = new Object[]{login};
            results = context.search(this._usersRelativeDN, filter, params, this._getSearchConstraint(0));
            while (results.hasMore()) {
                SearchResult result = results.next();
                Map<String, Object> attributes = this._getAttributes(result);
                if (attributes == null || this.isCaseSensitive() && !Strings.CS.equals(login, (String)attributes.get(this._usersLoginAttribute))) continue;
                if (storedUser != null) {
                    storedUser = null;
                    this.getLogger().error("Multiple matches for attribute '{}' and value = '{}'", (Object)this._usersLoginAttribute, (Object)login);
                    break;
                }
                storedUser = this._createUser(attributes);
            }
            if (this.isCachingEnabled()) {
                this.getCacheByLogin().put(csLogin, storedUser);
            }
        }
        catch (PartialResultException e) {
            if (this._ldapFollowReferrals) {
                this.getLogger().warn("Error communicating with ldap server retrieving user with login '{}'", (Object)login, (Object)e);
            } else {
                this.getLogger().debug("Error communicating with ldap server retrieving user with login '{}'", (Object)login, (Object)e);
            }
        }
        catch (NamingException e) {
            throw new IllegalStateException("Error communicating with ldap server retrieving user with login '" + login + "'", e);
        }
        finally {
            this._cleanup(context, results);
        }
        return storedUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserDirectory.CredentialsResult checkCredentials(String login, String password) {
        boolean authenticated = false;
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)password)) {
            String userDN = this.getUserDN(login);
            if (userDN != null) {
                InitialDirContext context = null;
                Hashtable<String, String> env = this._getContextEnv();
                env.put("java.naming.security.authentication", "simple");
                env.put("java.naming.security.principal", userDN);
                env.put("java.naming.security.credentials", password);
                try {
                    context = new InitialDirContext(env);
                    authenticated = true;
                }
                catch (AuthenticationException e) {
                    this.getLogger().info("Authentication failed", (Throwable)e);
                }
                catch (NamingException e) {
                    this.getLogger().error("Error communication with ldap server", (Throwable)e);
                }
                finally {
                    this._cleanup(context, null);
                }
            }
        } else if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("LDAP Authentication failed since no password (or an empty one) was given");
        }
        return authenticated ? UserDirectory.CredentialsResult.AUTHENTICATED : UserDirectory.CredentialsResult.NOT_AUTHENTICATED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserDN(String login) {
        String userDN = null;
        InitialDirContext context = null;
        NamingEnumeration<SearchResult> results = null;
        try {
            context = new InitialDirContext(this._getContextEnv());
            String filter = "(&" + this._usersObjectFilter + "(" + this._usersLoginAttribute + "={0}))";
            Object[] params = new Object[]{login};
            SearchControls constraints = new SearchControls();
            constraints.setSearchScope(this._usersSearchScope);
            constraints.setReturningAttributes(new String[0]);
            results = context.search(this._usersRelativeDN, filter, params, constraints);
            if (results.hasMore()) {
                SearchResult result = results.next();
                userDN = result.getName();
                if (result.isRelative()) {
                    NameParser parser = context.getNameParser("");
                    Name topDN = parser.parse(context.getNameInNamespace());
                    topDN.addAll(parser.parse(this._usersRelativeDN));
                    topDN.addAll(parser.parse(userDN));
                    userDN = topDN.toString();
                }
                if (results.hasMore()) {
                    userDN = null;
                    this.getLogger().error("Multiple matches for attribute \"{}\" and value = \"{}\"", (Object)this._usersLoginAttribute, (Object)login);
                }
            }
        }
        catch (NamingException e) {
            this.getLogger().error("Error communicating with ldap server retrieving user with login '" + login + "'", (Throwable)e);
        }
        finally {
            this._cleanup(context, results);
        }
        return userDN;
    }

    protected StoredUser _createUser(Map<String, Object> attributes) {
        if (attributes == null) {
            return null;
        }
        String login = (String)attributes.get(this._usersLoginAttribute);
        String userDn = (String)attributes.get("userDN");
        String lastName = (String)attributes.get(this._usersLastnameAttribute);
        String firstName = null;
        if (this._usersFirstnameAttribute != null) {
            firstName = (String)attributes.get(this._usersFirstnameAttribute);
        }
        String email = (String)attributes.get(this._usersEmailAttribute);
        return new StoredLdapUser(login, lastName, firstName, email, userDn);
    }

    @Override
    public UserIdentity getUserIdentity(StoredUser storedUser) {
        if (storedUser instanceof StoredLdapUser) {
            StoredLdapUser storedLdapUser = (StoredLdapUser)storedUser;
            return new LdapUserIdentity(storedUser.getIdentifier(), this._populationId, storedLdapUser.getDn());
        }
        return new UserIdentity(storedUser.getIdentifier(), this._populationId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<StoredUser> _internalGetUsers(Map<String, Map<String, Object>> entries, int count, int offset, String pattern, int possibleErrors) {
        List<StoredUser> list;
        InitialLdapContext context = null;
        NamingEnumeration<SearchResult> results = null;
        try {
            context = new InitialLdapContext(this._getContextEnv(), null);
            if (this._serverSideSorting) {
                context.setRequestControls(this._getSortControls());
            }
            Map<String, Object> filter = this._getPatternFilter(pattern);
            results = context.search(this._usersRelativeDN, (String)filter.get("filter"), (Object[])filter.get("params"), this._getSearchConstraint(count == -1 ? 0 : count + offset + possibleErrors));
            list = this._users(entries, count, offset, pattern, results, possibleErrors);
        }
        catch (NamingException e) {
            ArrayList<StoredUser> arrayList;
            try {
                this.getLogger().error("Error during the communication with ldap server", (Throwable)e);
                arrayList = new ArrayList<StoredUser>();
            }
            catch (Throwable throwable) {
                this._cleanup(context, results);
                throw throwable;
            }
            this._cleanup(context, results);
            return arrayList;
        }
        this._cleanup(context, results);
        return list;
    }

    private List<StoredUser> _users(Map<String, Map<String, Object>> entries, int count, int offset, String pattern, NamingEnumeration<SearchResult> results, int possibleErrors) throws NamingException {
        int nbResults = this._skipFirstResults(results, offset, pattern);
        if (nbResults < 0) {
            return new ArrayList<StoredUser>();
        }
        boolean exception = false;
        try {
            boolean hasMoreElement = results.hasMore();
            while ((count == -1 || entries.size() < count) && hasMoreElement) {
                ++nbResults;
                SearchResult result = results.next();
                Map<String, Object> attrs = this._getAttributes(result);
                if (attrs != null) {
                    entries.put((String)attrs.get(this._usersLoginAttribute), attrs);
                }
                hasMoreElement = results.hasMore();
            }
        }
        catch (SizeLimitExceededException e) {
            this.getLogger().warn("LDAP refused to return more than " + nbResults + " results");
            exception = true;
        }
        catch (PartialResultException e) {
            if (this._ldapFollowReferrals) {
                this.getLogger().warn("Error communicating with ldap server retrieving users with pattern '{}'", (Object)pattern, (Object)e);
            }
            this.getLogger().debug("Error communicating with ldap server retrieving users with pattern '{}'", (Object)pattern, (Object)e);
        }
        if (!exception && entries.size() < count && nbResults == count + offset + possibleErrors) {
            double nbErrors = count + possibleErrors - entries.size();
            double askedResultsSize = possibleErrors + count;
            int newPossibleErrors = Math.max(possibleErrors + count - entries.size(), (int)Math.ceil((nbErrors / askedResultsSize + 1.0) * nbErrors));
            return this._internalGetUsers(entries, count, offset, pattern, newPossibleErrors);
        }
        ArrayList<StoredUser> storedUsers = new ArrayList<StoredUser>();
        for (Map<String, Object> attributes : entries.values()) {
            storedUsers.add(this._createUser(attributes));
        }
        return storedUsers;
    }

    private int _skipFirstResults(NamingEnumeration<SearchResult> results, int offset, String pattern) throws NamingException {
        int nbResults;
        try {
            boolean hasMoreElement = results.hasMore();
            for (nbResults = 0; nbResults < offset && hasMoreElement; ++nbResults) {
                results.next();
                hasMoreElement = results.hasMore();
            }
        }
        catch (SizeLimitExceededException e) {
            this.getLogger().warn("LDAP refused to return more than " + nbResults + " results");
            return -1;
        }
        catch (PartialResultException e) {
            if (this._ldapFollowReferrals) {
                this.getLogger().warn("Error communicating with ldap server retrieving users with pattern '{}'", (Object)pattern, (Object)e);
            }
            this.getLogger().debug("Error communicating with ldap server retrieving users with pattern '{}'", (Object)pattern, (Object)e);
        }
        return nbResults;
    }

    protected Control[] _getSortControls() {
        try {
            SortControl sortControl = new SortControl(this.getSortByFields(), false);
            return new Control[]{sortControl};
        }
        catch (IOException e) {
            this.getLogger().warn("Cannot sort request on LDAP", (Throwable)e);
            return new Control[0];
        }
    }

    protected Map<String, Object> _getPatternFilter(String pattern) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (pattern == null) {
            result.put("filter", this._usersObjectFilter);
            result.put("params", new Object[0]);
        } else {
            StringBuffer filter = new StringBuffer("(&" + this._usersObjectFilter + "(|(");
            Object[] params = null;
            if (this._usersFirstnameAttribute == null) {
                filter.append(this._usersLoginAttribute);
                filter.append("=*{0}*)(");
                filter.append(this._usersLastnameAttribute);
                filter.append("=*{1}*)))");
                params = new Object[]{pattern, pattern};
            } else {
                filter.append(this._usersLoginAttribute);
                filter.append("=*{0}*)(");
                filter.append(this._usersFirstnameAttribute);
                filter.append("=*{1}*)(");
                filter.append(this._usersLastnameAttribute);
                filter.append("=*{2}*)))");
                params = new Object[]{pattern, pattern, pattern};
            }
            result.put("filter", filter.toString());
            result.put("params", params);
        }
        return result;
    }

    protected SearchControls _getSearchConstraint(int maxResults) {
        SearchControls constraints = new SearchControls();
        int attributesCount = 4;
        int index = 0;
        if (this._usersFirstnameAttribute == null) {
            --attributesCount;
        }
        String[] attrs = new String[attributesCount];
        attrs[index++] = this._usersLoginAttribute;
        if (this._usersFirstnameAttribute != null) {
            attrs[index++] = this._usersFirstnameAttribute;
        }
        attrs[index++] = this._usersLastnameAttribute;
        attrs[index++] = this._usersEmailAttribute;
        constraints.setReturningAttributes(attrs);
        constraints.setSearchScope(this._usersSearchScope);
        if (maxResults > 0) {
            constraints.setCountLimit(maxResults);
        }
        return constraints;
    }

    @Deprecated
    protected StoredUser _entry2User(Map<String, Object> attributes) {
        return this._createUser(attributes);
    }

    protected Map<String, Object> _getAttributes(SearchResult entry) throws NamingException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Attributes attrs = entry.getAttributes();
        result.put("userDN", entry.getNameInNamespace());
        Attribute ldapAttr = attrs.get(this._usersLoginAttribute);
        if (ldapAttr == null) {
            this.getLogger().warn("Missing login attribute : '{}'", (Object)this._usersLoginAttribute);
            return null;
        }
        result.put(this._usersLoginAttribute, ldapAttr.get());
        if (this._usersFirstnameAttribute != null) {
            ldapAttr = attrs.get(this._usersFirstnameAttribute);
            if (ldapAttr == null) {
                this.getLogger().warn("Missing firstname attribute : '{}', for user '{}'.", (Object)this._usersFirstnameAttribute, result.get(this._usersLoginAttribute));
                return null;
            }
            result.put(this._usersFirstnameAttribute, ldapAttr.get());
        }
        if ((ldapAttr = attrs.get(this._usersLastnameAttribute)) == null) {
            this.getLogger().warn("Missing lastname attribute : '{}', for user '{}'.", (Object)this._usersLastnameAttribute, result.get(this._usersLoginAttribute));
            return null;
        }
        result.put(this._usersLastnameAttribute, ldapAttr.get());
        ldapAttr = attrs.get(this._usersEmailAttribute);
        if (ldapAttr == null && this._userEmailIsMandatory) {
            this.getLogger().warn("Missing email attribute : '{}', for user '{}'.", (Object)this._usersEmailAttribute, result.get(this._usersLoginAttribute));
            return null;
        }
        if (ldapAttr == null) {
            result.put(this._usersEmailAttribute, "");
        } else {
            result.put(this._usersEmailAttribute, ldapAttr.get());
        }
        return result;
    }

    @Override
    protected String[] getSortByFields() {
        return new String[]{this._usersLastnameAttribute, this._usersFirstnameAttribute};
    }
}

