/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.user.directory;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.core.user.User;
import org.ametys.core.user.directory.NotUniqueUserException;
import org.ametys.core.user.directory.StoredUser;
import org.ametys.core.user.directory.UserDirectory;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;

public class StaticUserDirectory
extends AbstractLogEnabled
implements UserDirectory,
Component {
    private static final String __PARAM_USERS = "runtime.users.static.users";
    private Map<String, StoredUser> _staticUsers;
    private String _udModelId;
    private Map<String, Object> _paramValues;
    private String _populationId;
    private String _label;
    private String _id;
    private boolean _grantAllCredentials = true;

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public String getLabel() {
        return this._label;
    }

    @Override
    public void init(String id, String udModelId, Map<String, Object> paramValues, String label) {
        this._id = id;
        this._udModelId = udModelId;
        this._staticUsers = new HashMap<String, StoredUser>();
        this._label = label;
        this._paramValues = paramValues;
        String usersAsText = (String)paramValues.get(__PARAM_USERS);
        for (String userLine : usersAsText.split("\\n")) {
            StoredUser storedUser = this._createStoredUser(userLine);
            this._staticUsers.put(storedUser.getIdentifier(), storedUser);
        }
    }

    @Override
    public void setPopulationId(String populationId) {
        this._populationId = populationId;
    }

    @Override
    public String getPopulationId() {
        return this._populationId;
    }

    @Override
    public Map<String, Object> getParameterValues() {
        return this._paramValues;
    }

    public void setGrantAllCredentials(boolean grantAllCredentials) {
        this._grantAllCredentials = grantAllCredentials;
    }

    @Override
    public String getUserDirectoryModelId() {
        return this._udModelId;
    }

    @Override
    public Collection<StoredUser> getStoredUsers() {
        return this._staticUsers.values();
    }

    @Override
    public List<StoredUser> getStoredUsers(int count, int offset, Map<String, Object> parameters) {
        int toIndex;
        String pattern = (String)StringUtils.defaultIfEmpty((CharSequence)((String)parameters.get("pattern")), (CharSequence)"");
        boolean sort = (Boolean)parameters.getOrDefault("sort", false);
        int boundedCount = count >= 0 ? count : Integer.MAX_VALUE;
        int boundedOffset = offset >= 0 ? offset : 0;
        List result = this._staticUsers.values().stream().filter(user -> this._isLike((StoredUser)user, pattern)).collect(Collectors.toList());
        if (sort) {
            result.sort(Comparator.comparing(storedUser -> this._getSortableNameOfStoredUser((StoredUser)storedUser)));
        }
        toIndex = (toIndex = boundedOffset + boundedCount) > result.size() ? result.size() : toIndex;
        return result.subList(boundedOffset, toIndex);
    }

    private String _getSortableNameOfStoredUser(StoredUser storedUser) {
        String sortableName = Stream.of(storedUser.getLastName(), storedUser.getFirstName()).filter(StringUtils::isNotEmpty).collect(Collectors.joining(" "));
        return (String)StringUtils.defaultIfEmpty((CharSequence)sortableName, (CharSequence)storedUser.getIdentifier());
    }

    @Override
    public StoredUser getStoredUser(String login) {
        return this._staticUsers.get(login);
    }

    @Override
    public StoredUser getStoredUserByEmail(String email) throws NotUniqueUserException {
        if (StringUtils.isBlank((CharSequence)email)) {
            return null;
        }
        List storedUsers = this._staticUsers.values().stream().filter(user -> email.equalsIgnoreCase(user.getEmail())).collect(Collectors.toList());
        if (storedUsers.size() == 1) {
            return (StoredUser)storedUsers.get(0);
        }
        if (storedUsers.isEmpty()) {
            return null;
        }
        throw new NotUniqueUserException("Find " + storedUsers.size() + " users matching the email " + email);
    }

    @Override
    public UserDirectory.CredentialsResult checkCredentials(String login, String password) {
        return this._grantAllCredentials && this._staticUsers.containsKey(login) ? UserDirectory.CredentialsResult.AUTHENTICATED : UserDirectory.CredentialsResult.NOT_AUTHENTICATED;
    }

    private StoredUser _createStoredUser(String userLine) {
        String[] userInfo = userLine.split(":");
        String login = null;
        String lastName = null;
        String firstName = null;
        String email = null;
        switch (userInfo.length) {
            case 4: {
                email = userInfo[3];
            }
            case 3: {
                firstName = userInfo[2];
            }
            case 2: {
                lastName = userInfo[1];
                login = userInfo[0];
                break;
            }
            case 1: {
                lastName = login = userInfo[0];
                break;
            }
            default: {
                this.getLogger().error("Error while reading StaticUserDirectory users, cannot create a user with the data from line {}", (Object)userLine);
            }
        }
        return new StoredUser(login, lastName, firstName, email, null, User.UserCreationOrigin.SYSTEM);
    }

    private boolean _isLike(StoredUser storedUser, String pattern) {
        String modifiedPattern = StringUtils.stripAccents((String)pattern);
        return Strings.CI.contains((CharSequence)StringUtils.stripAccents((String)storedUser.getIdentifier()), (CharSequence)modifiedPattern) || Strings.CI.contains((CharSequence)StringUtils.stripAccents((String)storedUser.getFirstName()), (CharSequence)modifiedPattern) || Strings.CI.contains((CharSequence)StringUtils.stripAccents((String)storedUser.getLastName()), (CharSequence)modifiedPattern);
    }
}

