/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.userpref;

import java.time.ZonedDateTime;
import java.util.Map;
import org.ametys.core.datasource.dbtype.SQLDatabaseTypeExtensionPoint;
import org.ametys.core.model.type.ModelItemTypeExtensionPoint;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.userpref.DefaultUserPreferencesStorage;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.model.type.ElementType;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.commons.lang3.Strings;

public abstract class AbstractJdbcUserPreferencesStorage
extends AbstractLogEnabled
implements DefaultUserPreferencesStorage,
ThreadSafe,
Configurable,
Serviceable {
    protected SQLDatabaseTypeExtensionPoint _sqlDatabaseTypeExtensionPoint;
    protected ModelItemTypeExtensionPoint _userPreferenceTypeExtensionPoint;
    protected String _dataSourceId;
    protected String _databaseTable;

    public void service(ServiceManager manager) throws ServiceException {
        this._sqlDatabaseTypeExtensionPoint = (SQLDatabaseTypeExtensionPoint)manager.lookup(SQLDatabaseTypeExtensionPoint.ROLE);
        this._userPreferenceTypeExtensionPoint = (ModelItemTypeExtensionPoint)manager.lookup(ModelItemTypeExtensionPoint.ROLE_USER_PREFERENCES);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration dataSourceConf = configuration.getChild("datasource", false);
        if (dataSourceConf == null) {
            throw new ConfigurationException("The 'datasource' configuration node must be defined.", dataSourceConf);
        }
        String dataSourceConfParam = dataSourceConf.getValue();
        String dataSourceConfType = dataSourceConf.getAttribute("type", "config");
        this._dataSourceId = Strings.CS.equals(dataSourceConfType, "config") ? (String)Config.getInstance().getValue(dataSourceConfParam) : dataSourceConfParam;
        this._databaseTable = configuration.getChild("table").getValue();
    }

    @Override
    public String getUserPreferenceAsString(UserIdentity user, String storageContext, Map<String, String> contextVars, String id) throws UserPreferencesException {
        String value = null;
        Map values = this.getUnTypedUserPrefs(user, storageContext, contextVars);
        if (values.containsKey(id)) {
            value = (String)values.get(id);
        }
        return value;
    }

    @Override
    public Long getUserPreferenceAsLong(UserIdentity user, String storageContext, Map<String, String> contextVars, String id) throws UserPreferencesException {
        Long value = null;
        Map values = this.getUnTypedUserPrefs(user, storageContext, contextVars);
        if (values.containsKey(id)) {
            ElementType type = (ElementType)this._userPreferenceTypeExtensionPoint.getExtension("long");
            value = (Long)type.castValue(values.get(id));
        }
        return value;
    }

    @Override
    public ZonedDateTime getUserPreferenceAsDate(UserIdentity user, String storageContext, Map<String, String> contextVars, String id) throws UserPreferencesException {
        ZonedDateTime value = null;
        Map values = this.getUnTypedUserPrefs(user, storageContext, contextVars);
        if (values.containsKey(id)) {
            ElementType type = (ElementType)this._userPreferenceTypeExtensionPoint.getExtension("date");
            value = (ZonedDateTime)type.castValue(values.get(id));
        }
        return value;
    }

    @Override
    public Boolean getUserPreferenceAsBoolean(UserIdentity user, String storageContext, Map<String, String> contextVars, String id) throws UserPreferencesException {
        Boolean value = null;
        Map values = this.getUnTypedUserPrefs(user, storageContext, contextVars);
        if (values.containsKey(id)) {
            ElementType type = (ElementType)this._userPreferenceTypeExtensionPoint.getExtension("boolean");
            value = (Boolean)type.castValue(values.get(id));
        }
        return value;
    }

    @Override
    public Double getUserPreferenceAsDouble(UserIdentity user, String storageContext, Map<String, String> contextVars, String id) throws UserPreferencesException {
        Double value = null;
        Map values = this.getUnTypedUserPrefs(user, storageContext, contextVars);
        if (values.containsKey(id)) {
            ElementType type = (ElementType)this._userPreferenceTypeExtensionPoint.getExtension("double");
            value = (Double)type.castValue(values.get(id));
        }
        return value;
    }
}

