/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.userpref;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.ametys.core.datasource.ConnectionHelper;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.plugins.core.impl.userpref.AbstractJdbcUserPreferencesStorage;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class JdbcPlainUserPreferencesStorage
extends AbstractJdbcUserPreferencesStorage {
    protected String _loginColumn;
    protected String _populationColumn;
    protected String _contextColumn;
    protected Pattern _columnPattern;
    protected Map<String, String> _prefIdToColumn;
    protected Map<String, String> _columnToPrefId;
    protected Map<String, Integer> _columnToType;

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        String regex;
        super.configure(configuration);
        this._loginColumn = configuration.getChild("loginColumn").getValue("login").toLowerCase();
        this._populationColumn = configuration.getChild("populationColumn").getValue("population").toLowerCase();
        this._contextColumn = configuration.getChild("contextColumn").getValue(null);
        if (this._contextColumn != null) {
            this._contextColumn = this._contextColumn.toLowerCase();
        }
        this._columnPattern = StringUtils.isBlank((CharSequence)(regex = configuration.getChild("columnPattern").getValue(null))) ? null : Pattern.compile(regex, 2);
        this.configureMappings(configuration.getChild("mappings"));
    }

    public void configureMappings(Configuration configuration) throws ConfigurationException {
        this._prefIdToColumn = new HashMap<String, String>();
        this._columnToPrefId = new HashMap<String, String>();
        for (Configuration mappingConf : configuration.getChildren("mapping")) {
            String prefId = mappingConf.getAttribute("prefId");
            String column = mappingConf.getAttribute("column").toLowerCase();
            this._prefIdToColumn.put(prefId, column);
            this._columnToPrefId.put(column, prefId);
        }
    }

    private synchronized Map<String, Integer> _getColumnTypes(Connection connection) throws UserPreferencesException {
        if (this._columnToType != null) {
            return this._columnToType;
        }
        this._columnToType = new HashMap<String, Integer>();
        try {
            DatabaseMetaData metadata = connection.getMetaData();
            try (ResultSet rs = metadata.getColumns(connection.getCatalog(), connection.getSchema(), this._databaseTable, null);){
                while (rs.next()) {
                    String name = rs.getString("COLUMN_NAME");
                    if (!this.isColumnValid(name)) continue;
                    int type = rs.getInt("DATA_TYPE");
                    this._columnToType.put(name.toLowerCase(), type);
                }
            }
            return this._columnToType;
        }
        catch (SQLException e) {
            throw new UserPreferencesException("Database error trying to access the preferences' types. [" + this._dataSourceId + "." + this._databaseTable + "].", e);
        }
    }

    @Override
    public Map<String, String> getUnTypedUserPrefs(UserIdentity user, String storageContext, Map<String, String> contextVars) throws UserPreferencesException {
        HashMap<String, String> hashMap;
        HashMap<String, String> prefs = new HashMap<String, String>();
        Connection connection = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            connection = ConnectionHelper.getConnection(this._dataSourceId);
            String dbType = ConnectionHelper.getDatabaseType(connection);
            StringBuilder query = new StringBuilder();
            query.append("SELECT * FROM ").append(this._sqlDatabaseTypeExtensionPoint.languageEscapeTableName(dbType, this._databaseTable)).append(" WHERE ").append(this._loginColumn).append(" = ? AND ").append(this._populationColumn).append(" = ?");
            if (StringUtils.isNotBlank((CharSequence)this._contextColumn)) {
                query.append(" AND ").append(this._contextColumn).append(" = ?");
            }
            stmt = connection.prepareStatement(query.toString());
            stmt.setString(1, user.getLogin());
            stmt.setString(2, user.getPopulationId());
            if (StringUtils.isNotBlank((CharSequence)this._contextColumn)) {
                stmt.setString(3, storageContext);
            }
            if ((rs = stmt.executeQuery()).next()) {
                ResultSetMetaData metaData = rs.getMetaData();
                int colCount = metaData.getColumnCount();
                for (int col = 1; col <= colCount; ++col) {
                    String name = metaData.getColumnName(col).toLowerCase();
                    if (!this.isColumnValid(name)) continue;
                    int type = metaData.getColumnType(col);
                    String value = null;
                    try {
                        value = this.getPreferenceValue(rs, col, type, dbType);
                    }
                    catch (IOException | SQLException e) {
                        String message = "Database error trying to get the preference '" + name + "' for the user '" + String.valueOf(user) + "' in context '" + storageContext + "' [" + this._dataSourceId + "." + this._databaseTable + "].";
                        this.getLogger().error(message, (Throwable)e);
                    }
                    if (value == null) continue;
                    String prefId = this._columnToPrefId.containsKey(name) ? this._columnToPrefId.get(name) : name;
                    prefs.put(prefId, value);
                }
            }
            hashMap = prefs;
        }
        catch (SQLException e) {
            try {
                String message = "Database error trying to access the preferences of user '" + String.valueOf(user) + "' in context '" + storageContext + "'.[" + this._dataSourceId + "." + this._databaseTable + "].";
                this.getLogger().error(message, (Throwable)e);
                throw new UserPreferencesException(message, e);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(rs);
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup(connection);
                throw throwable;
            }
        }
        ConnectionHelper.cleanup(rs);
        ConnectionHelper.cleanup(stmt);
        ConnectionHelper.cleanup(connection);
        return hashMap;
    }

    @Override
    public void removeUserPreferences(UserIdentity user, String storageContext, Map<String, String> contextVars) throws UserPreferencesException {
        Connection connection = null;
        PreparedStatement stmt = null;
        try {
            connection = ConnectionHelper.getConnection(this._dataSourceId);
            String dbType = ConnectionHelper.getDatabaseType(connection);
            StringBuilder query = new StringBuilder();
            query.append("DELETE FROM ").append(this._sqlDatabaseTypeExtensionPoint.languageEscapeTableName(dbType, this._databaseTable)).append(" WHERE ").append(this._loginColumn).append(" = ? AND ").append(this._populationColumn).append(" = ?");
            if (StringUtils.isNotBlank((CharSequence)this._contextColumn) && storageContext != null) {
                query.append(" AND ").append(this._contextColumn).append(" = ?");
            }
            stmt = connection.prepareStatement(query.toString());
            stmt.setString(1, user.getLogin());
            stmt.setString(2, user.getPopulationId());
            if (StringUtils.isNotBlank((CharSequence)this._contextColumn) && storageContext != null) {
                stmt.setString(3, storageContext);
            }
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                String message = "Database error trying to remove preferences for login '" + String.valueOf(user) + "' in context '" + storageContext + "'. [" + this._dataSourceId + "." + this._databaseTable + "].";
                this.getLogger().error(message, (Throwable)e);
                throw new UserPreferencesException(message, e);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup(connection);
                throw throwable;
            }
        }
        ConnectionHelper.cleanup(stmt);
        ConnectionHelper.cleanup(connection);
    }

    @Override
    public void setUserPreferences(UserIdentity user, String storageContext, Map<String, String> contextVars, Map<String, String> preferences) throws UserPreferencesException {
        Connection connection = null;
        try {
            connection = ConnectionHelper.getConnection(this._dataSourceId);
            if (this.dataExists(connection, user, storageContext)) {
                this.updatePreferences(connection, preferences, user, storageContext);
            } else {
                this.insertPreferences(connection, preferences, user, storageContext);
            }
        }
        catch (SQLException e) {
            String message = "Database error trying to set the preferences of user '" + String.valueOf(user) + "' in context '" + storageContext + "'. [" + this._dataSourceId + "." + this._databaseTable + "].";
            this.getLogger().error(message, (Throwable)e);
            throw new UserPreferencesException(message, e);
        }
        finally {
            ConnectionHelper.cleanup(connection);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getUserPreferenceAsString(UserIdentity user, String storageContext, Map<String, String> contextVars, String id) throws UserPreferencesException {
        String value;
        ResultSet rs;
        PreparedStatement statement;
        Connection connection;
        block15: {
            connection = null;
            statement = null;
            rs = null;
            value = null;
            try {
                String column;
                String string = column = this._prefIdToColumn.containsKey(id) ? this._prefIdToColumn.get(id) : id;
                if (!this.isColumnValid(column)) break block15;
                connection = ConnectionHelper.getConnection(this._dataSourceId);
                String dbType = ConnectionHelper.getDatabaseType(connection);
                StringBuilder query = new StringBuilder();
                query.append("SELECT " + column + " FROM ").append(this._sqlDatabaseTypeExtensionPoint.languageEscapeTableName(dbType, this._databaseTable)).append(" WHERE ").append(this._loginColumn).append(" = ? AND ").append(this._populationColumn).append(" = ?");
                if (StringUtils.isNotBlank((CharSequence)this._contextColumn)) {
                    query.append(" AND ").append(this._contextColumn).append(" = ?");
                }
                statement = connection.prepareStatement(query.toString());
                statement.setString(1, user.getLogin());
                statement.setString(2, user.getPopulationId());
                if (StringUtils.isNotBlank((CharSequence)this._contextColumn)) {
                    statement.setString(3, storageContext);
                }
                rs = statement.executeQuery();
                ResultSetMetaData metaData = rs.getMetaData();
                int type = metaData.getColumnType(1);
                if (!rs.next()) break block15;
                if (type == 2004) {
                    try (InputStream dataIs = this._sqlDatabaseTypeExtensionPoint.getBlob(dbType, rs, column);){
                        if (dataIs != null) {
                            value = IOUtils.toString((InputStream)dataIs, (Charset)StandardCharsets.UTF_8);
                        }
                        break block15;
                    }
                }
                value = rs.getString(1);
            }
            catch (SQLException e) {
                try {
                    String message = "Database error trying to get the preferences of user '" + String.valueOf(user) + "' in context '" + storageContext + "'. [" + this._dataSourceId + "." + this._databaseTable + "].";
                    this.getLogger().error(message, (Throwable)e);
                    throw new UserPreferencesException(message, e);
                    catch (IOException e2) {
                        message = "Error trying to convert the preferences of user '" + String.valueOf(user) + "' in context '" + storageContext + "'. [" + this._dataSourceId + "." + this._databaseTable + "].";
                        this.getLogger().error(message, (Throwable)e2);
                        throw new UserPreferencesException(message, e2);
                    }
                }
                catch (Throwable throwable) {
                    ConnectionHelper.cleanup(rs);
                    ConnectionHelper.cleanup(statement);
                    ConnectionHelper.cleanup(connection);
                    throw throwable;
                }
            }
        }
        ConnectionHelper.cleanup(rs);
        ConnectionHelper.cleanup(statement);
        ConnectionHelper.cleanup(connection);
        return value;
    }

    protected boolean isColumnValid(String name) {
        return !(this._loginColumn.equalsIgnoreCase(name) || this._contextColumn != null && this._contextColumn.equalsIgnoreCase(name) || this._columnPattern != null && !this._columnPattern.matcher(name).matches());
    }

    protected String getPreferenceValue(ResultSet rs, int columnIndex, int jdbcType, String dbType) throws SQLException, IOException {
        String value = null;
        switch (jdbcType) {
            case -15: 
            case -9: 
            case -6: 
            case -5: 
            case -4: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 91: 
            case 92: 
            case 93: {
                value = rs.getString(columnIndex);
                break;
            }
            case 2004: {
                try (InputStream dataIs = this._sqlDatabaseTypeExtensionPoint.getBlob(dbType, rs, columnIndex);){
                    if (dataIs == null) break;
                    value = IOUtils.toString((InputStream)dataIs, (Charset)StandardCharsets.UTF_8);
                    break;
                }
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dataExists(Connection connection, UserIdentity user, String storageContext) throws SQLException {
        boolean bl;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            StringBuilder query = new StringBuilder();
            String dbType = ConnectionHelper.getDatabaseType(connection);
            query.append("SELECT count(*) FROM ").append(this._sqlDatabaseTypeExtensionPoint.languageEscapeTableName(dbType, this._databaseTable)).append(" WHERE ").append(this._loginColumn).append(" = ? AND ").append(this._populationColumn).append(" = ?");
            if (StringUtils.isNotBlank((CharSequence)this._contextColumn)) {
                query.append(" AND ").append(this._contextColumn).append(" = ?");
            }
            stmt = connection.prepareStatement(query.toString());
            stmt.setString(1, user.getLogin());
            stmt.setString(2, user.getPopulationId());
            if (StringUtils.isNotBlank((CharSequence)this._contextColumn)) {
                stmt.setString(3, storageContext);
            }
            rs = stmt.executeQuery();
            rs.next();
            bl = rs.getInt(1) > 0;
        }
        catch (Throwable throwable) {
            ConnectionHelper.cleanup(rs);
            ConnectionHelper.cleanup(stmt);
            throw throwable;
        }
        ConnectionHelper.cleanup(rs);
        ConnectionHelper.cleanup(stmt);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertPreferences(Connection connection, Map<String, String> preferences, UserIdentity user, String storageContext) throws SQLException, UserPreferencesException {
        PreparedStatement stmt = null;
        try {
            String dbType = ConnectionHelper.getDatabaseType(connection);
            StringBuilder query = new StringBuilder();
            StringBuilder values = new StringBuilder();
            query.append("INSERT INTO ").append(this._sqlDatabaseTypeExtensionPoint.languageEscapeTableName(dbType, this._databaseTable)).append("(").append(this._loginColumn).append(", ").append(this._populationColumn);
            values.append("?, ?");
            if (StringUtils.isNotBlank((CharSequence)this._contextColumn)) {
                query.append(", ").append(this._contextColumn);
                values.append(", ?");
            }
            ArrayList<String> valuesToSet = new ArrayList<String>();
            ArrayList<byte[]> blobsToSet = new ArrayList<byte[]>();
            Map<String, Integer> columnToType = this._getColumnTypes(connection);
            int validPrefCount = 0;
            for (String prefId : preferences.keySet()) {
                String column = this._prefIdToColumn.containsKey(prefId) ? this._prefIdToColumn.get(prefId) : prefId;
                if (!this.isColumnValid(column)) continue;
                if (columnToType.get(column) == 2004) {
                    blobsToSet.add(StringUtils.defaultString((String)preferences.get(prefId)).getBytes(StandardCharsets.UTF_8));
                } else {
                    valuesToSet.add(preferences.get(prefId));
                }
                query.append(", ").append(column);
                values.append(", ?");
                ++validPrefCount;
            }
            if (validPrefCount > 0) {
                query.append(") VALUES (").append((CharSequence)values).append(')');
                int i = 1;
                stmt = connection.prepareStatement(query.toString());
                stmt.setString(i++, user.getLogin());
                stmt.setString(i++, user.getPopulationId());
                if (StringUtils.isNotBlank((CharSequence)this._contextColumn)) {
                    stmt.setString(i++, storageContext);
                }
                for (String value : valuesToSet) {
                    stmt.setString(i, value);
                    ++i;
                }
                for (byte[] prefBytes : blobsToSet) {
                    this._sqlDatabaseTypeExtensionPoint.setBlob(dbType, stmt, i, prefBytes);
                    ++i;
                }
                stmt.executeUpdate();
            }
        }
        finally {
            ConnectionHelper.cleanup(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatePreferences(Connection connection, Map<String, String> preferences, UserIdentity user, String storageContext) throws SQLException, UserPreferencesException {
        PreparedStatement stmt = null;
        try {
            String dbType = ConnectionHelper.getDatabaseType(connection);
            StringBuilder query = new StringBuilder();
            query.append("UPDATE ").append(this._sqlDatabaseTypeExtensionPoint.languageEscapeTableName(dbType, this._databaseTable)).append(" SET ");
            ArrayList<String> valuesToSet = new ArrayList<String>();
            ArrayList<byte[]> blobsToSet = new ArrayList<byte[]>();
            Map<String, Integer> columnToType = this._getColumnTypes(connection);
            int validPrefCount = 0;
            for (String prefId : preferences.keySet()) {
                String column = this._prefIdToColumn.containsKey(prefId) ? this._prefIdToColumn.get(prefId) : prefId;
                if (!this.isColumnValid(column)) continue;
                if (columnToType.get(column) == 2004) {
                    blobsToSet.add(StringUtils.defaultString((String)preferences.get(prefId)).getBytes(StandardCharsets.UTF_8));
                } else {
                    valuesToSet.add(preferences.get(prefId));
                }
                if (validPrefCount > 0) {
                    query.append(", ");
                }
                query.append(" ").append(column).append(" = ?");
                ++validPrefCount;
            }
            query.append(" WHERE ").append(this._loginColumn).append(" = ?").append(" AND ").append(this._populationColumn).append(" = ?");
            if (StringUtils.isNotBlank((CharSequence)this._contextColumn)) {
                query.append(" AND ").append(this._contextColumn).append(" = ?");
            }
            if (validPrefCount > 0) {
                stmt = connection.prepareStatement(query.toString());
                int i = 1;
                for (String value : valuesToSet) {
                    stmt.setString(i, value);
                    ++i;
                }
                for (byte[] prefBytes : blobsToSet) {
                    this._sqlDatabaseTypeExtensionPoint.setBlob(dbType, stmt, i, prefBytes);
                    ++i;
                }
                stmt.setString(i++, user.getLogin());
                stmt.setString(i++, user.getPopulationId());
                if (StringUtils.isNotBlank((CharSequence)this._contextColumn)) {
                    stmt.setString(i++, storageContext);
                }
                stmt.executeUpdate();
            }
        }
        finally {
            ConnectionHelper.cleanup(stmt);
        }
    }
}

