/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.userpref;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import org.ametys.core.model.type.ModelItemTypeExtensionPoint;
import org.ametys.core.userpref.UserPreference;
import org.ametys.core.userpref.UserPreferenceProvider;
import org.ametys.core.util.UsersAndGroupsDataDisableConditions;
import org.ametys.runtime.model.AbstractElementDefinitionParser;
import org.ametys.runtime.model.Enumerator;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelItemGroup;
import org.ametys.runtime.model.disableconditions.DisableConditions;
import org.ametys.runtime.parameter.Validator;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.plugin.component.PluginAware;
import org.ametys.runtime.plugin.component.ThreadSafeComponentManager;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class StaticUserPreferenceProvider
extends AbstractLogEnabled
implements UserPreferenceProvider,
Contextualizable,
Serviceable,
Configurable,
PluginAware,
Disposable {
    protected Map<String, UserPreference> _preferences;
    protected ThreadSafeComponentManager<DisableConditions> _disableConditionsManager;
    protected ThreadSafeComponentManager<Validator> _validatorManager;
    protected ThreadSafeComponentManager<Enumerator> _enumeratorManager;
    protected ModelItemTypeExtensionPoint _userPreferenceTypeExtensionPoint;
    protected ServiceManager _serviceManager;
    protected Context _context;
    protected String _pluginName;

    @Override
    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._serviceManager = manager;
        this._userPreferenceTypeExtensionPoint = (ModelItemTypeExtensionPoint)this._serviceManager.lookup(ModelItemTypeExtensionPoint.ROLE_USER_PREFERENCES);
    }

    public void dispose() {
        this._disableConditionsManager.dispose();
        this._disableConditionsManager = null;
        this._validatorManager.dispose();
        this._validatorManager = null;
        this._enumeratorManager.dispose();
        this._enumeratorManager = null;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration[] userPrefenceConfigurations;
        this._disableConditionsManager = new ThreadSafeComponentManager();
        this._disableConditionsManager.setLogger(this.getLogger());
        this._disableConditionsManager.contextualize(this._context);
        this._disableConditionsManager.service(this._serviceManager);
        this._validatorManager = new ThreadSafeComponentManager();
        this._validatorManager.setLogger(this.getLogger());
        this._validatorManager.contextualize(this._context);
        this._validatorManager.service(this._serviceManager);
        this._enumeratorManager = new ThreadSafeComponentManager();
        this._enumeratorManager.setLogger(this.getLogger());
        this._enumeratorManager.contextualize(this._context);
        this._enumeratorManager.service(this._serviceManager);
        UserPreferenceParser userPreferenceParser = new UserPreferenceParser(this._userPreferenceTypeExtensionPoint, this._disableConditionsManager, this._enumeratorManager, this._validatorManager);
        this._preferences = new HashMap<String, UserPreference>();
        for (Configuration userPrefenceConfiguration : userPrefenceConfigurations = configuration.getChildren("param")) {
            this.configurePreference(userPreferenceParser, userPrefenceConfiguration);
        }
        try {
            userPreferenceParser.lookupComponents();
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to lookup parameter local components", configuration, (Throwable)e);
        }
    }

    protected void configurePreference(UserPreferenceParser userPreferenceParser, Configuration configuration) throws ConfigurationException {
        UserPreference preference = (UserPreference)userPreferenceParser.parse(this._serviceManager, this._pluginName, configuration, null, null);
        String userPreferenceName = preference.getName();
        if (this._preferences.containsKey(userPreferenceName)) {
            throw new ConfigurationException("The user preference '" + userPreferenceName + "' is already declared. Preference IDs must be unique.", configuration);
        }
        this._preferences.put(userPreferenceName, preference);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("User preference added: " + userPreferenceName);
        }
    }

    @Override
    public Collection<UserPreference> getPreferences(Map<String, String> context) {
        HashSet<UserPreference> userPreferences = new HashSet<UserPreference>();
        String currentWorkspace = context.get("workspace");
        for (UserPreference userPreference : this._preferences.values()) {
            Pattern workspace = ((StaticUserPreference)userPreference).getWorkspace();
            if (!StringUtils.isBlank((CharSequence)currentWorkspace) && workspace != null && !workspace.matcher(currentWorkspace).matches()) continue;
            userPreferences.add(userPreference);
        }
        return userPreferences;
    }

    class UserPreferenceParser
    extends AbstractElementDefinitionParser<UsersAndGroupsDataDisableConditions> {
        public UserPreferenceParser(ModelItemTypeExtensionPoint modelItemTypeExtensionPoint, ThreadSafeComponentManager<DisableConditions> disableConditionsManager, ThreadSafeComponentManager<Enumerator> enumeratorManager, ThreadSafeComponentManager<Validator> validatorManager) {
            super(modelItemTypeExtensionPoint, disableConditionsManager, enumeratorManager, validatorManager);
        }

        @Override
        public UserPreference parse(ServiceManager serviceManager, String pluginName, String catalog, Configuration userPreferenceConfig, Model model, ModelItemGroup parent) throws ConfigurationException {
            UserPreference userPreference = (UserPreference)super.parse(serviceManager, pluginName, catalog, userPreferenceConfig, model, parent);
            userPreference.setManagerRole(this._parseManagerRole(userPreferenceConfig));
            userPreference.setPrivate(this._parsePrivate(userPreferenceConfig));
            userPreference.setDisplayGroup(this._parseI18nizableText(userPreferenceConfig, catalog, "group"));
            userPreference.setPosition(userPreferenceConfig.getChild("order").getValueAsLong(-1L));
            ((StaticUserPreference)userPreference).setWorkspace(this._parseWorkspace(userPreferenceConfig));
            return userPreference;
        }

        @Override
        protected UserPreference _createModelItem(Configuration userPreferenceConfig) throws ConfigurationException {
            return new StaticUserPreference(StaticUserPreferenceProvider.this);
        }

        @Override
        protected String _getNameConfigurationAttribute() {
            return "id";
        }

        protected String _parseManagerRole(Configuration userPreferenceConfig) throws ConfigurationException {
            return userPreferenceConfig.getChild("manager-role").getValue(null);
        }

        protected Boolean _parsePrivate(Configuration userPreferenceConfig) throws ConfigurationException {
            return userPreferenceConfig.getAttributeAsBoolean("private", false);
        }

        protected Pattern _parseWorkspace(Configuration userPreferenceConfig) throws ConfigurationException {
            String value = userPreferenceConfig.getChild("workspace").getValue(null);
            if (StringUtils.isNotBlank((CharSequence)value)) {
                return Pattern.compile(value);
            }
            return null;
        }
    }

    class StaticUserPreference<T>
    extends UserPreference<T> {
        protected Pattern _workspace;

        StaticUserPreference(StaticUserPreferenceProvider this$0) {
        }

        public void setWorkspace(Pattern workspace) {
            this._workspace = workspace;
        }

        public Pattern getWorkspace() {
            return this._workspace;
        }
    }
}

