/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.userpref.type.impl;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ametys.core.model.type.BaseDateTimeElementType;
import org.ametys.core.util.DateUtils;
import org.ametys.runtime.model.exception.BadItemTypeException;
import org.ametys.runtime.model.type.DataContext;

public class DateUserPreferenceType
extends BaseDateTimeElementType {
    protected static final List<DateTimeFormatter> _INPUT_DATE_FORMATTERS = new ArrayList<DateTimeFormatter>();

    @Override
    protected ZonedDateTime _singleValueFromJSON(Object json, DataContext context) throws BadItemTypeException {
        if (json instanceof String) {
            String str = (String)json;
            ZonedDateTime date = null;
            for (DateTimeFormatter formatter : _INPUT_DATE_FORMATTERS) {
                try {
                    LocalDate localDate = DateUtils.parseLocalDate(str, Optional.of(formatter));
                    date = DateUtils.asZonedDateTime(localDate, (ZoneId)ZoneOffset.UTC);
                    return date;
                }
                catch (Exception exception) {
                }
            }
            return date;
        }
        return (ZonedDateTime)super._singleValueFromJSON(json, context);
    }

    static {
        _INPUT_DATE_FORMATTERS.add(DateTimeFormatter.ISO_LOCAL_DATE);
        _INPUT_DATE_FORMATTERS.add(new DateTimeFormatterBuilder().appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('/').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('/').appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).toFormatter().withResolverStyle(ResolverStyle.STRICT).withChronology(IsoChronology.INSTANCE));
    }
}

