/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.version;

import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import javax.xml.parsers.SAXParserFactory;
import org.ametys.core.version.Version;
import org.ametys.core.version.VersionsHandler;
import org.ametys.runtime.servlet.RuntimeConfig;
import org.ametys.runtime.util.MapHandler;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultVersionsHandler
extends AbstractLogEnabled
implements VersionsHandler,
ThreadSafe {
    private Version _ametysVersion;
    private Version _applicationVersion;

    @Override
    public final Collection<Version> getVersions() {
        ArrayList<Version> versions = new ArrayList<Version>();
        if (this._applicationVersion == null) {
            this._applicationVersion = this._getApplicationVersion();
        }
        if (this._ametysVersion == null) {
            this._ametysVersion = this._getVersionFromClasspath("/org/ametys/runtime/kernel/version.xml", "Ametys");
        }
        versions.add(this._applicationVersion);
        Collection<Version> additionalVersions = this.getAdditionalVersions();
        if (additionalVersions != null) {
            versions.addAll(additionalVersions);
        }
        versions.add(this._ametysVersion);
        return versions;
    }

    protected Collection<Version> getAdditionalVersions() {
        return null;
    }

    private Version _getApplicationVersion() {
        RuntimeConfig config = RuntimeConfig.getInstance();
        return new Version("Application", config.getApplicationVersion(), config.getApplicationBuildDate());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final Version _getVersionFromClasspath(String path, String versionName) {
        HashMap<String, String> config = new HashMap<String, String>();
        Date date = null;
        try (InputStream is = this.getClass().getResourceAsStream(path);){
            if (is == null) {
                this.getLogger().warn(versionName + " version is unavailable");
                Version version = new Version(versionName, null, null);
                return version;
            }
            SAXParserFactory.newInstance().newSAXParser().parse(is, (DefaultHandler)new MapHandler(config));
            String strDate = (String)config.get("date");
            date = new SimpleDateFormat("yyyyMMdd'T'HHmmz").parse(strDate);
            return new Version(versionName, (String)config.get("version"), date);
        }
        catch (Exception ex) {
            this.getLogger().warn("Unable to get version number for " + versionName, (Throwable)ex);
        }
        return new Version(versionName, (String)config.get("version"), date);
    }
}

