/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.right;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.right.Right;
import org.ametys.core.right.RightsExtensionPoint;
import org.ametys.core.util.I18nUtils;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;

public class GetRightsAction
extends ServiceableAction {
    private RightsExtensionPoint _rights;
    private I18nUtils _i18nUtils;

    public void service(ServiceManager m) throws ServiceException {
        super.service(m);
        this._rights = (RightsExtensionPoint)m.lookup(RightsExtensionPoint.ROLE);
        this._i18nUtils = (I18nUtils)((Object)m.lookup(I18nUtils.ROLE));
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Object right;
        Map jsParameters = (Map)objectModel.get("parent-context");
        HashMap result = new HashMap();
        ArrayList<Object> rights = new ArrayList<Object>();
        String rightQuery = (String)jsParameters.get("query");
        boolean includeReader = jsParameters.getOrDefault("includeReader", false);
        if (includeReader) {
            String id = "READER";
            I18nizableText label = new I18nizableText("plugin.core", "PLUGINS_CORE_RIGHTS_READER_LABEL");
            I18nizableText description = new I18nizableText("plugin.core", "PLUGINS_CORE_RIGHTS_READER_DESCRIPTION");
            if (StringUtils.isEmpty((CharSequence)rightQuery) || this._matchesFilter(id, label, description, rightQuery)) {
                right = new HashMap();
                right.put("id", id);
                right.put("label", label);
                right.put("description", description);
                right.put("category", new I18nizableText("plugin.core", "PLUGINS_CORE_RIGHTS_READER_CATEGORY"));
                rights.add(right);
            }
        }
        Set<String> rightIds = this._rights.getExtensionsIds();
        for (String rightId : rightIds) {
            right = this._rights.getExtension(rightId);
            if (!StringUtils.isEmpty((CharSequence)rightQuery) && !this._matchesFilter(rightId, ((Right)right).getLabel(), ((Right)right).getDescription(), rightQuery)) continue;
            rights.add(((Right)right).toJSON());
        }
        result.put("rights", rights);
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }

    private boolean _matchesFilter(String id, I18nizableText label, I18nizableText description, String filter) {
        String normalizedFilter = StringUtils.stripAccents((String)filter.toLowerCase());
        String normalizedId = id.toLowerCase();
        String normalizedLabel = StringUtils.stripAccents((String)StringUtils.defaultString((String)this._i18nUtils.translate(label)).toLowerCase());
        String normalizedDescription = StringUtils.stripAccents((String)StringUtils.defaultString((String)this._i18nUtils.translate(description)).toLowerCase());
        return normalizedId.contains(normalizedFilter) || normalizedLabel.contains(normalizedFilter) || normalizedDescription.contains(normalizedFilter);
    }
}

