/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.right;

import java.util.Map;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.cocoon.AbstractCurrentUserProviderServiceableAction;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.SourceResolver;

public class HasRightAction
extends AbstractCurrentUserProviderServiceableAction
implements Configurable {
    protected RightManager _rightManager;
    protected boolean _hasRight;
    protected String _baseContext;

    public void configure(Configuration configuration) throws ConfigurationException {
        this._hasRight = "true".equals(configuration.getChild("has-right").getValue("true"));
        this._baseContext = configuration.getChild("base-context").getValue("");
    }

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._rightManager = (RightManager)this.manager.lookup(RightManager.ROLE);
    }

    protected String getBaseContext(Parameters parameters, Map objectModel) {
        return this._baseContext;
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        UserIdentity user;
        boolean hasRight = false;
        String context = parameters.getParameter("context", null);
        if (context == null || "".equals(context)) {
            context = this.getBaseContext(parameters, objectModel);
        }
        if ((user = this._getCurrentUser()) == null) {
            throw new AccessDeniedException("Anonymous user tried to access a privileged feature without convenient right. Should have in right between those : '" + source + "' on context '" + context + "'");
        }
        String[] rights = source.split("\\|");
        for (int i = 0; i < rights.length; ++i) {
            String right = rights[i].trim();
            if (this._rightManager.hasRight(user, right, context) != RightManager.RightResult.RIGHT_ALLOW) continue;
            hasRight = true;
        }
        if (hasRight) {
            if (this._hasRight) {
                return EMPTY_MAP;
            }
            return null;
        }
        if (this._hasRight) {
            return null;
        }
        throw new AccessDeniedException("User '" + String.valueOf(user) + "' tried to access a privileged feature without convenient right. Should have in right between those : '" + source + "' on context '" + context + "'");
    }
}

