/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.right;

import java.io.IOException;
import org.ametys.core.right.Profile;
import org.ametys.core.right.RightProfilesDAO;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ProfilesListGenerator
extends ServiceableGenerator {
    protected RightProfilesDAO _profilesDAO;

    public void service(ServiceManager m) throws ServiceException {
        super.service(m);
        this._profilesDAO = (RightProfilesDAO)m.lookup(RightProfilesDAO.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"Profiles");
        for (Profile profile : this._profilesDAO.getProfiles()) {
            this.saxProfile(profile);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"Profiles");
        this.contentHandler.endDocument();
    }

    protected void saxProfile(Profile profile) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "id", "id", "CDATA", profile.getId());
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"profile", (Attributes)atts);
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"label", (String)profile.getLabel());
        String context = profile.getContext();
        if (context != null) {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"context", (String)context);
        }
        this.contentHandler.startElement("", "rights", "rights", new AttributesImpl());
        for (String right : this._profilesDAO.getRights(profile)) {
            AttributesImpl attsRight = new AttributesImpl();
            attsRight.addAttribute("", "id", "id", "CDATA", right);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"right", (Attributes)attsRight);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"rights");
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"profile");
    }
}

