/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.right.profile;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.ametys.core.right.RightManager;
import org.ametys.core.right.RightProfilesDAO;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.core.right.profile.ProfileDAO;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ExportProfilesGenerator
extends ServiceableGenerator {
    public static final String IMPORT_EXPORT_PROFILES_RIGHT_ID = "Runtime_Rights_Profile_Import_Export";
    protected ProfileDAO _profileDAO;
    protected RightProfilesDAO _profilesDAO;
    protected JSONUtils _jsonUtils;
    protected RightManager _rightManager;
    protected CurrentUserProvider _currentUserProvider;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._profileDAO = (ProfileDAO)serviceManager.lookup(ProfileDAO.ROLE);
        this._jsonUtils = (JSONUtils)serviceManager.lookup(JSONUtils.ROLE);
        this._rightManager = (RightManager)serviceManager.lookup(RightManager.ROLE);
        this._profilesDAO = (RightProfilesDAO)serviceManager.lookup(RightProfilesDAO.ROLE);
        this._currentUserProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String profileIdsAsString = request.getParameter("ids");
        String[] profileIds = profileIdsAsString.split(",");
        UserIdentity user = this._currentUserProvider.getUser();
        if (this._rightManager.hasRight(user, IMPORT_EXPORT_PROFILES_RIGHT_ID, "/${WorkspaceName}") != RightManager.RightResult.RIGHT_ALLOW) {
            throw new AccessDeniedException("User '" + String.valueOf(user) + "' tried to export the profiles without convenient right [Runtime_Rights_Profile_Import_Export]");
        }
        this.contentHandler.startDocument();
        Map<String, List<Map<String, Object>>> profiles2Json = this._profileDAO.getProfiles2Json(profileIds);
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"text", (String)this._jsonUtils.convertObjectToJson(profiles2Json));
        this.contentHandler.endDocument();
    }
}

