/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.right.profile;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.core.right.Profile;
import org.ametys.core.right.RightProfilesDAO;
import org.ametys.core.right.RightsExtensionPoint;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.core.upload.UploadAction;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ImportProfileAction
extends UploadAction
implements Contextualizable {
    protected RightProfilesDAO _rightProfileDAO;
    protected RightsExtensionPoint _rights;
    protected JSONUtils _jsonUtils;
    protected I18nUtils _i18nUtils;
    private Context _context;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._jsonUtils = (JSONUtils)serviceManager.lookup(JSONUtils.ROLE);
        this._i18nUtils = (I18nUtils)((Object)serviceManager.lookup(I18nUtils.ROLE));
        this._rights = (RightsExtensionPoint)serviceManager.lookup(RightsExtensionPoint.ROLE);
        if (serviceManager.hasService(RightProfilesDAO.ROLE)) {
            this._rightProfileDAO = (RightProfilesDAO)this.manager.lookup(RightProfilesDAO.ROLE);
        }
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    @Override
    protected void _storeUpload(InputStream is, String filename, Map<String, Object> result) throws IOException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            IOUtils.copy((InputStream)is, (OutputStream)os);
            Map<String, Object> readValue = this._jsonUtils.convertJsonToMap(os.toString(StandardCharsets.UTF_8));
            if (readValue == null || readValue.get("profiles") == null) {
                result.put("success", true);
                result.put("error", Map.of("message", new I18nizableText("plugin.core-ui", "PLUGINS_CORE_UI_PROFILES_IMPORT_INCORRECT_FILE_ERROR")));
            } else {
                List profiles = (List)readValue.get("profiles");
                ArrayList<String> profileIds = new ArrayList<String>();
                HashSet<String> unknownRights = new HashSet<String>();
                ArrayList<String> existingProfileIds = new ArrayList<String>();
                Request request = ContextHelper.getRequest((Context)this._context);
                String context = request.getParameter("context");
                for (Map jsonProfile : profiles) {
                    String id = (String)jsonProfile.get("id");
                    String label = (String)jsonProfile.get("label");
                    List rights = (List)jsonProfile.get("rights");
                    if (rights == null || !StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{label, id})) continue;
                    boolean needsRenaming = this._rightProfileDAO.getProfile(id) != null;
                    Profile profile = needsRenaming ? this._rightProfileDAO.addProfile(label, context) : this._rightProfileDAO.addProfile(id, label, context);
                    this._handleUnknownRights(unknownRights, rights);
                    this._rightProfileDAO.addRights(profile, rights);
                    profileIds.add(profile.getId());
                    if (!needsRenaming) continue;
                    existingProfileIds.add(id);
                    if (!this.getLogger().isInfoEnabled()) continue;
                    this.getLogger().info("Profile with id '" + id + "' already exists, it was imported with new id '" + profile.getId() + "'");
                }
                result.put("success", true);
                result.put("ids", profileIds);
                result.put("renamedIds", existingProfileIds);
                result.put("unknownRights", unknownRights);
                if (!unknownRights.isEmpty() && this.getLogger().isInfoEnabled()) {
                    this.getLogger().info("Rights with ids [" + StringUtils.join(unknownRights, (String)", ") + "] do not exist. They are ignored.");
                }
            }
        }
        catch (IllegalArgumentException e) {
            this.getLogger().error("Unable to store uploaded file: " + filename, (Throwable)e);
            result.put("success", false);
            HashMap<String, String> ex = new HashMap<String, String>();
            ex.put("message", this._i18nUtils.translate(new I18nizableText("plugin.core-ui", "PLUGINS_CORE_UI_PROFILES_IMPORT_JSON_PARSE_ERROR")));
            ex.put("stacktrace", ExceptionUtils.getRootCauseMessage((Throwable)e));
            result.put("error", ex);
        }
    }

    private void _handleUnknownRights(Set<String> rightsNotFound, List<String> rights) {
        ArrayList<String> notFound = new ArrayList<String>();
        for (String rightId : rights) {
            if (this._rights.getExtension(rightId) != null) continue;
            notFound.add(rightId);
        }
        for (String id : notFound) {
            rights.remove(id);
        }
        rightsNotFound.addAll(notFound);
    }
}

